/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.DoubleImageHelper;
import fr.esrf.tangoatk.core.attribute.DoubleSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberScalarHistory;
import java.util.Vector;

public class DoubleScalarHelper
extends ANumberScalarHelper {
    public DoubleScalarHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.spectrumHelper = new DoubleSpectrumHelper(iAttribute);
        this.imageHelper = new DoubleImageHelper(iAttribute);
    }

    void insert(double d) {
        this.attribute.getAttribute().insert(d);
    }

    final double getNumberScalarValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] dArray = null;
        dArray = deviceAttribute.extractDoubleArray();
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length < 1) {
            return Double.NaN;
        }
        return dArray[0];
    }

    double getNumberScalarSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] dArray = null;
        dArray = deviceAttribute.extractDoubleArray();
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length < 1) {
            return Double.NaN;
        }
        if (dArray.length > 1) {
            return dArray[1];
        }
        return dArray[0];
    }

    protected INumberScalarHistory[] getNumberScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        Vector<NumberScalarHistory> vector = new Vector<NumberScalarHistory>();
        int n = 0;
        while (n < deviceDataHistoryArray.length) {
            NumberScalarHistory numberScalarHistory = new NumberScalarHistory();
            try {
                numberScalarHistory.setTimestamp(deviceDataHistoryArray[n].getTime());
            }
            catch (Exception exception) {
                numberScalarHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[n].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberScalarHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberScalarHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberScalarHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberScalarHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberScalarHistory.setState("CHANGING");
                } else {
                    numberScalarHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberScalarHistory.setState("UNKNOWN");
            }
            try {
                numberScalarHistory.setValue(deviceDataHistoryArray[n].extractDouble());
            }
            catch (Exception exception) {
                numberScalarHistory.setValue(Double.NaN);
            }
            vector.add(n, numberScalarHistory);
            ++n;
        }
        INumberScalarHistory[] iNumberScalarHistoryArray = vector.toArray(new NumberScalarHistory[0]);
        return iNumberScalarHistoryArray;
    }

    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberScalarAttHistory(deviceDataHistoryArray);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Double(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Double(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Double(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Double(d), bl);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Double(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(d));
    }

    public String getVersion() {
        return "$Id: DoubleScalarHelper.java,v 1.10 2005/02/28 12:14:53 jlpons Exp $";
    }
}

