/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanImage;
import fr.esrf.tangoatk.core.attribute.BooleanScalar;
import fr.esrf.tangoatk.core.attribute.BooleanSpectrum;
import fr.esrf.tangoatk.core.attribute.DevStateScalar;
import fr.esrf.tangoatk.core.attribute.DoubleImageHelper;
import fr.esrf.tangoatk.core.attribute.DoubleScalarHelper;
import fr.esrf.tangoatk.core.attribute.DoubleSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.InvalidAttribute;
import fr.esrf.tangoatk.core.attribute.LongImageHelper;
import fr.esrf.tangoatk.core.attribute.LongScalarHelper;
import fr.esrf.tangoatk.core.attribute.LongSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberImage;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import fr.esrf.tangoatk.core.attribute.NumberSpectrum;
import fr.esrf.tangoatk.core.attribute.ShortImageHelper;
import fr.esrf.tangoatk.core.attribute.ShortScalarHelper;
import fr.esrf.tangoatk.core.attribute.ShortSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.StringScalar;
import fr.esrf.tangoatk.core.attribute.StringSpectrum;
import fr.esrf.tangoatk.core.attribute.UShortImageHelper;
import fr.esrf.tangoatk.core.attribute.UShortScalarHelper;
import fr.esrf.tangoatk.core.attribute.UShortSpectrumHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class AttributeFactory
extends AEntityFactory {
    private static AttributeFactory instance;
    private Vector attributes = new Vector();
    private String[] attNames = new String[0];

    protected AttributeFactory() {
    }

    public static AttributeFactory getInstance() {
        if (instance == null) {
            instance = new AttributeFactory();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AAttribute[] getAttributes() {
        AAttribute[] aAttributeArray = new AAttribute[this.attributes.size()];
        AttributeFactory attributeFactory = this;
        synchronized (attributeFactory) {
            int n = 0;
            while (n < this.attributes.size()) {
                aAttributeArray[n] = (AAttribute)this.attributes.get(n);
                ++n;
            }
        }
        return aAttributeArray;
    }

    public int getSize() {
        return this.attributes.size();
    }

    private int getAttributePos(String string) {
        return Arrays.binarySearch(this.attNames, string.toLowerCase());
    }

    protected synchronized List getWildCardEntities(String string, Device device) throws DevFailed {
        Vector<AAttribute> vector = new Vector<AAttribute>();
        string = "All attributes";
        String[] stringArray = new String[]{string};
        AttributeInfo[] attributeInfoArray = device.getAttributeInfo(stringArray);
        int n = 0;
        while (n < attributeInfoArray.length) {
            String string2 = AEntityFactory.getFQName(device, attributeInfoArray[n].name);
            int n2 = this.getAttributePos(string2);
            AAttribute aAttribute = n2 >= 0 ? (AAttribute)this.attributes.get(n2) : this.initAttribute(device, attributeInfoArray[n], -(n2 + 1), string2);
            vector.add(aAttribute);
            ++n;
        }
        return vector;
    }

    protected synchronized IEntity getSingleEntity(String string, Device device) throws DevFailed {
        int n = this.getAttributePos(string);
        if (n >= 0) {
            return (AAttribute)this.attributes.get(n);
        }
        String string2 = AEntityFactory.extractEntityName(string);
        AttributeInfo attributeInfo = device.getAttributeInfo(string2);
        return this.initAttribute(device, attributeInfo, -(n + 1), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute getAttribute(String string) throws ConnectionException, DevFailed {
        Device device = null;
        IEntity iEntity = null;
        AAttribute aAttribute = null;
        AttributeFactory attributeFactory = this;
        synchronized (attributeFactory) {
            int n = this.getAttributePos(string);
            if (n >= 0) {
                iEntity = (IEntity)this.attributes.get(n);
            }
        }
        if (iEntity == null) {
            device = this.getDevice(AEntityFactory.extractDeviceName(string));
            iEntity = this.getSingleEntity(string, device);
        }
        if (iEntity == null) {
            return null;
        }
        if (iEntity instanceof AAttribute) {
            aAttribute = (AAttribute)iEntity;
            return aAttribute;
        }
        return null;
    }

    public boolean isAttribute(String string) {
        try {
            return this.getAttribute(string) != null;
        }
        catch (ConnectionException connectionException) {
            System.out.println("AttributeFactory.isAttribute(" + string + ") : " + connectionException.getErrors()[0].desc);
            return false;
        }
        catch (DevFailed devFailed) {
            System.out.println("AttributeFactory.isAttribute(" + string + ") : " + devFailed.errors[0].desc);
            return false;
        }
        catch (Exception exception) {
            System.out.println("AttributeFactory.isAttribute(" + string + ") : Unexpected exception caught...");
            exception.printStackTrace();
            return false;
        }
    }

    private AAttribute initAttribute(Device device, AttributeInfo attributeInfo, int n, String string) {
        AAttribute aAttribute = this.getAttributeOfType(device.getName(), attributeInfo);
        long l = System.currentTimeMillis();
        aAttribute.init(device, attributeInfo.name, attributeInfo);
        DeviceFactory.getInstance().trace(2, "AttributeFactory.init(" + string + ")", l);
        int n2 = this.attNames.length;
        String[] stringArray = new String[n2 + 1];
        System.arraycopy(this.attNames, 0, stringArray, 0, n);
        System.arraycopy(this.attNames, n, stringArray, n + 1, n2 - n);
        stringArray[n] = string.toLowerCase();
        this.attNames = stringArray;
        this.attributes.add(n, aAttribute);
        this.dumpFactory("Adding " + string);
        return aAttribute;
    }

    private AAttribute getAttributeOfType(String string, AttributeInfo attributeInfo) {
        if (attributeInfo == null) {
            System.out.println("Warning, AttributeFactory.getAttributeOfType(): Warning, null AttributeInfo pointer got from " + string);
            return new InvalidAttribute();
        }
        AttrDataFormat attrDataFormat = attributeInfo.data_format;
        String string2 = attributeInfo.name;
        switch (attrDataFormat.value()) {
            case 0: {
                return this.getScalar(string, attributeInfo);
            }
            case 1: {
                return this.getSpectrum(string, attributeInfo);
            }
            case 2: {
                return this.getImage(string, attributeInfo);
            }
        }
        System.out.println("Warning, AttributeFactory.getAttributeOfType(" + string + "/" + string2 + ") : Unsupported attribute format [" + attrDataFormat.value() + "]");
        return new InvalidAttribute();
    }

    private AAttribute getScalar(String string, AttributeInfo attributeInfo) {
        String string2 = attributeInfo.name;
        int n = attributeInfo.data_type;
        BooleanScalar booleanScalar = null;
        DevStateScalar devStateScalar = null;
        if (n == 8) {
            return new StringScalar();
        }
        NumberScalar numberScalar = new NumberScalar();
        switch (n) {
            case 2: {
                numberScalar.setNumberHelper(new ShortScalarHelper(numberScalar));
                break;
            }
            case 6: {
                numberScalar.setNumberHelper(new UShortScalarHelper(numberScalar));
                break;
            }
            case 5: {
                numberScalar.setNumberHelper(new DoubleScalarHelper(numberScalar));
                break;
            }
            case 3: {
                numberScalar.setNumberHelper(new LongScalarHelper(numberScalar));
                break;
            }
            case 1: {
                booleanScalar = new BooleanScalar();
                return booleanScalar;
            }
            case 19: {
                devStateScalar = new DevStateScalar();
                return devStateScalar;
            }
            default: {
                System.out.println("Warning, AttributeFactory.getScalar(" + string + "/" + string2 + ") : Unsupported data type [" + n + "]");
                return new InvalidAttribute();
            }
        }
        return numberScalar;
    }

    private AAttribute getSpectrum(String string, AttributeInfo attributeInfo) {
        String string2 = attributeInfo.name;
        int n = attributeInfo.data_type;
        NumberSpectrum numberSpectrum = new NumberSpectrum();
        StringSpectrum stringSpectrum = null;
        BooleanSpectrum booleanSpectrum = null;
        switch (n) {
            case 2: {
                numberSpectrum.setNumberHelper(new ShortSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 6: {
                numberSpectrum.setNumberHelper(new UShortSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 5: {
                numberSpectrum.setNumberHelper(new DoubleSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 3: {
                numberSpectrum.setNumberHelper(new LongSpectrumHelper(numberSpectrum));
                return numberSpectrum;
            }
            case 8: {
                stringSpectrum = new StringSpectrum();
                return stringSpectrum;
            }
            case 1: {
                booleanSpectrum = new BooleanSpectrum();
                return booleanSpectrum;
            }
        }
        System.out.println("Warning, AttributeFactory.getSpectrum(" + string + "/" + string2 + ") : Unsupported data type [" + n + "]");
        return new InvalidAttribute();
    }

    private AAttribute getImage(String string, AttributeInfo attributeInfo) {
        String string2 = attributeInfo.name;
        int n = attributeInfo.data_type;
        NumberImage numberImage = new NumberImage();
        BooleanImage booleanImage = null;
        switch (n) {
            case 2: {
                numberImage.setNumberHelper(new ShortImageHelper(numberImage));
                return numberImage;
            }
            case 6: {
                numberImage.setNumberHelper(new UShortImageHelper(numberImage));
                return numberImage;
            }
            case 5: {
                numberImage.setNumberHelper(new DoubleImageHelper(numberImage));
                return numberImage;
            }
            case 3: {
                numberImage.setNumberHelper(new LongImageHelper(numberImage));
                return numberImage;
            }
            case 1: {
                booleanImage = new BooleanImage();
                return booleanImage;
            }
        }
        System.out.println("Warning, AttributeFactory.getSpectrum(" + string + "/" + string2 + ") : Unsupported data type [" + n + "]");
        return new InvalidAttribute();
    }

    private void dumpFactory(String string) {
        if ((DeviceFactory.getInstance().getTraceMode() & 0x200) != 0) {
            System.out.println("-- AttributeFactory : " + string + " --");
            int n = 0;
            while (n < this.attNames.length) {
                System.out.println("  " + n + ":" + this.attNames[n]);
                ++n;
            }
            System.out.println("-- AttributeFactory --------------------------------------");
        }
    }

    public String getVersion() {
        return "$Id: AttributeFactory.java,v 1.13 2005/06/15 09:42:08 jlpons Exp $";
    }
}

