/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityCollection;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IRefreshee;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.Refresher;
import fr.esrf.tangoatk.core.util.AtkTimer;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;

public abstract class AEntityList
extends DefaultListModel
implements IEntityCollection,
ComboBoxModel {
    protected int refreshInterval = 1000;
    protected AEntityFactory factory;
    protected Refresher refresher = null;
    protected static ThreadGroup refreshers = new ThreadGroup("listRefreshers");
    protected transient AtkTimer timer = AtkTimer.getInstance();
    protected List errorListeners = new Vector();
    protected List refresherListeners = new Vector();
    protected List setErrorListeners = new Vector();
    protected IEntity selectedItem;
    boolean polledList = false;
    protected IEntityFilter filter = new IEntityFilter(){

        public boolean keep(IEntity iEntity) {
            return true;
        }
    };
    private static String VERSION = "$Id: AEntityList.java,v 1.19 2005/06/10 16:50:16 poncet Exp $";

    public void setRefreshInterval(int n) {
        this.refreshInterval = n;
        if (this.refresher != null) {
            this.refresher.setRefreshInterval(this.refreshInterval);
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object object) {
        this.selectedItem = (IEntity)object;
    }

    public void refresh() {
        IEntity iEntity = null;
        long l = System.currentTimeMillis();
        if (this.isPolled()) {
            this.trace(4, "AEntityList.refresh() : a polled list doing refresh on all elements ... ", l);
            int n = 0;
            while (n < this.size()) {
                ((IRefreshee)this.get(n)).refresh();
                ++n;
            }
            this.trace(4, "AEntityList.refresh() : a polled list refresh on all elements done; will fire refresherStep evnt. ", l);
            this.fireRefresherStepEvent();
        } else {
            this.trace(4, "AEntityList.refresh()  ", l);
            int n = 0;
            while (n < this.size()) {
                IAttribute iAttribute;
                iEntity = (IEntity)this.get(n);
                if (!iEntity.getDevice().doesEvent()) {
                    this.trace(4, "AEntityList.refresh() : device is not event compatible; will call refresh for " + iEntity.getName(), l);
                    iEntity.refresh();
                } else if (iEntity instanceof IAttribute && !(iAttribute = (IAttribute)iEntity).hasEvents()) {
                    this.trace(4, "AEntityList.refresh() : attribute has not subscribed event; will call refresh for " + iEntity.getName(), l);
                    iEntity.refresh();
                }
                ++n;
            }
        }
    }

    public void stopRefresher() {
        if (this.refresher != null) {
            this.refresher.stop = true;
        }
        this.refresher = null;
    }

    public void startRefresher() {
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
        }
        this.refresher.addRefreshee(this).start();
    }

    public void setRefresher(Refresher refresher) {
        this.refresher = refresher;
    }

    public void setFilter(IEntityFilter iEntityFilter) {
        this.filter = iEntityFilter;
    }

    public IEntityFilter getFilter() {
        return this.filter;
    }

    public List get(String[] stringArray) {
        Vector<IEntity> vector = new Vector<IEntity>();
        int n = 0;
        while (n < stringArray.length) {
            vector.add(this.get(stringArray[n]));
            ++n;
        }
        return vector;
    }

    public IEntity get(String string) {
        int n = 0;
        while (n < this.size()) {
            IEntity iEntity = (IEntity)this.get(n);
            if (iEntity.getName().equals(string)) {
                return iEntity;
            }
            ++n;
        }
        return null;
    }

    public void add(String[] stringArray) throws ConnectionException {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                this.add(stringArray[n]);
            }
            ++n;
        }
    }

    public void add(IEntity iEntity) {
        int n;
        if (this.contains(iEntity)) {
            return;
        }
        if (!this.filter.keep(iEntity)) {
            return;
        }
        if (this.errorListeners != null) {
            n = 0;
            while (n < this.errorListeners.size()) {
                iEntity.addErrorListener((IErrorListener)this.errorListeners.get(n));
                ++n;
            }
        }
        if (iEntity instanceof IAttribute && this.setErrorListeners != null) {
            n = 0;
            while (n < this.setErrorListeners.size()) {
                ((IAttribute)iEntity).addSetErrorListener((ISetErrorListener)this.setErrorListeners.get(n));
                ++n;
            }
        }
        this.addElement(iEntity);
    }

    public IEntity add(String string) throws ConnectionException {
        IEntity iEntity = this.get(string);
        if (iEntity == null) {
            List list = null;
            try {
                list = this.factory.getEntities(string);
            }
            catch (ConnectionException connectionException) {
                if (AEntityFactory.isWildCard(string)) {
                    string = string.substring(0, string.length() - 2);
                }
                this.fireErrorEvent(connectionException, string);
                throw connectionException;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n;
                iEntity = (IEntity)iterator.next();
                if (iEntity == null || this.contains(iEntity) || !this.filter.keep(iEntity)) continue;
                if (this.errorListeners != null) {
                    n = 0;
                    while (n < this.errorListeners.size()) {
                        iEntity.addErrorListener((IErrorListener)this.errorListeners.get(n));
                        ++n;
                    }
                }
                if (iEntity instanceof IAttribute && this.setErrorListeners != null) {
                    n = 0;
                    while (n < this.setErrorListeners.size()) {
                        ((IAttribute)iEntity).addSetErrorListener((ISetErrorListener)this.setErrorListeners.get(n));
                        ++n;
                    }
                }
                this.addElement(iEntity);
            }
        }
        return iEntity;
    }

    public boolean remove(String string) {
        IEntity iEntity = this.get(string);
        int n = this.indexOf(iEntity);
        return n >= 0 && this.remove(n) != null;
    }

    public void setErrorListener(IErrorListener iErrorListener) {
        this.errorListeners.clear();
        this.errorListeners.add(iErrorListener);
    }

    public void addErrorListener(IErrorListener iErrorListener) {
        this.errorListeners.add(iErrorListener);
    }

    public void addSetErrorListener(ISetErrorListener iSetErrorListener) {
        this.setErrorListeners.add(iSetErrorListener);
    }

    public void addRefresherListener(IRefresherListener iRefresherListener) {
        if (!this.refresherListeners.contains(iRefresherListener)) {
            this.refresherListeners.add(iRefresherListener);
        }
    }

    public void removeRefresherListener(IRefresherListener iRefresherListener) {
        this.refresherListeners.remove(iRefresherListener);
    }

    public void clearRefresherListener() {
        this.refresherListeners.clear();
    }

    private void fireRefresherStepEvent() {
        int n = this.refresherListeners.size();
        int n2 = 0;
        while (n2 < n) {
            IRefresherListener iRefresherListener = (IRefresherListener)this.refresherListeners.get(n2);
            try {
                iRefresherListener.refreshStep();
            }
            catch (Exception exception) {
                System.out.println("AEntityList.fireRefresherStepEvent() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("AEntityList.fireRefresherStepEvent()------------------------------------------------");
            }
            ++n2;
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    private void fireErrorEvent(ConnectionException connectionException, String string) {
        if (this.errorListeners != null) {
            int n = 0;
            while (n < this.errorListeners.size()) {
                ((IErrorListener)this.errorListeners.get(n)).errorChange(new ErrorEvent(string, connectionException, System.currentTimeMillis()));
                ++n;
            }
        }
    }

    public boolean isPolled() {
        return this.polledList;
    }

    public void finalize() {
        this.stopRefresher();
    }

    public String getVersion() {
        return VERSION;
    }
}

