/*-
 * Copyright © 2009 Diamond Light Source Ltd.
 *
 * This file is part of GDA.
 *
 * GDA is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 as published by the Free
 * Software Foundation.
 *
 * GDA is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with GDA. If not, see <http://www.gnu.org/licenses/>.
 */

package gda.device.detector.ncddetector.subdetector;

import java.util.List;

import gda.device.Device;
import gda.device.DeviceException;
import gda.device.detector.DataDimension;

/**
 * A class to represent a physical detector for NCD.
 */
public interface INcdSubDetector extends Device {
	
	public static final String[] detectorTypes = new String[]{"SAXS", "WAXS", "CALIB", "TIMES", "SYS", "REDUCTION"};

	public void clear() throws DeviceException;

	public void restart() throws DeviceException;

	public void start() throws DeviceException;

	public void stop() throws DeviceException;
	
	public String getDetectorType() throws DeviceException;
	
	public double[] output(int frames) throws DeviceException;
	//	NXDetectorData writeout(int frames, NXDetectorData dataTree) throws DeviceException;
	
	public int getMemorySize() throws DeviceException;
	
	public List<DataDimension> getSupportedDimensions() throws DeviceException;
	
	public void setDataDimensions(int[] detectorSize) throws DeviceException;
	
	public int[] getDataDimensions() throws DeviceException;
	
	public double[] read(int x, int y, int t, int dx, int dy, int dt)
		throws DeviceException;
}