/*-
 * Copyright © 2009 Diamond Light Source Ltd.
 *
 * This file is part of GDA.
 *
 * GDA is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 as published by the Free
 * Software Foundation.
 *
 * GDA is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with GDA. If not, see <http://www.gnu.org/licenses/>.
 */

package gda.device;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;

public class TangoDeviceProxy  {
	private DeviceProxy deviceProxy = null;

	public TangoDeviceProxy() {}

	public TangoDeviceProxy(String deviceName) {
		try {
			if (deviceName != null) {
				deviceProxy = new DeviceProxy(deviceName);
			}
		} catch (Exception e) {
			System.out.println(e);
			System.out.println(e.getMessage());
		}
	}

	public String get_name() {
		return deviceProxy.get_name();
	}

	public DeviceData command_inout(String cmd) throws DevFailed {
		return deviceProxy.command_inout(cmd);
	}
	
	public DeviceData command_inout(String cmd, DeviceData argin) throws DevFailed {
		return deviceProxy.command_inout(cmd, argin);
	}
	
	public DevState state() throws DevFailed {
		return deviceProxy.state();		
	}
	
	public String status() throws DevFailed {
		return deviceProxy.status();
	}
	
	public void write_attribute(DeviceAttribute devattr) throws DevFailed {
		deviceProxy.write_attribute(devattr);
	}
	
	public DeviceAttribute read_attribute(String attributeName) throws DevFailed {
		return deviceProxy.read_attribute(attributeName);
	}
	
	public String[] get_attribute_list() throws DevFailed {
		return deviceProxy.get_attribute_list();
	}

	public AttributeInfo get_attribute_info(String attributeName) throws DevFailed {
		return deviceProxy.get_attribute_info(attributeName);
	}

	public boolean use_db() {
		return deviceProxy.use_db();
	}
	
	public DbDatum get_property(String propertyName) throws DevFailed {
		return deviceProxy.get_property(propertyName);
	}

	public void put_property(DbDatum property) throws DevFailed {
		deviceProxy.put_property(property);
	}

	public void isAvailable() throws DeviceException {
		try {
			// Is the device still connected or just started
			deviceProxy.state();
		} catch (DevFailed e) {
			// device has lost connection
			throw new DeviceException("Tango device server " + deviceProxy.get_name() + " failed");
		} catch (Exception e) {
			throw new DeviceException("Tango device server stuffed");			
		}
	}
}
