/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.Serializable;
import java.util.Vector;
import org.omg.CORBA.INTERNAL;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class Name
implements Serializable {
    private NameComponent[] fullName;
    private NameComponent baseName;
    private NameComponent[] ctxName;

    public Name() {
        this.fullName = null;
        this.baseName = null;
        this.ctxName = null;
    }

    public Name(NameComponent[] nameComponentArray) throws InvalidName {
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        this.fullName = nameComponentArray;
        this.baseName = nameComponentArray[nameComponentArray.length - 1];
        if (nameComponentArray.length > 1) {
            this.ctxName = new NameComponent[nameComponentArray.length - 1];
            for (int i = 0; i < nameComponentArray.length - 1; ++i) {
                this.ctxName[i] = nameComponentArray[i];
            }
        } else {
            this.ctxName = null;
        }
    }

    public Name(String string) throws InvalidName {
        this(Name.toName(string));
    }

    public Name(NameComponent nameComponent) throws InvalidName {
        if (nameComponent == null) {
            throw new InvalidName();
        }
        this.baseName = nameComponent;
        this.fullName = new NameComponent[1];
        this.fullName[0] = nameComponent;
        this.ctxName = null;
    }

    public NameComponent baseNameComponent() {
        return this.baseName;
    }

    public String kind() {
        return this.baseName.kind;
    }

    public NameComponent[] components() {
        return this.fullName;
    }

    public Name ctxName() {
        if (this.ctxName != null) {
            try {
                return new Name(this.ctxName);
            }
            catch (InvalidName invalidName) {
                throw new INTERNAL(invalidName.toString());
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Name)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public Name fullName() throws InvalidName {
        return new Name(this.fullName);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        try {
            return Name.toString(this.fullName);
        }
        catch (InvalidName invalidName) {
            return "<invalid>";
        }
    }

    private static NameComponent getComponent(String string) throws InvalidName {
        int n = string.length();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (++i >= n) {
                    throw new InvalidName();
                }
                c = string.charAt(i);
            } else if (c == '.') {
                if (bl) {
                    throw new InvalidName();
                }
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer2.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return new NameComponent(stringBuffer.toString(), stringBuffer2.toString());
    }

    public static NameComponent[] toName(String string) throws InvalidName {
        int n;
        if (string == null || string.length() == 0 || string.startsWith("/")) {
            throw new InvalidName();
        }
        Vector<NameComponent> vector = new Vector<NameComponent>();
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '/' || string.charAt(n - 1) == '\\') continue;
            if (n - n2 == 0) {
                throw new InvalidName();
            }
            vector.addElement(Name.getComponent(string.substring(n2, n)));
            n2 = n + 1;
        }
        if (n2 < n) {
            vector.addElement(Name.getComponent(string.substring(n2, n)));
        }
        NameComponent[] nameComponentArray = new NameComponent[vector.size()];
        for (int i = 0; i < nameComponentArray.length; ++i) {
            nameComponentArray[i] = (NameComponent)vector.elementAt(i);
        }
        return nameComponentArray;
    }

    public static String toString(NameComponent[] nameComponentArray) throws InvalidName {
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nameComponentArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("/");
            }
            if (nameComponentArray[i].id.length() > 0) {
                stringBuffer.append(Name.escape(nameComponentArray[i].id));
            }
            if (nameComponentArray[i].kind.length() > 0 || nameComponentArray[i].id.length() == 0) {
                stringBuffer.append(".");
            }
            if (nameComponentArray[i].kind.length() <= 0) continue;
            stringBuffer.append(Name.escape(nameComponentArray[i].kind));
        }
        return stringBuffer.toString();
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '/' && stringBuffer.charAt(i) != '\\' && stringBuffer.charAt(i) != '.') continue;
            stringBuffer.insert(i, '\\');
            ++i;
        }
        return stringBuffer.toString();
    }
}

