/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.AttDataReadyHelper;
import fr.esrf.Tango.AttributeConfigHelper;
import fr.esrf.Tango.AttributeConfig_3Helper;
import fr.esrf.Tango.AttributeValueHelper;
import fr.esrf.Tango.AttributeValue_3Helper;
import fr.esrf.Tango.AttributeValue_4Helper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevErrorListHelper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.DeviceProxyFactory;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventQueue;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UserException;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierHelper;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.StructuredPushConsumerPOA;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;

public class EventConsumer
extends StructuredPushConsumerPOA
implements TangoConst,
Runnable {
    private static EventConsumer instance = null;
    private static int subscribe_event_id = 0;
    private static final long EVENT_HEARTBEAT_PERIOD = 10000L;
    private static final long EVENT_RESUBSCRIBE_PERIOD = 600000L;
    private EventChannel eventChannel;
    private ConsumerAdmin consumerAdmin;
    private ProxySupplier proxySupplier;
    private ORB orb = ApiUtil.get_orb();
    private Hashtable channel_map;
    private Hashtable device_channel_map = null;
    private Hashtable event_callback_map;
    private Hashtable failed_event_callback_map;
    private Thread runner;
    private Timer keepAliveTimer;
    private boolean orbRunning = false;

    public static EventConsumer create() throws DevFailed {
        if (instance != null) {
            return instance;
        }
        return new EventConsumer();
    }

    private EventConsumer() throws DevFailed {
        instance = this;
        this.channel_map = new Hashtable();
        this.device_channel_map = new Hashtable();
        this.device_channel_map.clear();
        this.event_callback_map = new Hashtable();
        this.failed_event_callback_map = new Hashtable();
        this.keepAliveTimer = new Timer();
        this.runner = new Thread(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                EventConsumer.this.keepAliveTimer.cancel();
                EventConsumer.this.cleanup_heartbeat_filters();
                EventConsumer.this.cleanup_event_filters();
                EventConsumer.this.cleanup_heartbeat_proxies();
                if (EventConsumer.this.orbRunning) {
                    EventConsumer.this.orb.shutdown(true);
                    try {
                        EventConsumer.this.runner.join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        });
        this.runner.start();
    }

    public void updateDatabaseObject() throws DevFailed {
        System.out.println("updateDatabaseObject()  is deprecated !");
    }

    public void disconnect_structured_push_consumer() {
        System.out.println("calling EventConsumer.disconnect_structured_push_consumer()");
    }

    public void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        System.out.println("calling EventConsumer.offer_change()");
    }

    private void push_structured_event_heartbeat(String string) {
        try {
            if (this.channel_map.containsKey(string)) {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(string);
                eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            } else {
                Enumeration enumeration = this.channel_map.keys();
                boolean bl = false;
                while (enumeration.hasMoreElements() && !bl) {
                    String string2 = (String)enumeration.nextElement();
                    EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(string2);
                    if (!eventChannelStruct.adm_device_proxy.name().equals(string)) continue;
                    eventChannelStruct.last_heartbeat = System.currentTimeMillis();
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private java.lang.Object extractAttributeObject(StructuredEvent structuredEvent) throws BadKind {
        TypeCode typeCode = structuredEvent.remainder_of_body.type();
        if (typeCode.kind().equals(TCKind.tk_struct)) {
            String string = typeCode.name();
            if (string.equals("AttDataReady")) {
                return AttDataReadyHelper.extract(structuredEvent.remainder_of_body);
            }
            if (string.equals("AttributeConfig_3")) {
                return new AttributeInfoEx(AttributeConfig_3Helper.extract(structuredEvent.remainder_of_body));
            }
            if (string.equals("AttributeConfig_2")) {
                return new AttributeInfoEx(AttributeConfigHelper.extract(structuredEvent.remainder_of_body));
            }
            if (string.equals("AttributeValue_4")) {
                return new DeviceAttribute(AttributeValue_4Helper.extract(structuredEvent.remainder_of_body));
            }
            if (string.equals("AttributeValue_3")) {
                return new DeviceAttribute(AttributeValue_3Helper.extract(structuredEvent.remainder_of_body));
            }
            if (string.equals("AttributeValue")) {
                return new DeviceAttribute(AttributeValueHelper.extract(structuredEvent.remainder_of_body));
            }
            DevError[] devErrorArray = new DevError[]{new DevError("API_IncompatibleAttrDataType", ErrSeverity.ERR, "Unknown structure used to pass attribute value (Need compilation ?)", "EventConsumer::extractAttributeObject()")};
            return devErrorArray;
        }
        return DevErrorListHelper.extract(structuredEvent.remainder_of_body);
    }

    public void push_structured_event(StructuredEvent structuredEvent) {
        String string = structuredEvent.header.fixed_header.event_type.domain_name;
        String string2 = structuredEvent.header.fixed_header.event_name;
        try {
            if (string2.equals("heartbeat")) {
                this.push_structured_event_heartbeat(string);
                return;
            }
            String string3 = string + "." + string2;
            if (this.event_callback_map.containsKey(string3)) {
                EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)this.event_callback_map.get(string3);
                CallBack callBack = eventCallBackStruct.callback;
                DeviceAttribute deviceAttribute = null;
                AttributeInfoEx attributeInfoEx = null;
                AttDataReady attDataReady = null;
                DevError[] devErrorArray = null;
                java.lang.Object object = this.extractAttributeObject(structuredEvent);
                if (object instanceof AttributeInfoEx) {
                    attributeInfoEx = (AttributeInfoEx)object;
                } else if (object instanceof AttDataReady) {
                    attDataReady = (AttDataReady)object;
                } else if (object instanceof DeviceAttribute) {
                    deviceAttribute = (DeviceAttribute)object;
                } else if (object instanceof DevError[]) {
                    devErrorArray = (DevError[])object;
                }
                EventData eventData = new EventData(eventCallBackStruct.device, string, string2, eventCallBackStruct.event_type, deviceAttribute, attributeInfoEx, attDataReady, devErrorArray);
                if (eventCallBackStruct.use_ev_queue) {
                    EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                    eventQueue.insert_event(eventData);
                } else if (callBack != null) {
                    callBack.push_event(eventData);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String buildConstraintExpr(String string, String string2, String string3, String[] stringArray) {
        String string4 = "$domain_name == '" + string.toLowerCase() + "/" + string2.toLowerCase() + "'" + " and $event_name == '" + string3 + "'";
        if (stringArray != null && stringArray.length != 0) {
            string4 = string4 + " and ((";
            for (String string5 : stringArray) {
                string4 = string4 + string5;
            }
            string4 = string4 + " ) and $forced_event > 0.5 )";
        }
        return string4;
    }

    private void checkIfAlreadyConnected(DeviceProxy deviceProxy, String string, String string2, CallBack callBack, int n, boolean bl) throws DevFailed {
        if (deviceProxy == null || callBack == null && n < 0) {
            Except.throw_wrong_syntax_exception("API_InvalidArgs", "Device or callback pointer NULL and  event queue not used !!", "EventConsumer.subscribe_event()");
        }
        if (deviceProxy == null || deviceProxy.name() == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect to device", "EventConsumer.subscribe_event()");
        } else {
            String string3 = deviceProxy.name().toLowerCase() + "/" + string + "." + string2;
            if (this.event_callback_map.containsKey(string3)) {
                Except.throw_event_system_failed("API_MethodArgument", "Already connected to event " + string3, "EventConsumer.subscribe_event()");
            }
            if (bl && this.failed_event_callback_map.containsKey(string3)) {
                Except.throw_event_system_failed("API_MethodArgument", "Already trying to connect to event " + string3, "EventConsumer.subscribe_event()");
            }
        }
    }

    private void callEventSubscriptionAndConnect(DeviceProxy deviceProxy, String string, String string2) throws DevFailed {
        String string3 = deviceProxy.name();
        String[] stringArray = new String[]{string3, string, "subscribe", string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        deviceProxy.get_adm_dev().command_inout("EventSubscriptionChange", deviceData);
        if (!this.device_channel_map.containsKey(string3)) {
            this.connect(deviceProxy);
            if (!this.device_channel_map.containsKey(string3)) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect to event channel for device", "EventConsumer.subscribe_event()");
            }
        }
    }

    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, CallBack callBack, String[] stringArray, boolean bl) throws DevFailed {
        return this.subscribe_event(deviceProxy, string, n, callBack, -1, stringArray, bl);
    }

    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, int n2, String[] stringArray, boolean bl) throws DevFailed {
        return this.subscribe_event(deviceProxy, string, n, null, n2, stringArray, bl);
    }

    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, CallBack callBack, int n2, String[] stringArray, boolean bl) throws DevFailed {
        String string2 = eventNames[n];
        this.checkIfAlreadyConnected(deviceProxy, string, string2, callBack, n2, bl);
        if (callBack == null && n2 >= 0 && deviceProxy.getEventQueue() == null) {
            if (n2 > 0) {
                deviceProxy.setEventQueue(new EventQueue(n2));
            } else {
                deviceProxy.setEventQueue(new EventQueue());
            }
        }
        String string3 = deviceProxy.name();
        String string4 = string3.toLowerCase() + "/" + string + "." + string2;
        try {
            this.callEventSubscriptionAndConnect(deviceProxy, string.toLowerCase(), string2);
        }
        catch (DevFailed devFailed) {
            if (!bl) {
                throw devFailed;
            }
            EventCallBackStruct eventCallBackStruct = new EventCallBackStruct(deviceProxy, string, string2, "", callBack, n2, ++subscribe_event_id, n, "", -1, stringArray, false);
            this.failed_event_callback_map.put(string4, eventCallBackStruct);
            return subscribe_event_id;
        }
        String string5 = this.buildConstraintExpr(string3, string, string2, stringArray);
        String string6 = (String)this.device_channel_map.get(string3);
        EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(string6);
        eventChannelStruct.last_subscribed = System.currentTimeMillis();
        int n3 = this.add_filter_for_channel(eventChannelStruct, string5);
        EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)this.failed_event_callback_map.get(string4);
        int n4 = eventCallBackStruct == null ? ++subscribe_event_id : eventCallBackStruct.id;
        EventCallBackStruct eventCallBackStruct2 = new EventCallBackStruct(deviceProxy, string, string2, string6, callBack, n2, n4, n, string5, n3, stringArray, true);
        this.event_callback_map.put(string4, eventCallBackStruct2);
        if (n == 0 || n == 2 || n == 1 || n == 3 || n == 4 || n == 5) {
            new PushAttrValueLater(eventCallBackStruct2).start();
        }
        return n4;
    }

    private EventCallBackStruct getCallBackStruct(Hashtable hashtable, int n) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)hashtable.get(string);
            if (eventCallBackStruct.id != n) continue;
            return eventCallBackStruct;
        }
        return null;
    }

    private void removeCallBackStruct(Hashtable hashtable, EventCallBackStruct eventCallBackStruct) throws DevFailed {
        java.lang.Object object;
        try {
            StructuredProxyPushSupplier structuredProxyPushSupplier;
            Filter filter;
            object = (EventChannelStruct)this.channel_map.get(eventCallBackStruct.channel_name);
            if (object != null && (filter = (structuredProxyPushSupplier = ((EventChannelStruct)object).structuredProxyPushSupplier).get_filter(eventCallBackStruct.filter_id)) != null) {
                structuredProxyPushSupplier.remove_filter(eventCallBackStruct.filter_id);
                filter.destroy();
            }
        }
        catch (FilterNotFound filterNotFound) {
            Except.throw_event_system_failed("API_EventNotFound", "Failed to unsubscribe event, caught exception while calling remove_filter() (hint: check notification daemon is running)", "EventConsumer.unsubscribe_event()");
        }
        object = eventCallBackStruct.device.name().toLowerCase() + "/" + eventCallBackStruct.attr_name + "." + eventCallBackStruct.event_name;
        hashtable.remove(object);
    }

    public void unsubscribe_event(int n) throws DevFailed {
        EventCallBackStruct eventCallBackStruct = this.getCallBackStruct(this.event_callback_map, n);
        if (eventCallBackStruct != null) {
            this.removeCallBackStruct(this.event_callback_map, eventCallBackStruct);
        } else {
            eventCallBackStruct = this.getCallBackStruct(this.failed_event_callback_map, n);
            if (eventCallBackStruct != null) {
                this.removeCallBackStruct(this.failed_event_callback_map, eventCallBackStruct);
            } else {
                Except.throw_event_system_failed("API_EventNotFound", "Failed to unsubscribe event, the event id (" + n + ") specified does not correspond with any known one", "EventConsumer.unsubscribe_event()");
            }
        }
    }

    public void connect(DeviceProxy deviceProxy) throws DevFailed {
        String string = deviceProxy.name();
        String string2 = null;
        try {
            string2 = deviceProxy.adm_name();
        }
        catch (DevFailed devFailed) {
            Except.throw_event_system_failed("API_BadConfigurationProperty", "Can't subscribe to event for device " + string + "\n Check that device server is running...", "EventConsumer.connect");
        }
        String string3 = string2;
        Database database = null;
        if (!this.channel_map.containsKey(string3)) {
            if (deviceProxy.use_db()) {
                database = deviceProxy.get_db_obj();
            }
            this.connect_event_channel(string3, database, false);
        } else if (deviceProxy.use_db()) {
            database = deviceProxy.get_db_obj();
        }
        EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(string3);
        eventChannelStruct.adm_device_proxy = deviceProxy.get_adm_dev();
        eventChannelStruct.use_db = deviceProxy.use_db();
        eventChannelStruct.dbase = database;
        this.device_channel_map.put(string, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block6: {
            try {
                if (!ApiUtil.in_server()) {
                    this.keepAliveTimer.schedule((TimerTask)new KeepAliveThread(), 2000L, 10000L);
                    EventConsumer eventConsumer = this;
                    synchronized (eventConsumer) {
                        Object object = this.orb.resolve_initial_references("RootPOA");
                        POA pOA = POAHelper.narrow(object);
                        POAManager pOAManager = pOA.the_POAManager();
                        pOAManager.activate();
                    }
                    this.orbRunning = true;
                    this.orb.run();
                    this.orb.destroy();
                    break block6;
                }
                this.keepAliveTimer.schedule((TimerTask)new KeepAliveThread(), 2000L, 10000L);
            }
            catch (UserException userException) {
                System.out.println("EventConsumer.run() : Unable to start orb");
                userException.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void cleanup_heartbeat_filters() {
        Enumeration enumeration = this.channel_map.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(string);
            try {
                int n = eventChannelStruct.heartbeat_filter_id;
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(n);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(n);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {}
        }
    }

    private void cleanup_event_filters() {
        Enumeration enumeration = this.event_callback_map.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)this.event_callback_map.get(string);
            try {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(eventCallBackStruct.channel_name);
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(eventCallBackStruct.filter_id);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(eventCallBackStruct.filter_id);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {}
        }
    }

    private void cleanup_heartbeat_proxies() {
        Enumeration enumeration = this.event_callback_map.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)this.event_callback_map.get(string);
            try {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)this.channel_map.get(eventCallBackStruct.channel_name);
                if (eventChannelStruct.structuredProxyPushSupplier != null) {
                    eventChannelStruct.structuredProxyPushSupplier.disconnect_structured_push_supplier();
                    eventChannelStruct.structuredProxyPushSupplier = null;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            this.event_callback_map.remove(string);
        }
    }

    private synchronized void connect_event_channel(String string, Database database, boolean bl) throws DevFailed {
        EventChannelStruct eventChannelStruct;
        java.lang.Object object;
        java.lang.Object object2;
        DbEventImportInfo dbEventImportInfo = null;
        DeviceProxy deviceProxy = null;
        try {
            if (database != null) {
                deviceProxy = DeviceProxyFactory.get(string);
                dbEventImportInfo = deviceProxy.get_evt_import_info();
                if (dbEventImportInfo == null) {
                    dbEventImportInfo = database.import_event(string);
                }
            } else {
                dbEventImportInfo = new DbEventImportInfo();
                deviceProxy = DeviceProxyFactory.get(string);
                object2 = deviceProxy.command_inout("QueryEventChannelIOR");
                dbEventImportInfo.channel_ior = ((DeviceData)object2).extractString();
                dbEventImportInfo.channel_exported = true;
                IORdump iORdump = new IORdump(null, dbEventImportInfo.channel_ior);
                dbEventImportInfo.host = iORdump.get_hostname();
            }
        }
        catch (DevFailed devFailed) {
            if (database != null) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", string + " has no event channel defined in the database\n" + " May be the server is not running or is not linked with Tango release 4.x (or above)", "EventConsumer.connect_event_channel");
            }
            Except.throw_event_system_failed("API_NotificationServiceFailed", string + " did not returned event channel IOR\n" + " May be the server is not running or is not linked with Tango release 4.x (or above)", "EventConsumer.connect_event_channel");
        }
        object2 = dbEventImportInfo.channel_ior;
        boolean bl2 = dbEventImportInfo.channel_exported;
        int n = dbEventImportInfo.host.indexOf(46);
        if (n > 0) {
            dbEventImportInfo.host = dbEventImportInfo.host.substring(0, n);
        }
        if (bl2) {
            object = this.orb.string_to_object((String)object2);
            try {
                this.eventChannel = EventChannelHelper.narrow((Object)object);
            }
            catch (RuntimeException runtimeException) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
            }
            if (this.eventChannel == null) {
                bl2 = false;
            }
        }
        if (!bl2) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to narrow EventChannel from notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        try {
            this.consumerAdmin = this.eventChannel.default_consumer_admin();
        }
        catch (Exception exception) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Received " + exception.toString() + "\nduring eventChannel.default_consumer_admin() call", "EventConsumer.connect_event_channel");
        }
        if (this.consumerAdmin == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get default consumer admin from notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        object = new IntHolder();
        try {
            this.proxySupplier = this.consumerAdmin.obtain_notification_push_supplier(ClientType.STRUCTURED_EVENT, (IntHolder)object);
            if (this.proxySupplier == null) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier from notification daemon (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
            }
        }
        catch (TIMEOUT tIMEOUT) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier due to a Timeout", "EventConsumer.connect_event_channel");
        }
        catch (AdminLimitExceeded adminLimitExceeded) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier due to AdminLimitExceeded (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        StructuredProxyPushSupplier structuredProxyPushSupplier = StructuredProxyPushSupplierHelper.narrow(this.proxySupplier);
        if (structuredProxyPushSupplier == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to narrow the push supplier due to AdminLimitExceeded (hint : make sur the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        try {
            structuredProxyPushSupplier.connect_structured_push_consumer(this._this(this.orb));
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            Except.throw_event_system_failed("API_NotificationServiceFailed", nullPointerException + " detected when subscribing to " + string, "EventConsumer.connect_event_channel");
        }
        catch (AlreadyConnected alreadyConnected) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect the push supplier due to CosEventChannelAdmin.AlreadyConnected.AlreadyConnected  exception", "EventConsumer.connect_event_channel");
        }
        catch (TypeError typeError) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect the push supplier due to CosEventChannelAdmin.AlreadyConnected.TypeError  exception", "EventConsumer.connect_event_channel");
        }
        if (bl) {
            eventChannelStruct = (EventChannelStruct)this.channel_map.get(string);
            eventChannelStruct.eventChannel = this.eventChannel;
            eventChannelStruct.structuredProxyPushSupplier = structuredProxyPushSupplier;
            eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            eventChannelStruct.heartbeat_skipped = false;
            eventChannelStruct.host = dbEventImportInfo.host;
            eventChannelStruct.has_notifd_closed_the_connection = 0;
            try {
                int n2 = eventChannelStruct.heartbeat_filter_id;
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(n2);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(n2);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {
                // empty catch block
            }
            String string2 = "$event_name == 'heartbeat'";
            eventChannelStruct.heartbeat_filter_id = this.add_filter_for_channel(eventChannelStruct, string2);
            this.setEventChannelTimeoutMillis(eventChannelStruct.eventChannel, 3000);
        } else {
            eventChannelStruct = new EventChannelStruct();
            eventChannelStruct.eventChannel = this.eventChannel;
            eventChannelStruct.structuredProxyPushSupplier = structuredProxyPushSupplier;
            eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            eventChannelStruct.heartbeat_skipped = false;
            eventChannelStruct.adm_device_proxy = deviceProxy;
            eventChannelStruct.host = dbEventImportInfo.host;
            eventChannelStruct.has_notifd_closed_the_connection = 0;
            String string3 = "$event_name == 'heartbeat'";
            eventChannelStruct.heartbeat_filter_id = this.add_filter_for_channel(eventChannelStruct, string3);
            this.channel_map.put(string, eventChannelStruct);
            this.setEventChannelTimeoutMillis(eventChannelStruct.eventChannel, 3000);
        }
    }

    private void setEventChannelTimeoutMillis(EventChannel eventChannel, int n) {
        RelativeRoundtripTimeoutPolicy relativeRoundtripTimeoutPolicy = new RelativeRoundtripTimeoutPolicy(10000 * n);
        eventChannel._set_policy_override(new Policy[]{relativeRoundtripTimeoutPolicy}, SetOverrideType.ADD_OVERRIDE);
    }

    private int add_filter_for_channel(EventChannelStruct eventChannelStruct, String string) throws DevFailed {
        ConstraintExp[] constraintExpArray;
        Filter filter = null;
        int n = -1;
        try {
            constraintExpArray = eventChannelStruct.eventChannel.default_filter_factory();
            filter = constraintExpArray.create_filter("EXTENDED_TCL");
        }
        catch (InvalidGrammar invalidGrammar) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Caught Invalid Grammar exception while creating heartbeat filter : check filter", "EventConsumer.add_filter_for_channel");
        }
        constraintExpArray = new ConstraintExp[]{new ConstraintExp()};
        constraintExpArray[0].event_types = new EventType[0];
        constraintExpArray[0].constraint_expr = string;
        try {
            if (filter != null) {
                filter.add_constraints(constraintExpArray);
                n = eventChannelStruct.structuredProxyPushSupplier.add_filter(filter);
            }
        }
        catch (InvalidConstraint invalidConstraint) {
            filter.destroy();
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Caught InvalidConstraint exception while adding constraint for heartbeat : check filter", "EventConsumer.add_filter_for_channel");
        }
        return n;
    }

    class PushAttrValueLater
    extends Thread {
        private EventCallBackStruct cb_struct;

        PushAttrValueLater(EventCallBackStruct eventCallBackStruct) {
            this.cb_struct = eventCallBackStruct;
        }

        public void run() {
            try {
                PushAttrValueLater.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DeviceAttribute deviceAttribute = null;
            AttributeInfoEx attributeInfoEx = null;
            DevError[] devErrorArray = null;
            String string = this.cb_struct.device.name() + "/" + this.cb_struct.attr_name.toLowerCase();
            try {
                if (this.cb_struct.event_type == 5) {
                    attributeInfoEx = this.cb_struct.device.get_attribute_info_ex(this.cb_struct.attr_name);
                } else {
                    deviceAttribute = this.cb_struct.device.read_attribute(this.cb_struct.attr_name);
                }
            }
            catch (DevFailed devFailed) {
                devErrorArray = devFailed.errors;
            }
            EventData eventData = new EventData(this.cb_struct.device, string, this.cb_struct.event_name, this.cb_struct.event_type, deviceAttribute, attributeInfoEx, null, devErrorArray);
            if (this.cb_struct.use_ev_queue) {
                EventQueue eventQueue = this.cb_struct.device.getEventQueue();
                eventQueue.insert_event(eventData);
            } else {
                this.cb_struct.callback.push_event(eventData);
            }
        }
    }

    private class KeepAliveThread
    extends TimerTask {
        public void run() {
            long l = 15000L;
            if (System.currentTimeMillis() - this.scheduledExecutionTime() >= l) {
                return;
            }
            this.subscribe_if_not_done();
            this.resubscribe_if_needed();
        }

        private void subscribe_if_not_done() {
            Enumeration enumeration = EventConsumer.this.failed_event_callback_map.elements();
            while (enumeration.hasMoreElements()) {
                EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration.nextElement();
                String string = eventCallBackStruct.device.name().toLowerCase() + "/" + eventCallBackStruct.attr_name + "." + eventCallBackStruct.event_name;
                try {
                    EventConsumer.this.subscribe_event(eventCallBackStruct.device, eventCallBackStruct.attr_name, eventCallBackStruct.event_type, eventCallBackStruct.callback, eventCallBackStruct.max_size, eventCallBackStruct.filters, false);
                    EventConsumer.this.failed_event_callback_map.remove(string);
                }
                catch (DevFailed devFailed) {
                    EventData eventData = new EventData(eventCallBackStruct.device, string, eventCallBackStruct.event_name, eventCallBackStruct.event_type, null, null, null, devFailed.errors);
                    if (eventCallBackStruct.use_ev_queue) {
                        EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                        eventQueue.insert_event(eventData);
                        continue;
                    }
                    eventCallBackStruct.callback.push_event(eventData);
                }
            }
        }

        private void resubscribe_if_needed() {
            Enumeration enumeration = EventConsumer.this.channel_map.keys();
            long l = System.currentTimeMillis();
            while (enumeration.hasMoreElements()) {
                boolean bl;
                String string = (String)enumeration.nextElement();
                EventChannelStruct eventChannelStruct = (EventChannelStruct)EventConsumer.this.channel_map.get(string);
                if (l - eventChannelStruct.last_subscribed > 200000L) {
                    this.reSubscribeByName(eventChannelStruct, string);
                }
                boolean bl2 = bl = l - eventChannelStruct.last_heartbeat > 10000L;
                if (bl || eventChannelStruct.heartbeat_skipped || eventChannelStruct.notifd_failed) {
                    eventChannelStruct.heartbeat_skipped = true;
                    DevError devError = null;
                    try {
                        eventChannelStruct.eventChannel.MyFactory();
                        if (this.checkIfHostHasChanged(eventChannelStruct)) {
                            eventChannelStruct.notifd_failed = true;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        devError = new DevError();
                        devError.severity = ErrSeverity.ERR;
                        devError.origin = "EventConsumer.KeepAliveThread";
                        devError.reason = "API_EventException";
                        devError.desc = "Connection failed with notify daemon";
                        eventChannelStruct.notifd_failed = true;
                    }
                    if (!eventChannelStruct.use_db) {
                        eventChannelStruct.notifd_failed = true;
                    }
                    if (!eventChannelStruct.notifd_failed && eventChannelStruct.has_notifd_closed_the_connection >= 3) {
                        eventChannelStruct.notifd_failed = true;
                    }
                    if (eventChannelStruct.notifd_failed) {
                        boolean bl3 = eventChannelStruct.notifd_failed = !this.reconnect_to_channel(string);
                        if (!eventChannelStruct.notifd_failed) {
                            this.reconnect_to_event(string);
                        }
                    }
                    Enumeration enumeration2 = EventConsumer.this.event_callback_map.elements();
                    while (enumeration2.hasMoreElements()) {
                        EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration2.nextElement();
                        if (!eventCallBackStruct.channel_name.equals(string)) continue;
                        if (devError != null) {
                            this.pushReceivedException(eventChannelStruct, eventCallBackStruct, devError);
                        } else {
                            this.pushServerNotRespondingException(eventChannelStruct, eventCallBackStruct);
                        }
                        if (eventCallBackStruct.event_name.equals(TangoConst.eventNames[6]) || eventChannelStruct.notifd_failed || !this.reSubscribe(eventChannelStruct, eventCallBackStruct)) continue;
                        this.readAttributeAndPush(eventChannelStruct, eventCallBackStruct);
                    }
                    continue;
                }
                eventChannelStruct.has_notifd_closed_the_connection = 0;
            }
        }

        private boolean reSubscribe(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct) {
            boolean bl = true;
            try {
                DeviceData deviceData = new DeviceData();
                String[] stringArray = new String[]{eventCallBackStruct.device.name(), eventCallBackStruct.attr_name, "subscribe", eventCallBackStruct.event_name};
                deviceData.insert(stringArray);
                eventChannelStruct.adm_device_proxy.command_inout("EventSubscriptionChange", deviceData);
                eventChannelStruct.heartbeat_skipped = false;
                eventCallBackStruct.last_subscribed = eventChannelStruct.last_subscribed = System.currentTimeMillis();
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        private void reSubscribeByName(EventChannelStruct eventChannelStruct, String string) {
            Enumeration enumeration = EventConsumer.this.event_callback_map.elements();
            while (enumeration.hasMoreElements()) {
                EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration.nextElement();
                if (!eventCallBackStruct.channel_name.equals(string)) continue;
                this.reSubscribe(eventChannelStruct, eventCallBackStruct);
            }
        }

        private void readAttributeAndPush(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct) {
            boolean bl = false;
            for (int i = 0; !bl && i < TangoConst.eventNames.length; ++i) {
                bl = eventCallBackStruct.event_name.equals(TangoConst.eventNames[i]);
            }
            if (!bl) {
                return;
            }
            DeviceAttribute deviceAttribute = null;
            AttributeInfoEx attributeInfoEx = null;
            DevError[] devErrorArray = null;
            String string = eventCallBackStruct.device.name() + "/" + eventCallBackStruct.attr_name;
            boolean bl2 = eventCallBackStruct.device.get_transparency_reconnection();
            eventCallBackStruct.device.set_transparency_reconnection(true);
            try {
                if (eventCallBackStruct.event_name.equals(TangoConst.eventNames[5])) {
                    attributeInfoEx = eventCallBackStruct.device.get_attribute_info_ex(eventCallBackStruct.attr_name);
                } else {
                    deviceAttribute = eventCallBackStruct.device.read_attribute(eventCallBackStruct.attr_name);
                }
                ++eventChannelStruct.has_notifd_closed_the_connection;
            }
            catch (DevFailed devFailed) {
                devErrorArray = devFailed.errors;
            }
            eventCallBackStruct.device.set_transparency_reconnection(bl2);
            EventData eventData = new EventData(eventCallBackStruct.device, string, eventCallBackStruct.event_name, eventCallBackStruct.event_type, deviceAttribute, attributeInfoEx, null, devErrorArray);
            if (eventCallBackStruct.use_ev_queue) {
                EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                eventQueue.insert_event(eventData);
            } else {
                eventCallBackStruct.callback.push_event(eventData);
            }
        }

        private void pushServerNotRespondingException(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct) {
            try {
                if (eventChannelStruct != null) {
                    if (!eventCallBackStruct.filter_ok) {
                        eventCallBackStruct.filter_id = EventConsumer.this.add_filter_for_channel(eventChannelStruct, eventCallBackStruct.filter_constraint);
                        eventCallBackStruct.filter_ok = true;
                    }
                } else {
                    return;
                }
                CallBack callBack = eventCallBackStruct.callback;
                DevError[] devErrorArray = new DevError[]{new DevError()};
                devErrorArray[0].severity = ErrSeverity.ERR;
                devErrorArray[0].origin = "EventConsumer.KeepAliveThread";
                devErrorArray[0].reason = "API_EventTimeout";
                devErrorArray[0].desc = "Event channel is not responding any more, maybe the server or event system is down";
                String string = eventCallBackStruct.device.name() + "/" + eventCallBackStruct.attr_name.toLowerCase();
                EventData eventData = new EventData(eventChannelStruct.adm_device_proxy, string, eventCallBackStruct.event_name, eventCallBackStruct.event_type, null, null, null, devErrorArray);
                eventData.device = eventCallBackStruct.device;
                eventData.name = eventCallBackStruct.device.name();
                eventData.event = eventCallBackStruct.event_name;
                if (eventCallBackStruct.use_ev_queue) {
                    EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                    eventQueue.insert_event(eventData);
                } else {
                    callBack.push_event(eventData);
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        private void pushReceivedException(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct, DevError devError) {
            try {
                if (eventChannelStruct != null) {
                    if (!eventCallBackStruct.filter_ok) {
                        eventCallBackStruct.filter_id = EventConsumer.this.add_filter_for_channel(eventChannelStruct, eventCallBackStruct.filter_constraint);
                        eventCallBackStruct.filter_ok = true;
                    }
                } else {
                    return;
                }
                DevError[] devErrorArray = new DevError[]{devError};
                String string = eventCallBackStruct.device.name() + "/" + eventCallBackStruct.attr_name.toLowerCase();
                EventData eventData = new EventData(eventChannelStruct.adm_device_proxy, string, eventCallBackStruct.event_name, eventCallBackStruct.event_type, null, null, null, devErrorArray);
                CallBack callBack = eventCallBackStruct.callback;
                eventData.device = eventCallBackStruct.device;
                eventData.name = eventCallBackStruct.device.name();
                eventData.event = eventCallBackStruct.event_name;
                if (eventCallBackStruct.use_ev_queue) {
                    EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                    eventQueue.insert_event(eventData);
                } else {
                    callBack.push_event(eventData);
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        private boolean checkIfHostHasChanged(EventChannelStruct eventChannelStruct) {
            boolean bl = false;
            try {
                IORdump iORdump = new IORdump(eventChannelStruct.adm_device_proxy);
                String string = iORdump.get_hostname();
                int n = string.indexOf(46);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                if (!eventChannelStruct.host.equals(string)) {
                    bl = true;
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            return bl;
        }

        private void reconnect_to_event(String string) {
            Enumeration enumeration = EventConsumer.this.event_callback_map.elements();
            while (enumeration.hasMoreElements()) {
                EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration.nextElement();
                if (!eventCallBackStruct.channel_name.equals(string) || eventCallBackStruct.callback == null) continue;
                try {
                    EventChannelStruct eventChannelStruct = (EventChannelStruct)EventConsumer.this.channel_map.get(string);
                    eventCallBackStruct.filter_id = EventConsumer.this.add_filter_for_channel(eventChannelStruct, eventCallBackStruct.filter_constraint);
                    eventCallBackStruct.filter_ok = true;
                }
                catch (DevFailed devFailed) {
                    eventCallBackStruct.filter_ok = false;
                }
            }
        }

        private boolean reconnect_to_channel(String string) {
            boolean bl = true;
            Enumeration enumeration = EventConsumer.this.event_callback_map.elements();
            while (enumeration.hasMoreElements()) {
                EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration.nextElement();
                if (!eventCallBackStruct.channel_name.equals(string) || eventCallBackStruct.callback == null) continue;
                try {
                    EventChannelStruct eventChannelStruct = (EventChannelStruct)EventConsumer.this.channel_map.get(string);
                    eventChannelStruct.adm_device_proxy.ping();
                    EventConsumer.this.connect_event_channel(string, eventChannelStruct.dbase, true);
                    bl = true;
                }
                catch (DevFailed devFailed) {
                    bl = false;
                }
                break;
            }
            return bl;
        }
    }
}

