/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.TangoEnv;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class TangoUrl
implements ApiDefs,
Serializable {
    int protocol;
    String host;
    String strport;
    int port;
    String devname;
    boolean use_db;
    private static boolean envRead = false;

    public TangoUrl(String urlstr) throws DevFailed {
        URL url;
        block26: {
            int len;
            this.protocol = 0;
            this.host = null;
            this.strport = null;
            this.port = -1;
            this.devname = null;
            this.use_db = true;
            int idx = urlstr.indexOf(protocol_name[0] + ":");
            if (idx >= 0) {
                this.protocol = 0;
            } else {
                idx = urlstr.indexOf(protocol_name[1] + ":");
                if (idx >= 0) {
                    this.protocol = 1;
                    this.use_db = false;
                }
            }
            if (idx < 0) {
                len = 0;
                idx = 0;
            } else {
                len = protocol_name[this.protocol].length() + 1;
            }
            String new_urlstr = "http:" + urlstr.substring(idx + len);
            url = null;
            try {
                url = new URL(new_urlstr);
            }
            catch (MalformedURLException e) {
                int start;
                boolean ok = false;
                int comma = new_urlstr.indexOf(",");
                if (comma > 0 && (start = new_urlstr.indexOf("//")) >= 0) {
                    int end = new_urlstr.indexOf("/", start += 2);
                    if (end < 0) {
                        end = new_urlstr.length();
                    }
                    if (end > start) {
                        String[] array = ApiUtil.parseTangoHost(new_urlstr.substring(start, end));
                        this.host = array[0];
                        this.strport = array[1];
                        this.port = Integer.parseInt(this.strport);
                        String tmp = new_urlstr.substring(0, comma) + new_urlstr.substring(end);
                        try {
                            url = new URL(tmp);
                            ok = true;
                        }
                        catch (MalformedURLException ex) {
                            // empty catch block
                        }
                    }
                }
                if (ok) break block26;
                Except.throw_wrong_syntax_exception("TangoApi_BAD_URL", "Bad url parameter", "TangoUrl.TangoUrl()");
            }
        }
        assert (url != null);
        this.host = url.getHost();
        this.port = url.getPort();
        this.strport = Integer.toString(this.port);
        this.devname = url.getFile();
        if (this.protocol == 0 && (this.host == null || this.host.length() == 0)) {
            Database db = null;
            try {
                db = this.host != null && this.host.length() > 0 ? ApiUtil.get_db_obj(this.host, this.strport) : ApiUtil.get_db_obj();
            }
            catch (DevFailed e) {
                // empty catch block
            }
            if (db != null) {
                envRead = true;
            }
            if (!envRead) {
                this.setFromEnv();
                if (this.protocol == 0 && this.port < 0) {
                    Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Cannot parse port number", "TangoUrl.TangoUrl()");
                }
            } else {
                this.host = ApiUtil.get_db_obj().url.host;
                this.port = ApiUtil.get_db_obj().url.port;
                this.strport = Integer.toString(this.port);
            }
        }
        while (this.devname.startsWith("/")) {
            this.devname = this.devname.substring(1);
        }
        if (this.devname.length() > 0) {
            int nb_slash = 0;
            for (int i = 0; i < this.devname.length(); ++i) {
                if (this.devname.charAt(i) != '/') continue;
                ++nb_slash;
            }
            if (nb_slash != 0 && nb_slash != 2) {
                Except.throw_wrong_syntax_exception("TangoApi_BAD_DEVICE_NAME", "Device name (" + this.devname + ") wrong definition.", "TangoUrl.TangoUrl()");
            }
        }
        if (this.devname.indexOf(35) >= 0 && this.devname.indexOf("->") >= 0) {
            Except.throw_wrong_syntax_exception("TangoApi_BAD_DEVICE_NAME", "Device name (" + this.devname + ") wrong definition.", "TangoUrl.TangoUrl()");
        }
        if (this.protocol == 0 && url.getRef() != null && url.getRef().indexOf("dbase=no") == 0) {
            this.use_db = false;
        }
    }

    public TangoUrl() throws DevFailed {
        this.protocol = 0;
        this.host = null;
        this.strport = null;
        this.port = -1;
        this.devname = null;
        this.use_db = true;
        if (this.protocol == 0) {
            this.setFromEnv();
        }
    }

    private void setFromEnv() throws DevFailed {
        String env = TangoEnv.getTangoHost();
        assert (env != null);
        if (env.indexOf(":") < 0) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Unknown \"TANGO_HOST\" property " + env, "TangoUrl.TangoUrl()");
        }
        String[] array = ApiUtil.parseTangoHost(env);
        this.host = array[0];
        this.strport = array[1];
        this.port = Integer.parseInt(this.strport);
        envRead = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.protocol == 0 ? "tango" : "taco");
        sb.append("://").append(this.host).append(":").append(this.strport);
        sb.append("/").append(this.devname);
        if (!this.use_db) {
            sb.append("#dbase=no");
        }
        return sb.toString();
    }

    public void trace() {
        System.out.println("\tprotocol = " + protocol_name[this.protocol]);
        if (this.host != null) {
            System.out.println("\thost name= " + this.host);
        }
        System.out.println("\tport num = " + this.strport);
        System.out.println("\tdevice   = " + this.devname);
        if (this.use_db) {
            System.out.println("\tuse database");
        } else {
            System.out.println("\tDo NOT use database");
        }
        System.out.println();
    }
}

