/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;

class TangoEnv {
    private static String tango_host = null;
    private static String super_tango = null;
    private static String access_devname = null;
    private static String default_timeout = null;
    private static String orb_max_msg_size = null;
    private static boolean _osIsUnix = true;
    private static boolean _osIsUnixTested = false;

    TangoEnv() {
    }

    static String getTangoHost() throws DevFailed {
        if (tango_host == null && (tango_host = System.getProperty("TANGO_HOST")) == null && (tango_host = System.getenv("TANGO_HOST")) == null && (tango_host = TangoEnv.getFromEnvFile("TANGO_HOST")) == null) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Property \"TANGO_HOST\" not exported", "TangoEnv.getTangoHost()");
        }
        return tango_host;
    }

    static boolean isSuperTango() {
        if (super_tango == null && (super_tango = System.getProperty("SUPER_TANGO")) == null && (super_tango = System.getenv("SUPER_TANGO")) == null && (super_tango = TangoEnv.getFromEnvFile("SUPER_TANGO")) == null) {
            super_tango = "false";
        }
        return super_tango.toLowerCase() == "true";
    }

    static String getAccessDevname() {
        if (access_devname == null && (access_devname = System.getProperty("ACCESS_DEVNAME")) == null && (access_devname = System.getenv("ACCESS_DEVNAME")) == null) {
            access_devname = TangoEnv.getFromEnvFile("ACCESS_DEVNAME");
        }
        return access_devname;
    }

    static String getStrDefaultTimeout() {
        if (default_timeout == null && (default_timeout = System.getProperty("TANGO_TIMEOUT")) == null && (default_timeout = System.getenv("TANGO_TIMEOUT")) == null) {
            default_timeout = TangoEnv.getFromEnvFile("TANGO_TIMEOUT");
        }
        return default_timeout;
    }

    static String getORBgiopMaxMsgSize() {
        if (orb_max_msg_size == null && (orb_max_msg_size = System.getProperty("ORBgiopMaxMsgSize")) == null && (orb_max_msg_size = System.getenv("ORBgiopMaxMsgSize")) == null) {
            orb_max_msg_size = TangoEnv.getFromEnvFile("ORBgiopMaxMsgSize");
        }
        return orb_max_msg_size;
    }

    private static String getFromEnvFile(String varname) {
        if (TangoEnv.osIsUnix()) {
            String home = System.getenv("HOME");
            String varval = TangoEnv.getFromEnvFile(varname, home + "/.tangorc");
            if (varval != null) {
                return varval;
            }
            String tangorc = System.getProperty("TANGO_RC");
            if (tangorc == null) {
                tangorc = "/etc/tangorc";
            }
            return TangoEnv.getFromEnvFile(varname, tangorc);
        }
        String tangorc = System.getProperty("TANGO_RC");
        if (tangorc == null) {
            String tango_root = System.getenv("TANGO_ROOT");
            if (tango_root == null) {
                return null;
            }
            tangorc = tango_root + "/tangorc";
        }
        return TangoEnv.getFromEnvFile(varname, tangorc);
    }

    private static String getFromEnvFile(String varname, String filename) {
        try {
            String code = TangoEnv.readFile(filename);
            StringTokenizer stk = new StringTokenizer(code, "\n");
            while (stk.hasMoreTokens()) {
                int pos;
                String line = stk.nextToken().trim();
                if (line.startsWith("#") || (pos = line.indexOf(varname + "=")) < 0) continue;
                return line.substring(pos + varname.length() + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean osIsUnix() {
        if (!_osIsUnixTested) {
            try {
                String os = System.getProperty("os.name");
                _osIsUnix = !os.toLowerCase().startsWith("windows");
            }
            catch (Exception e) {
                _osIsUnix = false;
            }
        }
        return _osIsUnix;
    }

    private static String readFile(String filename) throws FileNotFoundException, SecurityException, IOException {
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        nb = fid.read(inStr);
        fid.close();
        return new String(inStr);
    }
}

