/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.PollObj;
import fr.esrf.TangoDs.PollThCmd;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TangoMonitor;
import fr.esrf.TangoDs.Util;
import java.util.Random;
import java.util.Vector;
import org.omg.CORBA.Any;

public class PollThread
extends Thread
implements TangoConst {
    PollThCmd shared_cmd;
    PollThCmd local_cmd;
    TangoMonitor p_mon;
    Vector works;
    Vector ext_trig_works;
    TimeVal now;
    TimeVal after;
    long sleep;
    boolean polling_stop;
    static DeviceImpl dev_to_del = null;
    static String name_to_del = "";
    static int type_to_del = 0;
    private String[] attr_names;
    private static final int POLL_COMMAND = 0;
    private static final int POLL_TRIGGER = 1;
    private static final int POLL_TIME_OUT = 2;

    PollThread(PollThCmd pollThCmd, TangoMonitor tangoMonitor) {
        this.shared_cmd = pollThCmd;
        this.p_mon = tangoMonitor;
        this.sleep = 1L;
        this.polling_stop = false;
        this.attr_names = new String[1];
        this.now = new TimeVal();
        long l = System.currentTimeMillis();
        this.now.tv_sec = (int)(l / 1000L);
        this.now.tv_usec = (int)(l - (long)(1000 * this.now.tv_sec)) * 1000;
        this.now.tv_nsec = 0;
        this.after = new TimeVal();
        this.after.tv_nsec = 0;
        this.works = new Vector();
        this.ext_trig_works = new Vector();
    }

    int get_command(long l) {
        int n;
        if (!this.shared_cmd.cmd_pending && !this.shared_cmd.trigger) {
            if (this.works.size() == 0) {
                this.p_mon.wait_it();
            } else if (l > 0L) {
                this.p_mon.wait_it(l);
            }
        }
        if (this.shared_cmd.cmd_pending) {
            this.local_cmd = this.shared_cmd;
            n = 0;
        } else if (this.shared_cmd.trigger) {
            this.local_cmd = this.shared_cmd;
            n = 1;
        } else {
            n = 2;
        }
        return n;
    }

    boolean pred_dev(WorkItem workItem) {
        return workItem.dev == dev_to_del;
    }

    boolean pred(WorkItem workItem) {
        if (workItem.dev == dev_to_del) {
            if (workItem.type == type_to_del) {
                return workItem.name.equals(name_to_del);
            }
            return false;
        }
        return false;
    }

    void execute_cmd() {
        WorkItem workItem = new WorkItem();
        block0 : switch (this.local_cmd.cmd_code) {
            case 0: {
                Util.out5.println("Received a Add object command");
                workItem.dev = this.local_cmd.dev;
                workItem.poll_list = workItem.dev.get_poll_obj_list();
                PollObj pollObj = (PollObj)workItem.poll_list.elementAt(this.local_cmd.index);
                workItem.type = pollObj.get_type();
                workItem.update = pollObj.get_upd();
                workItem.name = pollObj.get_name();
                if (workItem.update != 0L) {
                    this.now.tv_usec += new Random().nextInt(500000);
                    workItem.wake_up_date = this.now;
                    this.insert_in_list(workItem);
                    break;
                }
                workItem.wake_up_date.tv_sec = 0;
                workItem.wake_up_date.tv_usec = 0;
                this.ext_trig_works.add(workItem);
                break;
            }
            case 1: {
                Util.out5.println("---> Received a Rem object command");
                dev_to_del = this.local_cmd.dev;
                name_to_del = this.local_cmd.name;
                type_to_del = this.local_cmd.type;
                int n = this.works.size();
                for (int i = 0; i < n; ++i) {
                    WorkItem workItem2 = (WorkItem)this.works.elementAt(i);
                    if (workItem2.dev != dev_to_del || workItem2.type != type_to_del || !workItem2.name.equals(name_to_del)) continue;
                    this.works.remove(i);
                    break block0;
                }
                break;
            }
            case 5: {
                Util.out5.println("Received a Rem device command");
                dev_to_del = this.local_cmd.dev;
                int n = this.works.size();
                for (int i = 0; i < n; ++i) {
                    WorkItem workItem3 = (WorkItem)this.works.elementAt(i);
                    if (workItem3.dev != dev_to_del) continue;
                    this.works.remove(i);
                    --i;
                }
                break;
            }
            case 4: {
                Util.out5.println("Received a update polling period command");
                dev_to_del = this.local_cmd.dev;
                name_to_del = this.local_cmd.name;
                type_to_del = this.local_cmd.type;
                int n = this.works.size();
                for (int i = 0; i < n; ++i) {
                    WorkItem workItem4 = (WorkItem)this.works.elementAt(i);
                    if (workItem4.dev != dev_to_del || workItem4.type != type_to_del || !workItem4.name.equals(name_to_del)) continue;
                    workItem4.update = this.local_cmd.new_upd;
                    break block0;
                }
                break;
            }
            case 2: {
                Util.out5.println("Received a Start polling command");
                this.polling_stop = false;
                break;
            }
            case 3: {
                Util.out5.println("Received a Stop polling command");
                this.polling_stop = true;
            }
        }
        this.shared_cmd.cmd_pending = false;
        this.p_mon.signal();
        if (Util._tracelevel >= 5) {
            this.print_list();
        }
    }

    void one_more_poll() throws DevFailed {
        if (this.works.size() > 0) {
            WorkItem workItem = (WorkItem)this.works.elementAt(0);
            this.works.remove(0);
            if (!this.polling_stop) {
                if (workItem.type == 0) {
                    this.poll_cmd(workItem);
                } else {
                    this.poll_attr(workItem);
                }
            }
            workItem.wake_up_date = this.compute_new_date(workItem.wake_up_date, workItem.update);
            this.insert_in_list(workItem);
        }
    }

    void print_list() {
        for (int i = 0; i < this.works.size(); ++i) {
            WorkItem workItem = (WorkItem)this.works.elementAt(i);
            Util.out4.println("Dev name = " + workItem.dev.get_name() + ", obj name = " + workItem.name + ", next wake_up at " + workItem.wake_up_date.tv_sec + "," + workItem.wake_up_date.tv_usec);
        }
    }

    void insert_in_list(WorkItem workItem) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.works.size() && !bl; ++n) {
            WorkItem workItem2 = (WorkItem)this.works.elementAt(n);
            if (workItem2.wake_up_date.tv_sec < workItem.wake_up_date.tv_sec) continue;
            if (workItem2.wake_up_date.tv_sec == workItem.wake_up_date.tv_sec) {
                if (workItem2.wake_up_date.tv_usec < workItem.wake_up_date.tv_usec) continue;
                this.works.insertElementAt(workItem, n);
                bl = true;
                continue;
            }
            this.works.insertElementAt(workItem, n);
            bl = true;
        }
        if (n == this.works.size()) {
            this.works.add(workItem);
        }
    }

    TimeVal compute_new_date(TimeVal timeVal, long l) {
        double d = (double)timeVal.tv_sec + (double)timeVal.tv_usec / 1000000.0;
        double d2 = d + (double)l / 1000.0;
        TimeVal timeVal2 = new TimeVal();
        timeVal2.tv_sec = (int)d2;
        timeVal2.tv_usec = (int)((d2 - (double)timeVal2.tv_sec) * 1000000.0);
        return timeVal2;
    }

    TimeVal time_diff(TimeVal timeVal, TimeVal timeVal2) {
        double d = (double)timeVal.tv_sec + (double)timeVal.tv_usec / 1000000.0;
        double d2 = (double)timeVal2.tv_sec + (double)timeVal2.tv_usec / 1000000.0;
        double d3 = d2 - d;
        TimeVal timeVal3 = new TimeVal();
        timeVal3.tv_sec = (int)d3;
        timeVal3.tv_usec = (int)((d3 - (double)timeVal3.tv_sec) * 1000000.0);
        return timeVal3;
    }

    void compute_sleep_time() {
        if (this.works.size() > 0) {
            WorkItem workItem = (WorkItem)this.works.elementAt(0);
            double d = (double)workItem.wake_up_date.tv_sec + (double)workItem.wake_up_date.tv_usec / 1000000.0;
            double d2 = (double)this.after.tv_sec + (double)this.after.tv_usec / 1000000.0;
            double d3 = d - d2;
            if (d3 < 0.0) {
                if (Util.fabs(d3) < 0.5) {
                    this.sleep = 0L;
                } else {
                    while (d3 < 0.0 && Util.fabs(d3) > 0.5) {
                        Util.out5.println(d3 + " > " + 0.5);
                        Util.out5.println("Discard one elt !!!!!!!!!!!!!");
                        workItem = (WorkItem)this.works.elementAt(0);
                        this.compute_new_date(workItem.wake_up_date, workItem.update);
                        this.insert_in_list(workItem);
                        this.works.remove(0);
                        workItem = (WorkItem)this.works.elementAt(0);
                        d = (double)workItem.wake_up_date.tv_sec + (double)workItem.wake_up_date.tv_usec / 1000000.0;
                        d3 = d - d2;
                    }
                    this.sleep = Util.fabs(d3) < 0.5 ? 0L : (long)(d3 * 1000.0);
                }
            } else {
                this.sleep = (long)(d3 * 1000.0);
            }
            Util.out5.println("Sleep for : " + this.sleep);
        }
    }

    void poll_cmd(WorkItem workItem) throws DevFailed {
        Util.out5.println("poll_cmd  --> Time = " + this.now.tv_sec + "," + this.now.tv_usec + " Dev name = " + workItem.dev.get_name() + ", Cmd name = " + workItem.name);
        TimeVal timeVal = new TimeVal();
        TimeVal timeVal2 = new TimeVal();
        try {
            long l = System.currentTimeMillis();
            timeVal.tv_sec = (int)(l / 1000L);
            timeVal.tv_usec = (int)(l - (long)(1000 * timeVal.tv_sec)) * 1000;
            timeVal.tv_sec -= 1002000000;
            Any any = ApiUtil.get_orb().create_any();
            Any any2 = workItem.dev.command_inout(workItem.name, any);
            l = System.currentTimeMillis();
            timeVal2.tv_sec = (int)(l / 1000L);
            timeVal2.tv_usec = (int)(l - (long)(1000 * timeVal2.tv_sec)) * 1000;
            timeVal2.tv_sec -= 1002000000;
            TimeVal timeVal3 = this.time_diff(timeVal, timeVal2);
            workItem.dev.get_dev_monitor().get_monitor();
            PollObj pollObj = workItem.dev.get_polled_obj_by_type_name(workItem.type, workItem.name);
            pollObj.insert_data(any2, timeVal, timeVal3);
            workItem.dev.get_dev_monitor().rel_monitor();
        }
        catch (DevFailed devFailed) {
            long l = System.currentTimeMillis();
            timeVal2.tv_sec = (int)(l / 1000L);
            timeVal2.tv_usec = (int)(l - (long)(1000 * timeVal2.tv_sec)) * 1000;
            timeVal2.tv_sec -= 1002000000;
            TimeVal timeVal4 = this.time_diff(timeVal, timeVal2);
            try {
                PollObj pollObj = workItem.dev.get_polled_obj_by_type_name(workItem.type, workItem.name);
                pollObj.insert_except(devFailed, timeVal, timeVal4);
            }
            catch (DevFailed devFailed2) {
                // empty catch block
            }
            workItem.dev.get_dev_monitor().rel_monitor();
        }
    }

    void poll_attr(WorkItem workItem) throws DevFailed {
        Util.out5.println("----------> Time = " + this.now.tv_sec + "," + this.now.tv_usec + " Dev name = " + workItem.dev.get_name() + ", Attr name = " + workItem.name);
        TimeVal timeVal = new TimeVal();
        TimeVal timeVal2 = new TimeVal();
        try {
            long l = System.currentTimeMillis();
            timeVal.tv_sec = (int)(l / 1000L);
            timeVal.tv_usec = (int)(l - (long)(1000 * timeVal.tv_sec)) * 1000;
            timeVal.tv_sec -= 1002000000;
            this.attr_names[0] = workItem.name;
            AttributeValue[] attributeValueArray = workItem.dev.read_attributes(this.attr_names);
            l = System.currentTimeMillis();
            timeVal2.tv_sec = (int)(l / 1000L);
            timeVal2.tv_usec = (int)(l - (long)(1000 * timeVal2.tv_sec)) * 1000;
            timeVal2.tv_sec -= 1002000000;
            TimeVal timeVal3 = this.time_diff(timeVal, timeVal2);
            workItem.dev.get_dev_monitor().get_monitor();
            PollObj pollObj = workItem.dev.get_polled_obj_by_type_name(workItem.type, workItem.name);
            if (pollObj.get_upd() > 0) {
                pollObj.insert_data(attributeValueArray[0], timeVal, timeVal3);
            }
            workItem.dev.get_dev_monitor().rel_monitor();
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
            long l = System.currentTimeMillis();
            timeVal2.tv_sec = (int)(l / 1000L);
            timeVal2.tv_usec = (int)(l - (long)(1000 * timeVal2.tv_sec)) * 1000;
            timeVal2.tv_sec -= 1002000000;
            TimeVal timeVal4 = this.time_diff(timeVal, timeVal2);
            try {
                PollObj pollObj = workItem.dev.get_polled_obj_by_type_name(workItem.type, workItem.name);
                pollObj.insert_except(devFailed, timeVal, timeVal4);
            }
            catch (DevFailed devFailed2) {
                // empty catch block
            }
            workItem.dev.get_dev_monitor().rel_monitor();
        }
    }

    void one_more_trigg() throws DevFailed {
        Util.out5.println("Polling thread has received a trigger");
        WorkItem workItem = null;
        for (int i = 0; i < this.ext_trig_works.size(); ++i) {
            WorkItem workItem2 = (WorkItem)this.ext_trig_works.elementAt(i);
            if (workItem2.dev != this.local_cmd.dev || workItem2.type != this.local_cmd.type || !workItem2.name.equals(this.local_cmd.name)) continue;
            workItem = workItem2;
        }
        if (workItem == null) {
            Util.out5.println("Object externally triggered not found !!!");
            this.shared_cmd.trigger = false;
            this.p_mon.signal();
            return;
        }
        this.shared_cmd.trigger = false;
        this.p_mon.signal();
        WorkItem workItem3 = workItem;
        if (!this.polling_stop) {
            if (workItem3.type == 0) {
                this.poll_cmd(workItem3);
            } else {
                this.poll_attr(workItem3);
            }
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    int n = this.sleep != 0L ? this.get_command(this.sleep) : 2;
                    long l = System.currentTimeMillis();
                    this.now.tv_sec = (int)(l / 1000L);
                    this.now.tv_usec = (int)(l - (long)(1000 * this.now.tv_sec)) * 1000;
                    this.now.tv_sec -= 1002000000;
                    switch (n) {
                        case 0: {
                            this.execute_cmd();
                            break;
                        }
                        case 2: {
                            this.one_more_poll();
                            break;
                        }
                        case 1: {
                            this.one_more_trigg();
                        }
                    }
                    l = System.currentTimeMillis();
                    this.after.tv_sec = (int)(l / 1000L);
                    this.after.tv_usec = (int)(l - (long)(1000 * this.after.tv_sec)) * 1000;
                    this.after.tv_sec -= 1002000000;
                    this.compute_sleep_time();
                }
            }
            catch (DevFailed devFailed) {
                Util.out2.println("OUPS !! A thread fatal exception !!!!!!!!");
                Except.print_exception((Exception)((Object)devFailed));
                Util.out2.println("Trying to re-enter the main loop");
                continue;
            }
            break;
        }
    }

    class WorkItem {
        DeviceImpl dev;
        Vector poll_list;
        TimeVal wake_up_date = new TimeVal();
        long update;
        int type;
        String name;

        WorkItem() {
            this.poll_list = new Vector();
        }

        public String toString() {
            return this.name + " - " + this.update + " ms ";
        }
    }
}

