/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Command;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.KillThread;
import fr.esrf.TangoDs.Logging;
import fr.esrf.TangoDs.MultiAttribute;
import fr.esrf.TangoDs.MyComp;
import fr.esrf.TangoDs.PollObj;
import fr.esrf.TangoDs.PollThCmd;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TangoMonitor;
import fr.esrf.TangoDs.Util;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class DServer
extends DeviceImpl
implements TangoConst {
    protected String process_name;
    protected String instance_name;
    protected StringBuffer full_name;
    protected Vector class_list = new Vector();

    DServer(DeviceClass deviceClass, String string, String string2, DevState devState, String string3) throws DevFailed {
        super(deviceClass, string, string2, devState, string3);
        this.process_name = Util.instance().get_ds_exec_name();
        this.instance_name = Util.instance().get_ds_inst_name();
        this.full_name = new StringBuffer(this.process_name);
        this.full_name.append('/');
        this.full_name.append(this.instance_name);
        this.init_device();
    }

    public void init_device() throws DevFailed {
        block26: {
            Util.out4.println("DServer.DSserver() create dserver " + this.device_name);
            boolean bl = false;
            int n = 0;
            try {
                Util util = Util.instance();
                POAManager pOAManager = util.get_poa().the_POAManager();
                try {
                    pOAManager.activate();
                }
                catch (AdapterInactive adapterInactive) {
                    Except.throw_exception("API_CantActivatePOAManager", "The POA activate method throws an exception", "DServer.init_device()");
                }
                this.class_factory();
                bl = true;
                if (this.class_list.isEmpty()) break block26;
                util.set_class_list(this.class_list);
                String string = util.get_ds_name();
                for (n = 0; n < this.class_list.size(); ++n) {
                    String[] stringArray;
                    Object object;
                    DeviceClass deviceClass = (DeviceClass)this.class_list.elementAt(n);
                    deviceClass.command_factory();
                    MyComp myComp = new MyComp();
                    Collections.sort(deviceClass.get_command_list(), myComp);
                    deviceClass.attribute_factory(deviceClass.get_class_attr().get_attr_list());
                    deviceClass.get_class_attr().init_class_attribute(deviceClass.get_name(), 0);
                    for (int i = 0; i < deviceClass.get_command_list().size(); ++i) {
                        object = (String[])deviceClass.get_command_list().elementAt(i);
                        if (!((Command)object).is_template()) continue;
                        ((Command)object).set_device_class_name(deviceClass.get_name());
                        ((Command)object).analyse_methods();
                    }
                    String[] stringArray2 = null;
                    if (Util._UseDb) {
                        object = new String[]{string, ((DeviceClass)this.class_list.elementAt(n)).get_name()};
                        stringArray = new DeviceData();
                        stringArray.insert((String[])object);
                        DeviceData deviceData = util.get_database().command_inout("DbGetDeviceList", (DeviceData)stringArray);
                        try {
                            stringArray2 = deviceData.extractStringArray();
                        }
                        catch (BAD_OPERATION bAD_OPERATION) {
                            Util.out3.println("DServer.init_device() --> Wrong argument type for DbGetDeviceList command");
                            Except.throw_exception("API_IncompatibleCmdArgumentType", "Imcompatible command argument type returned by the DbGetDeviceList command", "DServer.init_device()");
                        }
                        if (stringArray2.length == 0) {
                            StringBuffer stringBuffer = new StringBuffer("No device defined in database for class ");
                            stringBuffer.append(((DeviceClass)this.class_list.elementAt(n)).get_name());
                            Except.throw_exception("API_DatabaseAccess", stringBuffer.toString(), "DServer.init_device()");
                        }
                        Util.out4.println(stringArray2.length + " device(s) defined");
                        ((DeviceClass)this.class_list.elementAt(n)).device_factory(stringArray2);
                        continue;
                    }
                    object = ((DeviceClass)this.class_list.elementAt(n)).get_nodb_name_list();
                    if (n != this.class_list.size() - 1) {
                        ((DeviceClass)this.class_list.elementAt(n)).device_name_factory((Vector)object);
                    } else if (util.get_cmd_line_name_list().size() == 0) {
                        ((DeviceClass)this.class_list.elementAt(n)).device_name_factory((Vector)object);
                    } else {
                        object = util.get_cmd_line_name_list();
                    }
                    if (((Vector)object).isEmpty()) {
                        stringArray = new String[]{"NoName"};
                    } else {
                        stringArray = new String[((Vector)object).size()];
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            stringArray[i] = (String)((Vector)object).elementAt(i);
                        }
                    }
                    ((DeviceClass)this.class_list.elementAt(n)).device_factory(stringArray);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                StringBuffer stringBuffer = new StringBuffer("Can't allocate memory in server while ");
                if (!bl) {
                    int n2 = this.class_list.size() + 1;
                    stringBuffer.append("creating class number ");
                    stringBuffer.append(n2);
                    if (!this.class_list.isEmpty()) {
                        this.class_list.removeAllElements();
                    }
                } else {
                    stringBuffer.append("building command(s) or device(s) for class number ");
                    stringBuffer.append(n + 1);
                    for (int i = n; i < this.class_list.size(); ++i) {
                        this.class_list.removeElementAt(i);
                    }
                }
                Except.throw_exception("API_MemoryAllocation", stringBuffer.toString(), "DServer.init_device()");
            }
            catch (DevFailed devFailed) {
                if (!bl) {
                    if (!this.class_list.isEmpty()) {
                        this.class_list.removeAllElements();
                    }
                } else {
                    for (int i = n; i < this.class_list.size(); ++i) {
                        this.class_list.removeElementAt(i);
                    }
                }
                throw devFailed;
            }
        }
    }

    private void class_factory() throws DevFailed {
        Class[] classArray;
        Object object;
        Util util = Util.instance();
        String[] stringArray = null;
        try {
            Serializable serializable;
            if (Util._UseDb) {
                serializable = new StringBuffer(util.get_ds_exec_name());
                ((StringBuffer)serializable).append('/');
                ((StringBuffer)serializable).append(util.get_ds_inst_name());
                object = new DeviceData();
                ((DeviceData)object).insert(((StringBuffer)serializable).toString());
                classArray = util.get_database().command_inout("DbGetDeviceServerClassList", (DeviceData)object);
                stringArray = classArray.extractStringArray();
            } else {
                serializable = util.get_class_name_list();
                stringArray = new String[((Vector)serializable).size()];
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    stringArray[i] = (String)((Vector)serializable).elementAt(i);
                }
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            Util.out3.println("DServer.class_factory() --> Wrong argument type for DbGetDeviceServerClassList command");
            Except.throw_exception("API_IncompatibleCmdArgumentType", "Imcompatible command argument type returned by the DbGetDeviceServerClassList command", "DServer.class_factory()");
        }
        catch (DevFailed devFailed) {
            Util.out3.println("DServer.class_factory() --> db command failed");
            Except.throw_exception("API_CantRetrieveClassList", "The db command DbGetDeviceServerClassList failed", "DServer.class_factory()");
        }
        Util.out4.println(stringArray.length - 1 + " class(es) defined in server");
        int n = 0;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                Class<?> clazz;
                Object object2;
                if (stringArray[n].equals("DServer")) continue;
                object = Class.forName("java.lang.String");
                classArray = new Class[]{object};
                int n2 = stringArray[n].indexOf("Class");
                if (n2 == -1) {
                    object2 = new StringBuffer(stringArray[n]);
                    int n3 = stringArray[n].indexOf(".");
                    if (n3 == -1) {
                        ((StringBuffer)object2).insert(0, ".");
                        ((StringBuffer)object2).append("Class");
                        ((StringBuffer)object2).insert(0, stringArray[n]);
                    } else {
                        ((StringBuffer)object2).append("Class");
                    }
                    Util.out4.println("Searching for class : " + object2);
                    clazz = Class.forName(new String((StringBuffer)object2));
                } else {
                    clazz = Class.forName(stringArray[n]);
                }
                object2 = clazz.getMethod("init", classArray);
                Object[] objectArray = new Object[1];
                int n4 = stringArray[n].lastIndexOf(".");
                objectArray[0] = n4 == -1 ? stringArray[n] : stringArray[n].substring(n4 + 1);
                this.class_list.addElement(((Method)object2).invoke(null, objectArray));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classArray = new StringBuffer("Can't retrieve class ");
            classArray.append(stringArray[n]);
            Util.out3.println("DServer.class_factory() --> Can't find class");
            Except.throw_exception("API_ClassNotFound", new String((StringBuffer)classArray), "DServer.class_factory()");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            classArray = new StringBuffer("Can't retrieve init method in class ");
            classArray.append(stringArray[n]);
            Util.out3.println("DServer.class_factory() --> Can't retrieve int method");
            Except.throw_exception("API_InitMethodNotFound", new String((StringBuffer)classArray), "DServer.class_factory()");
        }
        catch (SecurityException securityException) {
            classArray = new StringBuffer("Security exception while creating class ");
            classArray.append(stringArray[n]);
            Util.out3.println("DServer.class_factory() --> Security exception during class creation");
            Except.throw_exception("API_JavaRuntimeSecurityException", new String((StringBuffer)classArray), "DServer.class_factory()");
        }
        catch (InvocationTargetException invocationTargetException) {
            classArray = new StringBuffer("The init method of class ");
            classArray.append(stringArray[n]);
            classArray.append(" throws an exception");
            Util.out3.println("DServer.class_factory() --> Init method send on exception during class creation");
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ConnectionFailed) {
                throw (ConnectionFailed)((Object)throwable);
            }
            if (throwable instanceof DevFailed) {
                throw (DevFailed)((Object)throwable);
            }
            Except.throw_exception("API_InitThrowsException", new String((StringBuffer)classArray), "DServer.class_factory()");
        }
        catch (IllegalAccessException illegalAccessException) {
            classArray = new StringBuffer("The init method of class ");
            classArray.append(stringArray[n]);
            classArray.append(" is not public");
            Util.out3.println("DServer.class_factory() --> Init method not accessible during class creation");
            Except.throw_exception("API_InitNotPublic", new String((StringBuffer)classArray), "DServer.class_factory()");
        }
    }

    public String[] query_class() throws DevFailed {
        Util.out4.println("In QueryClass command");
        int n = this.class_list.size();
        String[] stringArray = null;
        try {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((DeviceClass)this.class_list.elementAt(i)).get_name();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Util.out3.println("Memory Allocation error in DServer.query_class  method");
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DServer.query_class");
        }
        return stringArray;
    }

    public String[] query_device() throws DevFailed {
        int n;
        Util.out4.println("In QueryDevice command");
        int n2 = this.class_list.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n2; ++i) {
            n = ((DeviceClass)this.class_list.elementAt(i)).get_device_list().size();
            for (int j = 0; j < n; ++j) {
                vector.addElement(((DeviceImpl)((DeviceClass)this.class_list.elementAt(i)).get_device_list().elementAt(j)).get_name());
            }
        }
        String[] stringArray = null;
        try {
            stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            Util.out3.println("Memory Allocation error in DServer.query_device method");
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DServer.query_device");
        }
        return stringArray;
    }

    public void restart(String string) throws DevFailed {
        Serializable serializable;
        int n;
        Util.out4.println("In DServer.restart(" + string + ") method");
        Util util = Util.instance();
        Vector vector = util.get_device_list_by_class(((DeviceClass)this.class_list.elementAt(0)).get_name());
        int n2 = this.class_list.size();
        DeviceImpl deviceImpl = null;
        DeviceClass deviceClass = null;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            vector = util.get_device_list_by_class(((DeviceClass)this.class_list.elementAt(n)).get_name());
            int n4 = vector.size();
            for (n3 = 0; n3 < n4; ++n3) {
                if (!((DeviceImpl)vector.elementAt(n3)).get_name().equals(string)) continue;
                deviceImpl = (DeviceImpl)vector.elementAt(n3);
                deviceClass = (DeviceClass)this.class_list.elementAt(n);
                break;
            }
            if (deviceImpl != null && deviceClass != null) break;
        }
        if (deviceImpl == null || deviceClass == null) {
            serializable = new StringBuffer("Device ");
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append(" not found");
            Except.throw_exception("API_DeviceNotFound", new String((StringBuffer)serializable), "Dserver.restart()");
        }
        vector.removeElementAt(n3);
        assert (deviceImpl != null);
        serializable = deviceImpl.get_poll_obj_list();
        Vector vector2 = new Vector();
        for (n = 0; n < ((Vector)serializable).size(); ++n) {
            vector2.add(((Vector)serializable).elementAt(n));
        }
        if (vector2.size() > 0) {
            this.stop_polling();
        }
        POA pOA = util.get_poa();
        if (deviceImpl.get_exported_flag()) {
            try {
                pOA.deactivate_object(deviceImpl.get_obj_id());
            }
            catch (WrongPolicy wrongPolicy) {
            }
            catch (ObjectNotActive objectNotActive) {
                // empty catch block
            }
        }
        String[] stringArray = new String[]{string};
        assert (deviceClass != null);
        deviceClass.device_factory(stringArray);
        DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
        devVarLongStringArray.lvalue = new int[1];
        devVarLongStringArray.svalue = new String[3];
        for (n = 0; n < vector2.size(); ++n) {
            PollObj pollObj = (PollObj)vector2.elementAt(n);
            devVarLongStringArray.lvalue[0] = pollObj.get_upd_i();
            devVarLongStringArray.svalue[0] = pollObj.get_name();
            devVarLongStringArray.svalue[1] = pollObj.type == 0 ? "command" : "attribute";
            devVarLongStringArray.svalue[2] = pollObj.name;
            try {
                this.add_obj_polling(devVarLongStringArray, false);
                continue;
            }
            catch (DevFailed devFailed) {
                if (Util._tracelevel < 4) continue;
                Except.print_exception((Exception)((Object)devFailed));
            }
        }
    }

    public void restart_server() throws DevFailed {
        Util.out4.println("In DServer.restart_server() method");
        this.set_state(DevState.ON);
        this.set_status("The device is ON");
        MultiAttribute multiAttribute = new MultiAttribute(this.device_name, this.get_device_class());
        this.set_device_attr(multiAttribute);
        if (!this.class_list.isEmpty()) {
            int n = this.class_list.size();
            POA pOA = Util.instance().get_poa();
            for (int i = 0; i < n; ++i) {
                Vector vector = ((DeviceClass)this.class_list.elementAt(i)).get_device_list();
                int n2 = vector.size();
                for (int j = 0; j < n2; ++j) {
                    if (!((DeviceImpl)vector.elementAt(j)).get_exported_flag()) continue;
                    try {
                        pOA.deactivate_object(((DeviceImpl)vector.elementAt(j)).get_obj_id());
                        continue;
                    }
                    catch (WrongPolicy wrongPolicy) {
                        continue;
                    }
                    catch (ObjectNotActive objectNotActive) {
                        // empty catch block
                    }
                }
                vector.removeAllElements();
                ((DeviceClass)this.class_list.elementAt(i)).get_command_list().removeAllElements();
            }
            this.class_list.removeAllElements();
            System.gc();
        }
        this.init_device();
        Util.instance().polling_configure();
    }

    public void kill() {
        Util.out4.println("In Kill command");
        KillThread killThread = new KillThread();
        killThread.start();
    }

    public String get_process_name() {
        return this.process_name;
    }

    public String get_personal_name() {
        return this.instance_name;
    }

    public String get_instance_name() {
        return this.instance_name;
    }

    public String get_full_name() {
        return new String(this.full_name);
    }

    public Vector get_class_list() {
        return this.class_list;
    }

    public Logger get_logger() {
        return Logging.core_logger();
    }

    public void init_logger() {
    }

    String[] polled_device() {
        int n;
        Util.out4.println("In polled_device command");
        int n2 = this.class_list.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n2; ++i) {
            DeviceClass deviceClass = (DeviceClass)this.class_list.elementAt(i);
            int n3 = deviceClass.get_device_list().size();
            for (n = 0; n < n3; ++n) {
                DeviceImpl deviceImpl = deviceClass.get_device_at(n);
                if (!deviceImpl.is_polled()) continue;
                vector.add(deviceImpl.get_name());
            }
        }
        if (vector.size() == 0) {
            Util.out4.println("Return an empty sequence because no devices are polled");
            return new String[0];
        }
        MyComp myComp = new MyComp();
        Collections.sort(vector, myComp);
        int n4 = vector.size();
        String[] stringArray = new String[n4];
        for (n = 0; n < n4; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    synchronized String[] dev_poll_status(String string) throws DevFailed {
        Util.out4.println("In dev_poll_status command");
        DeviceImpl deviceImpl = Util.instance().get_device_by_name(string);
        Vector vector = deviceImpl.get_poll_obj_list();
        int n = vector.size();
        if (n == 0) {
            return new String[0];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            PollObj pollObj = (PollObj)vector.elementAt(i);
            if (pollObj.get_type() != 0) continue;
            ++n2;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = n2;
        for (int i = 0; i < n; ++i) {
            PollObj pollObj = (PollObj)vector.elementAt(i);
            int n5 = pollObj.get_type();
            String string2 = n5 == 0 ? "Polled command name = " : "Polled attribute name = ";
            string2 = string2 + pollObj.get_name();
            string2 = string2 + "\nPolling period (mS) = ";
            int n6 = pollObj.get_upd();
            string2 = string2 + n6;
            string2 = string2 + "\nPolling ring buffer depth = ";
            int n7 = deviceImpl.get_poll_ring_depth();
            string2 = n7 == 0 ? string2 + 10 : string2 + n7;
            if (pollObj.is_ring_empty()) {
                string2 = string2 + "\nNo data recorded yet";
            } else {
                Object object;
                int n8;
                int n9;
                int n10;
                int n11;
                string2 = string2 + "\nTime needed for the last ";
                string2 = n5 == 0 ? string2 + "command execution (mS) = " : string2 + "attribute reading (mS) = ";
                string2 = string2 + pollObj.get_needed_time_i();
                string2 = string2 + "\nData not updated since ";
                double d = pollObj.get_last_insert_date_i();
                long l = System.currentTimeMillis();
                int n12 = (int)(l / 1000L);
                double d2 = (double)n12 + (double)(n11 = (int)(l - (long)(1000 * n12)) * 1000) / 1000000.0;
                double d3 = d2 - d;
                if (d3 < 1.0) {
                    n10 = (int)(d3 * 1000.0);
                    string2 = string2 + n10 + " mS";
                } else if (d3 < 60.0) {
                    n10 = (int)d3;
                    n9 = (int)((d3 - (double)n10) * 1000.0);
                    string2 = string2 + n10 + " S and ";
                    string2 = string2 + n9 + " mS";
                } else {
                    n10 = (int)(d3 / 60.0);
                    n9 = (int)(d3 - (double)(60 * n10));
                    n8 = (int)((d3 - (double)((int)d3)) * 1000.0);
                    string2 = string2 + n10 + " MN";
                    if (n9 != 0) {
                        string2 = string2 + " ," + n9 + " S";
                    }
                    if (n8 != 0) {
                        string2 = string2 + " and " + n8 + " mS";
                    }
                }
                try {
                    string2 = string2 + "\nDelta between last records (in mS) = ";
                    object = pollObj.get_delta_t_i(4);
                    for (n9 = 0; n9 < ((double[])object).length; ++n9) {
                        n8 = (int)(object[n9] * 1000.0);
                        string2 = string2 + n8;
                        if (n9 == ((double[])object).length - 1) continue;
                        string2 = string2 + ", ";
                    }
                }
                catch (DevFailed devFailed) {
                    // empty catch block
                }
                if (pollObj.is_last_an_error_i()) {
                    string2 = n5 == 0 ? string2 + "\nLast command execution FAILED :" : string2 + "\nLast attribute read FAILED :";
                    object = (Object)pollObj.get_last_except_i();
                    string2 = string2 + "\n\tReason = " + object.errors[0].reason;
                    string2 = string2 + "\n\tDesc = " + object.errors[0].desc;
                    string2 = string2 + "\n\tOrigin = " + object.errors[0].origin;
                }
            }
            if (n5 == 0) {
                stringArray[n3] = string2;
                ++n3;
                continue;
            }
            stringArray[n4] = string2;
            ++n4;
        }
        return stringArray;
    }

    public void add_obj_polling(DevVarLongStringArray devVarLongStringArray) throws DevFailed {
        this.add_obj_polling(devVarLongStringArray, true);
    }

    public void add_obj_polling(DevVarLongStringArray devVarLongStringArray, boolean bl) throws DevFailed {
        Object object;
        Object object2;
        int n;
        Util.out4.println("In add_obj_polling command");
        for (String string : devVarLongStringArray.svalue) {
            Util.out4.println("Input string = " + string);
        }
        for (String string : (Util)devVarLongStringArray.lvalue) {
            Util.out4.println("Input long = " + (int)string);
        }
        if (devVarLongStringArray.svalue.length != 3 || devVarLongStringArray.lvalue.length != 1) {
            Except.throw_exception("API_WrongNumberOfArgs", "Incorrect number of inout arguments", "DServer.add_obj_polling");
        }
        Util util = Util.instance();
        DeviceImpl deviceImpl = null;
        try {
            deviceImpl = util.get_device_by_name(devVarLongStringArray.svalue[0]);
        }
        catch (DevFailed devFailed) {
            Except.re_throw_exception(devFailed, "API_DeviceNotFound", "Device " + devVarLongStringArray.svalue[0] + " not found", "DServer.add_obj_polling");
        }
        String string = devVarLongStringArray.svalue[1].toLowerCase();
        String string2 = devVarLongStringArray.svalue[2].toLowerCase();
        int n2 = 0;
        assert (deviceImpl != null);
        if (string.equals("command")) {
            deviceImpl.check_command_exists(string2);
            n2 = 0;
        } else if (string.equals("attribute")) {
            deviceImpl.get_device_attr().get_attr_by_name(string2);
            n2 = 1;
        } else {
            Except.throw_exception("API_NotSupported", "Object type " + string + " not supported", "DServer.add_obj_polling");
        }
        if (n2 == 0 && string2.equals("Init")) {
            Except.throw_exception("API_NotSupported", "It's not possible to poll the Init command!", "DServer.add_obj_polling");
        }
        Vector vector = deviceImpl.get_poll_obj_list();
        for (n = 0; n < vector.size(); ++n) {
            object2 = (PollObj)vector.elementAt(n);
            if (((PollObj)object2).get_type() != n2 || !((PollObj)object2).get_name().equals(string2)) continue;
            object = n2 == 0 ? "Command " : "Attribute ";
            Except.throw_exception("API_AlreadyPolled", (String)object + " " + string2 + " already polled", "DServer.add_obj_polling");
        }
        n = devVarLongStringArray.lvalue[0];
        if (n < 20 && n != 0) {
            Except.throw_exception("API_NotSupported", n + " is below the min authorized period (100 mS)", "DServer.add_obj_polling");
        }
        vector.add(new PollObj(deviceImpl, n2, string2, n));
        Util.out4.println("Sending cmd to polling thread");
        object2 = util.get_poll_monitor();
        object = util.get_poll_shared_cmd();
        if (((PollThCmd)object).cmd_pending) {
            ((TangoMonitor)object2).wait_it();
        }
        ((PollThCmd)object).cmd_pending = true;
        ((PollThCmd)object).cmd_code = 0;
        ((PollThCmd)object).dev = deviceImpl;
        ((PollThCmd)object).index = vector.size() - 1;
        ((TangoMonitor)object2).signal();
        Util.out4.println("Cmd sent to polling thread");
        while (((PollThCmd)object).cmd_pending) {
            boolean bl2 = ((TangoMonitor)object2).wait_it(3000L);
            if (!((PollThCmd)object).cmd_pending || bl2) continue;
            Util.out4.println("TIME OUT");
            vector.remove(vector.size() - 1);
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "DServer.add_obj_polling");
        }
        Util.out4.println("Thread cmd normally executed");
        if (bl && Util._UseDb) {
            DbDatum[] dbDatumArray;
            String string3 = "" + n;
            boolean bl3 = false;
            DbDatum dbDatum = new DbDatum("polled_cmd");
            if (n2 == 0) {
                dbDatumArray = deviceImpl.get_non_auto_polled_cmd();
                for (int i = 0; i < dbDatumArray.size(); ++i) {
                    String string4 = (String)dbDatumArray.elementAt(i);
                    if (!string4.equals(string2)) continue;
                    dbDatumArray.remove(i);
                    dbDatum.name = "non_auto_polled_cmd";
                    dbDatum.insert(this.stringVect2StringArray((Vector)dbDatumArray));
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    int n3;
                    Vector vector2 = deviceImpl.get_polled_cmd();
                    for (n3 = 0; n3 < vector2.size(); n3 += 2) {
                        String string5 = (String)vector2.elementAt(n3);
                        if (!string5.equals(string2)) continue;
                        vector2.remove(n3 + 1);
                        vector2.insertElementAt(string3, n3 + 1);
                        break;
                    }
                    if (n3 == vector2.size()) {
                        vector2.add(string2);
                        vector2.add(string3);
                    }
                    dbDatum.insert(this.stringVect2StringArray(vector2));
                }
            } else {
                dbDatumArray = deviceImpl.get_non_auto_polled_attr();
                for (int i = 0; i < dbDatumArray.size(); ++i) {
                    String string6 = (String)dbDatumArray.elementAt(i);
                    if (!string6.equals(string2)) continue;
                    dbDatumArray.remove(i);
                    dbDatum.name = "non_auto_polled_attr";
                    dbDatum.insert(this.stringVect2StringArray((Vector)dbDatumArray));
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    int n4;
                    dbDatum.name = "polled_attr";
                    Vector vector3 = deviceImpl.get_polled_attr();
                    for (n4 = 0; n4 < vector3.size(); n4 += 2) {
                        String string7 = (String)vector3.elementAt(n4);
                        if (!string7.equals(string2)) continue;
                        vector3.remove(n4 + 1);
                        vector3.insertElementAt(string3, n4 + 1);
                        break;
                    }
                    if (n4 == vector3.size()) {
                        vector3.add(string2);
                        vector3.add(string3);
                    }
                    dbDatum.insert(this.stringVect2StringArray(vector3));
                }
            }
            dbDatumArray = new DbDatum[]{dbDatum};
            deviceImpl.get_db_device().put_property(dbDatumArray);
            Util.out4.println("Polling properties updated");
        }
        deviceImpl.is_polled(true);
    }

    void upd_obj_polling(DevVarLongStringArray devVarLongStringArray) throws DevFailed {
        this.upd_obj_polling(devVarLongStringArray, true);
    }

    void upd_obj_polling(DevVarLongStringArray devVarLongStringArray, boolean bl) throws DevFailed {
        Object object;
        Util.out4.println("In upd_obj_polling command");
        for (String string : devVarLongStringArray.svalue) {
            Util.out4.println("Input string = " + string);
        }
        for (String string : (Util)devVarLongStringArray.lvalue) {
            Util.out4.println("Input long = " + (int)string);
        }
        if (devVarLongStringArray.svalue.length != 3 || devVarLongStringArray.lvalue.length != 1) {
            Except.throw_exception("API_WrongNumberOfArgs", "Incorrect number of inout arguments", "DServer.upd_obj_polling");
        }
        Util util = Util.instance();
        DeviceImpl deviceImpl = null;
        try {
            deviceImpl = util.get_device_by_name(devVarLongStringArray.svalue[0]);
        }
        catch (DevFailed devFailed) {
            Except.re_throw_exception(devFailed, "API_DeviceNotFound", "Device " + devVarLongStringArray.svalue[0] + " not found", "DServer.upd_obj_polling");
        }
        assert (deviceImpl != null);
        if (!deviceImpl.is_polled()) {
            Except.throw_exception("API_DeviceNotPolled", "Device " + devVarLongStringArray.svalue[0] + " is not polled", "DServer.upd_obj_polling_period");
        }
        String string = devVarLongStringArray.svalue[1].toLowerCase();
        String string2 = devVarLongStringArray.svalue[2].toLowerCase();
        int n = 0;
        if (string.equals("command")) {
            n = 0;
        } else if (string.equals("attribute")) {
            n = 1;
        } else {
            Except.throw_exception("API_NotSupported", "Object type " + string + " not supported", "DServer.upd_obj_polling_period");
        }
        Vector vector = deviceImpl.get_poll_obj_list();
        for (int i = 0; i < vector.size(); ++i) {
            object = (PollObj)vector.elementAt(i);
            if (((PollObj)object).get_type() != n || !((PollObj)object).get_name().equals(string2)) continue;
            ((PollObj)object).update_upd(devVarLongStringArray.lvalue[0]);
        }
        TangoMonitor tangoMonitor = util.get_poll_monitor();
        object = util.get_poll_shared_cmd();
        if (((PollThCmd)object).cmd_pending) {
            tangoMonitor.wait_it();
        }
        ((PollThCmd)object).cmd_pending = true;
        ((PollThCmd)object).cmd_code = 4;
        ((PollThCmd)object).dev = deviceImpl;
        ((PollThCmd)object).name = string2;
        ((PollThCmd)object).type = n;
        ((PollThCmd)object).new_upd = devVarLongStringArray.lvalue[0];
        tangoMonitor.signal();
        if (bl && Util._UseDb) {
            DbDatum[] dbDatumArray;
            String string3 = "" + devVarLongStringArray.lvalue[0];
            DbDatum dbDatum = new DbDatum("polled_attr");
            if (n == 0) {
                int n2;
                dbDatum.name = "polled_cmd";
                dbDatumArray = deviceImpl.get_polled_cmd();
                for (n2 = 0; n2 < dbDatumArray.size(); n2 += 2) {
                    String string4 = (String)dbDatumArray.elementAt(n2);
                    if (!string4.equals(string2)) continue;
                    dbDatumArray.remove(n2 + 1);
                    dbDatumArray.insertElementAt(string3, n2 + 1);
                    break;
                }
                if (n2 == dbDatumArray.size()) {
                    dbDatumArray.add(string2);
                    dbDatumArray.add(string3);
                }
                dbDatum.insert(this.stringVect2StringArray((Vector)dbDatumArray));
            } else {
                int n3;
                dbDatumArray = deviceImpl.get_polled_attr();
                for (n3 = 0; n3 < dbDatumArray.size(); n3 += 2) {
                    String string5 = (String)dbDatumArray.elementAt(n3);
                    if (!string5.equals(string2)) continue;
                    dbDatumArray.remove(n3 + 1);
                    dbDatumArray.insertElementAt(string3, n3 + 1);
                    break;
                }
                if (n3 == dbDatumArray.size()) {
                    dbDatumArray.add(string2);
                    dbDatumArray.add(string3);
                }
                dbDatum.insert(this.stringVect2StringArray((Vector)dbDatumArray));
            }
            dbDatumArray = new DbDatum[]{dbDatum};
            deviceImpl.get_db_device().put_property(dbDatumArray);
            Util.out4.println("Polling properties updated");
        }
    }

    public void rem_obj_polling(String[] stringArray) throws DevFailed {
        this.rem_obj_polling(stringArray, Util._UseDb);
    }

    public synchronized void rem_obj_polling(String[] stringArray, boolean bl) throws DevFailed {
        Object object;
        String string2;
        Util.out4.println("In rem_obj_polling command");
        for (String string2 : stringArray) {
            Util.out4.println("Input string = " + string2);
        }
        if (stringArray.length != 3) {
            Except.throw_exception("API_WrongNumberOfArgs", "Incorrect number of inout arguments", "DServer.rem_obj_polling");
        }
        Util util = Util.instance();
        DeviceImpl deviceImpl = null;
        try {
            deviceImpl = util.get_device_by_name(stringArray[0]);
        }
        catch (DevFailed devFailed) {
            Except.re_throw_exception(devFailed, "API_DeviceNotFound", "Device " + stringArray + " not found", "DServer.rem_obj_polling");
        }
        assert (deviceImpl != null);
        if (!deviceImpl.is_polled()) {
            Except.throw_exception("API_DeviceNotPolled", "Device " + stringArray[0] + " is not polled", "DServer.rem_obj_polling_period");
        }
        String string3 = stringArray[1].toLowerCase();
        string2 = stringArray[2].toLowerCase();
        int n = 0;
        if (string3.equals("command")) {
            n = 0;
        } else if (string3.equals("attribute")) {
            n = 1;
        } else {
            Except.throw_exception("API_NotSupported", "Object type " + string3 + " not supported", "DServer.rem_obj_polling_period");
        }
        Vector vector = deviceImpl.get_poll_obj_list();
        for (int i = 0; i < vector.size(); ++i) {
            object = (PollObj)vector.elementAt(i);
            if (((PollObj)object).get_type() != n || !((PollObj)object).get_name().equals(string2)) continue;
            vector.remove(i);
        }
        Util.out4.println("Sending cmd to polling thread");
        TangoMonitor tangoMonitor = util.get_poll_monitor();
        object = util.get_poll_shared_cmd();
        if (((PollThCmd)object).cmd_pending) {
            tangoMonitor.signal();
        }
        ((PollThCmd)object).cmd_pending = true;
        ((PollThCmd)object).cmd_code = 1;
        ((PollThCmd)object).dev = deviceImpl;
        ((PollThCmd)object).name = string2;
        ((PollThCmd)object).type = n;
        tangoMonitor.signal();
        Util.out4.println("Cmd sent to polling thread");
        while (((PollThCmd)object).cmd_pending) {
            boolean bl2 = tangoMonitor.wait_it(3000L);
            if (!((PollThCmd)object).cmd_pending || bl2) continue;
            System.out.println("TIME OUT");
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "DServer.rem_obj_polling");
        }
        Util.out4.println("Thread cmd normally executed");
        if (vector.size() == 0) {
            deviceImpl.is_polled(false);
        }
        if (bl && Util._UseDb) {
            DbDatum[] dbDatumArray;
            DbDatum dbDatum = new DbDatum("polled_attr");
            boolean bl3 = false;
            if (n == 0) {
                Object object2;
                int n2;
                dbDatum.name = "polled_cmd";
                dbDatumArray = deviceImpl.get_polled_cmd();
                for (n2 = 0; n2 < dbDatumArray.size(); ++n2) {
                    object2 = (String)dbDatumArray.elementAt(n2);
                    if (((String)object2).equals(string2)) {
                        dbDatumArray.remove(n2);
                        dbDatumArray.remove(n2);
                        dbDatum.insert(this.stringVect2StringArray((Vector)dbDatumArray));
                        bl3 = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl3) {
                    String string4;
                    object2 = deviceImpl.get_non_auto_polled_cmd();
                    for (n2 = 0; n2 < ((Vector)object2).size() && !(string4 = (String)((Vector)object2).elementAt(n2)).equals(string2); ++n2) {
                    }
                    if (n2 == dbDatumArray.size()) {
                        ((Vector)object2).add(string2);
                        dbDatum.name = "non_auto_polled_cmd";
                        dbDatum.insert(this.stringVect2StringArray((Vector)object2));
                        bl3 = true;
                    }
                }
            } else {
                Object object3;
                int n3;
                dbDatumArray = deviceImpl.get_polled_attr();
                for (n3 = 0; n3 < dbDatumArray.size(); ++n3) {
                    object3 = (String)dbDatumArray.elementAt(n3);
                    if (((String)object3).equals(string2)) {
                        dbDatumArray.remove(n3);
                        dbDatumArray.remove(n3);
                        dbDatum.insert(this.stringVect2StringArray((Vector)dbDatumArray));
                        bl3 = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl3) {
                    String string5;
                    object3 = deviceImpl.get_non_auto_polled_attr();
                    for (n3 = 0; n3 < ((Vector)object3).size() && !(string5 = (String)((Vector)object3).elementAt(n3)).equals(string2); ++n3) {
                    }
                    if (n3 == dbDatumArray.size()) {
                        ((Vector)object3).add(string2);
                        dbDatum.name = "non_auto_polled_cmd";
                        dbDatum.insert(this.stringVect2StringArray((Vector)object3));
                        bl3 = true;
                    }
                }
            }
            if (bl3) {
                dbDatumArray = new DbDatum[]{dbDatum};
                deviceImpl.get_db_device().put_property(dbDatumArray);
                Util.out4.println("Polling properties updated");
            }
        }
    }

    synchronized void stop_polling() throws DevFailed {
        Util.out4.println("In stop_polling method");
        Util util = Util.instance();
        TangoMonitor tangoMonitor = util.get_poll_monitor();
        PollThCmd pollThCmd = util.get_poll_shared_cmd();
        if (pollThCmd.cmd_pending) {
            tangoMonitor.signal();
        }
        pollThCmd.cmd_pending = true;
        pollThCmd.cmd_code = 3;
        tangoMonitor.signal();
        while (pollThCmd.cmd_pending) {
            boolean bl = tangoMonitor.wait_it(3000L);
            if (!pollThCmd.cmd_pending || bl) continue;
            Util.out4.println("TIME OUT");
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "DServer.stop_polling");
        }
        util.poll_status(false);
        this.set_status("The device is ON\nThe polling is OFF");
    }

    synchronized void start_polling() throws DevFailed {
        Util.out4.println("In start_polling method");
        Util util = Util.instance();
        TangoMonitor tangoMonitor = util.get_poll_monitor();
        PollThCmd pollThCmd = util.get_poll_shared_cmd();
        if (pollThCmd.cmd_pending) {
            tangoMonitor.signal();
        }
        pollThCmd.cmd_pending = true;
        pollThCmd.cmd_code = 2;
        tangoMonitor.signal();
        while (pollThCmd.cmd_pending) {
            boolean bl = tangoMonitor.wait_it(3000L);
            if (!pollThCmd.cmd_pending || bl) continue;
            Util.out4.println("TIME OUT");
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "DServer.start_polling");
        }
        util.poll_status(true);
        this.set_status("The device is ON\nThe polling is ON");
    }

    private String[] stringVect2StringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }
}

