/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevBooleanHelper;
import fr.esrf.Tango.DevDoubleHelper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevFloatHelper;
import fr.esrf.Tango.DevLong64Helper;
import fr.esrf.Tango.DevLongHelper;
import fr.esrf.Tango.DevShortHelper;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevStringHelper;
import fr.esrf.Tango.DevUCharHelper;
import fr.esrf.Tango.DevULong64Helper;
import fr.esrf.Tango.DevULongHelper;
import fr.esrf.Tango.DevUShortHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarDoubleStringArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLong64ArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarLongStringArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULong64ArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.IDeviceDataDAO;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;

public class DeviceDataDAODefaultImpl
implements TangoConst,
IDeviceDataDAO {
    public void init(DeviceData deviceData) throws DevFailed {
        deviceData.setAny(ApiUtil.get_orb().create_any());
    }

    public void init(DeviceData deviceData, ORB orb) throws DevFailed {
        deviceData.setAny(orb.create_any());
    }

    public void init(DeviceData deviceData, Any any) throws DevFailed {
        deviceData.setAny(any);
    }

    public void insert(DeviceData deviceData) {
    }

    public void insert(DeviceData deviceData, Any any) {
        deviceData.setAny(any);
    }

    public void insert(DeviceData deviceData, boolean argin) {
        DevBooleanHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, short argin) {
        DevShortHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, long argin) {
        DevLong64Helper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, int argin) {
        DevLongHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, float argin) {
        DevFloatHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, double argin) {
        DevDoubleHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, String argin) {
        DevStringHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, DevState argin) {
        DevStateHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, byte[] argin) {
        DevVarCharArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, short[] argin) {
        DevVarShortArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, int[] argin) {
        DevVarLongArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, long[] argin) {
        DevVarLong64ArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, float[] argin) {
        DevVarFloatArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, double[] argin) {
        DevVarDoubleArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, String[] argin) {
        DevVarStringArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, DevVarLongStringArray argin) {
        DevVarLongStringArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert(DeviceData deviceData, DevVarDoubleStringArray argin) {
        DevVarDoubleStringArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_u64(DeviceData deviceData, long[] argin) {
        DevVarULong64ArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_u64(DeviceData deviceData, long argin) {
        DevULong64Helper.insert(deviceData.getAny(), argin);
    }

    public void insert_uc(DeviceData deviceData, short argin) {
        byte val = (byte)(argin & 0xFF);
        DevUCharHelper.insert(deviceData.getAny(), val);
    }

    public void insert_uc(DeviceData deviceData, byte argin) {
        DevUCharHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_us(DeviceData deviceData, int argin) {
        short val = (short)(argin & 0xFFFF);
        DevUShortHelper.insert(deviceData.getAny(), val);
    }

    public void insert_us(DeviceData deviceData, short argin) {
        DevUShortHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_u(DeviceData deviceData, short argin) {
        DevUShortHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_ul(DeviceData deviceData, long argin) {
        int val = (int)(argin & 0xFFFFFFFFFFFFFFFFL);
        DevULongHelper.insert(deviceData.getAny(), val);
    }

    public void insert_ul(DeviceData deviceData, int argin) {
        DevULongHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_u(DeviceData deviceData, int argin) {
        DevULongHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_us(DeviceData deviceData, int[] argin) {
        short[] val = new short[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            val[i] = (short)(argin[i] & 0xFFFF);
        }
        DevVarUShortArrayHelper.insert(deviceData.getAny(), val);
    }

    public void insert_us(DeviceData deviceData, short[] argin) {
        DevVarUShortArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_u(DeviceData deviceData, short[] argin) {
        DevVarUShortArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_ul(DeviceData deviceData, long[] argin) {
        int[] val = new int[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            val[i] = (int)(argin[i] & 0xFFFFFFFFFFFFFFFFL);
        }
        DevVarULongArrayHelper.insert(deviceData.getAny(), val);
    }

    public void insert_ul(DeviceData deviceData, int[] argin) {
        DevVarULongArrayHelper.insert(deviceData.getAny(), argin);
    }

    public void insert_u(DeviceData deviceData, int[] argin) {
        DevVarULongArrayHelper.insert(deviceData.getAny(), argin);
    }

    public Any extractAny(DeviceData deviceData) {
        return deviceData.getAny();
    }

    public boolean extractBoolean(DeviceData deviceData) {
        return DevBooleanHelper.extract(deviceData.getAny());
    }

    public short extractShort(DeviceData deviceData) {
        return DevShortHelper.extract(deviceData.getAny());
    }

    public short extractUChar(DeviceData deviceData) {
        byte tmp = DevUCharHelper.extract(deviceData.getAny());
        short val = (short)(0xFF & tmp);
        return val;
    }

    public int extractUShort(DeviceData deviceData) {
        short tmp = DevUShortHelper.extract(deviceData.getAny());
        int val = 0xFFFF & tmp;
        return val;
    }

    public int extractLong(DeviceData deviceData) {
        return DevLongHelper.extract(deviceData.getAny());
    }

    public long extractLong64(DeviceData deviceData) {
        return DevLong64Helper.extract(deviceData.getAny());
    }

    public long extractULong(DeviceData deviceData) {
        int tmp = DevULongHelper.extract(deviceData.getAny());
        long mask = Integer.MAX_VALUE;
        long val = (long)tmp & (mask += 0x80000000L);
        return val;
    }

    public long extractULong64(DeviceData deviceData) {
        return DevULong64Helper.extract(deviceData.getAny());
    }

    public float extractFloat(DeviceData deviceData) {
        return DevFloatHelper.extract(deviceData.getAny());
    }

    public double extractDouble(DeviceData deviceData) {
        return DevDoubleHelper.extract(deviceData.getAny());
    }

    public String extractString(DeviceData deviceData) {
        return DevStringHelper.extract(deviceData.getAny());
    }

    public DevState extractDevState(DeviceData deviceData) {
        return DevStateHelper.extract(deviceData.getAny());
    }

    public byte[] extractByteArray(DeviceData deviceData) {
        return DevVarCharArrayHelper.extract(deviceData.getAny());
    }

    public short[] extractShortArray(DeviceData deviceData) {
        return DevVarShortArrayHelper.extract(deviceData.getAny());
    }

    public int[] extractUShortArray(DeviceData deviceData) {
        short[] argout = DevVarUShortArrayHelper.extract(deviceData.getAny());
        int[] val = new int[argout.length];
        for (int i = 0; i < argout.length; ++i) {
            val[i] = 0xFFFF & argout[i];
        }
        return val;
    }

    public int[] extractLongArray(DeviceData deviceData) {
        return DevVarLongArrayHelper.extract(deviceData.getAny());
    }

    public long[] extractLong64Array(DeviceData deviceData) {
        return DevVarLong64ArrayHelper.extract(deviceData.getAny());
    }

    public long[] extractULongArray(DeviceData deviceData) {
        int[] argout = DevVarULongArrayHelper.extract(deviceData.getAny());
        long[] val = new long[argout.length];
        long mask = Integer.MAX_VALUE;
        mask += 0x80000000L;
        for (int i = 0; i < argout.length; ++i) {
            val[i] = (long)argout[i] & mask;
        }
        return val;
    }

    public long[] extractULong64Array(DeviceData deviceData) {
        return DevVarULong64ArrayHelper.extract(deviceData.getAny());
    }

    public float[] extractFloatArray(DeviceData deviceData) {
        return DevVarFloatArrayHelper.extract(deviceData.getAny());
    }

    public double[] extractDoubleArray(DeviceData deviceData) {
        return DevVarDoubleArrayHelper.extract(deviceData.getAny());
    }

    public String[] extractStringArray(DeviceData deviceData) {
        if (deviceData.getAny() == null) {
            System.out.println("any = null !!");
        }
        return DevVarStringArrayHelper.extract(deviceData.getAny());
    }

    public DevVarLongStringArray extractLongStringArray(DeviceData deviceData) {
        if (deviceData.getAny() == null) {
            System.out.println("any = null !!");
        }
        return DevVarLongStringArrayHelper.extract(deviceData.getAny());
    }

    public DevVarDoubleStringArray extractDoubleStringArray(DeviceData deviceData) {
        return DevVarDoubleStringArrayHelper.extract(deviceData.getAny());
    }

    public TypeCode type(DeviceData deviceData) {
        return deviceData.getAny().type();
    }

    public int getType(DeviceData deviceData) throws DevFailed {
        int type = 0;
        boolean is_array = false;
        boolean is_struct = false;
        TypeCode tc = deviceData.getAny().type();
        try {
            TCKind kind;
            if (tc.kind().value() == 17) {
                return 19;
            }
            if (tc.kind().value() == 15) {
                is_struct = true;
                tc = tc.member_type(0);
            }
            if (tc.kind().value() == 21) {
                TypeCode tc_alias = tc.content_type();
                if (tc_alias.kind().value() == 19) {
                    TypeCode tc_seq = tc_alias.content_type();
                    kind = tc_seq.kind();
                    is_array = true;
                } else {
                    kind = tc_alias.kind();
                }
            } else {
                kind = tc.kind();
            }
            switch (kind.value()) {
                case 1: {
                    type = 0;
                    break;
                }
                case 8: {
                    type = 1;
                    break;
                }
                case 9: 
                case 10: {
                    if (is_array) {
                        type = 9;
                        break;
                    }
                    type = 21;
                    break;
                }
                case 2: {
                    if (is_array) {
                        type = 10;
                        break;
                    }
                    type = 2;
                    break;
                }
                case 4: {
                    if (is_array) {
                        type = 14;
                        break;
                    }
                    type = 6;
                    break;
                }
                case 3: {
                    if (is_struct) {
                        type = 17;
                        break;
                    }
                    if (is_array) {
                        type = 11;
                        break;
                    }
                    type = 3;
                    break;
                }
                case 5: {
                    if (is_array) {
                        type = 15;
                        break;
                    }
                    type = 7;
                    break;
                }
                case 23: {
                    if (is_array) {
                        type = 25;
                        break;
                    }
                    type = 23;
                    break;
                }
                case 24: {
                    if (is_array) {
                        type = 26;
                        break;
                    }
                    type = 24;
                    break;
                }
                case 6: {
                    if (is_array) {
                        type = 12;
                        break;
                    }
                    type = 4;
                    break;
                }
                case 7: {
                    if (is_struct) {
                        type = 18;
                        break;
                    }
                    if (is_array) {
                        type = 13;
                        break;
                    }
                    type = 5;
                    break;
                }
                case 18: {
                    type = is_array ? 16 : 8;
                }
            }
        }
        catch (BadKind e) {
            e.printStackTrace();
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceAttribute.getType()");
        }
        catch (Bounds e) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceAttribute.getType()");
        }
        return type;
    }
}

