/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrValUnion;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceAttribute_3;
import fr.esrf.TangoApi.DeviceAttribute_3DAODefaultImpl;
import fr.esrf.TangoApi.IDeviceAttributeDAO;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.BAD_PARAM;

public class DeviceAttributeDAODefaultImpl
implements IDeviceAttributeDAO {
    private AttributeValue_4 attrval = new AttributeValue_4();
    private DeviceAttribute_3 devAtt_3 = null;
    private boolean use_union = true;

    private void buildAttributeValueObject(String name) {
        this.attrval.name = name;
        this.attrval.quality = AttrQuality.ATTR_VALID;
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.time = new TimeVal();
        this.attrval.r_dim = new AttributeDim();
        this.attrval.w_dim = new AttributeDim();
        this.attrval.r_dim.dim_x = 1;
        this.attrval.r_dim.dim_y = 0;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.value = new AttrValUnion();
        long now = System.currentTimeMillis();
        this.attrval.time.tv_sec = (int)(now / 1000L);
        this.attrval.time.tv_usec = (int)(now - (long)(this.attrval.time.tv_sec * 1000)) * 1000;
        this.attrval.time.tv_nsec = 0;
        this.attrval.err_list = new DevError[0];
    }

    public void init(AttributeValue_4 attrval) {
        this.attrval = attrval;
    }

    public void init(AttributeValue_3 attrval_3) {
        this.setAttributeValue(attrval_3);
    }

    public void init(AttributeValue attrval_2) {
        this.setAttributeValue(attrval_2);
    }

    public void init(String name) {
        this.buildAttributeValueObject(name);
    }

    public void init(String name, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.attrval.r_dim.dim_x = dim_x;
        this.attrval.r_dim.dim_y = dim_y;
    }

    public void init(String name, boolean value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public void init(String name, DevState value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public void init(String name, boolean[] value, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(value, dim_x, dim_y);
    }

    public void init(String name, byte value) {
        this.buildAttributeValueObject(name);
        this.insert_uc(value);
    }

    public void init(String name, byte[] value, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert_uc(value, dim_x, dim_y);
    }

    public void init(String name, short value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public void init(String name, short[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public void init(String name, int value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public void init(String name, int[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public void init(String name, long value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public void init(String name, long[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public void init(String name, float value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public void init(String name, float[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public void init(String name, double value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public void init(String name, double[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public void init(String name, String value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    public void init(String name, String[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    public boolean hasFailed() {
        return this.attrval.err_list != null && this.attrval.err_list.length > 0;
    }

    public DevError[] getErrStack() {
        return this.attrval.err_list;
    }

    public void setAttributeValue(AttributeValue_4 attrval) {
        this.attrval = attrval;
    }

    public void setAttributeValue(AttributeValue_3 attrval_3) {
        this.devAtt_3 = new DeviceAttribute_3(attrval_3);
        this.use_union = false;
        this.attrval.name = attrval_3.name;
        this.attrval.quality = attrval_3.quality;
        this.attrval.time = attrval_3.time;
        this.attrval.r_dim = attrval_3.r_dim;
        this.attrval.w_dim = attrval_3.w_dim;
        this.attrval.err_list = attrval_3.err_list;
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
    }

    public void setAttributeValue(AttributeValue attrval_2) {
        this.devAtt_3 = new DeviceAttribute_3(attrval_2);
        this.use_union = false;
        this.attrval.name = attrval_2.name;
        this.attrval.quality = attrval_2.quality;
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.time = attrval_2.time;
        this.attrval.r_dim = new AttributeDim();
        this.attrval.w_dim = new AttributeDim();
        this.attrval.r_dim.dim_x = attrval_2.dim_x;
        this.attrval.r_dim.dim_y = attrval_2.dim_y;
        this.attrval.w_dim.dim_x = 0;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.err_list = null;
    }

    public AttributeDim getReadAttributeDim() {
        return this.attrval.r_dim;
    }

    public AttributeDim getWriteAttributeDim() {
        return this.attrval.w_dim;
    }

    public void insert(DevState argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        DevState[] values = new DevState[]{argin};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.state_att_value(values);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(DevState[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.state_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(DevState[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.state_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(boolean argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        boolean[] values = new boolean[]{argin};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.bool_att_value(values);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(boolean[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.bool_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(boolean[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.bool_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert_uc(byte argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] values = new byte[]{argin};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(values);
        } else {
            this.devAtt_3.insert_uc(argin);
        }
    }

    public void insert_uc(byte[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(argin);
        } else {
            this.devAtt_3.insert_uc(argin);
        }
    }

    public void insert_uc(short argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] values = new byte[]{(byte)(argin & 0xFF)};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(values);
        } else {
            this.devAtt_3.insert_uc(argin);
        }
    }

    public void insert_uc(short[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] values = new byte[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (byte)(argin[i] & 0xFF);
        }
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(values);
        } else {
            this.devAtt_3.insert_uc(argin);
        }
    }

    public void insert_uc(short[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] values = new byte[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (byte)(argin[i] & 0xFF);
        }
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(values);
        } else {
            this.devAtt_3.insert_uc(argin);
        }
    }

    public void insert_uc(byte[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.uchar_att_value(argin);
        } else {
            this.devAtt_3.insert_uc(argin);
        }
    }

    public void insert(short argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new short[]{argin});
    }

    public void insert(short[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.short_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(short[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.short_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert_us(short argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] values = new short[]{argin};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(values);
        } else {
            this.devAtt_3.insert_us(argin);
        }
    }

    public void insert_us(int argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] values = new short[]{(short)(argin & 0xFFFF)};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(values);
        } else {
            this.devAtt_3.insert_us(argin);
        }
    }

    public void insert_us(short[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(argin);
        } else {
            this.devAtt_3.insert_us(argin);
        }
    }

    public void insert_us(int[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] values = new short[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (short)(argin[i] & 0xFFFF);
        }
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(values);
        } else {
            this.devAtt_3.insert_us(argin);
        }
    }

    public void insert_us(short[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(argin);
        } else {
            this.devAtt_3.insert_us(argin);
        }
    }

    public void insert_us(int[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] values = new short[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (short)(argin[i] & 0xFFFF);
        }
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.ushort_att_value(values);
        } else {
            this.devAtt_3.insert_us(argin);
        }
    }

    public void insert(int argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new int[]{argin});
    }

    public void insert(int[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.long_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(int[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.long_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(long argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new long[]{argin});
    }

    public void insert(long[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.long64_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(long[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.long64_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert_ul(int argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] values = new int[]{argin};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(values);
        } else {
            this.devAtt_3.insert_ul(argin);
        }
    }

    public void insert_ul(long argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] values = new int[]{(int)argin};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(values);
        } else {
            this.devAtt_3.insert_ul(argin);
        }
    }

    public void insert_ul(int[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(argin);
        } else {
            this.devAtt_3.insert_ul(argin);
        }
    }

    public void insert_ul(long[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] values = new int[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (int)argin[i];
        }
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(values);
        } else {
            this.devAtt_3.insert_ul(argin);
        }
    }

    public void insert_ul(int[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(argin);
        } else {
            this.devAtt_3.insert_ul(argin);
        }
    }

    public void insert_ul(long[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] values = new int[argin.length];
        for (int i = 0; i < argin.length; ++i) {
            values[i] = (int)argin[i];
        }
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.ulong_att_value(values);
        } else {
            this.devAtt_3.insert_ul(argin);
        }
    }

    public void insert_u64(long argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        long[] values = new long[]{argin};
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong64_att_value(values);
        } else {
            this.devAtt_3.insert_u64(argin);
        }
    }

    public void insert_u64(long[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.ulong64_att_value(argin);
        } else {
            this.devAtt_3.insert_u64(argin);
        }
    }

    public void insert_u64(long[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.ulong64_att_value(argin);
        } else {
            this.devAtt_3.insert_u64(argin);
        }
    }

    public void insert(float argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.float_att_value(new float[]{argin});
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(float[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.float_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(float[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.float_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(double argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new double[]{argin});
    }

    public void insert(double[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.double_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(double[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.double_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(String argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.insert(new String[]{argin});
    }

    public void insert(String[] argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = argin.length;
        this.attrval.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attrval.value.string_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(String[] argin, int dim_x, int dim_y) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.w_dim.dim_x = dim_x;
        this.attrval.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attrval.value.string_att_value(argin);
        } else {
            this.devAtt_3.insert(argin);
        }
    }

    public void insert(DevEncoded argin) {
        this.attrval.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attrval.err_list = new DevError[0];
        this.attrval.w_dim.dim_x = 1;
        this.attrval.w_dim.dim_y = 0;
        this.attrval.value.encoded_att_value(new DevEncoded[]{argin});
    }

    private void manageExceptions(String method_name) throws DevFailed {
        if (this.attrval.err_list != null && this.attrval.err_list.length > 0) {
            throw new WrongData(this.attrval.err_list);
        }
        if (this.attrval.quality == AttrQuality.ATTR_INVALID) {
            Except.throw_wrong_data_exception("AttrQuality_ATTR_INVALID", "Attribute quality factor is INVALID", "DeviceAttribute." + method_name + "()");
        }
    }

    public DevState[] extractDevStateArray() throws DevFailed {
        this.manageExceptions("extractDevStateArray()");
        try {
            if (this.use_union) {
                if (this.attrval.value.discriminator().value() == 12) {
                    return new DevState[]{this.attrval.value.dev_state_att()};
                }
                return this.attrval.value.state_att_value();
            }
            return this.devAtt_3.extractDevStateArray();
        }
        catch (BAD_PARAM e) {
            Except.throw_wrong_data_exception(e.toString(), "Exception catched : " + e.toString() + "\n" + "Maybe the attribute value has not been initialized", "DeviceAttribute.extractDevStateArray()");
            return new DevState[0];
        }
    }

    public DevState extractDevState() throws DevFailed {
        this.manageExceptions("extractDevState");
        if (this.use_union) {
            if (this.attrval.value.discriminator().value() == 12) {
                return this.attrval.value.dev_state_att();
            }
            return this.attrval.value.state_att_value()[0];
        }
        return this.devAtt_3.extractDevState();
    }

    public boolean extractBoolean() throws DevFailed {
        this.manageExceptions("extractBoolean()");
        if (this.use_union) {
            return this.attrval.value.bool_att_value()[0];
        }
        return this.devAtt_3.extractBoolean();
    }

    public boolean[] extractBooleanArray() throws DevFailed {
        this.manageExceptions("extractBooleanArray()");
        if (this.use_union) {
            return this.attrval.value.bool_att_value();
        }
        return this.devAtt_3.extractBooleanArray();
    }

    public short extractUChar() throws DevFailed {
        this.manageExceptions("extractUChar");
        if (this.use_union) {
            return this.attrval.value.uchar_att_value()[0];
        }
        return this.devAtt_3.extractUChar();
    }

    public short[] extractUCharArray() throws DevFailed {
        this.manageExceptions("extractUCharArray()");
        if (this.use_union) {
            byte[] argout = this.attrval.value.uchar_att_value();
            short[] val = new short[argout.length];
            int mask = 255;
            for (int i = 0; i < argout.length; ++i) {
                val[i] = (short)(mask & argout[i]);
            }
            return val;
        }
        return this.devAtt_3.extractUCharArray();
    }

    public byte[] extractCharArray() throws DevFailed {
        this.manageExceptions("extractCharArray()");
        if (this.use_union) {
            return this.attrval.value.uchar_att_value();
        }
        return this.devAtt_3.extractCharArray();
    }

    public short extractShort() throws DevFailed {
        this.manageExceptions("extractShort()");
        if (this.use_union) {
            return this.attrval.value.short_att_value()[0];
        }
        return this.devAtt_3.extractShort();
    }

    public short[] extractShortArray() throws DevFailed {
        this.manageExceptions("extractShortArray");
        if (this.use_union) {
            return this.attrval.value.short_att_value();
        }
        return this.devAtt_3.extractShortArray();
    }

    public int extractUShort() throws DevFailed {
        this.manageExceptions("extractUShort");
        if (this.use_union) {
            return this.attrval.value.ushort_att_value()[0];
        }
        return this.devAtt_3.extractUShort();
    }

    public int[] extractUShortArray() throws DevFailed {
        this.manageExceptions("extractUShortArray");
        if (this.use_union) {
            short[] argout = this.attrval.value.ushort_att_value();
            int[] val = new int[argout.length];
            for (int i = 0; i < argout.length; ++i) {
                val[i] = 0xFFFF & argout[i];
            }
            return val;
        }
        return this.devAtt_3.extractUShortArray();
    }

    public int extractLong() throws DevFailed {
        this.manageExceptions("extractLong");
        if (this.use_union) {
            return this.attrval.value.long_att_value()[0];
        }
        return this.devAtt_3.extractLong();
    }

    public int[] extractLongArray() throws DevFailed {
        this.manageExceptions("extractLongArray");
        if (this.use_union) {
            return this.attrval.value.long_att_value();
        }
        return this.devAtt_3.extractLongArray();
    }

    public long extractULong() throws DevFailed {
        this.manageExceptions("extractULong");
        if (this.use_union) {
            int[] argout = this.attrval.value.ulong_att_value();
            long mask = Integer.MAX_VALUE;
            return (mask += 0x80000000L) & (long)argout[0];
        }
        return this.devAtt_3.extractULong();
    }

    public long[] extractULongArray() throws DevFailed {
        this.manageExceptions("extractULong");
        if (this.use_union) {
            int[] array = this.attrval.value.ulong_att_value();
            long mask = Integer.MAX_VALUE;
            mask += 0x80000000L;
            long[] result = new long[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = mask & (long)array[i];
            }
            return result;
        }
        return this.devAtt_3.extractULongArray();
    }

    public long extractLong64() throws DevFailed {
        this.manageExceptions("extractLong64");
        if (this.use_union) {
            return this.extractLong64Array()[0];
        }
        return this.devAtt_3.extractLong64();
    }

    public long[] extractLong64Array() throws DevFailed {
        this.manageExceptions("extractLong64Array");
        if (this.use_union) {
            return this.attrval.value.long64_att_value();
        }
        return this.devAtt_3.extractLong64Array();
    }

    public long extractULong64() throws DevFailed {
        this.manageExceptions("extractULong64");
        return this.extractULong64Array()[0];
    }

    public long[] extractULong64Array() throws DevFailed {
        this.manageExceptions("extractULong64Array");
        if (this.use_union) {
            return this.attrval.value.ulong64_att_value();
        }
        return this.devAtt_3.extractULong64Array();
    }

    public float extractFloat() throws DevFailed {
        this.manageExceptions("extractFloat");
        return this.extractFloatArray()[0];
    }

    public float[] extractFloatArray() throws DevFailed {
        this.manageExceptions("extractFloatArray");
        if (this.use_union) {
            return this.attrval.value.float_att_value();
        }
        return this.devAtt_3.extractFloatArray();
    }

    public double extractDouble() throws DevFailed {
        this.manageExceptions("extractDouble");
        return this.extractDoubleArray()[0];
    }

    public double[] extractDoubleArray() throws DevFailed {
        this.manageExceptions("extractDoubleArray");
        if (this.use_union) {
            return this.attrval.value.double_att_value();
        }
        return this.devAtt_3.extractDoubleArray();
    }

    public DevState extractState() throws DevFailed {
        this.manageExceptions("extractState");
        return this.extractDevState();
    }

    public String extractString() throws DevFailed {
        this.manageExceptions("extractString");
        return this.extractStringArray()[0];
    }

    public String[] extractStringArray() throws DevFailed {
        this.manageExceptions("extractStringArray");
        if (this.use_union) {
            return this.attrval.value.string_att_value();
        }
        return this.devAtt_3.extractStringArray();
    }

    public DevEncoded extractDevEncoded() throws DevFailed {
        this.manageExceptions("extractDevEncoded");
        if (this.attrval.value.encoded_att_value() == null) {
            Except.throw_exception("BAD_PARAM", "DevEcoded object is null", "DeviceAttribute.extractDevEncoded()");
        }
        return this.attrval.value.encoded_att_value()[0];
    }

    public DevEncoded[] extractDevEncodedArray() throws DevFailed {
        this.manageExceptions("extractDevEncoded");
        if (this.attrval.value.encoded_att_value() == null) {
            Except.throw_exception("BAD_PARAM", "DevEcoded object is null", "DeviceAttribute.extractDevEncoded()");
        }
        return this.attrval.value.encoded_att_value();
    }

    public AttrQuality getQuality() throws DevFailed {
        this.manageExceptions("getQuality");
        return this.attrval.quality;
    }

    public AttrDataFormat getDataFormat() throws DevFailed {
        return this.attrval.data_format;
    }

    public TimeVal getTimeVal() throws DevFailed {
        this.manageExceptions("getTimeVal");
        return this.attrval.time;
    }

    public long getTimeValSec() throws DevFailed {
        this.manageExceptions("getTimeValSec");
        return this.attrval.time.tv_sec;
    }

    public long getTimeValMillisSec() throws DevFailed {
        this.manageExceptions("getTimeValMillisSec");
        return (long)this.attrval.time.tv_sec * 1000L + (long)this.attrval.time.tv_usec / 1000L;
    }

    public String getName() throws DevFailed {
        return this.attrval.name;
    }

    private int DIM_MINI(int x) {
        return x == 0 ? 1 : x;
    }

    public int getNbRead() throws DevFailed {
        this.manageExceptions("getNbRead");
        return this.attrval.r_dim.dim_x * this.DIM_MINI(this.attrval.r_dim.dim_y);
    }

    public int getNbWritten() throws DevFailed {
        this.manageExceptions("getNbWritten");
        return this.attrval.w_dim.dim_x * this.DIM_MINI(this.attrval.w_dim.dim_y);
    }

    public int getDimX() throws DevFailed {
        this.manageExceptions("getDimX");
        return this.attrval.r_dim.dim_x;
    }

    public int getDimY() throws DevFailed {
        this.manageExceptions("getDimY");
        return this.attrval.r_dim.dim_y;
    }

    public int getWrittenDimX() throws DevFailed {
        this.manageExceptions("getWrittenDimX");
        return this.attrval.w_dim.dim_x;
    }

    public int getWrittenDimY() throws DevFailed {
        this.manageExceptions("getWrittenDimY");
        return this.attrval.w_dim.dim_y;
    }

    public AttributeValue getAttributeValueObject_2() {
        DeviceAttribute_3DAODefaultImpl att = new DeviceAttribute_3DAODefaultImpl();
        att.setAttributeValue(this);
        AttributeValue attrval = att.getAttributeValueObject_2();
        return attrval;
    }

    public AttributeValue_3 getAttributeValueObject_3() {
        DeviceAttribute_3 att = new DeviceAttribute_3();
        att.setAttributeValue(this);
        return att.getAttributeValueObject_3();
    }

    public AttributeValue_4 getAttributeValueObject_4() {
        return this.attrval;
    }

    public long getTime() throws DevFailed {
        this.manageExceptions("getTime");
        return (long)this.attrval.time.tv_sec * 1000L + (long)(this.attrval.time.tv_usec / 1000);
    }

    public int getType() throws DevFailed {
        if (!this.use_union) {
            return this.devAtt_3.getType();
        }
        if (this.attrval.value == null || this.attrval.value.discriminator() == null) {
            Except.throw_exception("AttributeTypeNotSet", "Attribute " + this.attrval.name + " Value Has Not Been Set", "DeviceAttribute.getType()");
        }
        int type = -1;
        try {
            switch (this.attrval.value.discriminator().value()) {
                case 0: {
                    type = 1;
                    break;
                }
                case 1: {
                    type = 2;
                    break;
                }
                case 2: {
                    type = 3;
                    break;
                }
                case 3: {
                    type = 23;
                    break;
                }
                case 4: {
                    type = 4;
                    break;
                }
                case 5: {
                    type = 5;
                    break;
                }
                case 6: {
                    type = 22;
                    break;
                }
                case 7: {
                    type = 6;
                    break;
                }
                case 8: {
                    type = 7;
                    break;
                }
                case 9: {
                    type = 24;
                    break;
                }
                case 10: {
                    type = 8;
                    break;
                }
                case 11: 
                case 12: {
                    type = 19;
                    break;
                }
                case 13: {
                    type = 28;
                    break;
                }
                case 14: {
                    type = 0;
                    break;
                }
                default: {
                    Except.throw_exception("AttributeTypeNotSupported", "Attribute Type (" + this.attrval.value.discriminator().value() + ") Not Supported", "DeviceAttribute.getType()");
                    break;
                }
            }
        }
        catch (BAD_PARAM e) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceAttribute.getType()");
        }
        return type;
    }

    void setValueAsAny(DeviceAttribute_3DAODefaultImpl att_3) throws DevFailed {
        switch (this.getType()) {
            case 1: {
                att_3.insert(this.extractBooleanArray());
                break;
            }
            case 2: {
                att_3.insert(this.extractShortArray());
                break;
            }
            case 3: {
                att_3.insert(this.extractLongArray());
                break;
            }
            case 23: {
                att_3.insert(this.extractLong64Array());
                break;
            }
            case 4: {
                att_3.insert(this.extractFloatArray());
                break;
            }
            case 5: {
                att_3.insert(this.extractDoubleArray());
                break;
            }
            case 22: {
                att_3.insert(this.extractUCharArray());
                break;
            }
            case 6: {
                att_3.insert_us(this.extractUShortArray());
                break;
            }
            case 7: {
                att_3.insert_ul(this.extractULongArray());
                break;
            }
            case 24: {
                att_3.insert_u64(this.extractULong64Array());
                break;
            }
            case 8: {
                att_3.insert(this.extractStringArray());
                break;
            }
            case 19: {
                att_3.insert(this.extractDevStateArray());
            }
        }
    }
}

