/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.AccessProxy;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.ConnectionDAODefaultImpl;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IDatabaseDAO;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoDs.Except;
import java.util.StringTokenizer;
import java.util.Vector;

public class DatabaseDAODefaultImpl
extends ConnectionDAODefaultImpl
implements IDatabaseDAO {
    private boolean access_service_read = false;

    public void init(Database database) throws DevFailed {
        super.init(database);
    }

    public void init(Database database, String host, String port) throws DevFailed {
        super.init((Connection)database, host, port);
    }

    public String toString(Database database) {
        return database.url.host + ":" + database.url.port;
    }

    private String stringArray2String(String[] array) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i >= array.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private void checkAccess(Database database) {
        if (database.check_access && !database.isAccess_checked()) {
            database.access = this.checkAccessControl(database, database.devname);
            database.setAccess_checked(true);
            ApiUtil.getReconnectionDelay();
        }
    }

    public String get_info(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argout = this.command_inout(database, "DbInfo");
        String[] info = argout.extractStringArray();
        return this.stringArray2String(info);
    }

    public String[] get_host_list(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert("*");
        DeviceData argout = this.command_inout(database, "DbGetHostList", argin);
        return argout.extractStringArray();
    }

    public String[] get_host_list(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetHostList", argin);
        return argout.extractStringArray();
    }

    public String[] get_server_class_list(Database database, String servname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout(database, "DbGetDeviceServerClassList", argin);
        String[] list = argout.extractStringArray();
        int nb_classes = list.length == 0 ? 0 : list.length - 1;
        String[] classes = new String[nb_classes];
        int j = 0;
        for (int i = 0; i < list.length && j < nb_classes; ++i) {
            if (list[i].equals("DServer")) continue;
            classes[j++] = list[i];
        }
        return classes;
    }

    public String[] get_server_name_list(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert("*");
        DeviceData argout = this.command_inout(database, "DbGetServerNameList", argin);
        return argout.extractStringArray();
    }

    public String[] get_instance_name_list(Database database, String servname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout(database, "DbGetInstanceNameList", argin);
        return argout.extractStringArray();
    }

    public String[] get_server_list(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert("*");
        DeviceData argout = this.command_inout(database, "DbGetServerList", argin);
        return argout.extractStringArray();
    }

    public String[] get_server_list(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetServerList", argin);
        return argout.extractStringArray();
    }

    public String[] get_host_server_list(Database database, String hostname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(hostname);
        DeviceData argout = this.command_inout(database, "DbGetHostServerList", argin);
        return argout.extractStringArray();
    }

    public DbServInfo get_server_info(Database database, String servname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout(database, "DbGetServerInfo", argin);
        String[] info = argout.extractStringArray();
        return new DbServInfo(info);
    }

    public void put_server_info(Database database, DbServInfo info) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{info.name, info.host, info.controlled ? "1" : "0", Integer.toString(info.startup_level)};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbPutServerInfo", argin);
    }

    public void delete_server_info(Database database, String servname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        this.command_inout(database, "DbDeleteServerInfo", argin);
    }

    public void add_device(Database database, DbDevInfo devinfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(devinfo.toStringArray());
        this.command_inout(database, "DbAddDevice", argin);
    }

    public void add_device(Database database, String devname, String classname, String servname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DbDevInfo devinfo = new DbDevInfo(devname, classname, servname);
        DeviceData argin = new DeviceData();
        argin.insert(devinfo.toStringArray());
        this.command_inout(database, "DbAddDevice", argin);
    }

    public void delete_device(Database database, String devname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        boolean delete = true;
        try {
            DeviceProxy d = new DeviceProxy(devname);
            d.ping();
            delete = false;
        }
        catch (DevFailed e) {
            // empty catch block
        }
        if (delete) {
            DeviceData argin = new DeviceData();
            argin.insert(devname);
            this.command_inout(database, "DbDeleteDevice", argin);
        } else {
            Except.throw_connection_failed("TangoApi_DEVICE_ALIVE", "Cannot delete a device which is ALIVE.", "delete_device()");
        }
    }

    public DeviceInfo get_device_info(Database database, String devname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.command_inout(database, "DbGetDeviceInfo", argin);
        DevVarLongStringArray info = argout.extractLongStringArray();
        return new DeviceInfo(info);
    }

    public String[] get_device_list(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetDeviceWideList", argin);
        return argout.extractStringArray();
    }

    public DbDevImportInfo import_device(Database database, String devname) throws DevFailed {
        int tmp_access = database.access;
        database.access = 1;
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.command_inout(database, "DbImportDevice", argin);
        DevVarLongStringArray info = argout.extractLongStringArray();
        database.access = tmp_access;
        return new DbDevImportInfo(info);
    }

    public void unexport_device(Database database, String devname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        this.command_inout(database, "DbUnExportDevice", argin);
    }

    public void export_device(Database database, DbDevExportInfo devinfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = devinfo.toStringArray();
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbExportDevice", argin);
    }

    public String[] get_device_class_list(Database database, String servname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout(database, "DbGetDeviceClassList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_name(Database database, String servname, String classname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{servname, classname};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.command_inout(database, "DbGetDeviceList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_domain(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetDeviceDomainList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_family(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetDeviceFamilyList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_member(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetDeviceMemberList", argin);
        return argout.extractStringArray();
    }

    public void add_server(Database database, String servname, DbDevInfo[] devinfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[1 + 2 * devinfo.length];
        array[0] = servname;
        for (int i = 0; i < devinfo.length; ++i) {
            array[2 * i + 1] = devinfo[i].name;
            array[2 * i + 2] = devinfo[i]._class;
        }
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbAddServer", argin);
    }

    public void delete_server(Database database, String devname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        this.command_inout(database, "DbDeleteServer", argin);
    }

    public void export_server(Database database, DbDevExportInfo[] devinfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[6 * devinfo.length];
        for (int i = 0; i < devinfo.length; ++i) {
            String[] one = devinfo[i].toStringArray();
            for (int j = 0; j < 6; ++j) {
                array[6 * i + j] = one[j];
            }
        }
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbExportServer", argin);
    }

    public void unexport_server(Database database, String devname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        this.command_inout(database, "DbUnExportServer", argin);
    }

    private String[] dbdatum2StringArray(String name, DbDatum[] properties) {
        int size = 2;
        for (DbDatum property : properties) {
            size += 2;
            size += property.size();
        }
        String[] result = new String[size];
        result[0] = name;
        result[1] = String.valueOf(properties.length);
        int pnum = 2;
        for (int i = 0; i < properties.length; ++i) {
            String[] prop;
            for (String propname : prop = properties[i].toStringArray()) {
                result[pnum++] = propname;
            }
        }
        return result;
    }

    private DbDatum[] stringArray2DbDatum(String[] strprop) {
        int nb_prop = Integer.parseInt(strprop[1]);
        DbDatum[] properties = new DbDatum[nb_prop];
        int i = 2;
        int pnum = 0;
        while (i < strprop.length - 1) {
            int nb = Integer.parseInt(strprop[i + 1]);
            int start_val = i + 2;
            int end_val = i + 2 + nb;
            if (nb > 0) {
                properties[pnum++] = new DbDatum(strprop[i], strprop, start_val, end_val);
            } else {
                String s;
                properties[pnum++] = new DbDatum(strprop[i]);
                if (start_val + 1 < strprop.length && ((s = strprop[start_val]).length() == 0 || s.equals(" "))) {
                    end_val = start_val + 1;
                }
            }
            i = end_val;
        }
        return properties;
    }

    private DbDatum[] get_obj_property(Database database, String name, String type, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            array[i] = properties[i].name;
        }
        return this.get_obj_property(database, name, type, array);
    }

    private DbDatum get_obj_property(Database database, String name, String type, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{propname};
        DbDatum[] data = this.get_obj_property(database, name, type, array);
        return data[0];
    }

    private DbDatum[] get_obj_property(Database database, String name, String type, String[] propnames) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[1 + propnames.length];
        array[0] = name;
        for (int i = 1; i < propnames.length + 1; ++i) {
            array[i] = propnames[i - 1];
        }
        String cmd = "DbGet" + type + "Property";
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.command_inout(database, cmd, argin);
        String[] result = argout.extractStringArray();
        return this.stringArray2DbDatum(result);
    }

    private void delete_obj_property(Database database, String name, String type, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            array[i] = properties[i].name;
        }
        this.delete_obj_property(database, name, type, array);
    }

    private void delete_obj_property(Database database, String name, String type, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{propname};
        this.delete_obj_property(database, name, type, array);
    }

    private void delete_obj_property(Database database, String name, String type, String[] propnames) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[propnames.length + 1];
        array[0] = name;
        System.arraycopy(propnames, 0, array, 1, propnames.length);
        String cmd = "DbDelete" + type + "Property";
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, cmd, argin);
    }

    public String[] get_object_list(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetObjectList", argin);
        return argout.extractStringArray();
    }

    public String[] get_object_property_list(Database database, String objname, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{objname, wildcard};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.command_inout(database, "DbGetPropertyList", argin);
        return argout.extractStringArray();
    }

    public DbDatum[] get_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "";
        return this.get_obj_property(database, name, type, propnames);
    }

    public DbDatum get_property(Database database, String name, String propname) throws DevFailed {
        String type = "";
        return this.get_obj_property(database, name, type, propname);
    }

    public DbDatum get_property(Database database, String name, String propname, boolean forced) throws DevFailed {
        int tmp_access = database.access;
        if (forced) {
            database.access = 1;
        }
        DbDatum datum = null;
        try {
            String[] array = new String[]{name, propname};
            DeviceData argin = new DeviceData();
            argin.insert(array);
            DeviceData argout = this.command_inout(database, "DbGetProperty", argin);
            String[] result = argout.extractStringArray();
            datum = this.stringArray2DbDatum(result)[0];
            database.access = tmp_access;
        }
        catch (DevFailed e) {
            database.access = tmp_access;
            throw e;
        }
        return datum;
    }

    public DbDatum[] get_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "";
        return this.get_obj_property(database, name, type, properties);
    }

    public void put_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = this.dbdatum2StringArray(name, properties);
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbPutProperty", argin);
    }

    public void delete_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "";
        this.delete_obj_property(database, name, type, propnames);
    }

    public void delete_property(Database database, String name, String propname) throws DevFailed {
        String type = "";
        this.delete_obj_property(database, name, type, propname);
    }

    public void delete_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "";
        this.delete_obj_property(database, name, type, properties);
    }

    public String[] get_class_property_list(Database database, String classname, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(classname);
        DeviceData argout = this.command_inout(database, "DbGetClassPropertyList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_property_list(Database database, String devname, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{devname, wildcard};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.command_inout(database, "DbGetDevicePropertyList", argin);
        return argout.extractStringArray();
    }

    public String get_class_for_device(Database database, String devname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.command_inout(database, "DbGetClassForDevice", argin);
        return argout.extractString();
    }

    public String[] get_class_inheritance_for_device(Database database, String devname) throws DevFailed {
        String[] result;
        block3: {
            if (!database.isAccess_checked()) {
                this.checkAccess(database);
            }
            result = new String[]{"Device_3Impl"};
            try {
                DeviceData argin = new DeviceData();
                argin.insert(devname);
                DeviceData argout = this.command_inout(database, "DbGetClassInheritanceForDevice", argin);
                result = argout.extractStringArray();
            }
            catch (DevFailed e) {
                if (e.errors[0].reason.equals("API_CommandNotFound")) break block3;
                throw e;
            }
        }
        return result;
    }

    public DbDatum[] get_device_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "Device";
        return this.get_obj_property(database, name, type, propnames);
    }

    public DbDatum get_device_property(Database database, String name, String propname) throws DevFailed {
        String type = "Device";
        return this.get_obj_property(database, name, type, propname);
    }

    public DbDatum[] get_device_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "Device";
        return this.get_obj_property(database, name, type, properties);
    }

    public void put_device_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = this.dbdatum2StringArray(name, properties);
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbPutDeviceProperty", argin);
    }

    public void delete_device_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "Device";
        this.delete_obj_property(database, name, type, propnames);
    }

    public void delete_device_property(Database database, String name, String propname) throws DevFailed {
        String type = "Device";
        this.delete_obj_property(database, name, type, propname);
    }

    public void delete_device_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "Device";
        this.delete_obj_property(database, name, type, properties);
    }

    public String[] get_device_attribute_list(Database database, String devname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{devname, "*"});
        DeviceData argout = this.command_inout(database, "DbGetDeviceAttributeList", argin);
        return argout.extractStringArray();
    }

    public DbAttribute[] get_device_attribute_property(Database database, String devname, String[] attnames) throws DevFailed {
        DeviceData argout;
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        int mode = 2;
        try {
            argin.insert(ApiUtil.toStringArray(devname, attnames));
            argout = this.command_inout(database, "DbGetDeviceAttributeProperty2", argin);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                argout = this.command_inout(database, "DbGetDeviceAttributeProperty", argin);
                mode = 1;
            }
            throw e;
        }
        return ApiUtil.toDbAttributeArray(argout.extractStringArray(), mode);
    }

    public DbAttribute get_device_attribute_property(Database database, String devname, String attname) throws DevFailed {
        String[] attnames = new String[]{attname};
        return this.get_device_attribute_property(database, devname, attnames)[0];
    }

    public void put_device_attribute_property(Database database, String devname, DbAttribute[] attr) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        try {
            argin.insert(ApiUtil.toStringArray(devname, attr, 2));
            this.command_inout(database, "DbPutDeviceAttributeProperty2", argin);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                argin.insert(ApiUtil.toStringArray(devname, attr, 1));
                this.command_inout(database, "DbPutDeviceAttributeProperty", argin);
            }
            throw e;
        }
    }

    public void put_device_attribute_property(Database database, String devname, DbAttribute attr) throws DevFailed {
        DbAttribute[] da = new DbAttribute[]{attr};
        this.put_device_attribute_property(database, devname, da);
    }

    public void delete_device_attribute_property(Database database, String devname, DbAttribute attr) throws DevFailed {
        this.delete_device_attribute_property(database, devname, attr.name, attr.get_property_list());
    }

    public void delete_device_attribute_property(Database database, String devname, DbAttribute[] attribute) throws DevFailed {
        for (DbAttribute att : attribute) {
            this.delete_device_attribute_property(database, devname, att.name, att.get_property_list());
        }
    }

    public void delete_device_attribute_property(Database database, String devname, String attname, String[] propnames) throws DevFailed {
        if (propnames.length == 0) {
            return;
        }
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[2 + propnames.length];
        array[0] = devname;
        array[1] = attname;
        System.arraycopy(propnames, 0, array, 2, propnames.length);
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbDeleteDeviceAttributeProperty", argin);
    }

    public void delete_device_attribute_property(Database database, String devname, String attname, String propname) throws DevFailed {
        String[] array = new String[]{propname};
        this.delete_device_attribute_property(database, devname, attname, array);
    }

    public void delete_device_attribute(Database database, String devname, String attname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{devname, attname};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbDeleteDeviceAttribute", argin);
    }

    public String[] get_class_list(Database database, String servname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout(database, "DbGetClassList", argin);
        return argout.extractStringArray();
    }

    public DbDatum[] get_class_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "Class";
        return this.get_obj_property(database, name, type, propnames);
    }

    public DbDatum get_class_property(Database database, String name, String propname) throws DevFailed {
        String type = "Class";
        return this.get_obj_property(database, name, type, propname);
    }

    public DbDatum[] get_class_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "Class";
        return this.get_obj_property(database, name, type, properties);
    }

    public void put_class_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = this.dbdatum2StringArray(name, properties);
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbPutClassProperty", argin);
    }

    public void delete_class_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "Class";
        this.delete_obj_property(database, name, type, propnames);
    }

    public void delete_class_property(Database database, String name, String propname) throws DevFailed {
        String type = "Class";
        this.delete_obj_property(database, name, type, propname);
    }

    public void delete_class_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "Class";
        this.delete_obj_property(database, name, type, properties);
    }

    public String[] get_class_attribute_list(Database database, String classname, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(ApiUtil.toStringArray(classname, wildcard));
        DeviceData argout = this.command_inout(database, "DbGetClassAttributeList", argin);
        return argout.extractStringArray();
    }

    public DbAttribute get_class_attribute_property(Database database, String classname, String attname) throws DevFailed {
        String[] attnames = new String[]{attname};
        return this.get_class_attribute_property(database, classname, attnames)[0];
    }

    public DbAttribute[] get_class_attribute_property(Database database, String classname, String[] attnames) throws DevFailed {
        DeviceData argout;
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        int mode = 2;
        try {
            argin.insert(ApiUtil.toStringArray(classname, attnames));
            argout = this.command_inout(database, "DbGetClassAttributeProperty2", argin);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                argout = this.command_inout(database, "DbGetClassAttributeProperty", argin);
                mode = 1;
            }
            throw e;
        }
        return ApiUtil.toDbAttributeArray(argout.extractStringArray(), mode);
    }

    public void put_class_attribute_property(Database database, String classname, DbAttribute[] attr) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(ApiUtil.toStringArray(classname, attr, 2));
        this.command_inout(database, "DbPutClassAttributeProperty2", argin);
    }

    public void put_class_attribute_property(Database database, String classname, DbAttribute attr) throws DevFailed {
        DbAttribute[] da = new DbAttribute[]{attr};
        this.put_class_attribute_property(database, classname, da);
    }

    public void delete_class_attribute_property(Database database, String name, String attname, String propname) throws DevFailed {
        String[] array = new String[]{propname};
        this.delete_class_attribute_property(database, name, attname, array);
    }

    public void delete_class_attribute_property(Database database, String name, String attname, String[] propnames) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[2 + propnames.length];
        array[0] = name;
        array[1] = attname;
        System.arraycopy(propnames, 0, array, 2, propnames.length);
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbDeleteClassAttributeProperty", argin);
    }

    public String[] get_device_exported(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetDeviceExportedList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_exported_for_class(Database database, String classname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(classname);
        DeviceData argout = this.command_inout(database, "DbGetExportdDeviceListForClass", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_alias_list(Database database, String wildcard) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetDeviceAliasList", argin);
        return argout.extractStringArray();
    }

    public String get_device_alias(Database database, String devname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.command_inout(database, "DbGetDeviceAlias", argin);
        return argout.extractString();
    }

    public String get_alias_device(Database database, String alias) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(alias);
        DeviceData argout = this.command_inout(database, "DbGetAliasDevice", argin);
        return argout.extractString();
    }

    public void put_device_alias(Database database, String devname, String aliasname) throws DevFailed {
        String[] array = new String[]{devname, aliasname};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbPutDeviceAlias", argin);
    }

    public void delete_device_alias(Database database, String alias) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(alias);
        this.command_inout(database, "DbDeleteDeviceAlias", argin);
    }

    public String[] get_attribute_alias_list(Database database, String wildcard) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout(database, "DbGetAttributeAliasList", argin);
        return argout.extractStringArray();
    }

    public String get_attribute_alias(Database database, String attname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(attname);
        DeviceData argout = this.command_inout(database, "DbGetAttributeAlias", argin);
        return argout.extractString();
    }

    public void put_attribute_alias(Database database, String attname, String aliasname) throws DevFailed {
        String[] array = new String[]{attname, aliasname};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(database, "DbPutAttributeAlias", argin);
    }

    public void delete_attribute_alias(Database database, String alias) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(alias);
        this.command_inout(database, "DbDeleteAttributeAlias", argin);
    }

    public String[] getDevices(Database database, String wildcard) throws DevFailed {
        StringTokenizer stk = new StringTokenizer(wildcard, "/");
        Vector<String> vector = new Vector<String>();
        while (stk.hasMoreTokens()) {
            vector.add(stk.nextToken());
        }
        if (vector.size() < 3) {
            Except.throw_exception("TangoApi_DeviceNameNotValid", "Device name not valid", "ATangoApi.Database.getDevices()");
        }
        String domain = (String)vector.elementAt(0);
        String family = (String)vector.elementAt(1);
        String member = (String)vector.elementAt(2);
        vector.clear();
        String[] domains = this.get_device_domain(database, domain);
        if (domains.length == 0) {
            domains = new String[]{domain};
        }
        for (String domain_1 : domains) {
            String domain_header = domain_1 + "/";
            String[] families = this.get_device_family(database, domain_header + family);
            if (families.length == 0) {
                families = new String[]{family};
            }
            for (String family_1 : families) {
                String[] members;
                String family_header = domain_header + family_1 + "/";
                for (String member_1 : members = this.get_device_member(database, family_header + member)) {
                    vector.add(family_header + member_1);
                }
            }
        }
        String[] devices = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            devices[i] = (String)vector.elementAt(i);
        }
        return devices;
    }

    public DbEventImportInfo import_event(Database database, String channel_name) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(channel_name);
        DeviceData argout = this.command_inout(database, "DbImportEvent", argin);
        DevVarLongStringArray info = argout.extractLongStringArray();
        return new DbEventImportInfo(info);
    }

    private DbHistory[] convertPropertyHistory(String[] ret, boolean isAttribute) throws DevFailed {
        int i;
        int offset;
        Vector<DbHistory> v = new Vector<DbHistory>();
        int count = 0;
        String aName = "";
        for (i = 0; i < ret.length; i += count + offset) {
            String pCount;
            String pDate;
            String pName;
            if (isAttribute) {
                aName = ret[i];
                pName = ret[i + 1];
                pDate = ret[i + 2];
                pCount = ret[i + 3];
                offset = 4;
            } else {
                pName = ret[i];
                pDate = ret[i + 1];
                pCount = ret[i + 2];
                offset = 3;
            }
            try {
                count = Integer.parseInt(pCount);
            }
            catch (NumberFormatException e) {
                Except.throw_exception("TangoApi_HisotryInvalid", "History format is invalid", "ATangoApi.Database.convertPropertyHistory()");
            }
            String[] value = new String[count];
            for (int j = 0; j < count; ++j) {
                value[j] = ret[i + offset + j];
            }
            if (isAttribute) {
                v.add(new DbHistory(aName, pName, pDate, value));
                continue;
            }
            v.add(new DbHistory(pName, pDate, value));
        }
        DbHistory[] result = new DbHistory[v.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = (DbHistory)v.get(i);
        }
        return result;
    }

    public DbHistory[] get_device_property_history(Database database, String devname, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{devname, propname});
        DeviceData argout = this.command_inout(database, "DbGetDevicePropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), false);
    }

    public DbHistory[] get_device_attribute_property_history(Database database, String devname, String attname, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{devname, attname, propname});
        DeviceData argout = this.command_inout(database, "DbGetDeviceAttributePropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), true);
    }

    public DbHistory[] get_class_property_history(Database database, String classname, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{classname, propname});
        DeviceData argout = this.command_inout(database, "DbGetClassPropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), false);
    }

    public DbHistory[] get_class_attribute_property_history(Database database, String classname, String attname, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{classname, attname, propname});
        DeviceData argout = this.command_inout(database, "DbGetClassAttributePropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), true);
    }

    public DbHistory[] get_property_history(Database database, String objname, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{objname, propname});
        DeviceData argout = this.command_inout(database, "DbGetPropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), false);
    }

    public String[] getServices(Database database, String servicename, String instname) throws DevFailed {
        Vector<String> v = new Vector<String>();
        DbDatum datum = this.get_property(database, "CtrlSystem", "Services", true);
        if (!datum.is_empty()) {
            int separ;
            String[] services = datum.extractStringArray();
            String target = servicename.toLowerCase();
            if (!instname.equals("*")) {
                target = target + "/" + instname.toLowerCase();
                separ = 58;
            } else {
                separ = 47;
            }
            for (String service : services) {
                String startLine;
                int start = service.indexOf(separ);
                if (start <= 0 || !(startLine = service.substring(0, start).toLowerCase()).equals(target)) continue;
                v.add(service.substring(service.indexOf(58) + 1));
            }
        }
        String[] result = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            result[i] = (String)v.get(i);
        }
        return result;
    }

    public void registerService(Database database, String serviceName, String instanceName, String devname) throws DevFailed {
        String[] services = new String[]{};
        DbDatum data = this.get_property(database, "CtrlSystem", "Services");
        if (!data.is_empty()) {
            services = data.extractStringArray();
        }
        String new_line = serviceName + "/" + instanceName;
        String target = new_line.toLowerCase();
        new_line = new_line + ":" + devname;
        boolean exists = false;
        Vector<String> v = new Vector<String>();
        for (String service : services) {
            String line = service.toLowerCase();
            int idx = line.indexOf(58);
            if (idx > 0) {
                line = line.substring(0, idx);
            }
            if (line.equals(target)) {
                exists = true;
                v.add(new_line);
                continue;
            }
            v.add(service);
        }
        if (!exists) {
            v.add(new_line);
        }
        services = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            services[i] = (String)v.get(i);
        }
        data = new DbDatum("Services");
        data.insert(services);
        this.put_property(database, "CtrlSystem", new DbDatum[]{data});
    }

    public void unregisterService(Database database, String serviceName, String instanceName, String devname) throws DevFailed {
        String[] services = new String[]{};
        DbDatum data = this.get_property(database, "CtrlSystem", "Services");
        if (!data.is_empty()) {
            services = data.extractStringArray();
        }
        String target = serviceName + "/" + instanceName;
        target = target.toLowerCase();
        boolean exists = false;
        Vector<String> v = new Vector<String>();
        for (String service : services) {
            String line = service.toLowerCase();
            int idx = line.indexOf(58);
            if (idx > 0) {
                line = line.substring(0, idx);
            }
            if (line.equals(target)) {
                exists = true;
                continue;
            }
            v.add(service);
        }
        if (exists) {
            services = new String[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                services[i] = (String)v.get(i);
            }
            data = new DbDatum("Services");
            data.insert(services);
            this.put_property(database, "CtrlSystem", new DbDatum[]{data});
        }
    }

    public int checkAccessControl(Database database, String devname) {
        if (database.devname == null) {
            database.devname = database.device.name();
        }
        if (devname.equals(database.devname) && database.isAccess_checked()) {
            return database.access;
        }
        int access = 1;
        try {
            if (!database.isAccess_checked() && database.getAccess_proxy() == null) {
                String access_devname = System.getProperty("ACCESS_DEVNAME");
                if (access_devname == null || access_devname.length() == 0) {
                    if (this.access_service_read && !database.check_access) {
                        return 1;
                    }
                    String[] services = this.getServices(database, "AccessControl", "*");
                    if (services.length > 0) {
                        access_devname = services[0];
                    } else {
                        database.check_access = false;
                        this.access_service_read = true;
                        return 1;
                    }
                }
                database.setAccess_proxy(new AccessProxy(access_devname));
            }
            if (database.getAccess_proxy() != null) {
                access = database.getAccess_proxy().checkAccessControl(devname);
            }
            if (!database.isAccess_checked() && !devname.equals(database.device.name())) {
                this.checkAccess(database);
            }
        }
        catch (DevFailed e) {
            access = 0;
            if (e.errors.length > 1 && e.errors[1].reason.equals("TangoApi_CANNOT_IMPORT_DEVICE")) {
                e.errors[0].desc = e.errors[0].desc + "\nControlled access service defined in Db but unreachable --> Read Only access given to all devices...";
            }
            database.setAccess_devfailed(e);
            Except.print_exception((Exception)((Object)e));
        }
        return access;
    }

    public boolean isCommandAllowed(Database database, String classname, String cmd) throws DevFailed {
        if (database.getAccess_proxy() == null) {
            if (!database.isAccess_checked()) {
                this.checkAccess(database);
            }
            return !database.check_access;
        }
        return database.getAccess_proxy().isCommandAllowed(classname, cmd);
    }
}

