#include "conversion_utils.h"
#include <attribute_proxy.h>
#include <device_proxy.h>
#include <templates.cpp>

void PythonPushEventCallbackAttr::push_event(Tango::EventData *event)
{
        EventData py_event;
        DeviceProxyUtils dev_utils(event->device);

        py_event.attr_name = event->attr_name;
        PyThreadState *tstate = 0;
        tstate = PyThreadState_New(interp);
        PyEval_AcquireThread(tstate);
        if (event->err) {
                py_event.err = 1;
                const Tango::DevErrorList &dev_error_list = event->errors;
/*                CORBA::ULong i;
                for (i=0; i < dev_error_list.length() ; i++)
                {
                        py_event.errors.append( dev_error_list[i] );
                }*/
		py_event.errors = Utils::translate_exception_value(dev_error_list);
        } else {
                py_event.err = 0;
		Tango::DeviceAttribute *dati = event->attr_value;
	        int pos = event->attr_name.find_last_of('/');
        	std::string name = event->attr_name.substr(pos + 1, event->attr_name.size() - pos - 1);
	        long arg_type = (dev_utils.get_attribute_type(name)).first;
	        Tango::AttrDataFormat arg_format = (dev_utils.get_attribute_type(name)).second;
	        py_event.attr_value = (boost::python::object)Utils::translate_from_device_attribute((*dati), arg_type, arg_format);
        }

        boost::python::call_method<void>(python_callback.ptr(), "push_event", py_event);
        PyThreadState_Clear(tstate);
        PyThreadState_DeleteCurrent();
}

void PythonAttrReadCallbackAttr::attr_read(Tango::AttrReadEvent *read_event)
{
	AttrReadEvent py_read_event;
	//py_read_event.device = device->getself();
        PyThreadState *tstate = 0;
        tstate = PyThreadState_New(interp);
        PyEval_AcquireThread(tstate);
	py_read_event.attr_names = get_list_from_vector<std::string>(read_event->attr_names);
	if (read_event->err) {
		py_read_event.err = 1;
		const Tango::DevErrorList &dev_error_list = read_event->errors;
		/*CORBA::ULong i;
		for (i=0; i < dev_error_list.length() ; i++)
			py_read_event.errors.append( dev_error_list[i] );*/
		py_read_event.errors = Utils::translate_exception_value(dev_error_list);
	} else {
		py_read_event.err = 0;
		DeviceProxyUtils dev_utils(read_event->device);
		std::vector<Tango::DeviceAttribute> *dev_attr = read_event->argout;
		boost::python::list pyDevAttrList;
		std::vector<Tango::DeviceAttribute>::iterator i;
		long arg_type;
		Tango::AttrDataFormat arg_format;
		for (i = dev_attr->begin() ; i < dev_attr->end() ; i++ )
		{
			arg_type = (dev_utils.get_attribute_type( i->get_name() )).first;
			arg_format = (dev_utils.get_attribute_type( i->get_name() )).second;
			pyDevAttrList.append( Utils::translate_from_device_attribute( *i , arg_type , arg_format ));
		}
		py_read_event.argout = pyDevAttrList;
	}
	boost::python::call_method<void>(python_callback.ptr(),"attr_read",py_read_event);
        PyThreadState_Clear(tstate);
        PyThreadState_DeleteCurrent();
}

void PythonAttrWriteCallbackAttr::attr_written(Tango::AttrWrittenEvent *write_event)
{	
	AttrWrittenEvent py_write_event;
	//py_write_event.device = device->getself();

        PyThreadState *tstate = 0;
        tstate = PyThreadState_New(interp);
        PyEval_AcquireThread(tstate);
	py_write_event.attr_names = get_list_from_vector<std::string>(write_event->attr_names);
	if (write_event->err) {
		py_write_event.err = 1;
		/* commented out to compile in Tango V5: check */
		/*const Tango::DevErrorList &dev_error_list = write_event->errors;
		CORBA::ULong i;
		for (i=0; i < dev_error_list.length() ; i++)
		{
			py_write_event.errors.append( dev_error_list[i] );
		}*/
	} else
		py_write_event.err = 0;
	boost::python::call_method<void>(python_callback.ptr(),"attr_written",py_write_event); 
        PyThreadState_Clear(tstate);
        PyThreadState_DeleteCurrent();
}

AttributeProxyUtils::AttributeProxyUtils(Tango::AttributeProxy *attr) : attributeProxy(attr)
{
	attribute_type = pair<long,Tango::AttrDataFormat>(-1,Tango::SCALAR);
}

std::pair<long,Tango::AttrDataFormat> &AttributeProxyUtils::get_type()
{
	if (attribute_type.first == -1)
	{
		Tango::AttributeInfo attributeInfo = attributeProxy->get_config();
     		attribute_type = pair<long,Tango::AttrDataFormat>(attributeInfo.data_type,attributeInfo.data_format);
	}
	return attribute_type;
}



AttributeProxy::AttributeProxy(std::string name):event_callback(NULL),read_cb(NULL),write_cb(NULL)
{		
	attributeProxy = new Tango::AttributeProxy(name);
	attributeProxyUtils = new AttributeProxyUtils(attributeProxy);
	deviceProxy = new DeviceProxy(attributeProxy->get_device_proxy()->dev_name());
}

AttributeProxy::AttributeProxy(const AttributeProxy& proxy):event_callback(NULL),read_cb(NULL),write_cb(NULL)
{
	attributeProxy = new Tango::AttributeProxy(*proxy.attributeProxy);
	attributeProxyUtils = new AttributeProxyUtils(attributeProxy);
	deviceProxy = new DeviceProxy(attributeProxy->get_device_proxy()->dev_name());
}

AttributeProxy::AttributeProxy(DeviceProxy& d_proxy,std::string at_name):event_callback(NULL),read_cb(NULL),write_cb(NULL)
{
	attributeProxy = new Tango::AttributeProxy(d_proxy.get_internal_proxy(),at_name);
	attributeProxyUtils = new AttributeProxyUtils(attributeProxy);
	deviceProxy = new DeviceProxy(d_proxy.get_internal_proxy());
}

AttributeProxy::~AttributeProxy()
{
	delete deviceProxy;
	delete attributeProxy;
	delete attributeProxyUtils;
	
	if (event_callback != NULL)
		delete event_callback;
	if (read_cb != NULL)
		delete read_cb;
	if (write_cb != NULL)
		delete write_cb;
		
}

int AttributeProxy::ping()
{
	return attributeProxy->ping();
}

boost::python::object AttributeProxy::get_device_proxy()
{
	std::string name = attributeProxy->get_device_proxy()->dev_name();
	DeviceProxy* proxy = new DeviceProxy(name);
	return (boost::python::object) proxy;
}

boost::python::dict AttributeProxy::get_property(boost::python::list list_prop)
{
	Tango::DbData db_data;
	std::vector<std::string> vstr_array;
	get_array_value<std::string>(vstr_array,"String", (boost::python::object)list_prop);
	attributeProxy->get_property(vstr_array,db_data);
	std::vector<Tango::DbDatum>::iterator i;
	boost::python::dict py_list_prop;
	int k;
	for (k=0, i=db_data.begin(); i < db_data.end(); k++,i++)
	{
		boost::python::list py_list_val = get_list_from_vector<std::string>(i->value_string);
		py_list_prop[ vstr_array[k] ] = py_list_val;
	}
	return py_list_prop;
}

void AttributeProxy::put_property(boost::python::dict py_list_prop)
{
	Tango::DbData db_data;
	std::string prop_name;
	std::string i_string;
	boost::python::list list_prop = py_list_prop.keys();
	int p_len = boost::python::extract<int>(list_prop.attr("__len__")()) ;
	for (int i = 0 ; i < p_len; i++ )
	{
		get_scalar_value<std::string>(prop_name,"String",list_prop[i]);
		Tango::DbDatum db_datum(prop_name);
		get_array_value<std::string>(db_datum.value_string,"String list",py_list_prop[prop_name]);
		db_data.push_back(db_datum);
	}
	attributeProxy->put_property(db_data);
}

void AttributeProxy::delete_property(boost::python::list list_prop)
{
	std::vector<std::string> vstr_array;
	get_array_value<std::string>(vstr_array,"String list", (boost::python::object)list_prop);
	attributeProxy->delete_property(vstr_array);
}

boost::python::object AttributeProxy::get_config()
{
	Tango::AttributeInfo attributeInfo = attributeProxy->get_config();
	return boost::python::object (Utils::translate_attribute_info(&attributeInfo) );
}

void AttributeProxy::set_config(AttributeInfo info)
{
	Tango::AttributeInfo t_info = Utils::translate_to_attribute_info(info);
	attributeProxy->set_config(t_info);
}

boost::python::object AttributeProxy::read()
{
	Tango::DeviceAttribute tangoOutData = attributeProxy->read();
	
	std::pair<long,Tango::AttrDataFormat> &type_format = attributeProxyUtils->get_type();
	boost::python::object result = (boost::python::object)Utils::translate_from_device_attribute(tangoOutData,
												     type_format.first,
												     type_format.second);
	return result;
}

void AttributeProxy::write(AttributeValue val)
{
	Tango::DeviceAttribute dev_attr;
	std::pair<long,Tango::AttrDataFormat> &type_format = attributeProxyUtils->get_type();
	Utils::translate_to_device_attribute(dev_attr, val, type_format.first, type_format.second);
	attributeProxy->write(dev_attr);
}

boost::python::object AttributeProxy::history(int depth)
{
	std::pair<long,Tango::AttrDataFormat> &type_format = attributeProxyUtils->get_type();
	std::vector<Tango::DeviceAttributeHistory> *dev_attr_hist = attributeProxy->history(depth);
	boost::python::list pyDevAttrList;
	std::vector<Tango::DeviceAttributeHistory>::iterator i;
	for (i = dev_attr_hist->begin() ; i < dev_attr_hist->end() ; i++ )
		pyDevAttrList.append( Utils::translate_from_attribute_history( *i , type_format.first, type_format.second) );
	delete dev_attr_hist;
	return pyDevAttrList;
}
	
boost::python::object AttributeProxy::read_reply(long id)
{
	std::pair<long,Tango::AttrDataFormat> &type_format = attributeProxyUtils->get_type();
	Tango::DeviceAttribute *tangoOutData = attributeProxy->read_reply(id);
	boost::python::object result = (boost::python::object)Utils::translate_from_device_attribute(*tangoOutData,
												     type_format.first,
												     type_format.second);
	return result;
}

boost::python::object AttributeProxy::read_reply(long id, long to)
{
	std::pair<long,Tango::AttrDataFormat> &type_format = attributeProxyUtils->get_type();
	Tango::DeviceAttribute *tangoOutData = attributeProxy->read_reply(id, to);
	boost::python::object result = (boost::python::object)Utils::translate_from_device_attribute(*tangoOutData,
												     type_format.first,
												     type_format.second);
	return result;
}

long AttributeProxy::write_asynch(AttributeValue val)
{
	Tango::DeviceAttribute dev_attr;
	std::pair<long,Tango::AttrDataFormat> &type_format = attributeProxyUtils->get_type();
	Utils::translate_to_device_attribute(dev_attr, val, type_format.first, type_format.second);
	return attributeProxy->write_asynch(dev_attr);
}

void AttributeProxy::read_asynch(boost::python::object callback)
{
	PyThreadState *tstate = 0;
	
	try
	{
		if (read_cb == NULL)
			read_cb = new PythonAttrReadCallbackAttr(callback);
		else
			read_cb->set_cb(callback);
			
		PyEval_InitThreads();
		tstate = PyEval_SaveThread();
		read_cb->interp = tstate->interp;
		attributeProxy->read_asynch((Tango::CallBack&) *read_cb);
	}
	catch (Tango::DevFailed &e)
	{
		PyEval_RestoreThread(tstate);
		throw e;
	}
	PyEval_RestoreThread(tstate);
}

void AttributeProxy::write_asynch(AttributeValue attr_val, boost::python::object callback)
{
	PyThreadState *tstate = 0;
	
	try
	{
		if (write_cb == NULL)
			write_cb = new PythonAttrWriteCallbackAttr(callback);
		else
			write_cb->set_cb(callback);
			
		Tango::DeviceAttribute dev_attr;
		std::pair<long,Tango::AttrDataFormat> &type_format = attributeProxyUtils->get_type();
		Utils::translate_to_device_attribute(dev_attr, attr_val, type_format.first, type_format.second);
		PyEval_InitThreads();
		tstate = PyEval_SaveThread();
		write_cb->interp = tstate->interp;
		attributeProxy->write_asynch(dev_attr, (Tango::CallBack&) *write_cb);
	}
	catch (Tango::DevFailed &e)
	{
		PyEval_RestoreThread(tstate);
		throw e;
	}
	
	PyEval_RestoreThread(tstate);
}

int AttributeProxy::subscribe_event(Tango::EventType event, boost::python::object call, boost::python::list filters)
{
	PyThreadState *tstate = 0;
	int event_id = 0;
	try
	{	
		std::vector<std::string> str_array;
		get_array_value<std::string>(str_array, "String", filters);
		
		if (event_callback == NULL)
			event_callback = new PythonPushEventCallback(deviceProxy, call);
		else
			event_callback->set_cb(call);
			
		PyEval_InitThreads();
		tstate = PyEval_SaveThread();
		event_callback->interp = tstate->interp;
		event_id = attributeProxy->subscribe_event((Tango::EventType) event, (Tango::CallBack *) event_callback, (const std::vector<string>&) str_array);
	}
	catch (Tango::EventSystemFailed &e)
	{
		PyEval_RestoreThread(tstate);
		throw e;
	}
	catch (Tango::DevFailed &e)
	{
		PyEval_RestoreThread(tstate);
		throw e;
	}
	
	PyEval_RestoreThread(tstate);
	return event_id;

}

void AttributeProxy::unsubscribe_event(int event_id)
{
	attributeProxy->unsubscribe_event(event_id);
}
