static const char *RcsId = "$Header: /cvsroot/tango-cs/tango/bindings/python/src/py_device_proxy3.cpp,v 1.3 2006/04/13 13:40:03 taurel Exp $";
//+=============================================================================
//
// file :         py_device_proxy3.cpp
//
// description :  C++ source using BOOST macros to ease mapping
//                between C++ objects and C/C++ (hidden) instructions
//                for embedding thease  objects into a Python run time
//                This file defines a first subset   of Tango base types
//			(AttributeInfo, AttributeValue, .. etc)
//
// project :      Python Binding
//
// $Author: taurel $
//
// $Revision: 1.3 $
//
// $Log: py_device_proxy3.cpp,v $
// Revision 1.3  2006/04/13 13:40:03  taurel
// Several changes:
// - Add wrapping of the new set/get_transparency_reconnection AttributeProxy class methods
// - Add wrapping of the new AttributeProxy class ctor (with DeviceProxy)
// - Fix bug: Now all Pthon exceptions inherit from PyTango.DevFailed
// - Exception name from WrongSynTax to WrongNameSyntax and Communication to CommunicationFailed to be coherent with C++
// - Change the way attribute data type are managed in AttributeProxy class to speed up read() and write() methods
// - Change the R/W type for some elements of the AttributeInfo class. All of them were read only
//
// Revision 1.2  2004/01/27 09:59:57  ounsy
// Added asynchronous related methods
//
// Revision 1.1  2003/10/23 13:50:55  ounsy
//
//
// Added Python binding for TANGO
//
//
// copyleft :     Synchrotron SOLEIL
//			L'Orme des Merisiers, Saint-Aubin BP 48
//			91192 GIF SUR YVETTE Cedex
//
//-=============================================================================

#include <device_proxy.h>
#include <boost/python/class.hpp>
#include <boost/python/module.hpp>
#include <boost/python/def.hpp>
#include <boost/python/enum.hpp>
#include <boost/python/dict.hpp>
#include <boost/python/operators.hpp>
#include <boost/operators.hpp>
#include <boost/python/overloads.hpp>
#include <boost/python/exception_translator.hpp>
#include <exception>

std::string attrinfo_to_string(AttributeInfo const& attr_info)
{
	std::ostringstream s;
        std::string strtemp;
	s<<"AttributeInfo[\nname : "<<attr_info.name<<",\n";
	s<<"writable : "<<attr_info.writable<<",\n";
	s<<"data_format : "<<attr_info.data_format<<",\n";
	s<<"data_type : "<<attr_info.data_type<<",\n";
	s<<"max_dim_x : "<<attr_info.max_dim_x<<",\n";
	s<<"max_dim_y : "<<attr_info.max_dim_y<<",\n";
	s<<"description : "<<attr_info.description<<",\n";
	s<<"label : "<<attr_info.label<<",\n";
	s<<"unit : "<<attr_info.unit<<",\n";
	s<<"standard_unit : "<<attr_info.standard_unit<<",\n";
	s<<"display_unit : "<<attr_info.display_unit<<",\n";
	s<<"format : "<<attr_info.format<<",\n";
	s<<"min_value : "<<attr_info.min_value<<",\n";
	s<<"max_value : "<<attr_info.max_value<<",\n";
	s<<"mini_alarm : "<<attr_info.min_alarm<<",\n";
	s<<"max_alarm : "<<attr_info.max_alarm<<",\n";
	s<<"writable_attr_name : "<<attr_info.writable_attr_name<<",\n";
        strtemp = boost::python::extract<std::string>((attr_info.extensions).attr("__str__")());
	s<<"extensions : "<<strtemp<<",\n";
	s<<"disp_level : "<<attr_info.disp_level<<"]";
	return s.str();
}

std::string attrvalue_to_string(AttributeValue const& attr_value)
{
	std::ostringstream s;
        std::string strtemp;
        boost::python::object obj;
        strtemp = boost::python::extract<std::string>((attr_value.value).attr("__str__")());
	s<<"AttributeValue[\nvalue : "<<strtemp<<",\n";
	obj = (boost::python::object)attr_value.time;
        strtemp = boost::python::extract<std::string>(obj.attr("__str__")());
	s<<"time : "<<strtemp<<",\n";
	s<<"quality : "<<attr_value.quality<<",\n";
	s<<"name : "<<attr_value.name<<",\n";
	s<<"dim_x : "<<attr_value.dim_x<<",\n";
	s<<"dim_y : "<<attr_value.dim_y<<"]";
	return s.str();
}

std::string attrhist_to_string(DeviceAttributeHistory const& attr_hist)
{
	std::ostringstream s;
        std::string strtemp;
        boost::python::object obj;
	s<<"AttributeHistory[\nattr_failed : "<<attr_hist.attr_failed<<",\n";
        obj = (boost::python::object)attr_hist.value;
        strtemp = boost::python::extract<std::string>(obj.attr("__str__")());
	s<<"value : "<<strtemp<<",\n";
        obj = (boost::python::object)attr_hist.errors;
        strtemp = boost::python::extract<std::string>(obj.attr("__str__")());
	s<<"errors : "<<strtemp<<"]";
	return s.str();
}


void declare_database_types();
//BOOST_PYTHON_MODULE(PyTango)
void declare_base_types_continued()
{
    using namespace boost::python;


     class_<AttributeInfo>("AttributeInfo",
		 "A structure containing available information for an attribute with\n"
		 "the following members,\n"
		 " - name : attribute name\n"
		 " - writable : one of AttrWriteType constant values,\n"
		 "              AttrWriteType.READ, AttrWriteType.READ_WITH_WRITE,\n"
		 "              AttrWriteType.WRITE or AttrWriteType.READ_WRITE\n"
		 " - data_format : one of AttrDataFormat constant values\n"
		 "              AttrWriteType.SCALAR, AttrWriteType.SPECTRUM,\n"
		 "              or AttrWriteType.IMAGE\n"
		 " - data_type : integer value indicating attribute type (float, string,..) \n"
		 " - max_dim_x : first dimension of attribute (spectrum or image attributes)\n"
		 " - max_dim_y : second dimension of attribute(image attribute)\n"
		 " - description : string describing the attribute\n"
		 " - label : attribute label (Voltage, time, ...)\n"
		 " - unit : attribute unit (V, ms, ...)\n"
		 " - standard_unit : string\n"
		 " - display_unit : string\n"
		 " - format : string\n"
		 " - min_value : string\n"
		 " - max_value : string\n"
		 " - min_alarm : string\n"
		 " - max_alarm : string\n"
		 " - writable_attr_name : string\n"
		 " - extensions : list of strings\n"
		 " - disp_level : one of DispLevel constants,\n"
		 "                DispLevel.OPERATOR or DispLevel.EXPERT"
         )
        .def_readonly("name", &AttributeInfo::name)
        .def_readonly("writable", &AttributeInfo::writable)
        .def_readonly("data_format", &AttributeInfo::data_format)
        .def_readonly("data_type", &AttributeInfo::data_type)
        .def_readonly("max_dim_x", &AttributeInfo::max_dim_x)
        .def_readonly("max_dim_y", &AttributeInfo::max_dim_y)
        .def_readwrite("description", &AttributeInfo::description)
        .def_readwrite("label", &AttributeInfo::label)
        .def_readwrite("unit", &AttributeInfo::unit)
        .def_readwrite("standard_unit", &AttributeInfo::standard_unit)
        .def_readwrite("display_unit", &AttributeInfo::display_unit)
        .def_readwrite("format", &AttributeInfo::format)
        .def_readwrite("min_value", &AttributeInfo::min_value)
        .def_readwrite("max_value", &AttributeInfo::max_value)
        .def_readwrite("min_alarm", &AttributeInfo::min_alarm)
        .def_readwrite("max_alarm", &AttributeInfo::max_alarm)
        .def_readwrite("writable_attr_name", &AttributeInfo::writable_attr_name)
        .def_readwrite("extensions", &AttributeInfo::extensions)
        .def_readonly("disp_level", &AttributeInfo::disp_level)
		.def("__str__",&attrinfo_to_string)
	;

     class_<AttributeValue>("AttributeValue",
		 "A structure encapsulating the attribute value with the following\n"
		 "members,\n"
		 " - value : python object with effectuve value\n"
		 " - quality : one of AttrQuality constant values,\n"
		 "             AttrQuality.VALID, AttrQuality.INVALID,\n"
		 "             or AttrQuality.ALARM\n"
		 " - time : time of value read (see TimeVal type)\n"
		 " - name : attribute name \n"
		 " - dim_x : effective first dimension of attribute (spectrum or image attributes)\n"
		 " - dim_y : effective second dimension of attribute(image attribute)"
         )
        .def_readwrite("value", &AttributeValue::value)
        .def_readonly("time", &AttributeValue::time)
        .def_readonly("quality", &AttributeValue::quality)
        .def_readwrite("name", &AttributeValue::name)
        .def_readonly("dim_x", &AttributeValue::dim_x)
        .def_readonly("dim_y", &AttributeValue::dim_y)
		.def("__str__",&attrvalue_to_string)
	;

     class_<DeviceAttributeHistory>("DeviceAttributeHistory",
		 "Structure members,\n"
		 " - attr_failed : true if attribute read operation failed\n"
		 " - value : attribute value as an AttributeValue type,\n"
		 "           valid if attr_failed is false,\n"
		 " - errors : list of errors that occurred (see DevError type)\n"
		 "            empty if attr_failed is false\n"
		 " - name : attribute name \n"
		 " - dim_x : effective first dimension of attribute (spectrum or image attributes)\n"
		 " - dim_y : effective second dimension of attribute(image attribute)"
         )
        .def_readonly("attr_failed", &DeviceAttributeHistory::attr_failed)
        .def_readonly("value", &DeviceAttributeHistory::value)
        .def_readonly("errors", &DeviceAttributeHistory::errors)
		.def("__str__",&attrhist_to_string)
	;

     declare_database_types();
}






























