//+=============================================================================
//
// file :         device_group.h
//
// description :  header file for all principal C++ classes of 
//			the python binding for group functionalities.
//
// project :      Python Binding
//
// $Author: ounsy $
//
// $Revision: 1.1 $
//
// $Log: device_group.h,v $
// Revision 1.1  2005/06/02 17:10:53  ounsy
// First introduction of group related methods
//
//
//
// copyleft :     Synchrotron SOLEIL
//			L'Orme des Merisiers, Saint-Aubin BP 48
//			91192 GIF SUR YVETTE Cedex
//
//-=============================================================================
#ifndef PY_DEVICE_GROUP
#define PY_DEVICE_GROUP

#include <device_proxy.h>
/*#include <map>
#include <boost/enable_shared_from_this.hpp>
#include <boost/any.hpp>
#include <boost/python/dict.hpp>
#include <boost/python/extract.hpp>
#include <boost/python/long.hpp>
#include <boost/python/call_method.hpp>*/


//=============================================================================
// class GroupReply : reply to command or attribute read/write executed on a group
//=============================================================================
class GroupReply
{
public:
  GroupReply();
  GroupReply (std::string dev_name, 
              std::string obj_name); 
  //- dtor
  virtual ~GroupReply ();
  
  void set_data(boost::python::object data) ;
  void set_exception(const Tango::DevErrorList &errors) ;
  bool has_failed (void) const { 
    return has_failed_m;
  }
  //- data accessor (may throw Tango::DevFailed)
  boost::python::object  get_data (void);
  //- device name accessor
  	std::string dev_name (void) const {
    return dev_name_m;
  }
  //- object (i.e. command or attribute) name accessor
  	std::string obj_name (void) const {
    return obj_name_m;
  }
  //- error stack accessor
  boost::python::tuple get_err_stack (void) const;
  
private:
  //- the device name
  std::string dev_name_m;
  //- command or attribute name
  std::string obj_name_m;
  //- has_failed_m: true is an error occurred, false otherwise
  bool has_failed_m;
  //- exception: valid if has_failed_m set to true
  Tango::DevErrorList     errors_m;
  boost::python::tuple exception_m;
  //- data: valid if GroupReply::has_failed_m set to false
  boost::python::object data_m;
};


class GroupUtils
{
public:
	GroupUtils(Tango::Group *group);
//   Utils
     std::pair<long,long> get_command_args(std::string name);
     std::pair<long,Tango::AttrDataFormat> get_attribute_type(std::string name);

     GroupReply translate_command_reply(Tango::GroupCmdReply *groupCmdReply);
     boost::python::object translate_from_command_reply(Tango::GroupCmdReply &groupCmdReply,long arg_type);
     boost::python::list translate_command_reply_list(Tango::GroupCmdReplyList &groupList); 	
     GroupReply translate_readattr_reply(Tango::GroupAttrReply *groupAttrReply);
     boost::python::object translate_from_readattr_reply(Tango::GroupAttrReply &groupCmdReply,long arg_type,Tango::AttrDataFormat);
     boost::python::list translate_readattr_reply_list(Tango::GroupAttrReplyList &groupList); 	
     Tango::GroupCmdReplyList apply_command_to_arglist(const std::string &c,boost::python::object pyData,bool fwd,long arg_type);
     long apply_command_asynch_to_arglist(const std::string &c,boost::python::object pyData,bool fgt,bool fwd,long arg_type);
	 boost::python::list translate_writeattr_reply_list(Tango::GroupReplyList &groupList); 
	 GroupReply translate_writeattr_reply(Tango::GroupReply *grpReply); 
/*	 Tango::GroupReplyList apply_writeattr_to_arglist(const std::string &attr,boost::python::object pyData,bool fwd);*/
private:
      Tango::Group *group_m;
      std::map< std::string, std::pair<long,long> > command_args;
      std::map< std::string, std::pair<long,Tango::AttrDataFormat> > attribute_types;
};

class Group : public boost::enable_shared_from_this<Group>
{
public:

      Group(std::string name);
      Group(Tango::Group *group,std::string name);

     virtual ~Group();

// Group management related methods
      void add(boost::python::object group);
      void add(const std::string& pattern);
      void remove(const std::string& pattern, 
					  boost::python::object pyData=boost::python::object());
      void remove_all();
      bool contains(const std::string& pattern, 
					  boost::python::object pyData=boost::python::object());
      long get_size(boost::python::object pyData=boost::python::object());
      boost::python::list get_device_list(boost::python::object pyData=boost::python::object());
      boost::python::object get_device(const std::string& device_name);
      boost::python::object get_device(long idx);
      boost::python::object get_group(const std::string& group_name);
      boost::python::list command_inout(const std::string& command,boost::python::object fwd);
      boost::python::list command_inout(const std::string& command,boost::python::object pyData,boost::python::object fwd);
      boost::python::list command_inout(const std::string& command,boost::python::list pyDataList,boost::python::object fwd);
      boost::python::object ping(boost::python::object pyData=boost::python::object());
      long command_inout_asynch(const std::string& command,boost::python::object fgt,boost::python::object fwd);
      long command_inout_asynch(const std::string& command,boost::python::object pyData,boost::python::object fgt,boost::python::object fwd);
      long command_inout_asynch(const std::string& command,boost::python::list pyDataList,boost::python::object fgt,boost::python::object fwd);
      boost::python::list command_inout_reply(long req_id,long timeout_ms = 0);
      boost::python::list read_attribute(const std::string& attr,boost::python::object fwd);
      long read_attribute_asynch(const std::string& attr,boost::python::object fwd);
      boost::python::list read_attribute_reply(long req_id,long timeout_ms = 0);
	  boost::python::list write_attribute(AttributeValue attr_val,boost::python::object pyFWD);
//	  boost::python::list write_attribute(const std::string &attr,boost::python::list pyDataList,boost::python::object pyFWD);
	  long write_attribute_asynch(AttributeValue attr_val,boost::python::object pyFWD);
	  boost::python::list write_attribute_reply(long req_id,long timeout_ms=0);
	  	  
// special methods
      boost::python::object getself();
private:
	  bool was_allocated;
      std::string group_name;
      Tango::Group *group_m;
	  GroupUtils *groupUtils;
};


#endif