import PyTango
import sys

class_list = []
cpp_class_list = []
constructed_class = []


#
# Two litle functions and a global variables to allow 
# DS debugging using Python with Eclipse/PyDev
#

pydev_dbg = 10

def PyDev_debug(in_hook):
    if in_hook is not None:
        global pydev_trace_func
        global pydev_dbg
        pydev_trace_func = in_hook
        PyTango.pydev_dbg = 1
	
def set_dbg_fct():
    sys.settrace(pydev_trace_func)

#
# Several little functions to solve a default value problems
#

def set_att_val(att,data,x=1,y=0):
    if ((x == 1) and (y == 0)):
       PyTango.set_attribute_value(att,data)
    else:
       PyTango.set_attribute_value(att,data,x,y)

def set_att_val_dq(att,data,ti,qua,x=1,y=0):
    if ((x == 1) and (y == 0)):
       PyTango.set_attribute_value_date_quality(att,data,ti,qua)
    else:
       PyTango.set_attribute_value_date_quality(att,data,ti,qua,x,y)
       
def push_ev(dev,att_name,data='not_defined',x=1,y=0,filt_names=[],filt_vals=[]):
    if (data == 'not_defined'):
       PyTango.push_att_event(dev,att_name,filt_names,filt_vals)
    elif ((x == 1) and (y == 0)):
       PyTango.push_att_event(dev,att_name,filt_names,filt_vals,data)
    else:
       PyTango.push_att_event(dev,att_name,filt_names,filt_vals,data,x,y)
       
def push_change_ev(dev,att_name,data='not_defined',x=1,y=0):
    if (data == 'not_defined'):
       PyTango.push_att_ch_event(dev,att_name)
    elif ((x == 1) and (y == 0)):
       PyTango.push_att_ch_event(dev,att_name,data)
    else:
       PyTango.push_att_ch_event(dev,att_name,data,x,y)
       
def push_archive_ev(dev,att_name,data='not_defined',x=1,y=0):
    if (data == 'not_defined'):
       PyTango.push_att_ar_event(dev,att_name)
    elif ((x == 1) and (y == 0)):
       PyTango.push_att_ar_event(dev,att_name,data)
    else:
       PyTango.push_att_ar_event(dev,att_name,data,x,y)

#
# The PyUtil class
#

        
class PyUtil(PyTango.Util):
    def __init__(self,args):
        dot=args[0].find('.')
        new_str=args[0][:dot]
        args[0]=new_str
        PyTango.Util.init(len(args),args)
        PyTango.Util.python_init()

# transform attribute function as Attribute class methods
	
	PyTango.WAttribute.get_write_value = lambda self, data: PyTango.get_write_value(self,data)
	PyTango.WAttribute.set_write_value = lambda self, data: PyTango.set_write_value(self,data)
	PyTango.Attribute.set_value = set_att_val
	PyTango.Attribute.set_value_date_quality = set_att_val_dq
	
# transform device function as Device class methods

	PyTango.DeviceImpl.push_event = push_ev
	PyTango.DeviceImpl.push_change_event = push_change_ev
	PyTango.DeviceImpl.push_archive_event = push_archive_ev
	             	
    def add_TgClass(self,cl_class,cl,name):
	class_list.append((cl_class,cl,name))
	
    def add_Cpp_TgClass(self,class_name,name):
	cpp_class_list.append((class_name,name))

#
# A generic class_factory method
#
	
def class_factory():
    if ((len(class_list) + len(cpp_class_list)) == 0):
	print 'Oups, no Tango class defined within this device server !!!'
	print 'Sorry, but I exit'
	sys.exit()
    else:
        for tup in class_list:
            print "Creating one Tango Class :",tup[2]
            constructed_class.append(tup[0](tup[2]))

#
# A method to delete Tango classes from Python
#
	    
def delete_class_list():
    del(constructed_class[:])


#
# The device "get_device_class" method written in Python
#

def get_device_class(dev):
     loop = 0
     for tup in class_list:
	 if (tup[1].__name__ == dev.__class__.__name__):
	     return constructed_class[loop]
	 else:
	     loop += 1
     return None
     

#
# The PyDeviceClass class with the generic device_factory method
#
     

class PyDeviceClass(PyTango.CppDeviceClass):
    def __init__(self,name):
        PyTango.CppDeviceClass.__init__(self,name)
	
	
    def device_factory(self,devicelist):
       loop = 0
       for tup in class_list:
           if (tup[0].__name__ == self.__class__.__name__):
	       tup[1].get_device_class = get_device_class		     
               for dev_name in devicelist:
                   print "Creating one Tango device of name",dev_name
                   self.z = tup[1](constructed_class[loop],dev_name)
		   self.add_device(self.z)
		   if ((PyTango.Util._UseDb == True) and (PyTango.Util._FileDb == False)):
		        self.export_device(self.z)
		   else:
		        self.export_device(self.z,dev_name)
		   del(self.z)
	       break
	   loop += 1

