static const char *RcsId = "$Header: /cvsroot/tango-cs/tango/bindings/python/src/py_tangodb3.cpp,v 1.3 2005/03/24 13:20:20 taurel Exp $";
//+=============================================================================
//
// file :         py_tangodb3.cpp
//
// description :  C++ source using BOOST macros to ease mapping
//                between C++ objects and C/C++ (hidden) instructions
//                for embedding thease  objects into a Python run time
//                This file defines a first subset of Database methods
//
//
// project :      Python Binding
//
// $Author: taurel $
//
// $Revision: 1.3 $
//
// $Log: py_tangodb3.cpp,v $
// Revision 1.3  2005/03/24 13:20:20  taurel
// - Added Vincenzo changes for the Tango V5 port
// - Fix bug on Linux in the client_request function (default  argument)
//
// Revision 1.2  2004/01/27 09:59:56  ounsy
// Added asynchronous related methods
//
// Revision 1.1  2003/10/23 13:50:55  ounsy
//
//
// Added Python binding for TANGO
//
//
// copyleft :     Synchrotron SOLEIL
//			L'Orme des Merisiers, Saint-Aubin BP 48
//			91192 GIF SUR YVETTE Cedex
//
//-=============================================================================

#include <tangodb.h>
#include <boost/python/class.hpp>
#include <boost/python/module.hpp>
#include <boost/python/def.hpp>
#include <boost/python/enum.hpp>
#include <boost/python/dict.hpp>
#include <boost/python/operators.hpp>
#include <boost/operators.hpp>
#include <boost/python/overloads.hpp>
#include <boost/python/exception_translator.hpp>
#include <exception>


void second_of_tangodb(boost::python::class_<Database> &x);

void first_of_tangodb(boost::python::class_<Database> &tangoDB)
{

    using namespace boost::python;


    tangoDB

		.def("get_info",&Database::get_info, 
		   "Query the database for some general info about the tables.\n"
		   "Parameters : None\n"
 		   "Return     : a multiline string"
		   )

        .def("add_device", &Database::add_device,
		   "Add a device to the database. The device name, server and class\n"
		   "are specified in the DbDevInfo structure\n"
		   "Parameters : DbDevInfo structure\n"
		   "Return     : None\n"
           "Example :\n"
           "        dev_info = DbDevInfo()\n"
		   "        dev_info.name = ""my/own/device""\n"
		   "        dev_info.class = ""MyDevice""\n"
		   "        dev_info.server = ""MyServer/test""\n"
		   "        db.add_device(dev_info)"
		   )

        .def("delete_device", &Database::delete_device,
		   "Delete the device of the specified name from the database\n"
		   "Parameters : Device name\n"
		   "Return     : None\n"
           "Example :\n"
		   "        db.delete_device(""my/own/device"")"
		   )

        .def("import_device", &Database::import_device,
		   "Query the databse for the export info of the specified device\n"
		   "Parameters : Device name\n"
 		   "Return     : DbDevImportInfo object\n"
           "Example :\n"
           "        dev_imp_info = db.import_device(""my/own/device"")\n"
		   "        print dev_imp_info.name\n"
		   "        print dev_imp_info.exported\n"
		   "        print dev_imp_info.ior\n"
		   "        print dev_imp_info.version"
		   )

        .def("export_device", &Database::export_device,
		   "Update the export info for this device in the database\n"
		   "Parameters : DbDevExportInfo structure\n"
		   "Return     : None\n"
           "Example :\n"
           "        dev_export = DbDevExportInfo()\n"
		   "        dev_export.name = ""my/own/device""\n"
		   "        dev_export.ior = ""the real ior""\n"
		   "        dev_export.host = ""the host""\n"
		   "        dev_export.version = ""1.0""\n"
		   "        dev_export.pid = ""....""\n"
		   "        db.export_device(dev_export)"
		   )

        .def("unexport_device", &Database::unexport_device,
		   "Mark the specified device as unexported in the database\n"
		   "Parameters : Device name\n"
		   "Return     : None\n"
           "Example :\n"
		   "        db.unexport_device(""my/own/device"")"
		   )

        .def("add_server", &Database::add_server,
		   "Add a a group of devices to the database.\n"
		   "Parameters : Server name\n"
		   "             List of DbDevInfo structures\n"
		   "Return     : None"
		   )

        .def("delete_server", &Database::delete_server,
		   "Delete the device server and its associated devices from database\n"
		   "Parameters : Server name\n"
		   "Return     : None"
		   )

        .def("export_server", &Database::add_server,
		   "Export a group of devices to the database.\n"
		   "Parameters : Server name\n"
		   "             List of DbDevExportInfo structures\n"
		   "Return     : None"
		   )

        .def("unexport_server", &Database::unexport_server,
		   "Mark all devices exported for this server as unexported\n"
		   "Parameters : Server name\n"
		   "Return     : None"
		   )

        .def("get_device_name", &Database::get_device_name,
		   "Query the database for a list of devices served by a server for\n"
		   "a given device class\n"
		   "Parameters : Server name\n"
		   "             Device class name\n"
		   "Return     : List of device names"
		   )
/*
        .def("get_device_alias", &Database::get_device_alias,
		   "Query the database for a list of aliases for the specified device\n"
		   "Parameters : Device name\n"
		   "Return     : List of aliases"
		   )
*/
        .def("get_device_exported", &Database::get_device_exported,
		   "Query the database for a list of exported devices whose names\n"
		   "satisfy the supplied filter (* is wildcard for any character(s))\n"
		   "Parameters : string filter\n"
		   "Return     : List of exported devices"
		   )

        .def("get_device_domain", &Database::get_device_domain,
		   "Query the database for a list of of device domain names which\n"
		   "match the wildcard provided (* is wildcard for any character(s)).\n"
		   "Domain names are case insensitive.\n"
		   "Parameters : string filter\n"
		   "Return     : List of device domain names"
		   )

        .def("get_device_family", &Database::get_device_family,
		   "Query the database for a list of of device family names which\n"
		   "match the wildcard provided (* is wildcard for any character(s)).\n"
		   "Family names are case insensitive.\n"
		   "Parameters : string filter\n"
		   "Return     : List of device family names"
		   )

        .def("get_device_member", &Database::get_device_member,
		   "Query the database for a list of of device member names which\n"
		   "match the wildcard provided (* is wildcard for any character(s)).\n"
		   "member names are case insensitive.\n"
		   "Parameters : string filter\n"
		   "Return     : List of device member names"
		   )

	;


	second_of_tangodb(tangoDB);

}


































