#ifndef CONVERSION_UTILS_H
#define CONVERSION_UTILS_H

#include <boost/python.hpp>
#include <vector>
#include <string>
#include "device_proxy.h"

class Utils
{
public:
    	static boost::python::tuple translate_exception_value(const Tango::DevErrorList &dev_error_list);
	static boost::python::tuple translate_black_box(std::vector<string>*);
	static void translate_to_device_data(Tango::DeviceData &, boost::python::object, long);
	static boost::python::object translate_from_device_data(Tango::DeviceData &, long);
	static DeviceAttributeHistory translate_from_attribute_history(Tango::DeviceAttributeHistory &, long, Tango::AttrDataFormat);
	static AttributeInfo translate_attribute_info(Tango::AttributeInfo *);
	static Tango::AttributeInfo translate_to_attribute_info(AttributeInfo); 
	static boost::python::list translate_attribute_list(Tango::AttributeInfoList *);
	static DeviceDataHistory translate_from_data_history(Tango::DeviceDataHistory &,long);
	static AttributeValue translate_from_device_attribute(Tango::DeviceAttribute &, long, Tango::AttrDataFormat);
	static void translate_to_device_attribute(Tango::DeviceAttribute &, AttributeValue, long, Tango::AttrDataFormat);
};

#endif /* CONVERSION_UTILS_H */
