//=============================================================================
//
// file :         KiKeThread.h
//
// description :  Thread that handle the ON sequence (which is long).
//                		
// project :      TANGO Device Server
//
// $Author: vedder $
//
// $Revision:  $
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================

#ifndef _KIKETHREAD_H
#define _KIKETHREAD_H

#include <tango.h>
#include <KiKe.h>

namespace KiKe_ns
{

	class KiKeThread : public omni_thread 
		{
		public :
			KiKeThread(KiKe *dev, omni_mutex &m);

		private :
			KiKe				 		*kike_obj;
			omni_mutex 					&mutex;
			void *run_undetached (void *arg);
		};
		
}// namespace
#endif	// _KIKETHREAD_H
