//=============================================================================
//
// file :         KiKeThread.cpp
//
// description :  Thread that handle the ON sequence (which is long).
//                		
// project :      TANGO Device Server
//
// $Author: vedder $
//
// $Revision:  $
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================

#include <KiKeThread.h>

namespace KiKe_ns
{

KiKeThread::KiKeThread(KiKe *dev, omni_mutex &m) : omni_thread(), mutex(m) 
{	
	kike_obj = dev;	
	start_undetached();
}


//+------------------------------------------------------------------
/**
 *      method: KiKeThread::run_undetached
 *
 *      description:    method which actually execute sequence ON on the KiKe.
 *   
 * @param       :
 *
 */


void *KiKeThread::run_undetached(void *arg)
{
	time_t ct;	// Current time.
	kike_obj->sequenceRunning = true;
	kike_obj->sequenceFailed = false;
		
	try
	{
		if (KIKE_IS_OFF_TH)
		{
			
			kike_obj->standby_on_PLC();
			kike_obj->set_current_on_PLC();
			sleep(5);
			kike_obj->on_on_PLC();
			
		}
		else if (KIKE_IN_STANDBY_TH)
		{
			
			time(&ct);
			int delta = ct - kike_obj->last_current_write;

			if (delta <= 2)	sleep(3 - delta);
			kike_obj->on_on_PLC();
			
		}
	} 
	catch(Tango::DevFailed &e)
	{
		omni_mutex_lock l(mutex);
		{
			
			kike_obj->sequenceError = e.errors[0].reason;
			kike_obj->sequenceFailed = true;
			
		}
	}
	
	kike_obj->sequenceRunning = false;
	return NULL;
}



} // namespace
