static const char *RcsId = "$Header: /segfs/tango/cvsroot/cppserver/machine/powersupply/KiKe/KiKeStateMachine.cpp,v 1.1.1.1 2008/07/10 08:41:16 meyer Exp $";
//+=============================================================================
//
// file :         KiKeStateMachine.cpp
//
// description :  C++ source for the KiKe and its alowed 
//                methods for commands and attributes
//
// project :      TANGO Device Server
//
// $Author: meyer $
//
// $Revision: 1.1.1.1 $
//
// $Log: KiKeStateMachine.cpp,v $
// Revision 1.1.1.1  2008/07/10 08:41:16  meyer
// Imported using TkCVS
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

#include <tango.h>
#include <KiKe.h>
#include <KiKeClass.h>

/*====================================================================
 *	This file contains the methods to allow commands and attributes
 * read or write execution.
 *
 * If you wand to add your own code, add it between 
 * the "End/Re-Start of Generated Code" comments.
 *
 * If you want, you can also add your own methods.
 *====================================================================
 */

namespace KiKe_ns
{

//=================================================
//		Attributes Allowed Methods
//=================================================

//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_Current_allowed
// 
// description : 	Read/Write allowed for Current attribute.
//
//-----------------------------------------------------------------------------
bool KiKe::is_Current_allowed(Tango::AttReqType type)
{
		//	End of Generated Code
		
		if ( type == Tango::READ_REQ )
			{
			return true;
			}
			
		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_Voltage_allowed
// 
// description : 	Read/Write allowed for Voltage attribute.
//
//-----------------------------------------------------------------------------
bool KiKe::is_Voltage_allowed(Tango::AttReqType type)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_CurrentSetPoint_allowed
// 
// description : 	Read/Write allowed for CurrentSetPoint attribute.
//
//-----------------------------------------------------------------------------
bool KiKe::is_CurrentSetPoint_allowed(Tango::AttReqType type)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_PulseNumber_allowed
// 
// description : 	Read/Write allowed for PulseNumber attribute.
//
//-----------------------------------------------------------------------------
bool KiKe::is_PulseNumber_allowed(Tango::AttReqType type)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}

//=================================================
//		Commands Allowed Methods
//=================================================

//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_On_allowed
// 
// description : 	Execution allowed for On command.
//
//-----------------------------------------------------------------------------
bool KiKe::is_On_allowed(const CORBA::Any &any)
{
	if (get_state() == Tango::ON	||
		get_state() == Tango::FAULT	||
		get_state() == Tango::MOVING)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_Off_allowed
// 
// description : 	Execution allowed for Off command.
//
//-----------------------------------------------------------------------------
bool KiKe::is_Off_allowed(const CORBA::Any &any)
{
	if (get_state() == Tango::OFF	||
		get_state() == Tango::FAULT	||
		get_state() == Tango::MOVING)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_Reset_allowed
// 
// description : 	Execution allowed for Reset command.
//
//-----------------------------------------------------------------------------
bool KiKe::is_Reset_allowed(const CORBA::Any &any)
{
	if (get_state() == Tango::MOVING)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_Standby_allowed
// 
// description : 	Execution allowed for Standby command.
//
//-----------------------------------------------------------------------------
bool KiKe::is_Standby_allowed(const CORBA::Any &any)
{
	if (get_state() == Tango::STANDBY	||
		get_state() == Tango::FAULT	||
		get_state() == Tango::MOVING)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_DBG_On_allowed
// 
// description : 	Execution allowed for DBG_On command.
//
//-----------------------------------------------------------------------------
bool KiKe::is_DBG_On_allowed(const CORBA::Any &any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_DBG_Off_allowed
// 
// description : 	Execution allowed for DBG_Off command.
//
//-----------------------------------------------------------------------------
bool KiKe::is_DBG_Off_allowed(const CORBA::Any &any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_DBG_Reset_allowed
// 
// description : 	Execution allowed for DBG_Reset command.
//
//-----------------------------------------------------------------------------
bool KiKe::is_DBG_Reset_allowed(const CORBA::Any &any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKe::is_DBG_Standby_allowed
// 
// description : 	Execution allowed for DBG_Standby command.
//
//-----------------------------------------------------------------------------
bool KiKe::is_DBG_Standby_allowed(const CORBA::Any &any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}

}	// namespace KiKe_ns
