//=============================================================================
//
// file :         KiKeClass.h
//
// description :  Include for the KiKeClass root class.
//                This class is the singleton class for
//                the KiKe device class.
//                It contains all properties and methods which the 
//                KiKe requires only once e.g. the commands.
//			
// project :      TANGO Device Server
//
// $Author: meyer $
//
// $Revision: 1.1.1.1 $
//
// $Log: KiKeClass.h,v $
// Revision 1.1.1.1  2008/07/10 08:41:16  meyer
// Imported using TkCVS
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

#ifndef _KIKECLASS_H
#define _KIKECLASS_H

#include <tango.h>
#include <KiKe.h>


namespace KiKe_ns
{//=====================================
//	Define classes for attributes
//=====================================
class PulseNumberAttrib: public Tango::Attr
{
public:
	PulseNumberAttrib():Attr("PulseNumber", Tango::DEV_USHORT, Tango::READ_WRITE) {};
	~PulseNumberAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<KiKe *>(dev))->read_PulseNumber(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<KiKe *>(dev))->write_PulseNumber(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<KiKe *>(dev))->is_PulseNumber_allowed(ty);}
};

class CurrentSetPointAttrib: public Tango::Attr
{
public:
	CurrentSetPointAttrib():Attr("CurrentSetPoint", Tango::DEV_DOUBLE, Tango::READ) {};
	~CurrentSetPointAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<KiKe *>(dev))->read_CurrentSetPoint(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<KiKe *>(dev))->is_CurrentSetPoint_allowed(ty);}
};

class VoltageAttrib: public Tango::Attr
{
public:
	VoltageAttrib():Attr("Voltage", Tango::DEV_DOUBLE, Tango::READ_WRITE) {};
	~VoltageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<KiKe *>(dev))->read_Voltage(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<KiKe *>(dev))->write_Voltage(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<KiKe *>(dev))->is_Voltage_allowed(ty);}
};

class CurrentAttrib: public Tango::Attr
{
public:
	CurrentAttrib():Attr("Current", Tango::DEV_DOUBLE, Tango::READ_WRITE) {};
	~CurrentAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<KiKe *>(dev))->read_Current(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<KiKe *>(dev))->write_Current(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<KiKe *>(dev))->is_Current_allowed(ty);}
};

//=========================================
//	Define classes for commands
//=========================================
class DBG_StandbyCmd : public Tango::Command
{
public:
	DBG_StandbyCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DBG_StandbyCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DBG_StandbyCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<KiKe *>(dev))->is_DBG_Standby_allowed(any);}
};



class DBG_ResetCmd : public Tango::Command
{
public:
	DBG_ResetCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DBG_ResetCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DBG_ResetCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<KiKe *>(dev))->is_DBG_Reset_allowed(any);}
};



class DBG_OffCmd : public Tango::Command
{
public:
	DBG_OffCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DBG_OffCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DBG_OffCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<KiKe *>(dev))->is_DBG_Off_allowed(any);}
};



class DBG_OnClass : public Tango::Command
{
public:
	DBG_OnClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DBG_OnClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DBG_OnClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<KiKe *>(dev))->is_DBG_On_allowed(any);}
};



class StandbyCmd : public Tango::Command
{
public:
	StandbyCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	StandbyCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~StandbyCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<KiKe *>(dev))->is_Standby_allowed(any);}
};



class ResetClass : public Tango::Command
{
public:
	ResetClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	ResetClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~ResetClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<KiKe *>(dev))->is_Reset_allowed(any);}
};



class OffClass : public Tango::Command
{
public:
	OffClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	OffClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~OffClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<KiKe *>(dev))->is_Off_allowed(any);}
};



class OnClass : public Tango::Command
{
public:
	OnClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	OnClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~OnClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<KiKe *>(dev))->is_On_allowed(any);}
};



//
// The KiKeClass singleton definition
//

class
#ifdef WIN32
	__declspec(dllexport)
#endif
	KiKeClass : public Tango::DeviceClass
{
public:
//	properties member data

//	add your own data members here
//------------------------------------

public:
	Tango::DbData	cl_prop;
	Tango::DbData	cl_def_prop;
	Tango::DbData	dev_def_prop;

//	Method prototypes
	static KiKeClass *init(const char *);
	static KiKeClass *instance();
	~KiKeClass();
	Tango::DbDatum	get_class_property(string &);
	Tango::DbDatum	get_default_device_property(string &);
	Tango::DbDatum	get_default_class_property(string &);
	
protected:
	KiKeClass(string &);
	static KiKeClass *_instance;
	void command_factory();
	void get_class_property();
	void attribute_factory(vector<Tango::Attr *> &);
	void write_class_property();
	void set_default_property();
	string get_cvstag();
	string get_cvsroot();

private:
	void device_factory(const Tango::DevVarStringArray *);
};


}	//	namespace KiKe_ns

#endif // _KIKECLASS_H
