static const char *RcsId     = "$Header: /segfs/tango/cvsroot/cppserver/machine/powersupply/KiKe/KiKeClass.cpp,v 1.1.1.1 2008/07/10 08:41:16 meyer Exp $";
static const char *TagName   = "$Name:  $";
static const char *HttpServer= "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/";
//+=============================================================================
//
// file :        KiKeClass.cpp
//
// description : C++ source for the KiKeClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the KiKe once per process.
//
// project :     TANGO Device Server
//
// $Author: meyer $
//
// $Revision: 1.1.1.1 $
//
// $Log: KiKeClass.cpp,v $
// Revision 1.1.1.1  2008/07/10 08:41:16  meyer
// Imported using TkCVS
//
//
// copyleft :   European Synchrotron Radiation Facility
//              BP 220, Grenoble 38043
//              FRANCE
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================


#include <tango.h>

#include <KiKe.h>
#include <KiKeClass.h>


//+----------------------------------------------------------------------------
/**
 *	Create KiKeClass singleton and return it in a C function for Python usage
 */
//+----------------------------------------------------------------------------
extern "C" {
#ifdef WIN32

__declspec(dllexport)

#endif

	Tango::DeviceClass *_create_KiKe_class(const char *name) {
		return KiKe_ns::KiKeClass::init(name);
	}
}


namespace KiKe_ns
{
//+----------------------------------------------------------------------------
//
// method : 		DBG_StandbyCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DBG_StandbyCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DBG_StandbyCmd::execute(): arrived" << endl;

	((static_cast<KiKe *>(device))->dbg__standby());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DBG_ResetCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DBG_ResetCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DBG_ResetCmd::execute(): arrived" << endl;

	((static_cast<KiKe *>(device))->dbg__reset());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DBG_OffCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DBG_OffCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DBG_OffCmd::execute(): arrived" << endl;

	((static_cast<KiKe *>(device))->dbg__off());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DBG_OnClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DBG_OnClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DBG_OnClass::execute(): arrived" << endl;

	((static_cast<KiKe *>(device))->dbg__on());
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		OnClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be executed
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *OnClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "OnClass::execute(): arrived" << endl;

	((static_cast<KiKe *>(device))->on());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		OffClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be executed
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *OffClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "OffClass::execute(): arrived" << endl;

	((static_cast<KiKe *>(device))->off());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		ResetClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be executed
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ResetClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ResetClass::execute(): arrived" << endl;

	((static_cast<KiKe *>(device))->reset());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		StandbyCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be executed
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *StandbyCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "StandbyCmd::execute(): arrived" << endl;

	((static_cast<KiKe *>(device))->standby());
	return new CORBA::Any();
}


//
//----------------------------------------------------------------
//	Initialize pointer for singleton pattern
//----------------------------------------------------------------
//
KiKeClass *KiKeClass::_instance = NULL;

//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::KiKeClass(string &s)
// 
// description : 	constructor for the KiKeClass
//
// in : - s : The class name
//
//-----------------------------------------------------------------------------
KiKeClass::KiKeClass(string &s):DeviceClass(s)
{

	cout2 << "Entering KiKeClass constructor" << endl;
	set_default_property();
	get_class_property();
	write_class_property();
	
	cout2 << "Leaving KiKeClass constructor" << endl;

}
//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::~KiKeClass()
// 
// description : 	destructor for the KiKeClass
//
//-----------------------------------------------------------------------------
KiKeClass::~KiKeClass()
{
	_instance = NULL;
}

//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::instance
// 
// description : 	Create the object if not already done. Otherwise, just
//			return a pointer to the object
//
// in : - name : The class name
//
//-----------------------------------------------------------------------------
KiKeClass *KiKeClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			string s(name);
			_instance = new KiKeClass(s);
		}
		catch (bad_alloc)
		{
			throw;
		}		
	}		
	return _instance;
}

KiKeClass *KiKeClass::instance()
{
	if (_instance == NULL)
	{
		cerr << "Class is not initialised !!" << endl;
		exit(-1);
	}
	return _instance;
}

//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::command_factory
// 
// description : 	Create the command object(s) and store them in the 
//			command list
//
//-----------------------------------------------------------------------------
void KiKeClass::command_factory()
{
	command_list.push_back(new OnClass("On",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));
	command_list.push_back(new OffClass("Off",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));
	command_list.push_back(new ResetClass("Reset",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));
	command_list.push_back(new StandbyCmd("Standby",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));
	command_list.push_back(new DBG_OnClass("DBG_On",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::EXPERT));
	command_list.push_back(new DBG_OffCmd("DBG_Off",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::EXPERT));
	command_list.push_back(new DBG_ResetCmd("DBG_Reset",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::EXPERT));
	command_list.push_back(new DBG_StandbyCmd("DBG_Standby",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::EXPERT));

	//	add polling if any
	for (unsigned int i=0 ; i<command_list.size(); i++)
	{
	}
}

//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::get_class_property
// 
// description : 	Get the class property for specified name.
//
// in :		string	name : The property name
//
//+----------------------------------------------------------------------------
Tango::DbDatum KiKeClass::get_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == prop_name)
			return cl_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}
//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::get_default_device_property()
// 
// description : 	Return the default value for device property.
//
//-----------------------------------------------------------------------------
Tango::DbDatum KiKeClass::get_default_device_property(string &prop_name)
{
	for (unsigned int i=0 ; i<dev_def_prop.size() ; i++)
		if (dev_def_prop[i].name == prop_name)
			return dev_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::get_default_class_property()
// 
// description : 	Return the default value for class property.
//
//-----------------------------------------------------------------------------
Tango::DbDatum KiKeClass::get_default_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_def_prop.size() ; i++)
		if (cl_def_prop[i].name == prop_name)
			return cl_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}
//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::device_factory
// 
// description : 	Create the device object(s) and store them in the 
//			device list
//
// in :		Tango::DevVarStringArray *devlist_ptr : The device name list
//
//-----------------------------------------------------------------------------
void KiKeClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{

	//	Create all devices.(Automatic code generation)
	//-------------------------------------------------------------
	for (unsigned long i=0 ; i < devlist_ptr->length() ; i++)
	{
		cout4 << "Device name : " << (*devlist_ptr)[i].in() << endl;
						
		// Create devices and add it into the device list
		//----------------------------------------------------
		device_list.push_back(new KiKe(this, (*devlist_ptr)[i]));							 

		// Export device to the outside world
		// Check before if database used.
		//---------------------------------------------
		if ((Tango::Util::_UseDb == true) && (Tango::Util::_FileDb == false))
			export_device(device_list.back());
		else
			export_device(device_list.back(), (*devlist_ptr)[i]);
	}
	//	End of Automatic code generation
	//-------------------------------------------------------------

}
//+----------------------------------------------------------------------------
//	Method: KiKeClass::attribute_factory(vector<Tango::Attr *> &att_list)
//-----------------------------------------------------------------------------
void KiKeClass::attribute_factory(vector<Tango::Attr *> &att_list)
{
	//	Attribute : Current
	CurrentAttrib	*current = new CurrentAttrib();
	Tango::UserDefaultAttrProp	current_prop;
	current_prop.set_label("Current");
	current_prop.set_unit("A");
	current_prop.set_description("The powersupply current setting in amps");
	current->set_default_properties(current_prop);
	current->set_memorized();
	current->set_memorized_init(true);
	att_list.push_back(current);

	//	Attribute : Voltage
	VoltageAttrib	*voltage = new VoltageAttrib();
	Tango::UserDefaultAttrProp	voltage_prop;
	voltage_prop.set_label("PFN Voltage");
	voltage_prop.set_unit("V");
	voltage_prop.set_description("The powersupply voltage in volts.");
	voltage->set_default_properties(voltage_prop);
	att_list.push_back(voltage);

	//	Attribute : CurrentSetPoint
	CurrentSetPointAttrib	*current_set_point = new CurrentSetPointAttrib();
	Tango::UserDefaultAttrProp	current_set_point_prop;
	current_set_point_prop.set_label("Current Setting");
	current_set_point_prop.set_unit("A");
	current_set_point_prop.set_description("The current set value as stored in the powersupply.");
	current_set_point->set_default_properties(current_set_point_prop);
	att_list.push_back(current_set_point);

	//	Attribute : PulseNumber
	PulseNumberAttrib	*pulse_number = new PulseNumberAttrib();
	att_list.push_back(pulse_number);

	//	End of Automatic code generation
	//-------------------------------------------------------------
}

//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::get_class_property()
// 
// description : 	Read the class properties from database.
//
//-----------------------------------------------------------------------------
void KiKeClass::get_class_property()
{
	//	Initialize your default values here (if not done with  POGO).
	//------------------------------------------------------------------

	//	Read class properties from database.(Automatic code generation)
	//------------------------------------------------------------------

	//	Call database and extract values
	//--------------------------------------------
	if (Tango::Util::instance()->_UseDb==true)
		get_db_class()->get_property(cl_prop);
	Tango::DbDatum	def_prop;
	int	i = -1;


	//	End of Automatic code generation
	//------------------------------------------------------------------

}

//+----------------------------------------------------------------------------
//
// method : 	KiKeClass::set_default_property
// 
// description: Set default property (class and device) for wizard.
//              For each property, add to wizard property name and description
//              If default value has been set, add it to wizard property and
//              store it in a DbDatum.
//
//-----------------------------------------------------------------------------
void KiKeClass::set_default_property()
{
	string	prop_name;
	string	prop_desc;
	string	prop_def;

	vector<string>	vect_data;
	//	Set Default Class Properties
	//	Set Default Device Properties
	prop_name = "ModbusDevice";
	prop_desc = "The name of the modbus device to use for comunication with the PLC.";
	prop_def  = "";
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);

	prop_name = "RegisterBaseAddress";
	prop_desc = "The base address for the block of registers used\nfor this kicker power supply.";
	prop_def  = "";
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);

}
//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::get_cvstag
// 
// description : 	parse TagName static var
//
//-----------------------------------------------------------------------------
string KiKeClass::get_cvstag()
{
	string	strtag("");
	string	tagname(TagName);
	string	header = "$Name: ";
	string	endstr(" $");
	string::size_type	start = header.length();
	string::size_type	end   = tagname.find(endstr);
	if (end!=string::npos && end>start)
		strtag = tagname.substr(start, end-start);
	return strtag;
}

//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::get_cvstag
// 
// description : 	parse RcsId static var
//
//-----------------------------------------------------------------------------
string KiKeClass::get_cvsroot()
{
	string	rcsId(RcsId);
	string	strloc("");
	string::size_type	start = rcsId.find("/");
	if (start!=string::npos)
	{
		string	filename(get_name());
		filename += "Class.cpp";
		string::size_type	end   = rcsId.find(filename);
		if (end>start)
		{
			strloc = rcsId.substr(start, end-start);
			//	Check if specific repository
			start = strloc.find("/cvsroot/");
			if (start!=string::npos && start>0)
			{
				string	repository = strloc.substr(0, start);
				if (repository.find("/segfs/")!=string::npos)
					strloc = "ESRF:" + strloc.substr(start, strloc.length()-start);
			}
		}
	}
	return strloc;
}
//+----------------------------------------------------------------------------
//
// method : 		KiKeClass::write_class_property
// 
// description : 	Set class description as property in database
//
//-----------------------------------------------------------------------------
void KiKeClass::write_class_property()
{
	//	Get and set cvs info
	string	cvsroot = get_cvsroot();
	string	cvstag = get_cvstag();
	set_cvs_location(cvsroot);
	set_cvs_tag(cvstag);

	//	Check if database used
	if (Tango::Util::_UseDb == false)
		return;

	Tango::DbData	data;
	string	classname = get_name();
	string	header;
	string::size_type	start, end;

	//	Put title
	Tango::DbDatum	title("ProjectTitle");
	string	str_title("KiKe Kickers");
	title << str_title;
	data.push_back(title);

	//	Put Description
	Tango::DbDatum	description("Description");
	vector<string>	str_desc;
	str_desc.push_back("Interface class for the booster extraction kickers Ki and Ke.");
	description << str_desc;
	data.push_back(description);

	//	put cvs location
	Tango::DbDatum	cvs_loc("cvs_location");
	cvs_loc << cvsroot;
	data.push_back(cvs_loc);

	//	Get CVS tag revision
	Tango::DbDatum	cvs_tag("cvs_tag");
	cvs_tag << cvstag;
	data.push_back(cvs_tag);

	//	Get URL location
	string	httpServ(HttpServer);
	if (httpServ.length()>0)
	{
		Tango::DbDatum	db_doc_url("doc_url");
		db_doc_url << httpServ;
		data.push_back(db_doc_url);
	}

	//  Put inheritance
	Tango::DbDatum	inher_datum("InheritedFrom");
	vector<string> inheritance;
	inheritance.push_back("PowerSupply");
	inheritance.push_back("Device_3Impl");
	inher_datum << inheritance;
	data.push_back(inher_datum);

	//	Call database and and values
	//--------------------------------------------
	get_db_class()->put_property(data);
}

}	// namespace
