//=============================================================================
//
// file :        KiKe.h
//
//  _  _  ____  _  _  ____    _  _  ___     ___  
// ( )/ )(_  _)( )/ )( ___)  ( \/ )(__ \   / _ \ 
//  )  (  _)(_  )  (  )__)    \  /  / _/  ( (_) )
// (_)\_)(____)(_)\_)(____)    \/  (____)()\___/ 
//
// description : Include for the KiKe class.
//
// project :	KiKe Kickers
//
// $Author: vedder $
//
// $Revision: 1.1.1.1 $
//
// $Log: KiKe.h,v $
// Revision 1.1.1.1  2008/07/10 08:41:16  meyer
// Imported using TkCVS
//
//
// copyleft :    European Synchrotron Radiation Facility
//               BP 220, Grenoble 38043
//               FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================
#ifndef _KIKE_H
#define _KIKE_H

#include <tango.h>
#include <PowerSupply.h>

//using namespace Tango;

/**
 * @author	$Author: meyer $
 * @version	$Revision: 1.1.1.1 $
 */

 //	Add your own constant definitions here.
 //-----------------------------------------------

// Register offsets
#define CURRENT_SET_OFFSET 		0x0
#define PULSE_SET_OFFSET 		0x1
#define CONTROL_WORD_OFFSET 	0x2
#define READING_OFFSET			0x0		

// Command bits in the control word
#define OFF_CMD					0x04
#define STANDBY_CMD				0x08
#define ON_CMD					0x10
#define RESET_CMD				0x20
#define APPLY_SETTING		  	0x40

// State bits in the status word
#define OFF_STATE				0x02
#define STANDBY_STATE			0x04
#define ON_STATE				0x08
#define FAULT_STATE			   	0x20
#define ALARM_STATE				0x80

#define KIKE_IS_ON			(status_word & ON_STATE)
#define KIKE_IS_OFF			(status_word & OFF_STATE)
#define KIKE_IN_STANDBY		(status_word & STANDBY_STATE)
#define KIKE_IS_OFF_TH		(kike_obj->status_word & OFF_STATE)
#define KIKE_IN_STANDBY_TH	(kike_obj->status_word & STANDBY_STATE)
#define KIKE_IN_ALARM		(status_word & ALARM_STATE)
#define KIKE_IN_FAULT		(status_word & FAULT_STATE)



// fault bits in the fault1 word
#define OIL_GROUP_FAULT        0x01
#define OIL_LEVEL_LOW          0x02
#define OIL_PRESSURE_HIGH      0x04
#define OIL_TEMP_HIGH          0x08
#define OIL_FLOW_LOW           0x10
#define THYRATRON_HEATERS      0x20
#define BREAKER                0x40
#define PLC_24V_PS_FAILURE	   0x80
#define CTRL_UNIT_PS_FAILURE   0x100
#define MAGNET_VACUUM_FAULT    0x200	
#define MAG_SF6_PRESS_LOW      0x400	
#define MAG_SF6BIS_PRESS_LOW   0x800	// KI only !
//#define SPARE BIT   		   0x1000	
//#define SPARE BIT   		   0x2000	
#define  MACHINE_INTERLOCK	   0x4000	// KE only !
#define  PSS_INTERLOCK  	   0x8000	// KE only !

// fault bits in the fault2 word
#define FLT_TRIG_10HZ_FAILURE      0x01
#define FLT_TRIG_1_10TH_HZ_FAILURE 0x02
#define FLT_SYNCHRO_FAULT	       0x04
//#define SPARE BIT            0x08
//#define SPARE BIT            0x10
//#define SPARE BIT      	   0x20
//#define SPARE BIT            0x40
//#define SPARE BIT	   		   0x80
#define FLT_IMAG_LOW           0x100
#define FLT_IMAG_HIGH          0x200
#define FLT_VPFN_LOW           0x400
#define FLT_VPFN_HIGH          0x800
//#define SPARE BIT           0x1000
//#define SPARE BIT      	  0x2000
//#define SPARE BIT           0x4000
//#define SPARE BIT	   		  0x8000


// alarm bits in the alarm word
#define TRIG_10HZ_MISSING      0x01
#define TRIG_1_10TH_HZ_MISSING 0x02
//#define SPARE BIT		       0x04
//#define SPARE BIT            0x08
//#define SPARE BIT            0x10
//#define SPARE BIT      	   0x20
//#define SPARE BIT            0x40
//#define SPARE BIT	   		   0x80
#define IMAG_LOW              0x100
#define IMAG_HIGH             0x200
#define VPFN_LOW              0x400
#define VPFN_HIGH             0x800
#define T1_TOO_SHORT          0x1000
#define T1_TOO_LONG           0x2000
#define T2_TOO_SHORT          0x4000
#define T2_TOO_LONG           0x8000

namespace KiKe_ns
{

/**
 * Class Description:
 * Interface class for the booster extraction kickers Ki and Ke.
 */

/*
 *	Device States Description:
*  Tango::ON :       Power Supply is ON
*  Tango::OFF :      Power Supply is OFF
*  Tango::STANDBY :  Power Supply is STANDBY
*  Tango::FAULT :    Fault detected on the Power Supply
*  Tango::ALARM :    Alarm detected on the Power Supply
*  Tango::MOVING :   When the device is going on, it execute a sequence. During this execution,
 *                    the device state is moving.
 */


class KiKe: public PowerSupply_ns::PowerSupply	//	Inherited from class Device_3Impl
{
public :
	//	Add your own data members here
	//-----------------------------------------
	Tango::DeviceProxy 	*modbus_obj;	
	bool sequenceRunning;
	bool sequenceFailed;
	string sequenceError;
	
	double 			current_set;
	double 			current_read;
	double		 	voltage;
	short			status_word;
	short			fault_word1;
	short			fault_word2;
	short			alarm_word;
	unsigned short 	pulse_number;
	unsigned short 	pulse_number_read;

	// Low level commands (without timing constrains).
	void set_current_on_PLC();
	void standby_on_PLC();
	void on_on_PLC();
	void off_on_PLC();
	void reset_on_PLC();
	
	time_t			last_read_time;
	time_t			last_current_write;
	
	//	Here is the Start of the automatic code generation part
	//-------------------------------------------------------------	
/**
 *	@name attributes
 *	Attribute member data.
 */
//@{
		Tango::DevDouble	*attr_Current_read;
		Tango::DevDouble	attr_Current_write;
		Tango::DevDouble	*attr_Voltage_read;
		Tango::DevDouble	attr_Voltage_write;
		Tango::DevDouble	*attr_CurrentSetPoint_read;
		Tango::DevUShort	*attr_PulseNumber_read;
		Tango::DevUShort	attr_PulseNumber_write;
//@}

/**
 * @name Device properties
 * Device properties member data.
 */
//@{
/**
 *	The name of the modbus device to use for comunication with the PLC.
 */
	string	modbusDevice;
/**
 *	The base address for the block of registers used
 *	for this kicker power supply.
 */
	Tango::DevLong	registerBaseAddress;
//@}

/**
 *	@name Device properties
 *	Device property member data.
 */
//@{
//@}

/**@name Constructors
 * Miscellaneous constructors */
//@{
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	KiKe(Tango::DeviceClass *cl,string &s);
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	KiKe(Tango::DeviceClass *cl,const char *s);
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device name
 *	@param d	Device description.
 */
	KiKe(Tango::DeviceClass *cl,const char *s,const char *d);
//@}

/**@name Destructor
 * Only one destructor is defined for this class */
//@{
/**
 * The object destructor.
 */	
	~KiKe() {delete_device();};
/**
 *	will be called at device destruction or at init command.
 */
	void delete_device();
//@}

	
/**@name Miscellaneous methods */
//@{
/**
 *	Initialize the device
 */
	virtual void init_device();
/**
 *	Always executed method before execution command method.
 */
	virtual void always_executed_hook();

//@}

/**
 * @name KiKe methods prototypes
 */

//@{
/**
 *	Hardware acquisition for attributes.
 */
	virtual void read_attr_hardware(vector<long> &attr_list);
/**
 *	Extract real attribute values for Current acquisition result.
 */
	virtual void read_Current(Tango::Attribute &attr);
/**
 *	Write Current attribute values to hardware.
 */
	virtual void write_Current(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for Voltage acquisition result.
 */
	virtual void read_Voltage(Tango::Attribute &attr);
/**
 *	Write Voltage attribute values to hardware.
 */
	virtual void write_Voltage(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for CurrentSetPoint acquisition result.
 */
	virtual void read_CurrentSetPoint(Tango::Attribute &attr);
/**
 *	Extract real attribute values for PulseNumber acquisition result.
 */
	virtual void read_PulseNumber(Tango::Attribute &attr);
/**
 *	Write PulseNumber attribute values to hardware.
 */
	virtual void write_PulseNumber(Tango::WAttribute &attr);
/**
 *	Read/Write allowed for Current attribute.
 */
	virtual bool is_Current_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for Voltage attribute.
 */
	virtual bool is_Voltage_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for CurrentSetPoint attribute.
 */
	virtual bool is_CurrentSetPoint_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for PulseNumber attribute.
 */
	virtual bool is_PulseNumber_allowed(Tango::AttReqType type);
/**
 *	Execution allowed for On command.
 */
	virtual bool is_On_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for Off command.
 */
	virtual bool is_Off_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for Reset command.
 */
	virtual bool is_Reset_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for Standby command.
 */
	virtual bool is_Standby_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DBG_On command.
 */
	virtual bool is_DBG_On_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DBG_Off command.
 */
	virtual bool is_DBG_Off_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DBG_Reset command.
 */
	virtual bool is_DBG_Reset_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DBG_Standby command.
 */
	virtual bool is_DBG_Standby_allowed(const CORBA::Any &any);
/**
 * This command gets the device state (stored in its <i>device_state</i> data member) and returns it to the caller.
 *	@return	State Code
 *	@exception DevFailed
 */
	virtual Tango::DevState	dev_state();
/**
 * This command gets the device status (stored in its <i>device_status</i> data member) and returns it to the caller.
 *	@return	Status description
 *	@exception DevFailed
 */
	virtual Tango::ConstDevString	dev_status();
/**
 * Switch powersupply ON.
 *	@exception DevFailed
 */
	void	on();
/**
 * Switch powersupply OFF.
 *	@exception DevFailed
 */
	void	off();
/**
 * Reset the powersupply to a well known state.
 *	@exception DevFailed
 */
	void	reset();
/**
 * Set the kicker to standby
 *	@exception DevFailed
 */
	void	standby();
/**
 * Send a ON command to the PLC, without any timing or state control. This is a debug function.
 *	@exception DevFailed
 */
	void	dbg__on();
/**
 * Send a OFF command to the PLC, without any timing or state control. This is a debug function.
 *	@exception DevFailed
 */
	void	dbg__off();
/**
 * Send a Reset command to the PLC, without any timing or state control. This is a debug function.
 *	@exception DevFailed
 */
	void	dbg__reset();
/**
 * Send a Standby command to the PLC, without any timing or state control. This is a debug function.
 *	@exception DevFailed
 */
	void	dbg__standby();

/**
 *	Read the device properties from database
 */
	 void get_device_property();
//@}

	//	Here is the end of the automatic code generation part
	//-------------------------------------------------------------	



protected :	
	//	Add your own data members here
	//-----------------------------------------

	Tango::DevState kicker_state;
	omni_mutex		mutex;
	
};

}	// namespace_ns

#endif	// _KIKE_H
