//=============================================================================
//
// file :         CcdClass.h
//
// description :  Include for the CcdClass root class.
//                This class is represents the singleton class for
//                the Ccd device class.
//                It contains all properties and methods which the 
//                Ccd requires only once e.g. the commands.
//			
// project :      TANGO Device Server
//
// $Author:  $
//
// $Revision:  $
//
// $Log:  $
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

#ifndef _CCDCLASS_H
#define _CCDCLASS_H

#include <tango.h>
#include <Ccd.h>


namespace Ccd_ns
{
//=====================================
//	Define classes for attributes
//=====================================
class JpegImageAttrib: public Tango::SpectrumAttr
{
public:
	JpegImageAttrib():SpectrumAttr("JpegImage", Tango::DEV_UCHAR, Tango::READ, 6400000) {};
	~JpegImageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_JpegImage(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_JpegImage_allowed(ty);}
};

class ImageCounterAttrib: public Tango::Attr
{
public:
	ImageCounterAttrib():Attr("ImageCounter", Tango::DEV_LONG, Tango::READ) {};
	~ImageCounterAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_ImageCounter(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_ImageCounter_allowed(ty);}
};

class ImageFormatAttrib: public Tango::Attr
{
public:
	ImageFormatAttrib():Attr("ImageFormat", Tango::DEV_STRING, Tango::WRITE) {};
	~ImageFormatAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_ImageFormat(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<Ccd *>(dev))->write_ImageFormat(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_ImageFormat_allowed(ty);}
};

class ImageAttrib: public Tango::ImageAttr
{
public:
	ImageAttrib():ImageAttr("Image", Tango::DEV_UCHAR, Tango::READ, 4096, 4096) {};
	~ImageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_Image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_Image_allowed(ty);}
};

class FileFormatAttrib: public Tango::Attr
{
public:
	FileFormatAttrib():Attr("FileFormat", Tango::DEV_STRING, Tango::READ_WRITE) {};
	~FileFormatAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_FileFormat(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<Ccd *>(dev))->write_FileFormat(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_FileFormat_allowed(ty);}
};

class FileParamsAttrib: public Tango::SpectrumAttr
{
public:
	FileParamsAttrib():SpectrumAttr("FileParams", Tango::DEV_STRING, Tango::READ_WRITE, 4) {};
	~FileParamsAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_FileParams(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<Ccd *>(dev))->write_FileParams(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_FileParams_allowed(ty);}
};

class DepthAttrib: public Tango::Attr
{
public:
	DepthAttrib():Attr("Depth", Tango::DEV_SHORT, Tango::READ) {};
	~DepthAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_Depth(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_Depth_allowed(ty);}
};

class FramesAttrib: public Tango::Attr
{
public:
	FramesAttrib():Attr("Frames", Tango::DEV_LONG, Tango::READ_WRITE) {};
	~FramesAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_Frames(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<Ccd *>(dev))->write_Frames(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_Frames_allowed(ty);}
};

class HeightAttrib: public Tango::Attr
{
public:
	HeightAttrib():Attr("Height", Tango::DEV_LONG, Tango::READ) {};
	~HeightAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_Height(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_Height_allowed(ty);}
};

class WidthAttrib: public Tango::Attr
{
public:
	WidthAttrib():Attr("Width", Tango::DEV_LONG, Tango::READ) {};
	~WidthAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_Width(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_Width_allowed(ty);}
};

class TriggerAttrib: public Tango::Attr
{
public:
	TriggerAttrib():Attr("Trigger", Tango::DEV_SHORT, Tango::READ_WRITE) {};
	~TriggerAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_Trigger(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<Ccd *>(dev))->write_Trigger(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_Trigger_allowed(ty);}
};

class BinningAttrib: public Tango::SpectrumAttr
{
public:
	BinningAttrib():SpectrumAttr("Binning", Tango::DEV_SHORT, Tango::READ_WRITE, 2) {};
	~BinningAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_Binning(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<Ccd *>(dev))->write_Binning(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_Binning_allowed(ty);}
};

class RoiAttrib: public Tango::SpectrumAttr
{
public:
	RoiAttrib():SpectrumAttr("Roi", Tango::DEV_LONG, Tango::READ_WRITE, 4) {};
	~RoiAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_Roi(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<Ccd *>(dev))->write_Roi(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_Roi_allowed(ty);}
};

class ExposureAttrib: public Tango::Attr
{
public:
	ExposureAttrib():Attr("Exposure", Tango::DEV_DOUBLE, Tango::READ_WRITE) {};
	~ExposureAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Ccd *>(dev))->read_Exposure(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<Ccd *>(dev))->write_Exposure(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Ccd *>(dev))->is_Exposure_allowed(ty);}
};

//=========================================
//	Define classes for commands
//=========================================
class WriteFileClass : public Tango::Command
{
public:
	WriteFileClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	WriteFileClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~WriteFileClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Ccd *>(dev))->is_WriteFile_allowed(any);}
};



class ResetClass : public Tango::Command
{
public:
	ResetClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	ResetClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~ResetClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Ccd *>(dev))->is_Reset_allowed(any);}
};



class StopClass : public Tango::Command
{
public:
	StopClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	StopClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~StopClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Ccd *>(dev))->is_Stop_allowed(any);}
};



class StartClass : public Tango::Command
{
public:
	StartClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	StartClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~StartClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Ccd *>(dev))->is_Start_allowed(any);}
};



//
// The CcdClass singleton definition
//

class CcdClass : public Tango::DeviceClass
{
public:
//	properties member data

//	add your own data members here
//------------------------------------

public:

protected:
	CcdClass(string &);
	void command_factory();
	void get_class_property();
	void attribute_factory(vector<Tango::Attr *> &);

private:
};


}	//	namespace Ccd_ns

#endif // _CCDCLASS_H
