static const char *TagName   = "$Name: $";
static const char *HttpServer= "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/";
static const char *RcsId = "$Header:  $";
//+=============================================================================
//
// file :        CcdClass.cpp
//
// description : C++ source for the CcdClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the Ccd once per process.
//
// project :     TANGO Device Server
//
// $Author:  $
//
// $Revision:  $
//
// $Log:  $
//
// copyleft :   European Synchrotron Radiation Facility
//              BP 220, Grenoble 38043
//              FRANCE
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================


#include <tango.h>

#include <Ccd.h>
#include <CcdClass.h>


namespace Ccd_ns
{

//+----------------------------------------------------------------------------
//
// method : 		StartClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *StartClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "StartClass::execute(): arrived" << endl;

	((static_cast<Ccd *>(device))->start());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		StopClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *StopClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "StopClass::execute(): arrived" << endl;

	((static_cast<Ccd *>(device))->stop());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		ResetClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *ResetClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "ResetClass::execute(): arrived" << endl;

	((static_cast<Ccd *>(device))->reset());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		WriteFileClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *WriteFileClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "WriteFileClass::execute(): arrived" << endl;

	((static_cast<Ccd *>(device))->write_file());
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		CcdClass::CcdClass(string &s)
// 
// description : 	constructor for the CcdClass
//
// in : - s : The class name
//
//-----------------------------------------------------------------------------
CcdClass::CcdClass(string &s):DeviceClass(s)
{

	cout2 << "Entering CcdClass constructor" << endl;
	
	cout2 << "Leaving CcdClass constructor" << endl;

}
//+----------------------------------------------------------------------------
//
// method : 		CcdClass::command_factory
// 
// description : 	Create the command object(s) and store them in the 
//			command list
//
//-----------------------------------------------------------------------------
void CcdClass::command_factory()
{
	command_list.push_back(new StartClass("Start",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));
	command_list.push_back(new StopClass("Stop",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));
	command_list.push_back(new ResetClass("Reset",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));
	command_list.push_back(new WriteFileClass("WriteFile",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));

	//	add polling if any
	for (unsigned int i=0 ; i<command_list.size(); i++)
	{
	}
}
//+----------------------------------------------------------------------------
//	Method: CcdClass::attribute_factory(vector<Tango::Attr *> &att_list)
//-----------------------------------------------------------------------------
void CcdClass::attribute_factory(vector<Tango::Attr *> &att_list)
{
	//	Attribute : Exposure
	ExposureAttrib	*exposure = new ExposureAttrib();
	Tango::UserDefaultAttrProp	exposure_prop;
	exposure_prop.set_label("exposure");
	exposure_prop.set_unit("seconds");
	exposure_prop.set_standard_unit("seconds");
	exposure_prop.set_display_unit("seconds");
	exposure_prop.set_format("%6.3d");
	exposure_prop.set_description("the exposure time for the image");
	exposure->set_default_properties(exposure_prop);
	att_list.push_back(exposure);

	//	Attribute : Roi
	RoiAttrib	*roi = new RoiAttrib();
	Tango::UserDefaultAttrProp	roi_prop;
	roi_prop.set_label("region of interest");
	roi_prop.set_unit("pixels");
	roi_prop.set_standard_unit("pixels");
	roi_prop.set_display_unit("pixels");
	roi_prop.set_format("%d");
	roi_prop.set_description("coordinates of the region of interest ");
	roi->set_default_properties(roi_prop);
	att_list.push_back(roi);

	//	Attribute : Binning
	BinningAttrib	*binning = new BinningAttrib();
	Tango::UserDefaultAttrProp	binning_prop;
	binning_prop.set_label("binning");
	binning_prop.set_unit("pixels");
	binning_prop.set_standard_unit("pixels");
	binning_prop.set_display_unit("pixels");
	binning_prop.set_format("%d");
	binning_prop.set_description("binning factor of image");
	binning->set_default_properties(binning_prop);
	att_list.push_back(binning);

	//	Attribute : Trigger
	TriggerAttrib	*trigger = new TriggerAttrib();
	Tango::UserDefaultAttrProp	trigger_prop;
	trigger_prop.set_label("trigger");
	trigger_prop.set_description("trigger mode of camera (0=internal, 1=external)");
	trigger->set_default_properties(trigger_prop);
	att_list.push_back(trigger);

	//	Attribute : Width
	WidthAttrib	*width = new WidthAttrib();
	Tango::UserDefaultAttrProp	width_prop;
	width_prop.set_label("width");
	width_prop.set_unit("pixels");
	width_prop.set_standard_unit("pixels");
	width_prop.set_display_unit("pixels");
	width_prop.set_description("width of image in pixels");
	width->set_default_properties(width_prop);
	att_list.push_back(width);

	//	Attribute : Height
	HeightAttrib	*height = new HeightAttrib();
	Tango::UserDefaultAttrProp	height_prop;
	height_prop.set_label("height");
	height_prop.set_unit("pixels");
	height_prop.set_standard_unit("pixels");
	height_prop.set_display_unit("pixels");
	height_prop.set_format("%d");
	height_prop.set_description("height of image in pixels");
	height->set_default_properties(height_prop);
	att_list.push_back(height);

	//	Attribute : Frames
	FramesAttrib	*frames = new FramesAttrib();
	Tango::UserDefaultAttrProp	frames_prop;
	frames_prop.set_label("frames");
	frames_prop.set_format("%d");
	frames_prop.set_description("number of images to take");
	frames->set_default_properties(frames_prop);
	att_list.push_back(frames);

	//	Attribute : Depth
	DepthAttrib	*depth = new DepthAttrib();
	Tango::UserDefaultAttrProp	depth_prop;
	depth_prop.set_label("depth");
	depth_prop.set_unit("bits");
	depth_prop.set_standard_unit("bits");
	depth_prop.set_display_unit("bits");
	depth_prop.set_format("%d");
	depth_prop.set_description("number of bits per pixel");
	depth->set_default_properties(depth_prop);
	att_list.push_back(depth);

	//	Attribute : FileParams
	FileParamsAttrib	*file_params = new FileParamsAttrib();
	Tango::UserDefaultAttrProp	file_params_prop;
	file_params_prop.set_label("file parameters");
	file_params_prop.set_description("the file parameters for generating file names (directory, prefix, suffix, number)");
	file_params->set_default_properties(file_params_prop);
	att_list.push_back(file_params);

	//	Attribute : FileFormat
	FileFormatAttrib	*file_format = new FileFormatAttrib();
	Tango::UserDefaultAttrProp	file_format_prop;
	file_format_prop.set_label("file format");
	file_format_prop.set_description("file format for saving images to disk");
	file_format->set_default_properties(file_format_prop);
	att_list.push_back(file_format);

	//	Attribute : Image
	ImageAttrib	*image = new ImageAttrib();
	Tango::UserDefaultAttrProp	image_prop;
	image_prop.set_label("image");
	image_prop.set_description("image data");
	image->set_default_properties(image_prop);
	att_list.push_back(image);

	//	Attribute : ImageFormat
	ImageFormatAttrib	*image_format = new ImageFormatAttrib();
	att_list.push_back(image_format);

	//	Attribute : ImageCounter
	ImageCounterAttrib	*image_counter = new ImageCounterAttrib();
	att_list.push_back(image_counter);

	//	Attribute : JpegImage
	JpegImageAttrib	*jpeg_image = new JpegImageAttrib();
	att_list.push_back(jpeg_image);

}

}	// namespace
