//=============================================================================
//
// file :        Ccd.h
//
// description : Include for the Ccd class.
//
// project :	Abstract class for Ccd cameras
//
// $Author:  $
//
// $Revision:  $
//
// $Log:  $
//
// copyleft :    European Synchrotron Radiation Facility
//               BP 220, Grenoble 38043
//               FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================
#ifndef _CCD_H
#define _CCD_H

#include <tango.h>
//using namespace Tango;

/**
 * @author	$Author:  $
 * @version	$Revision:  $
 */

 //	Add your own constants definitions here.
 //-----------------------------------------------


namespace Ccd_ns
{

/**
 * Class Description:
 * Abstract class for charged coupled device (ccd) cameras.
 */

/*
 *	Device States Description:
 *  Tango::ON :     camera is exposing
 *
 *  Tango::OFF :    camera is ready to start a new exposure
 *
 *  Tango::FAULT :  camera is in fault
 */


class Ccd: public Tango::Device_3Impl
{
public :
	//	Add your own data members here
	//-----------------------------------------


	//	Here is the Start of the automatic code generation part
	//-------------------------------------------------------------	
/**
 *	@name attributes
 *	Attributs member data.
 */
//@{
		Tango::DevDouble	*attr_Exposure_read;
		Tango::DevDouble	attr_Exposure_write;
		Tango::DevLong	*attr_Roi_read;
		Tango::DevLong	attr_Roi_write;
		Tango::DevShort	*attr_Binning_read;
		Tango::DevShort	attr_Binning_write;
		Tango::DevShort	*attr_Trigger_read;
		Tango::DevShort	attr_Trigger_write;
		Tango::DevLong	*attr_Width_read;
		Tango::DevLong	*attr_Height_read;
		Tango::DevLong	*attr_Frames_read;
		Tango::DevLong	attr_Frames_write;
		Tango::DevShort	*attr_Depth_read;
		Tango::DevString	*attr_FileParams_read;
		Tango::DevString	attr_FileParams_write;
		Tango::DevString	*attr_FileFormat_read;
		Tango::DevString	attr_FileFormat_write;
		Tango::DevUChar	*attr_Image_read;
		Tango::DevString	attr_ImageFormat_write;
		Tango::DevLong	*attr_ImageCounter_read;
		Tango::DevUChar	*attr_JpegImage_read;
//@}

/**
 *	@name Device properties
 *	Device properties member data.
 */
//@{
//@}

/**@name Constructors
 * Miscellaneous constructors */
//@{
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	Ccd(Tango::DeviceClass *cl,string &s):Device_3Impl(cl,s) {};
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	Ccd(Tango::DeviceClass *cl,const char *s):Device_3Impl(cl,s) {};
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device name
 *	@param d	Device description.
 */
	Ccd(Tango::DeviceClass *cl,const char *s,const char *d):Device_3Impl(cl,s,d) {};
//@}

/**
 * @name Ccd methods prototypes
 */

//@{
/**
 *	Hardware acquisition for attributes.
 */
	virtual void read_attr_hardware(vector<long> &attr_list) = NULL;
/**
 *	Extract real attribute values for Exposure acquisition result.
 */
	virtual void read_Exposure(Tango::Attribute &attr) = NULL;
/**
 *	Write Exposure attribute values to hardware.
 */
	virtual void write_Exposure(Tango::WAttribute &attr) = NULL;
/**
 *	Extract real attribute values for Roi acquisition result.
 */
	virtual void read_Roi(Tango::Attribute &attr) = NULL;
/**
 *	Write Roi attribute values to hardware.
 */
	virtual void write_Roi(Tango::WAttribute &attr) = NULL;
/**
 *	Extract real attribute values for Binning acquisition result.
 */
	virtual void read_Binning(Tango::Attribute &attr) = NULL;
/**
 *	Write Binning attribute values to hardware.
 */
	virtual void write_Binning(Tango::WAttribute &attr) = NULL;
/**
 *	Extract real attribute values for Trigger acquisition result.
 */
	virtual void read_Trigger(Tango::Attribute &attr) = NULL;
/**
 *	Write Trigger attribute values to hardware.
 */
	virtual void write_Trigger(Tango::WAttribute &attr) = NULL;
/**
 *	Extract real attribute values for Width acquisition result.
 */
	virtual void read_Width(Tango::Attribute &attr) = NULL;
/**
 *	Extract real attribute values for Height acquisition result.
 */
	virtual void read_Height(Tango::Attribute &attr) = NULL;
/**
 *	Extract real attribute values for Frames acquisition result.
 */
	virtual void read_Frames(Tango::Attribute &attr) = NULL;
/**
 *	Write Frames attribute values to hardware.
 */
	virtual void write_Frames(Tango::WAttribute &attr) = NULL;
/**
 *	Extract real attribute values for Depth acquisition result.
 */
	virtual void read_Depth(Tango::Attribute &attr) = NULL;
/**
 *	Extract real attribute values for FileParams acquisition result.
 */
	virtual void read_FileParams(Tango::Attribute &attr) = NULL;
/**
 *	Write FileParams attribute values to hardware.
 */
	virtual void write_FileParams(Tango::WAttribute &attr) = NULL;
/**
 *	Extract real attribute values for FileFormat acquisition result.
 */
	virtual void read_FileFormat(Tango::Attribute &attr) = NULL;
/**
 *	Write FileFormat attribute values to hardware.
 */
	virtual void write_FileFormat(Tango::WAttribute &attr) = NULL;
/**
 *	Extract real attribute values for Image acquisition result.
 */
	virtual void read_Image(Tango::Attribute &attr) = NULL;
/**
 *	Extract real attribute values for ImageFormat acquisition result.
 */
	virtual void read_ImageFormat(Tango::Attribute &attr) = NULL;
/**
 *	Write ImageFormat attribute values to hardware.
 */
	virtual void write_ImageFormat(Tango::WAttribute &attr) = NULL;
/**
 *	Extract real attribute values for ImageCounter acquisition result.
 */
	virtual void read_ImageCounter(Tango::Attribute &attr) = NULL;
/**
 *	Extract real attribute values for JpegImage acquisition result.
 */
	virtual void read_JpegImage(Tango::Attribute &attr) = NULL;
/**
 *	Read/Write allowed for Exposure attribute.
 */
	virtual bool is_Exposure_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for Roi attribute.
 */
	virtual bool is_Roi_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for Binning attribute.
 */
	virtual bool is_Binning_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for Trigger attribute.
 */
	virtual bool is_Trigger_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for Width attribute.
 */
	virtual bool is_Width_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for Height attribute.
 */
	virtual bool is_Height_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for Frames attribute.
 */
	virtual bool is_Frames_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for Depth attribute.
 */
	virtual bool is_Depth_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for FileParams attribute.
 */
	virtual bool is_FileParams_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for FileFormat attribute.
 */
	virtual bool is_FileFormat_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for Image attribute.
 */
	virtual bool is_Image_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for ImageFormat attribute.
 */
	virtual bool is_ImageFormat_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for ImageCounter attribute.
 */
	virtual bool is_ImageCounter_allowed(Tango::AttReqType type){ return true; };
/**
 *	Read/Write allowed for JpegImage attribute.
 */
	virtual bool is_JpegImage_allowed(Tango::AttReqType type){ return true; };
/**
 *	Execution allowed for Start command.
 */
	virtual bool is_Start_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for Stop command.
 */
	virtual bool is_Stop_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for Reset command.
 */
	virtual bool is_Reset_allowed(const CORBA::Any &any){ return true; };
/**
 *	Execution allowed for WriteFile command.
 */
	virtual bool is_WriteFile_allowed(const CORBA::Any &any){ return true; };
/**
 * start camera exposing
 *	@exception DevFailed
 */
	virtual void	start() = NULL;
/**
 * stop camera exposing
 *	@exception DevFailed
 */
	virtual void	stop() = NULL;
/**
 * reset camera
 *	@exception DevFailed
 */
	virtual void	reset() = NULL;
/**
 * write image to file in the selected format, use the file parameters to generate file name
 *	@exception DevFailed
 */
	virtual void	write_file() = NULL;

//@}

	//	Here is the end of the automatic code generation part
	//-------------------------------------------------------------	



protected :	
	//	Add your own data members here
	//-----------------------------------------
};

}	// namespace

#endif	// _CCD_H
