/*
 * Decompiled with CFR 0.152.
 */
package mambo;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import mambo.DateUtil;
import mambo.QueryInfo;

public class HdbQueryDlg
extends JDialog {
    static final long DAY = 86400000L;
    static final long HOUR = 3600000L;
    static final long[] dateOffset = new long[]{14400000L, 28800000L, 86400000L, 259200000L, 604800000L, 2592000000L};
    private JTextField d1Text;
    private JTextField d2Text;
    private JComboBox dateCombo;
    private JButton goBtn;
    private JButton cancelBtn;
    boolean ret_value = false;

    public HdbQueryDlg(String string, Frame frame) {
        super(frame, string, true);
        this.getContentPane().setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HdbQueryDlg.this.ret_value = false;
                HdbQueryDlg.this.hide();
                HdbQueryDlg.this.dispose();
            }
        });
        this.d1Text = new JTextField();
        this.d1Text.setEditable(true);
        this.d1Text.setBorder(BorderFactory.createTitledBorder("Start date"));
        this.d1Text.setBackground(this.getBackground());
        this.getContentPane().add(this.d1Text);
        this.d2Text = new JTextField();
        this.d2Text.setEditable(true);
        this.d2Text.setBorder(BorderFactory.createTitledBorder("Stop date"));
        this.d2Text.setBackground(this.getBackground());
        this.getContentPane().add(this.d2Text);
        this.dateCombo = new JComboBox();
        this.dateCombo.removeAllItems();
        this.dateCombo.addItem("Last 4 hours");
        this.dateCombo.addItem("Last 8 hours");
        this.dateCombo.addItem("Last day");
        this.dateCombo.addItem("Last 3 days");
        this.dateCombo.addItem("Last week");
        this.dateCombo.addItem("Last month");
        this.getContentPane().add(this.dateCombo);
        this.dateCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HdbQueryDlg.this.updateDate();
            }
        });
        this.dateCombo.setSelectedIndex(0);
        this.goBtn = new JButton();
        this.goBtn.setText("Go");
        this.getContentPane().add(this.goBtn);
        this.cancelBtn = new JButton();
        this.cancelBtn.setText("Cancel");
        this.getContentPane().add(this.cancelBtn);
        this.d1Text.setBounds(5, 10, 390, 40);
        this.d2Text.setBounds(5, 50, 390, 40);
        this.dateCombo.setBounds(5, 95, 390, 25);
        this.goBtn.setBounds(5, 245, 150, 30);
        this.cancelBtn.setBounds(315, 245, 80, 30);
        this.cancelBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HdbQueryDlg.this.ret_value = false;
                HdbQueryDlg.this.hide();
                HdbQueryDlg.this.dispose();
            }
        });
        this.goBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HdbQueryDlg.this.ret_value = true;
                HdbQueryDlg.this.hide();
                HdbQueryDlg.this.dispose();
            }
        });
        Rectangle rectangle = frame.getBounds();
        int n = rectangle.x + (rectangle.width - 410) / 2;
        int n2 = rectangle.y + (rectangle.height - 310) / 2;
        this.setBounds(n, n2, 410, 310);
    }

    public QueryInfo showDlg() {
        this.show();
        if (this.ret_value) {
            long l;
            long l2;
            String string = this.d1Text.getText();
            try {
                l2 = DateUtil.dateToTime(string);
            }
            catch (ParseException parseException) {
                this.showError("Failed to parse start date\n" + parseException.getMessage());
                return null;
            }
            String string2 = this.d2Text.getText();
            try {
                l = DateUtil.dateToTime(string2);
            }
            catch (ParseException parseException) {
                this.showError("Failed to parse stop date\n" + parseException.getMessage());
                return null;
            }
            return new QueryInfo(l2, l);
        }
        return null;
    }

    private void updateDate() {
        long l = System.currentTimeMillis();
        this.d2Text.setText(DateUtil.timeToDate(l));
        this.d1Text.setText(DateUtil.timeToDate(l -= dateOffset[this.dateCombo.getSelectedIndex()]));
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "Mambo error", 0);
    }
}

