/*
 * Decompiled with CFR 0.152.
 */
package mambo;

import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.soleil.TangoHdb.HdbApi.HdbDataBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mambo.HdbQueryDlg;
import mambo.HdbTreeNode;
import mambo.HdbTreeNodeRenderer;
import mambo.QueryInfo;

public class MainPanel
extends JFrame {
    private String appVersion = "Mambo 1.0";
    private HdbDataBase theDB;
    private boolean runningFromShell = false;
    private JPanel innerPanel;
    private JTree mainTree = null;
    private DefaultTreeModel mainTreeModel;
    private DefaultMutableTreeNode rootNode;
    private MouseListener treeMousellistemner;
    private MouseListener valueMousellistemner;
    private TreeSelectionListener treeSelectionlistemner;
    private JScrollPane treeView;
    private JPopupMenu treeMenu;
    private JMenuItem[] treeMenuItem;
    private HdbTreeNodeRenderer renderer;
    JLChart theGraph;
    private JMenuBar mainMenu;

    MainPanel() {
        this.initComponents();
    }

    public void initComponents() {
        this.theDB = new HdbDataBase(1, "proxima", "extractor", "extractor", "hdb");
        try {
            this.theDB.connect();
        }
        catch (SQLException sQLException) {
            this.showError("Cannot connect to HDB\n" + sQLException.getMessage());
            this.exitForm();
        }
        this.setTitle(this.appVersion + " [ Connected on " + this.theDB.getHost() + "." + this.theDB.getName() + "]");
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.innerPanel = new JPanel();
        this.getContentPane().add(this.innerPanel);
        this.innerPanel.setLayout(new BorderLayout());
        this.theGraph = new JLChart();
        this.theGraph.setBorder((Border)new EtchedBorder());
        this.theGraph.setBackground(new Color(180, 180, 180));
        this.theGraph.getY1Axis().setAutoScale(true);
        this.theGraph.getY2Axis().setAutoScale(true);
        this.theGraph.getXAxis().setAutoScale(true);
        this.innerPanel.add((Component)this.theGraph, "Center");
        this.treeMousellistemner = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MainPanel.this.innerPanel.revalidate();
                TreePath treePath = MainPanel.this.mainTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                int n = MainPanel.this.mainTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3 && treePath != null) {
                    MainPanel.this.mainTree.setSelectionPath(treePath);
                    HdbTreeNode hdbTreeNode = (HdbTreeNode)treePath.getLastPathComponent();
                    boolean[] blArray = hdbTreeNode.getAction();
                    if (blArray != null) {
                        int n2 = 0;
                        while (n2 < blArray.length) {
                            MainPanel.this.treeMenuItem[n2].setEnabled(blArray[n2]);
                            ++n2;
                        }
                        MainPanel.this.treeMenu.show(MainPanel.this.mainTree, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        };
        this.treeSelectionlistemner = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            }
        };
        this.createMainTree();
        this.innerPanel.add((Component)this.treeView, "West");
        this.treeMenu = new JPopupMenu();
        this.treeMenuItem = new JMenuItem[HdbTreeNode.nbAction];
        int n = 0;
        while (n < HdbTreeNode.nbAction) {
            this.treeMenuItem[n] = new JMenuItem();
            this.treeMenuItem[n].setText(HdbTreeNode.ItemAction[n]);
            this.treeMenuItem[n].setEnabled(false);
            this.treeMenuItem[n].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainPanel.this.execMenuAction(actionEvent);
                }
            });
            ++n;
        }
        int n2 = 0;
        while (n2 < HdbTreeNode.nbAction) {
            this.treeMenu.add(this.treeMenuItem[n2]);
            ++n2;
        }
        this.mainMenu = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Options");
        JMenu jMenu3 = new JMenu("Query");
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.exitForm();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Graph settings");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.showGraphOption();
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("View " + this.theDB.getName() + " tree");
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (!jCheckBoxMenuItem.isSelected()) {
                    MainPanel.this.innerPanel.remove(MainPanel.this.treeView);
                    jCheckBoxMenuItem.setSelected(false);
                } else {
                    MainPanel.this.innerPanel.add((Component)MainPanel.this.treeView, "West");
                    jCheckBoxMenuItem.setSelected(true);
                }
                MainPanel.this.innerPanel.revalidate();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Request data");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = MainPanel.this.mainTree.getSelectionPaths();
                if (treePathArray != null && treePathArray.length > 0) {
                    MainPanel.this.executeRequest(treePathArray);
                    MainPanel.this.mainTree.repaint();
                    return;
                }
                MainPanel.this.showError("No item selected.");
            }
        });
        jMenu.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jCheckBoxMenuItem);
        jMenu3.add(jMenuItem3);
        this.mainMenu.add(jMenu);
        this.mainMenu.add(jMenu2);
        this.mainMenu.add(jMenu3);
        this.setJMenuBar(this.mainMenu);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
                MainPanel.this.exitForm();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.centerWindow();
        this.setVisible(true);
    }

    public void showGraphOption() {
        this.theGraph.showOptionDialog();
    }

    public void executeRequest(TreePath[] treePathArray) {
        HdbQueryDlg hdbQueryDlg;
        Object object;
        if (treePathArray.length == 1) {
            object = (HdbTreeNode)treePathArray[0].getLastPathComponent();
            if (!((HdbTreeNode)object).isLeaf()) {
                return;
            }
            hdbQueryDlg = new HdbQueryDlg("Resquesting data for " + ((HdbTreeNode)object).getAttributeName(), this);
        } else {
            hdbQueryDlg = new HdbQueryDlg("Resquesting data for " + treePathArray.length + " attributes", this);
        }
        object = hdbQueryDlg.showDlg();
        if (object != null) {
            String string = null;
            this.setCursor(Cursor.getPredefinedCursor(3));
            int n = 0;
            while (n < treePathArray.length) {
                String string2;
                HdbTreeNode hdbTreeNode = (HdbTreeNode)treePathArray[n].getLastPathComponent();
                if (hdbTreeNode.isLeaf() && (string2 = hdbTreeNode.retrieveData((QueryInfo)object, this.theDB)) != null) {
                    string = string == null ? string2 : (string.endsWith("\n") ? string + "----------------------------------------\n" + string2 : string + "\n----------------------------------------\n" + string2);
                }
                ++n;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (string != null) {
                this.showError(string);
            }
        }
    }

    public void execMenuAction(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        int n = 0;
        boolean bl = false;
        while (n < HdbTreeNode.nbAction && !bl) {
            boolean bl2 = bl = jMenuItem == this.treeMenuItem[n];
            if (bl) continue;
            ++n;
        }
        if (!bl) {
            return;
        }
        HdbTreeNode hdbTreeNode = (HdbTreeNode)this.mainTree.getSelectionPath().getLastPathComponent();
        switch (n) {
            case 0: {
                TreePath[] treePathArray = new TreePath[]{this.mainTree.getSelectionPath()};
                this.executeRequest(treePathArray);
                break;
            }
            case 1: {
                hdbTreeNode.setSelected(1);
                break;
            }
            case 2: {
                hdbTreeNode.setSelected(2);
                break;
            }
            case 3: {
                hdbTreeNode.setSelected(3);
                break;
            }
            case 4: {
                hdbTreeNode.setSelected(0);
                break;
            }
            case 5: {
                hdbTreeNode.showOptions(this);
            }
        }
        this.mainTree.repaint();
    }

    private void createMainTree() {
        this.renderer = new HdbTreeNodeRenderer();
        this.rootNode = new HdbTreeNode(this.theDB.getName(), 0, this.theGraph);
        this.mainTreeModel = new DefaultTreeModel(this.rootNode);
        this.mainTree = new JTree(this.mainTreeModel);
        this.mainTree.setEditable(false);
        this.mainTree.setCellRenderer(this.renderer);
        this.mainTree.getSelectionModel().setSelectionMode(4);
        this.mainTree.setShowsRootHandles(true);
        this.mainTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.mainTree);
        this.mainTree.addMouseListener(this.treeMousellistemner);
        this.mainTree.addTreeSelectionListener(this.treeSelectionlistemner);
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = new Dimension(750, 500);
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setBounds(n, n2, dimension2.width, dimension2.height);
    }

    public void exitForm() {
        if (this.runningFromShell) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "Mambo error", 0);
    }

    public static void main(String[] stringArray) {
        MainPanel mainPanel = new MainPanel();
    }
}

