/*
 * Decompiled with CFR 0.152.
 */
package mambo;

import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.JLDataViewOption;
import fr.soleil.TangoHdb.HdbApi.HdbDataBase;
import java.awt.Color;
import java.sql.SQLException;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import mambo.DateUtil;
import mambo.QueryInfo;

public class HdbTreeNode
extends DefaultMutableTreeNode {
    public static int nbAction = 6;
    public static String[] ItemAction = new String[]{"Request data", "Plot on Y1", "Plot on Y2", "Set on X axis", "Unselect", "Settings"};
    public static final int SELNONE = 0;
    public static final int SELY1 = 1;
    public static final int SELY2 = 2;
    public static final int SELX = 3;
    public static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow};
    static int colorIndex = 0;
    private boolean areChildrenDefined = false;
    private int numChildren;
    private String value = "";
    private int level = 0;
    private int selected = 0;
    private JLChart theGraph = null;
    private JLDataView theView = null;

    public HdbTreeNode(String string, int n, JLChart jLChart) {
        this.value = string;
        this.level = n;
        this.theGraph = jLChart;
        if (this.isLeaf()) {
            this.theView = new JLDataView();
            this.theView.setColor(defaultColor[colorIndex % 8]);
            ++colorIndex;
        }
    }

    public boolean isLeaf() {
        return this.level == 4;
    }

    public int getChildCount() {
        if (!this.areChildrenDefined) {
            this.defineChildNodes();
        }
        return super.getChildCount();
    }

    private void defineChildNodes() {
        this.areChildrenDefined = true;
        String[] stringArray = null;
        switch (this.level) {
            case 0: {
                stringArray = new String[]{"jlp", "sr"};
                break;
            }
            case 1: {
                stringArray = new String[]{"test", "d-irm"};
                break;
            }
            case 2: {
                stringArray = new String[]{"1", "2", "3", "id22"};
                break;
            }
            case 3: {
                stringArray = new String[15];
                stringArray[0] = "att_un";
                stringArray[1] = "att_deux";
                stringArray[2] = "att_trois";
                stringArray[3] = "att_quatre";
                stringArray[4] = "T1";
                stringArray[5] = "T2";
                stringArray[6] = "T3";
                stringArray[7] = "T4";
                stringArray[8] = "T5";
                stringArray[9] = "T6";
                stringArray[10] = "T7";
                stringArray[11] = "T8";
                stringArray[12] = "T9";
                stringArray[13] = "Position";
            }
        }
        if (stringArray != null) {
            this.numChildren = stringArray.length;
            int n = 0;
            while (n < this.numChildren) {
                this.add(new HdbTreeNode(stringArray[n], this.level + 1, this.theGraph));
                ++n;
            }
        } else {
            this.numChildren = 0;
        }
    }

    public String toString() {
        return this.value;
    }

    public TreePath getCompletePath() {
        HdbTreeNode hdbTreeNode = this;
        Object[] objectArray = new HdbTreeNode[hdbTreeNode.level + 1];
        int n = objectArray.length - 1;
        while (n >= 0) {
            objectArray[n] = hdbTreeNode;
            hdbTreeNode = (HdbTreeNode)hdbTreeNode.getParent();
            --n;
        }
        return new TreePath(objectArray);
    }

    public String getAttributeName() {
        String string = "";
        HdbTreeNode hdbTreeNode = this;
        HdbTreeNode[] hdbTreeNodeArray = new HdbTreeNode[hdbTreeNode.level];
        int n = hdbTreeNodeArray.length;
        while (n > 0) {
            hdbTreeNodeArray[n - 1] = hdbTreeNode;
            hdbTreeNode = (HdbTreeNode)hdbTreeNode.getParent();
            --n;
        }
        n = 0;
        while (n < hdbTreeNodeArray.length) {
            string = string + hdbTreeNodeArray[n].toString();
            if (n < hdbTreeNodeArray.length - 1) {
                string = string + "/";
            }
            ++n;
        }
        return string;
    }

    public boolean[] getAction() {
        boolean[] blArray = null;
        if (this.isLeaf()) {
            blArray = new boolean[nbAction];
            int n = 0;
            while (n < nbAction) {
                blArray[n] = false;
                ++n;
            }
        } else {
            return null;
        }
        blArray[0] = true;
        blArray[1] = this.selected != 1 && this.hasData();
        blArray[2] = this.selected != 2 && this.hasData();
        blArray[3] = this.selected != 3 && this.hasData();
        blArray[4] = this.selected != 0;
        blArray[5] = this.hasData();
        return blArray;
    }

    public boolean hasData() {
        if (this.isLeaf()) {
            return this.theView.getDataLength() > 0;
        }
        return false;
    }

    public int getDataLength() {
        if (this.isLeaf()) {
            return this.theView.getDataLength();
        }
        return 0;
    }

    public JLChart getGraph() {
        return this.theGraph;
    }

    public String retrieveData(QueryInfo queryInfo, HdbDataBase hdbDataBase) {
        DevVarDoubleStringArray devVarDoubleStringArray;
        String[] stringArray = new String[3];
        this.setSelected(0);
        this.theView.reset();
        try {
            stringArray[0] = this.getAttributeName();
            stringArray[1] = queryInfo.getStartDate();
            stringArray[2] = queryInfo.getStopDate();
            devVarDoubleStringArray = hdbDataBase.getAttributeScalarDataBetweenDates(stringArray);
        }
        catch (SQLException sQLException) {
            return "Cannot get data for " + this.getAttributeName() + "\n" + sQLException.getMessage();
        }
        int n = devVarDoubleStringArray.dvalue.length;
        System.out.println(this.getAttributeName() + " : " + n + " datas.");
        try {
            int n2 = 0;
            while (n2 < n) {
                this.theView.add((double)DateUtil.dateToTime(devVarDoubleStringArray.svalue[n2]), devVarDoubleStringArray.dvalue[n2]);
                ++n2;
            }
        }
        catch (ParseException parseException) {
            this.theView.reset();
            return "Error during date conversion\n" + parseException.getMessage();
        }
        return null;
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int n) {
        switch (n) {
            case 0: {
                switch (this.selected) {
                    case 3: {
                        this.theGraph.getXAxis().removeDataView(this.theView);
                        break;
                    }
                    case 1: {
                        this.theGraph.getY1Axis().removeDataView(this.theView);
                        break;
                    }
                    case 2: {
                        this.theGraph.getY2Axis().removeDataView(this.theView);
                    }
                }
                break;
            }
            case 3: {
                switch (this.selected) {
                    case 1: {
                        this.theGraph.getY1Axis().removeDataView(this.theView);
                        break;
                    }
                    case 2: {
                        this.theGraph.getY2Axis().removeDataView(this.theView);
                    }
                }
                this.theGraph.getXAxis().addDataView(this.theView);
                break;
            }
            case 1: {
                switch (this.selected) {
                    case 3: {
                        this.theGraph.getXAxis().removeDataView(this.theView);
                        break;
                    }
                    case 2: {
                        this.theGraph.getY2Axis().removeDataView(this.theView);
                    }
                }
                this.theGraph.getY1Axis().addDataView(this.theView);
                break;
            }
            case 2: {
                switch (this.selected) {
                    case 3: {
                        this.theGraph.getXAxis().removeDataView(this.theView);
                        break;
                    }
                    case 1: {
                        this.theGraph.getY1Axis().removeDataView(this.theView);
                    }
                }
                this.theGraph.getY2Axis().addDataView(this.theView);
            }
        }
        this.theView.setName(this.getAttributeName());
        this.theGraph.repaint();
        this.selected = n;
    }

    public void showOptions(JFrame jFrame) {
        if (this.hasData()) {
            JLDataViewOption jLDataViewOption = new JLDataViewOption(jFrame, this.theGraph, this.theView);
            jLDataViewOption.setVisible(true);
        }
    }
}

