/*
 * Decompiled with CFR 0.152.
 */
package MStatus;

import MStatus.Alarm;
import MStatus.MesgPanel;
import MStatus.RPanel;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class MainPanel
extends JFrame {
    int nb_panel;
    Alarm[] alarms;
    private RPanel Left_Panel;
    private MesgPanel Down_Panel;
    private JPanel Right_Panel;
    private JPanel Mesg_Panel;
    private Font large_font;

    public MainPanel(Splash splash) {
        splash.setMessage("Initialising parameters panel...");
        this.initComponents(splash.getProgressBar());
        splash.setMessage("Initialising alarm panel...");
        this.initAlarmDevices(splash.getProgressBar());
    }

    public void initAlarmDevices(JSmoothProgressBar jSmoothProgressBar) {
        Font font = new Font("Lucida Bright", 1, 22);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(1.0, 2.0);
        this.large_font = font.deriveFont(affineTransform);
        try {
            Database database = new Database();
            this.nb_panel = database.get_property("MSTATUS_APPLI", "NU_OF_PANELS").extractLong();
            this.alarms = new Alarm[this.nb_panel];
            this.Right_Panel.setLayout(new GridBagLayout());
            int n = 0;
            while (n < this.nb_panel) {
                String string = "LABEL" + (n + 1);
                String string2 = "DEVICES" + (n + 1);
                this.alarms[n] = new Alarm(database.get_property("MSTATUS_APPLI", string).extractString(), database.get_property("MSTATUS_APPLI", string2).extractStringArray(), this.large_font, jSmoothProgressBar, 10 + (int)(90.0 * (double)n / (double)this.nb_panel), 90.0 / (double)this.nb_panel);
                ++n;
            }
            int n2 = 0;
            n = 0;
            while (n < this.nb_panel) {
                n2 += this.alarms[n].nb / 5 + 1;
                ++n;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            n = 0;
            while (n < this.nb_panel) {
                gridBagConstraints.weighty = (double)(this.alarms[n].nb / 5 + 1) / (double)n2;
                gridBagConstraints.gridy = n + 1;
                this.Right_Panel.add((Component)this.alarms[n].panel1, gridBagConstraints);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            System.exit(0);
        }
    }

    private void initComponents(JSmoothProgressBar jSmoothProgressBar) {
        this.Left_Panel = new RPanel(this);
        this.Right_Panel = new JPanel();
        this.Mesg_Panel = new MesgPanel();
        this.getContentPane().setLayout(null);
        jSmoothProgressBar.setValue(10);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainPanel.this.exitForm();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                System.out.println("KeyReleased");
                if (keyEvent.getKeyCode() == 27) {
                    MainPanel.this.exitForm();
                }
            }
        });
        this.Right_Panel.setBorder(new EtchedBorder());
        this.getContentPane().add(this.Right_Panel);
        this.Right_Panel.setBounds(640, 0, 640, 970);
        this.Left_Panel.setBorder(new EtchedBorder());
        this.getContentPane().add(this.Left_Panel);
        this.Left_Panel.setBounds(0, 0, 640, 970);
        this.Mesg_Panel.setBorder(new EtchedBorder());
        this.getContentPane().add(this.Mesg_Panel);
        this.Mesg_Panel.setBounds(0, 970, 1280, 54);
        DeviceFactory.getInstance().setRefreshInterval(3000);
        this.setUndecorated(true);
        this.requestFocus();
    }

    private void exitForm() {
        System.exit(0);
    }

    public void printParams() {
        PageAttributes pageAttributes = new PageAttributes();
        JobAttributes jobAttributes = new JobAttributes();
        pageAttributes.setPrintQuality(5);
        pageAttributes.setPrinterResolution(200);
        pageAttributes.setColor(PageAttributes.ColorType.COLOR);
        jobAttributes.setMaxPage(1);
        jobAttributes.setMinPage(1);
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this, "Print params", jobAttributes, pageAttributes);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            graphics.translate(100, 300);
            graphics.setClip(1, 1, this.getSize().width, this.getSize().height);
            this.Left_Panel.printAll(graphics);
            graphics.dispose();
            printJob.end();
        }
    }

    public void printAlarms() {
        PageAttributes pageAttributes = new PageAttributes();
        JobAttributes jobAttributes = new JobAttributes();
        pageAttributes.setPrintQuality(5);
        pageAttributes.setPrinterResolution(200);
        pageAttributes.setColor(PageAttributes.ColorType.COLOR);
        jobAttributes.setMaxPage(1);
        jobAttributes.setMinPage(1);
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this, "Print alarms", jobAttributes, pageAttributes);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            graphics.translate(100, 300);
            graphics.setClip(1, 1, this.getSize().width, this.getSize().height);
            this.Right_Panel.printAll(graphics);
            graphics.dispose();
            printJob.end();
        }
    }

    public void printAllScreen() {
        PageAttributes pageAttributes = new PageAttributes();
        JobAttributes jobAttributes = new JobAttributes();
        pageAttributes.setPrintQuality(5);
        pageAttributes.setPrinterResolution(200);
        pageAttributes.setColor(PageAttributes.ColorType.COLOR);
        jobAttributes.setMaxPage(1);
        jobAttributes.setMinPage(1);
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this, "Print all", jobAttributes, pageAttributes);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            graphics.translate(100, 300);
            graphics.setClip(1, 1, this.getSize().width, this.getSize().height);
            this.printAll(graphics);
            graphics.dispose();
            printJob.end();
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("TANGO_HOST", "orion.esrf.fr:10000");
        Splash splash = new Splash();
        JSmoothProgressBar jSmoothProgressBar = splash.getProgressBar();
        splash.setTitle("CTRM synopsis");
        splash.setMessage("Please wait.....");
        final MainPanel mainPanel = new MainPanel(splash);
        final GregorianCalendar gregorianCalendar = new GregorianCalendar();
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm");
        new Thread(){

            public void run() {
                while (true) {
                    gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
                    Date date = gregorianCalendar.getTime();
                    mainPanel.Left_Panel.setDate(simpleDateFormat.format(date));
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(interruptedException);
                        interruptedException.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
        splash.hide();
        mainPanel.setSize(1280, 1024);
        mainPanel.setVisible(true);
    }
}

