/*
 * Decompiled with CFR 0.152.
 */
package MStatus;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AlarmDlg
extends JDialog {
    private JTextArea helpLb;
    private JLabel minLb;
    private JTextField minText;
    private JLabel maxLb;
    private JTextField maxText;
    private JButton apply;
    private JButton cancel;
    DeviceProxy ds;
    Frame parent;
    AttributeInfo att_info;
    String mode;

    public AlarmDlg(Frame frame, String string, String string2) {
        super(frame, true);
        this.parent = frame;
        this.getContentPane().setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AlarmDlg.this.ds = null;
                AlarmDlg.this.hide();
                AlarmDlg.this.dispose();
            }
        });
        try {
            this.ds = new DeviceProxy(string);
            this.att_info = this.ds.get_attribute_config(string2);
            this.mode = this.ds.read_attribute("filling_mode").extractString();
        }
        catch (DevFailed devFailed) {
            this.showTangoError(devFailed);
            return;
        }
        this.setTitle("Edit Alarm of " + this.att_info.label);
        this.minLb = new JLabel("Min ( " + this.att_info.unit + " )");
        this.getContentPane().add(this.minLb);
        this.maxLb = new JLabel("Max ( " + this.att_info.unit + " )");
        this.getContentPane().add(this.maxLb);
        this.helpLb = new JTextArea("Alarms of " + this.att_info.label + " for \nthe " + this.mode + " filling mode");
        this.helpLb.setEditable(false);
        this.helpLb.setBackground(this.maxLb.getBackground());
        this.getContentPane().add(this.helpLb);
        this.minText = new JTextField();
        this.minText.setEditable(true);
        this.minText.setText(this.att_info.min_alarm);
        this.minText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add(this.minText);
        this.maxText = new JTextField();
        this.maxText.setEditable(true);
        this.maxText.setText(this.att_info.max_alarm);
        this.maxText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add(this.maxText);
        this.apply = new JButton();
        this.apply.setText("Apply");
        this.getContentPane().add(this.apply);
        this.cancel = new JButton();
        this.cancel.setText("Cancel");
        this.getContentPane().add(this.cancel);
        this.minLb.setBounds(5, 10, 100, 30);
        this.minText.setBounds(105, 10, 130, 30);
        this.maxLb.setBounds(5, 45, 100, 30);
        this.maxText.setBounds(105, 45, 130, 30);
        this.helpLb.setBounds(5, 80, 230, 50);
        this.apply.setBounds(5, 130, 110, 30);
        this.cancel.setBounds(125, 130, 110, 30);
        this.cancel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AlarmDlg.this.ds = null;
                AlarmDlg.this.hide();
                AlarmDlg.this.dispose();
            }
        });
        this.apply.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AlarmDlg.this.applyAlarms();
                AlarmDlg.this.ds = null;
                AlarmDlg.this.hide();
                AlarmDlg.this.dispose();
            }
        });
        Rectangle rectangle = this.parent.getBounds();
        int n = rectangle.x + (rectangle.width - 250) / 2;
        int n2 = rectangle.y + (rectangle.height - 200) / 2;
        this.setBounds(n, n2, 250, 200);
    }

    public void showTangoError(DevFailed devFailed) {
        String string = "";
        if (devFailed != null) {
            int n = 0;
            while (n < devFailed.errors.length) {
                string = string + "Desc -> " + devFailed.errors[n].desc + "\n";
                string = string + "Reason -> " + devFailed.errors[n].reason + "\n";
                string = string + "Origin -> " + devFailed.errors[n].origin + "\n";
                ++n;
            }
            if (string.length() > 0) {
                JOptionPane.showMessageDialog(this.parent, string, "Tango error", 0);
            }
        }
    }

    public void applyAlarms() {
        try {
            DeviceData deviceData = new DeviceData();
            String[] stringArray = new String[]{this.att_info.name, this.minText.getText(), this.maxText.getText()};
            deviceData.insert(stringArray);
            this.ds.command_inout("SetAlarm", deviceData);
        }
        catch (DevFailed devFailed) {
            this.showTangoError(devFailed);
            return;
        }
    }
}

