/*
 * Decompiled with CFR 0.152.
 */
package MStatus;

import MStatus.devPopup;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.IconNumberScalarViewer;
import fr.esrf.tangoatk.widget.device.IDevicePopUp;
import fr.esrf.tangoatk.widget.device.SimpleStateViewer;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class Alarm {
    int nb;
    String title;
    String[] dev_names;
    JPanel panel1;
    JPanel panel2;
    JPanel[] sub_panels;
    JLabel label;
    SimpleStateViewer[] states;
    IconNumberScalarViewer[] icons;
    Device[] devices;
    AttributeList attributes;

    public Alarm() {
        this.title = "";
        this.devices = null;
        this.dev_names = null;
    }

    public Alarm(String string, String[] stringArray, Font font, JSmoothProgressBar jSmoothProgressBar, int n, double d) {
        this.nb = stringArray.length;
        this.title = string;
        this.dev_names = stringArray;
        this.states = new SimpleStateViewer[this.nb];
        this.icons = new IconNumberScalarViewer[2 * this.nb];
        this.attributes = new AttributeList();
        this.devices = new Device[this.nb];
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.label = new JLabel();
        this.sub_panels = new JPanel[this.nb];
        this.panel1.setLayout(new BorderLayout());
        this.panel1.setBorder(new EtchedBorder());
        this.label.setText(this.title);
        this.label.setForeground(Color.black);
        this.label.setHorizontalAlignment(0);
        this.label.setFont(new Font("Lucida Sans", 1, 14));
        this.panel1.add((Component)this.label, "North");
        int n2 = this.nb / 4;
        if (this.nb % 4 != 0) {
            ++n2;
        }
        this.panel2.setLayout(new GridLayout(n2, 4));
        int n3 = 0;
        while (n3 < this.nb) {
            this.states[n3] = this.CreateStateViewer(stringArray[n3], font);
            try {
                this.devices[n3] = DeviceFactory.getInstance().getDevice(stringArray[n3]);
                this.states[n3].setModel(this.devices[n3]);
                this.states[n3].getPopUp().setModel(this.devices[n3]);
            }
            catch (Exception exception) {
                System.out.println(stringArray[n3] + " : " + exception.toString());
            }
            this.icons[2 * n3 + 0] = this.CreateIcon("icon_audio.gif", stringArray[n3] + "/VoiceState");
            this.icons[2 * n3 + 1] = this.CreateIcon("icon_i.gif", stringArray[n3] + "/Inhibited");
            this.sub_panels[n3] = new JPanel();
            this.sub_panels[n3].setLayout(new GridBagLayout());
            this.AddToPanel((Component)this.states[n3], 0, 0, 2, 0.9, 1.0, this.sub_panels[n3]);
            this.AddToPanel((Component)this.icons[2 * n3 + 0], 1, 0, 1, 0.1, 1.0, this.sub_panels[n3]);
            this.AddToPanel((Component)this.icons[2 * n3 + 1], 1, 1, 1, 0.1, 1.0, this.sub_panels[n3]);
            this.panel2.add(this.sub_panels[n3]);
            if (jSmoothProgressBar != null) {
                jSmoothProgressBar.setValue(n + (int)(d * (double)(n3 + 1) / (double)this.nb));
            }
            ++n3;
        }
        this.panel1.add((Component)this.panel2, "Center");
        this.attributes.startRefresher();
    }

    private SimpleStateViewer CreateStateViewer(String string, Font font) {
        SimpleStateViewer simpleStateViewer = new SimpleStateViewer();
        simpleStateViewer.setStateFont(font);
        simpleStateViewer.setPopUp((IDevicePopUp)new devPopup());
        simpleStateViewer.setStateBorder((Border)new EtchedBorder(new Color(204, 204, 204), Color.gray));
        simpleStateViewer.setStateHorizontalAlignment(JSmoothLabel.CENTER_ALIGNMENT);
        simpleStateViewer.setValueOffsets(0, -12);
        simpleStateViewer.setSizingBehavior(JSmoothLabel.MATRIX_BEHAVIOR);
        try {
            Database database = new Database();
            String string2 = database.get_device_property(string, "label").extractString();
            simpleStateViewer.setStateText(string2.toUpperCase());
        }
        catch (Exception exception) {
            simpleStateViewer.setStateText(string.substring(string.lastIndexOf("/") + 1).toUpperCase());
        }
        return simpleStateViewer;
    }

    private IconNumberScalarViewer CreateIcon(String string, String string2) {
        IconNumberScalarViewer iconNumberScalarViewer;
        try {
            INumberScalar iNumberScalar = null;
            iNumberScalar = (INumberScalar)this.attributes.add(string2);
            Icon[] iconArray = new Icon[2];
            iconNumberScalarViewer = new IconNumberScalarViewer();
            iconArray[0] = new ImageIcon(this.getClass().getResource("/MStatus/icon_no.gif"));
            iconArray[1] = new ImageIcon(this.getClass().getResource("/MStatus/" + string));
            iconNumberScalarViewer.setIcons(iconArray);
            iconNumberScalarViewer.setModel(iNumberScalar);
        }
        catch (Exception exception) {
            System.out.println("Attribute:" + string2 + " :" + exception.toString());
            iconNumberScalarViewer = null;
        }
        return iconNumberScalarViewer;
    }

    private void AddToPanel(Component component, int n, int n2, int n3, double d, double d2, JPanel jPanel) {
        if (component != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridheight = n3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = d;
            gridBagConstraints.weighty = d2;
            jPanel.add(component, gridBagConstraints);
        }
    }
}

