/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDSpline
extends JDPolyline
implements JDPolyConvert {
    public JDSpline(String string, Point[] pointArray) {
        this.initDefault();
        this.summit = new Point2D.Double[pointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            this.summit[n] = new Point2D.Double(pointArray[n].x, pointArray[n].y);
            ++n;
        }
        this.step = 10;
        this.name = string;
        this.updateShape();
        Point2D.Double double_ = new Point2D.Double(this.boundRect.x + this.boundRect.width / 2, this.boundRect.y + this.boundRect.height / 2);
        this.setOrigin(double_);
    }

    JDSpline(JDSpline jDSpline, int n, int n2) {
        this.cloneObject(jDSpline, n, n2);
        this.isClosed = jDSpline.isClosed;
        this.step = jDSpline.step;
        this.updateShape();
    }

    JDSpline(JLXObject jLXObject, JLXPath jLXPath) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        int n = (jLXPath.path.size() - 1) * 3 + 1;
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[n];
        this.createSummit();
        int n2 = 0;
        int n3 = 0;
        while (n2 < jLXPath.path.size()) {
            double[] dArray = (double[])jLXPath.path.get(n2);
            if (n2 == 0) {
                this.summit[n3].x = this.origin.x + dArray[0];
                this.summit[n3].y = this.origin.y + dArray[1];
                ++n3;
            } else {
                if (jLXPath.pathType == 2) {
                    this.summit[n3].x = this.origin.x + dArray[0];
                    this.summit[n3].y = this.origin.y + dArray[1];
                    this.summit[n3 + 1].x = this.origin.x + dArray[0];
                    this.summit[n3 + 1].y = this.origin.y + dArray[1];
                    this.summit[n3 + 2].x = this.origin.x + dArray[2];
                    this.summit[n3 + 2].y = this.origin.y + dArray[3];
                } else {
                    this.summit[n3].x = this.origin.x + dArray[0];
                    this.summit[n3].y = this.origin.y + dArray[1];
                    this.summit[n3 + 1].x = this.origin.x + dArray[2];
                    this.summit[n3 + 1].y = this.origin.y + dArray[3];
                    this.summit[n3 + 2].x = this.origin.x + dArray[4];
                    this.summit[n3 + 2].y = this.origin.y + dArray[5];
                }
                n3 += 3;
            }
            ++n2;
        }
        this.isClosed = jLXPath.closed;
        this.step = 10;
        this.updateShape();
    }

    public JDObject copy(int n, int n2) {
        return new JDSpline(this, n, n2);
    }

    void computeBoundRect() {
        double d = -65536.0;
        double d2 = -65536.0;
        double d3 = 65536.0;
        double d4 = 65536.0;
        int n = 0;
        while (n < this.summit.length) {
            if (this.summit[n].x < d3) {
                d3 = this.summit[n].x;
            }
            if (this.summit[n].x > d) {
                d = this.summit[n].x;
            }
            if (this.summit[n].y < d4) {
                d4 = this.summit[n].y;
            }
            if (this.summit[n].y > d2) {
                d2 = this.summit[n].y;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.ptsx.length) {
            if ((double)this.ptsx[n2] < d3) {
                d3 = this.ptsx[n2];
            }
            if ((double)this.ptsx[n2] > d) {
                d = this.ptsx[n2];
            }
            if ((double)this.ptsy[n2] < d4) {
                d4 = this.ptsy[n2];
            }
            if ((double)this.ptsy[n2] > d2) {
                d2 = this.ptsy[n2];
            }
            ++n2;
        }
        this.boundRect = new Rectangle((int)d3, (int)d4, (int)(d - d3) + 1, (int)(d2 - d4) + 1);
    }

    public void setStep(int n) {
        this.step = n;
        this.updateShape();
    }

    public JDPolyline convertToPolyline() {
        JDPolyline jDPolyline = this.buildDefaultPolyline();
        jDPolyline.setClosed(this.isClosed());
        jDPolyline.updateShape();
        return jDPolyline;
    }

    public void moveSummit(int n, double d, double d2) {
        if (n % 3 == 0) {
            double d3 = d - this.summit[n].x;
            double d4 = d2 - this.summit[n].y;
            if (n > 0) {
                this.summit[n - 1].x += d3;
                this.summit[n - 1].y += d4;
            }
            this.summit[n].x += d3;
            this.summit[n].y += d4;
            if (n < this.summit.length - 1) {
                this.summit[n + 1].x += d3;
                this.summit[n + 1].y += d4;
            }
        } else {
            this.summit[n].x = d;
            this.summit[n].y = d2;
        }
        this.updateShape();
    }

    void deleteSummit() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] doubleArray = null;
        doubleArray = new Point2D.Double[this.summit.length - 3];
        if (this.breakId == 0) {
            int n = 3;
            while (n < this.summit.length) {
                doubleArray[n - 3] = this.summit[n];
                ++n;
            }
        } else if (this.breakId == this.summit.length - 1) {
            int n = 0;
            while (n < this.summit.length - 3) {
                doubleArray[n] = this.summit[n];
                ++n;
            }
        } else {
            int n = 0;
            int n2 = 0;
            while (n < this.summit.length) {
                if (n < this.breakId - 1 || n > this.breakId + 1) {
                    doubleArray[n2++] = this.summit[n];
                }
                ++n;
            }
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    boolean canDeleteSummit(int n) {
        if (!this.visible) {
            return false;
        }
        this.breakId = -1;
        if (n < 0 || n >= this.summit.length || this.summit.length <= 4) {
            return false;
        }
        if (n % 3 != 0) {
            return false;
        }
        this.breakId = n;
        return true;
    }

    void paintSummit(Graphics graphics, double d) {
        super.paintSummit(graphics, d);
        graphics.setColor(Color.green);
        int n = 0;
        while (n < this.summit.length - 1) {
            graphics.drawLine((int)this.summit[n].x, (int)this.summit[n].y, (int)this.summit[n + 1].x, (int)this.summit[n + 1].y);
            graphics.drawLine((int)this.summit[n + 2].x, (int)this.summit[n + 2].y, (int)this.summit[n + 3].x, (int)this.summit[n + 3].y);
            n += 3;
        }
    }

    void breakShape() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length + 3];
        int n = this.breakId / this.step * 3 + 2;
        if (n < this.summit.length) {
            double d = this.ptsx[this.breakId + 1] - this.ptsx[this.breakId];
            double d2 = this.ptsy[this.breakId + 1] - this.ptsy[this.breakId];
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (d3 < 1.0) {
                d = 30.0;
                d2 = 30.0;
            } else {
                d = 30.0 * d / d3;
                d2 = 30.0 * d2 / d3;
            }
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.summit.length) {
                if (n2 == n) {
                    doubleArray[n3++] = new Point2D.Double(this.breakX - (int)d, this.breakY - (int)d2);
                    doubleArray[n3++] = new Point2D.Double(this.breakX, this.breakY);
                    doubleArray[n3++] = new Point2D.Double(this.breakX + (int)d, this.breakY + (int)d2);
                }
                doubleArray[n3++] = this.summit[n2];
                ++n2;
            }
        } else {
            double d = this.ptsx[0] - this.ptsx[this.ptsx.length - 1];
            double d4 = this.ptsy[0] - this.ptsy[this.ptsx.length - 1];
            double d5 = Math.sqrt(d * d + d4 * d4);
            if (d5 < 1.0) {
                d = 30.0;
                d4 = 30.0;
            } else {
                d = 30.0 * d / d5;
                d4 = 30.0 * d4 / d5;
            }
            int n4 = 0;
            while (n4 < this.summit.length) {
                doubleArray[n4] = this.summit[n4];
                ++n4;
            }
            doubleArray[n4++] = new Point2D.Double(this.breakX - (int)d, this.breakY - (int)d4);
            doubleArray[n4++] = new Point2D.Double(this.breakX, this.breakY);
            doubleArray[n4++] = new Point2D.Double(this.breakX + (int)d, this.breakY + (int)d4);
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    /*
     * Unable to fully structure code
     */
    JDSpline(JDFileLoader var1_1) throws IOException {
        super();
        this.initDefault();
        var2_2 = var1_1.getCurrentLine();
        var1_1.startBlock();
        this.summit = var1_1.parseSummitArray();
        if (this.summit.length >= 2) ** GOTO lbl16
        throw new IOException("Invalid summit number for JDSpline at line " + var2_2);
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1.parseProperyName();
            if (var3_3.equals("isClosed")) {
                this.isClosed = var1_1.parseBoolean();
                continue;
            }
            if (var3_3.equals("step")) {
                this.step = (int)var1_1.parseDouble();
                continue;
            }
            this.loadDefaultPropery(var1_1, var3_3);
lbl16:
            // 4 sources

            ** while (!var1_1.isEndBlock())
        }
lbl17:
        // 1 sources

        var1_1.endBlock();
        this.updateShape();
    }

    public void connect(JDPolyline jDPolyline) {
        if (jDPolyline instanceof JDSpline) {
            Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length + jDPolyline.getSummitNumber() + 2];
            int n = 0;
            while (n < this.summit.length) {
                doubleArray[n] = this.summit[n];
                ++n;
            }
            double d = this.summit[n - 1].x;
            double d2 = this.summit[n - 1].y;
            double d3 = jDPolyline.getSummit((int)0).x - this.summit[n - 1].x;
            double d4 = jDPolyline.getSummit((int)0).y - this.summit[n - 1].y;
            doubleArray[n] = new Point2D.Double(d + d3 * 0.33, d2 + d4 * 0.33);
            doubleArray[n + 1] = new Point2D.Double(d + d3 * 0.66, d2 + d4 * 0.66);
            n = 0;
            while (n < jDPolyline.getSummitNumber()) {
                doubleArray[n + 2 + this.summit.length] = new Point2D.Double(jDPolyline.getSummit((int)n).x, jDPolyline.getSummit((int)n).y);
                ++n;
            }
            this.summit = doubleArray;
            this.updateShape();
        } else {
            System.out.println("JDSpline.connect() : Cannot connect a JDSpline to JDPolyline.");
        }
    }

    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(8);
        this.fillUndoPattern(undoPattern);
        undoPattern.step = this.step;
        undoPattern.isClosed = this.isClosed;
        return undoPattern;
    }

    JDSpline(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.step = undoPattern.step;
        this.isClosed = undoPattern.isClosed;
        this.updateShape();
    }

    void updateShape() {
        int n = 0;
        this.ptsx = new int[this.summit.length / 3 * this.step + 1];
        this.ptsy = new int[this.summit.length / 3 * this.step + 1];
        int n2 = 0;
        while (n2 < this.summit.length - 1) {
            JDUtils.computeSpline(this.summit[n2 + 0].x, this.summit[n2 + 0].y, this.summit[n2 + 1].x, this.summit[n2 + 1].y, this.summit[n2 + 2].x, this.summit[n2 + 2].y, this.summit[n2 + 3].x, this.summit[n2 + 3].y, this.step, n2 == this.summit.length - 4, n, null, this.ptsx, this.ptsy);
            n += this.step;
            n2 += 3;
        }
        if (this.hasShadow()) {
            this.computeShadow(this.isClosed());
            this.computeShadowColors();
        }
        this.computeBoundRect();
    }
}

