/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;

public abstract class JDRectangular
extends JDObject {
    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        Object object;
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.prepareRendering(graphics2D);
        if (this.fillStyle != 0) {
            object = GraphicsUtils.createPatternForFilling(this);
            if (object != null) {
                graphics2D.setPaint((Paint)object);
            }
            graphics.fillPolygon(this.ptsx, this.ptsy, this.ptsx.length);
        }
        if (this.lineWidth > 0) {
            graphics.setColor(this.foreground);
            object = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            if (object != null) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke((Stroke)object);
                graphics.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
                graphics2D.setStroke(stroke);
            } else {
                graphics.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
            }
        }
        this.paintShadows(graphics);
    }

    int getSummitMotion(int n) {
        switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return 3;
            }
            case 1: 
            case 5: {
                return 2;
            }
        }
        return 1;
    }

    public void moveSummit(int n, double d, double d2) {
        switch (n) {
            case 0: {
                if (Math.abs(this.summit[2].x - d) > 0.5) {
                    this.summit[0].x = d;
                    this.summit[6].x = d;
                }
                if (!(Math.abs(this.summit[4].y - d2) > 0.5)) break;
                this.summit[0].y = d2;
                this.summit[2].y = d2;
                break;
            }
            case 1: {
                if (!(Math.abs(this.summit[4].y - d2) > 0.5)) break;
                this.summit[0].y = d2;
                this.summit[2].y = d2;
                break;
            }
            case 2: {
                if (Math.abs(this.summit[0].x - d) > 0.5) {
                    this.summit[2].x = d;
                    this.summit[4].x = d;
                }
                if (!(Math.abs(this.summit[4].y - d2) > 0.5)) break;
                this.summit[0].y = d2;
                this.summit[2].y = d2;
                break;
            }
            case 3: {
                if (!(Math.abs(this.summit[0].x - d) > 0.5)) break;
                this.summit[2].x = d;
                this.summit[4].x = d;
                break;
            }
            case 4: {
                if (Math.abs(this.summit[0].x - d) > 0.5) {
                    this.summit[2].x = d;
                    this.summit[4].x = d;
                }
                if (!(Math.abs(this.summit[0].y - d2) > 0.5)) break;
                this.summit[4].y = d2;
                this.summit[6].y = d2;
                break;
            }
            case 5: {
                if (!(Math.abs(this.summit[0].y - d2) > 0.5)) break;
                this.summit[4].y = d2;
                this.summit[6].y = d2;
                break;
            }
            case 6: {
                if (Math.abs(this.summit[2].x - d) > 0.5) {
                    this.summit[0].x = d;
                    this.summit[6].x = d;
                }
                if (!(Math.abs(this.summit[0].y - d2) > 0.5)) break;
                this.summit[4].y = d2;
                this.summit[6].y = d2;
                break;
            }
            case 7: {
                if (!(Math.abs(this.summit[2].x - d) > 0.5)) break;
                this.summit[0].x = d;
                this.summit[6].x = d;
            }
        }
        this.centerSummit();
        this.updateShape();
    }

    void centerSummit() {
        this.summit[1].x = (this.summit[0].x + this.summit[2].x) / 2.0;
        this.summit[1].y = (this.summit[0].y + this.summit[2].y) / 2.0;
        this.summit[3].x = (this.summit[2].x + this.summit[4].x) / 2.0;
        this.summit[3].y = (this.summit[2].y + this.summit[4].y) / 2.0;
        this.summit[5].x = (this.summit[6].x + this.summit[4].x) / 2.0;
        this.summit[5].y = (this.summit[6].y + this.summit[4].y) / 2.0;
        this.summit[7].x = (this.summit[0].x + this.summit[6].x) / 2.0;
        this.summit[7].y = (this.summit[0].y + this.summit[6].y) / 2.0;
    }

    void saveSummit(FileWriter fileWriter, String string) throws IOException {
        String string2 = string + "summit:";
        string2 = string2 + this.roundDouble(this.summit[0].x) + "," + this.roundDouble(this.summit[0].y) + ",";
        string2 = string2 + this.roundDouble(this.summit[4].x) + "," + this.roundDouble(this.summit[4].y) + "\n";
        fileWriter.write(string2, 0, string2.length());
    }

    public void rotate90(double d, double d2) {
        Point2D.Double double_ = this.summit[0];
        Point2D.Double double_2 = this.summit[1];
        int n = 2;
        while (n < 8) {
            this.summit[n - 2] = this.summit[n];
            ++n;
        }
        this.summit[6] = double_;
        this.summit[7] = double_2;
        super.rotate90(d, d2);
    }
}

