/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;

public class JDRectangle
extends JDRectangular
implements JDPolyConvert {
    public JDRectangle(String string, int n, int n2, int n3, int n4) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(n, n2));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.createSummit();
        this.computeSummitCoordinates(n, n2, n3, n4);
        this.updateShape();
    }

    JDRectangle(JDRectangle jDRectangle, int n, int n2) {
        this.cloneObject(jDRectangle, n, n2);
        this.updateShape();
    }

    JDRectangle(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    JDRectangle(JLXObject jLXObject) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = d;
        this.summit[0].y = d2;
        this.summit[1].x = d + d3 / 2.0;
        this.summit[1].y = d2;
        this.summit[2].x = d + d3;
        this.summit[2].y = d2;
        this.summit[3].x = d + d3;
        this.summit[3].y = d2 + d4 / 2.0;
        this.summit[4].x = d + d3;
        this.summit[4].y = d2 + d4;
        this.summit[5].x = d + d3 / 2.0;
        this.summit[5].y = d2 + d4;
        this.summit[6].x = d;
        this.summit[6].y = d2 + d4;
        this.summit[7].x = d;
        this.summit[7].y = d2 + d4 / 2.0;
        this.updateShape();
    }

    public JDObject copy(int n, int n2) {
        return new JDRectangle(this, n, n2);
    }

    public boolean isInsideObject(int n, int n2) {
        if (!super.isInsideObject(n, n2)) {
            return false;
        }
        if (this.fillStyle != 0) {
            return this.boundRect.contains(n, n2);
        }
        int n3 = this.boundRect.x;
        int n4 = this.boundRect.x + this.boundRect.width;
        int n5 = this.boundRect.y;
        int n6 = this.boundRect.y + this.boundRect.height;
        return this.isPointOnLine(n, n2, n3, n5, n4, n5) || this.isPointOnLine(n, n2, n4, n5, n4, n6) || this.isPointOnLine(n, n2, n4, n6, n3, n6) || this.isPointOnLine(n, n2, n3, n6, n3, n5);
    }

    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        this.ptsx[0] = (int)(this.summit[0].x + 0.5);
        this.ptsy[0] = (int)(this.summit[0].y + 0.5);
        this.ptsx[1] = (int)(this.summit[2].x + 0.5);
        this.ptsy[1] = (int)(this.summit[2].y + 0.5);
        this.ptsx[2] = (int)(this.summit[4].x + 0.5);
        this.ptsy[2] = (int)(this.summit[4].y + 0.5);
        this.ptsx[3] = (int)(this.summit[6].x + 0.5);
        this.ptsy[3] = (int)(this.summit[6].y + 0.5);
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }

    public JDPolyline convertToPolyline() {
        JDPolyline jDPolyline = this.buildDefaultPolyline();
        jDPolyline.setClosed(true);
        jDPolyline.updateShape();
        return jDPolyline;
    }

    void saveObject(FileWriter fileWriter, int n) throws IOException {
        this.saveObjectHeader(fileWriter, n);
        this.closeObjectHeader(fileWriter, n);
    }

    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(6);
        this.fillUndoPattern(undoPattern);
        return undoPattern;
    }

    JDRectangle(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.updateShape();
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3;
        this.summit[4].y = n2 + n4;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4;
        this.centerSummit();
    }
}

