/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileFilter;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class JDImagePanel
extends JPanel
implements ActionListener {
    private JTextField filenameLabel;
    private JButton filenameBtn;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JButton resetBtn;
    private JDImage[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDImagePanel(JDImage[] jDImageArray, JDrawEditor jDrawEditor) {
        this.invoker = jDrawEditor;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Filename"));
        jPanel.setBounds(5, 5, 370, 60);
        this.filenameLabel = new JTextField();
        this.filenameLabel.setFont(JDUtils.labelFont);
        this.filenameLabel.setEditable(false);
        this.filenameLabel.setBorder(null);
        this.filenameLabel.setForeground(JDUtils.labelColor);
        this.filenameLabel.setBounds(10, 20, 310, 25);
        jPanel.add(this.filenameLabel);
        this.filenameBtn = new JButton();
        this.filenameBtn.setText("...");
        this.filenameBtn.setMargin(new Insets(0, 0, 0, 0));
        this.filenameBtn.setFont(JDUtils.labelFont);
        this.filenameBtn.setBounds(325, 20, 30, 24);
        this.filenameBtn.addActionListener(this);
        jPanel.add(this.filenameBtn);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setBorder(JDUtils.createTitleBorder("Dimension"));
        jPanel2.setBounds(5, 75, 370, 115);
        this.widthLabel = new JLabel();
        this.widthLabel.setBounds(10, 20, 240, 25);
        this.widthLabel.setFont(JDUtils.labelFont);
        jPanel2.add(this.widthLabel);
        this.heightLabel = new JLabel();
        this.heightLabel.setBounds(10, 50, 240, 25);
        this.heightLabel.setFont(JDUtils.labelFont);
        jPanel2.add(this.heightLabel);
        this.resetBtn = new JButton();
        this.resetBtn.setText("Reset to original size");
        this.resetBtn.setMargin(new Insets(0, 0, 0, 0));
        this.resetBtn.setFont(JDUtils.labelFont);
        this.resetBtn.setBounds(10, 80, 180, 24);
        this.resetBtn.addActionListener(this);
        jPanel2.add(this.resetBtn);
        this.add(jPanel2);
        this.updatePanel(jDImageArray);
    }

    public void updatePanel(JDImage[] jDImageArray) {
        this.allObjects = jDImageArray;
        this.isUpdating = true;
        if (jDImageArray == null || jDImageArray.length <= 0) {
            this.filenameLabel.setText("");
            this.widthLabel.setText("Width: ");
            this.heightLabel.setText("Height: ");
        } else {
            JDImage jDImage = jDImageArray[0];
            this.filenameLabel.setText(jDImage.getFileName());
            this.filenameLabel.setCaretPosition(jDImage.getFileName().length());
            this.widthLabel.setText("Width: " + jDImage.getImageWidth());
            this.heightLabel.setText("Height: " + jDImage.getImageHeight());
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            this.oldRect = this.oldRect.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            rectangle = rectangle.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
        this.invoker.repaint(rectangle.union(this.oldRect));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = actionEvent.getSource();
        if (object == this.filenameBtn) {
            JFileChooser jFileChooser = new JFileChooser(".");
            String[] stringArray = new String[]{"gif", "png", "jpg"};
            jFileChooser.addChoosableFileFilter(new JDFileFilter("Image file", stringArray));
            if (jFileChooser.showOpenDialog(this) == 0) {
                int n = 0;
                while (n < this.allObjects.length) {
                    this.allObjects[n].setFileName(jFileChooser.getSelectedFile().getAbsolutePath());
                    ++n;
                }
                this.invoker.setNeedToSave(true, "New image");
            }
        } else if (object == this.resetBtn) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].resetToOriginalSize();
                ++n;
            }
            this.invoker.setNeedToSave(true, "Reset size");
        }
        this.repaintObjects();
    }
}

