/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;

public class JDEllipse
extends JDRectangular
implements JDPolyConvert {
    public static final int ARC_OPEN = 0;
    public static final int ARC_CLOSED = 1;
    public static final int ARC_PIE = 2;
    static final int stepDefault = 36;
    static final int angleStartDefault = 0;
    static final int angleExtentDefault = 360;
    static final int arcTypeDefault = 0;
    int step;
    int arcType;
    int angleStart;
    int angleExtent;
    int sAngleStart;
    private boolean useOval = false;
    private double x1;
    private double y1;
    private double width;
    private double height;

    public JDEllipse(String string, int n, int n2, int n3, int n4) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(n, n2));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.createSummit();
        this.computeSummitCoordinates(n, n2, n3, n4);
        this.updateShape();
    }

    JDEllipse(JDEllipse jDEllipse, int n, int n2) {
        this.cloneObject(jDEllipse, n, n2);
        this.step = jDEllipse.step;
        this.arcType = jDEllipse.arcType;
        this.angleStart = jDEllipse.angleStart;
        this.angleExtent = jDEllipse.angleExtent;
        this.updateShape();
    }

    JDEllipse(JLXObject jLXObject, int n, int n2, int n3) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = d;
        this.summit[0].y = d2;
        this.summit[1].x = d + d3 / 2.0;
        this.summit[1].y = d2;
        this.summit[2].x = d + d3;
        this.summit[2].y = d2;
        this.summit[3].x = d + d3;
        this.summit[3].y = d2 + d4 / 2.0;
        this.summit[4].x = d + d3;
        this.summit[4].y = d2 + d4;
        this.summit[5].x = d + d3 / 2.0;
        this.summit[5].y = d2 + d4;
        this.summit[6].x = d;
        this.summit[6].y = d2 + d4;
        this.summit[7].x = d;
        this.summit[7].y = d2 + d4 / 2.0;
        this.step = 36;
        this.angleStart = n;
        this.angleExtent = n2;
        this.arcType = n3 == 1 ? 1 : 2;
        this.updateShape();
    }

    void initDefault() {
        super.initDefault();
        this.step = 36;
        this.arcType = 0;
        this.angleStart = 0;
        this.angleExtent = 360;
    }

    public JDObject copy(int n, int n2) {
        return new JDEllipse(this, n, n2);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isInsideObject(int var1_1, int var2_2) {
        block3: {
            if (!super.isInsideObject(var1_1, var2_2)) {
                return false;
            }
            var3_3 = false;
            var4_4 = 0;
            if (this.fillStyle == 0) ** GOTO lbl12
            var5_5 = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
            var3_3 = var5_5.contains(var1_1, var2_2);
            break block3;
lbl-1000:
            // 1 sources

            {
                var3_3 = this.isPointOnLine(var1_1, var2_2, this.ptsx[var4_4], this.ptsy[var4_4], this.ptsx[var4_4 + 1], this.ptsy[var4_4 + 1]);
                if (var3_3) continue;
                ++var4_4;
lbl12:
                // 3 sources

                ** while (var4_4 < this.ptsx.length - 1 && !var3_3)
            }
lbl13:
            // 1 sources

            if (!var3_3) {
                var3_3 = this.isPointOnLine(var1_1, var2_2, this.ptsx[var4_4], this.ptsy[var4_4], this.ptsx[0], this.ptsy[0]);
            }
        }
        return var3_3;
    }

    void updateShape() {
        this.computeBoundRect();
        this.makePolygon();
        if (this.hasShadow()) {
            this.computeShadow(this.isClosed());
            this.computeShadowColors();
        }
    }

    public JDPolyline convertToPolyline() {
        JDPolyline jDPolyline = this.buildDefaultPolyline();
        jDPolyline.setClosed(this.isClosed());
        jDPolyline.updateShape();
        return jDPolyline;
    }

    boolean isClosed() {
        return this.angleExtent == 360 || this.arcType != 0;
    }

    public void rotate90(double d, double d2) {
        this.angleStart += 90;
        this.angleStart %= 360;
        super.rotate90(d, d2);
    }

    public void restoreTransform() {
        this.angleStart = this.sAngleStart;
        super.restoreTransform();
    }

    public void saveTransform() {
        this.sAngleStart = this.angleStart;
        super.saveTransform();
    }

    void computeBoundRect() {
        double d = -65536.0;
        double d2 = -65536.0;
        double d3 = 65536.0;
        double d4 = 65536.0;
        int n = 0;
        while (n < this.summit.length) {
            if (this.summit[n].x < d3) {
                d3 = this.summit[n].x;
            }
            if (this.summit[n].x > d) {
                d = this.summit[n].x;
            }
            if (this.summit[n].y < d4) {
                d4 = this.summit[n].y;
            }
            if (this.summit[n].y > d2) {
                d2 = this.summit[n].y;
            }
            ++n;
        }
        this.x1 = d3;
        this.y1 = d4;
        this.width = d - d3;
        this.height = d2 - d4;
        this.boundRect = new Rectangle((int)d3, (int)d4, (int)(d - d3) + 1, (int)(d2 - d4) + 1);
    }

    JDEllipse(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("step")) {
                this.step = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("angle_start")) {
                this.angleStart = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("angle_extent")) {
                this.angleExtent = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("arc_type")) {
                this.arcType = (int)jDFileLoader.parseDouble();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    void saveObject(FileWriter fileWriter, int n) throws IOException {
        String string;
        String string2 = this.saveObjectHeader(fileWriter, n);
        if (this.step != 36) {
            string = string2 + "step:" + this.step + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.angleStart != 0) {
            string = string2 + "angle_start:" + this.angleStart + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.angleExtent != 360) {
            string = string2 + "angle_extent:" + this.angleExtent + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.arcType != 0) {
            string = string2 + "arc_type:" + this.arcType + "\n";
            fileWriter.write(string, 0, string.length());
        }
        this.closeObjectHeader(fileWriter, n);
    }

    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(1);
        this.fillUndoPattern(undoPattern);
        undoPattern.step = this.step;
        undoPattern.arcType = this.arcType;
        undoPattern.angleStart = this.angleStart;
        undoPattern.angleExtent = this.angleExtent;
        return undoPattern;
    }

    JDEllipse(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.step = undoPattern.step;
        this.arcType = undoPattern.arcType;
        this.angleStart = undoPattern.angleStart;
        this.angleExtent = undoPattern.angleExtent;
        this.updateShape();
    }

    public void setStep(int n) {
        this.step = n;
        this.updateShape();
    }

    public int getStep() {
        return this.step;
    }

    public void setArcType(int n) {
        this.arcType = n;
        this.updateShape();
    }

    public int getArcType() {
        return this.arcType;
    }

    public void setAngleStart(int n) {
        this.angleStart = n;
        this.updateShape();
    }

    public int getAngleStart() {
        return this.angleStart;
    }

    public void setAngleExtent(int n) {
        this.angleExtent = n;
        this.updateShape();
    }

    public int getAngleExtent() {
        return this.angleExtent;
    }

    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        Object object;
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.prepareRendering(graphics2D);
        if (this.fillStyle != 0 && this.isClosed() && (object = GraphicsUtils.createPatternForFilling(this)) != null) {
            graphics2D.setPaint((Paint)object);
            if (this.useOval) {
                graphics.fillOval((int)(this.x1 + 0.5), (int)(this.y1 + 0.5), (int)(this.width + 1.0), (int)(this.height + 1.0));
            } else {
                graphics.fillPolygon(this.ptsx, this.ptsy, this.ptsx.length);
            }
        }
        if (this.lineWidth > 0) {
            graphics.setColor(this.foreground);
            object = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            Stroke stroke = null;
            if (object != null) {
                stroke = graphics2D.getStroke();
                graphics2D.setStroke((Stroke)object);
            }
            if (this.isClosed()) {
                if (this.useOval) {
                    graphics.drawOval((int)(this.x1 + 0.5), (int)(this.y1 + 0.5), (int)this.width, (int)this.height);
                } else {
                    graphics.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
                }
            } else {
                graphics.drawPolyline(this.ptsx, this.ptsy, this.ptsx.length);
            }
            if (object != null) {
                graphics2D.setStroke(stroke);
            }
        }
        this.paintShadows(graphics);
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3;
        this.summit[4].y = n2 + n4;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4;
        this.centerSummit();
    }

    private void makePolygon() {
        double d = this.width / 2.0;
        double d2 = this.height / 2.0;
        double d3 = this.x1 + d;
        double d4 = this.y1 + d2;
        d -= 0.5;
        d2 -= 0.5;
        int n = this.arcType == 2 && this.angleExtent != 360 ? this.step + 1 : this.step;
        this.ptsx = new int[n];
        this.ptsy = new int[n];
        double d5 = (double)this.angleExtent / 180.0 * Math.PI / (double)this.step;
        double d6 = (double)this.angleStart / 180.0 * Math.PI;
        int n2 = 0;
        while (n2 < this.step) {
            double d7 = d * Math.cos(d6 + d5 * (double)n2);
            double d8 = d2 * Math.sin(d6 + d5 * (double)n2);
            this.ptsx[n2] = (int)(d3 + d7);
            this.ptsy[n2] = (int)(d4 + d8);
            ++n2;
        }
        if (this.arcType == 2 && this.angleExtent != 360) {
            this.ptsx[n2] = (int)d3;
            this.ptsy[n2] = (int)d4;
        }
        this.useOval = this.angleExtent == 360 && this.step == 36;
    }
}

