/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKFontChooser;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDAxisPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private JLabel orientationLabel;
    private JComboBox orientationCombo;
    private JLabel labelLabel;
    private JComboBox labelCombo;
    private JLabel scaleLabel;
    private JComboBox scaleCombo;
    private JLabel formatLabel;
    private JComboBox formatCombo;
    private JLabel fontLabel;
    private JButton fontBtn;
    private JLabel tickSpacingLabel;
    private JSpinner tickSpacingSpinner;
    private JLabel tickWidthLabel;
    private JSpinner tickWidthSpinner;
    private JCheckBox tickCenterCheckBox;
    private JLabel minLabel;
    private JTextField minText;
    private JLabel maxLabel;
    private JTextField maxText;
    private JCheckBox invertCheckBox;
    private JButton applyValueBtn;
    private JDAxis[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDAxisPanel(JDAxis[] jDAxisArray, JDrawEditor jDrawEditor) {
        this.invoker = jDrawEditor;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Axis style"));
        jPanel.setBounds(5, 5, 370, 171);
        this.orientationLabel = JDUtils.createLabel("Orientation");
        this.orientationLabel.setBounds(10, 20, 200, 20);
        jPanel.add(this.orientationLabel);
        this.orientationCombo = new JComboBox();
        this.orientationCombo.setFont(JDUtils.labelFont);
        this.orientationCombo.addItem("Horizontal");
        this.orientationCombo.addItem("Vertical");
        this.orientationCombo.addActionListener(this);
        this.orientationCombo.setBounds(220, 20, 140, 25);
        jPanel.add(this.orientationCombo);
        this.labelLabel = JDUtils.createLabel("Label position (Vertical only)");
        this.labelLabel.setBounds(10, 50, 200, 20);
        jPanel.add(this.labelLabel);
        this.labelCombo = new JComboBox();
        this.labelCombo.setFont(JDUtils.labelFont);
        this.labelCombo.addItem("Left");
        this.labelCombo.addItem("Right");
        this.labelCombo.addActionListener(this);
        this.labelCombo.setBounds(220, 50, 140, 25);
        jPanel.add(this.labelCombo);
        this.scaleLabel = JDUtils.createLabel("Scale");
        this.scaleLabel.setBounds(10, 80, 200, 20);
        jPanel.add(this.scaleLabel);
        this.scaleCombo = new JComboBox();
        this.scaleCombo.setFont(JDUtils.labelFont);
        this.scaleCombo.addItem("Linear");
        this.scaleCombo.addItem("Logarithmic");
        this.scaleCombo.addActionListener(this);
        this.scaleCombo.setBounds(220, 80, 140, 25);
        jPanel.add(this.scaleCombo);
        this.formatLabel = JDUtils.createLabel("Number format");
        this.formatLabel.setBounds(10, 110, 200, 20);
        jPanel.add(this.formatLabel);
        this.formatCombo = new JComboBox();
        this.formatCombo.setFont(JDUtils.labelFont);
        this.formatCombo.addItem("Auto");
        this.formatCombo.addItem("Scientific");
        this.formatCombo.addItem("Time");
        this.formatCombo.addItem("Decimal");
        this.formatCombo.addItem("Hexadecimal");
        this.formatCombo.addItem("Binary");
        this.formatCombo.addItem("Scientific (Int)");
        this.formatCombo.addActionListener(this);
        this.formatCombo.setBounds(220, 110, 140, 25);
        jPanel.add(this.formatCombo);
        this.fontLabel = new JLabel("Font");
        this.fontLabel.setFont(JDUtils.labelFont);
        this.fontLabel.setForeground(JDUtils.labelColor);
        this.fontLabel.setBounds(10, 140, 200, 24);
        jPanel.add(this.fontLabel);
        this.fontBtn = new JButton();
        this.fontBtn.setText("Choose");
        this.fontBtn.setMargin(new Insets(0, 0, 0, 0));
        this.fontBtn.setFont(JDUtils.labelFont);
        this.fontBtn.setBounds(220, 140, 140, 24);
        this.fontBtn.addActionListener(this);
        jPanel.add(this.fontBtn);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setBorder(JDUtils.createTitleBorder("Axis tick"));
        jPanel2.setBounds(5, 232, 370, 54);
        this.tickCenterCheckBox = new JCheckBox("Center");
        this.tickCenterCheckBox.setFont(JDUtils.labelFont);
        this.tickCenterCheckBox.setForeground(JDUtils.labelColor);
        this.tickCenterCheckBox.setBounds(10, 20, 100, 25);
        this.tickCenterCheckBox.addActionListener(this);
        jPanel2.add(this.tickCenterCheckBox);
        this.tickSpacingLabel = new JLabel("Spacing");
        this.tickSpacingLabel.setHorizontalAlignment(4);
        this.tickSpacingLabel.setFont(JDUtils.labelFont);
        this.tickSpacingLabel.setForeground(JDUtils.labelColor);
        this.tickSpacingLabel.setBounds(110, 20, 60, 25);
        jPanel2.add(this.tickSpacingLabel);
        this.tickSpacingSpinner = new JSpinner();
        this.tickSpacingSpinner.addChangeListener(this);
        this.tickSpacingSpinner.setBounds(175, 20, 60, 25);
        jPanel2.add(this.tickSpacingSpinner);
        this.tickWidthLabel = new JLabel("Width");
        this.tickWidthLabel.setHorizontalAlignment(4);
        this.tickWidthLabel.setFont(JDUtils.labelFont);
        this.tickWidthLabel.setForeground(JDUtils.labelColor);
        this.tickWidthLabel.setBounds(235, 20, 60, 25);
        jPanel2.add(this.tickWidthLabel);
        this.tickWidthSpinner = new JSpinner();
        this.tickWidthSpinner.addChangeListener(this);
        this.tickWidthSpinner.setBounds(300, 20, 60, 25);
        jPanel2.add(this.tickWidthSpinner);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(null);
        jPanel3.setBorder(JDUtils.createTitleBorder("Axis range"));
        jPanel3.setBounds(5, 176, 370, 54);
        this.minLabel = new JLabel("Min");
        this.minLabel.setFont(JDUtils.labelFont);
        this.minLabel.setForeground(JDUtils.labelColor);
        this.minLabel.setBounds(10, 20, 35, 25);
        jPanel3.add(this.minLabel);
        this.minText = new JTextField();
        this.minText.setEditable(true);
        this.minText.setFont(JDUtils.labelFont);
        this.minText.setBounds(45, 20, 60, 24);
        this.minText.addActionListener(this);
        jPanel3.add(this.minText);
        this.maxLabel = new JLabel("Max");
        this.maxLabel.setFont(JDUtils.labelFont);
        this.maxLabel.setForeground(JDUtils.labelColor);
        this.maxLabel.setBounds(110, 20, 35, 25);
        jPanel3.add(this.maxLabel);
        this.maxText = new JTextField();
        this.maxText.setEditable(true);
        this.maxText.setFont(JDUtils.labelFont);
        this.maxText.setBounds(145, 20, 60, 24);
        this.maxText.addActionListener(this);
        jPanel3.add(this.maxText);
        this.invertCheckBox = new JCheckBox("Invert");
        this.invertCheckBox.setFont(JDUtils.labelFont);
        this.invertCheckBox.setForeground(JDUtils.labelColor);
        this.invertCheckBox.setBounds(210, 20, 70, 25);
        this.invertCheckBox.addActionListener(this);
        jPanel3.add(this.invertCheckBox);
        this.applyValueBtn = new JButton("Apply");
        this.applyValueBtn.setFont(JDUtils.labelFont);
        this.applyValueBtn.setBounds(280, 20, 80, 24);
        this.applyValueBtn.addActionListener(this);
        jPanel3.add(this.applyValueBtn);
        this.add(jPanel3);
        this.updatePanel(jDAxisArray);
    }

    public void updatePanel(JDAxis[] jDAxisArray) {
        this.allObjects = jDAxisArray;
        this.refreshControl();
    }

    private void refreshControl() {
        this.isUpdating = true;
        if (this.allObjects == null || this.allObjects.length <= 0) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, 0, 0);
            this.tickWidthSpinner.setModel(spinnerNumberModel);
            this.tickSpacingSpinner.setModel(spinnerNumberModel);
            this.orientationCombo.setSelectedIndex(-1);
            this.labelCombo.setSelectedIndex(-1);
            this.scaleCombo.setSelectedIndex(-1);
            this.formatCombo.setSelectedIndex(-1);
            this.fontLabel.setText("Font: ");
            this.tickCenterCheckBox.setSelected(false);
            this.invertCheckBox.setSelected(false);
            this.minText.setText("");
            this.maxText.setText("");
        } else {
            JDAxis jDAxis = this.allObjects[0];
            Integer n = new Integer(jDAxis.getTickWidth());
            Integer n2 = new Integer(-10);
            Integer n3 = new Integer(10);
            Integer n4 = new Integer(1);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
            this.tickWidthSpinner.setModel(spinnerNumberModel);
            n = new Integer(jDAxis.getTickSpacing());
            n2 = new Integer(1);
            n3 = new Integer(1000);
            n4 = new Integer(1);
            SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(n, n2, n3, n4);
            this.tickSpacingSpinner.setModel(spinnerNumberModel2);
            this.orientationCombo.setSelectedIndex(jDAxis.getOrientation());
            this.labelCombo.setSelectedIndex(jDAxis.getLabelPos());
            this.formatCombo.setSelectedIndex(jDAxis.getFormat());
            this.scaleCombo.setSelectedIndex(jDAxis.getScale());
            this.fontLabel.setText("Font: [" + JDUtils.buildFontName(jDAxis.getFont()) + "]");
            this.tickCenterCheckBox.setSelected(jDAxis.isTickCentered());
            this.invertCheckBox.setSelected(jDAxis.isInverted());
            this.minText.setText(Double.toString(jDAxis.getMin()));
            this.maxText.setText(Double.toString(jDAxis.getMax()));
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            this.oldRect = this.oldRect.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            rectangle = rectangle.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
        this.invoker.repaint(rectangle.union(this.oldRect));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = actionEvent.getSource();
        if (object == this.orientationCombo) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setOrientation(this.orientationCombo.getSelectedIndex());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change axis orientation");
        } else if (object == this.labelCombo) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setLabelPos(this.labelCombo.getSelectedIndex());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change axis label");
        } else if (object == this.scaleCombo) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setScale(this.scaleCombo.getSelectedIndex());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change axis scale");
        } else if (object == this.fontBtn) {
            Font font = ATKFontChooser.getNewFont(this, "Choose axis font", this.allObjects[0].getFont());
            if (font != null) {
                int n = 0;
                while (n < this.allObjects.length) {
                    this.allObjects[n].setFont(font);
                    ++n;
                }
                this.fontLabel.setText("Font: [" + JDUtils.buildFontName(font) + "]");
                this.invoker.setNeedToSave(true, "Change axis font");
            }
        } else if (object == this.tickCenterCheckBox) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setTickCentered(this.tickCenterCheckBox.isSelected());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change axis tick");
        } else if (object == this.invertCheckBox) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setInverted(this.invertCheckBox.isSelected());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Invert axis");
        } else if (object == this.formatCombo) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setFormat(this.formatCombo.getSelectedIndex());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change axis format");
        } else if (object == this.applyValueBtn || object == this.minText || object == this.maxText) {
            try {
                double d = Double.parseDouble(this.minText.getText());
                double d2 = Double.parseDouble(this.maxText.getText());
                if (d >= d2) {
                    JOptionPane.showMessageDialog(this, "Min must be lower than max.", "Error", 0);
                    this.refreshControl();
                } else {
                    int n = 0;
                    while (n < this.allObjects.length) {
                        this.allObjects[n].setMin(d);
                        this.allObjects[n].setMax(d2);
                        ++n;
                    }
                    this.invoker.setNeedToSave(true, "Change axis range");
                    this.minText.setCaretPosition(0);
                    this.maxText.setCaretPosition(0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid range value.\n" + numberFormatException.getMessage(), "Error", 0);
                this.refreshControl();
            }
        }
        this.repaintObjects();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = changeEvent.getSource();
        if (object == this.tickWidthSpinner) {
            Integer n = (Integer)this.tickWidthSpinner.getValue();
            int n2 = 0;
            while (n2 < this.allObjects.length) {
                this.allObjects[n2].setTickWidth(n);
                ++n2;
            }
            this.invoker.setNeedToSave(true, "Change tick length");
        } else if (object == this.tickSpacingSpinner) {
            Integer n = (Integer)this.tickSpacingSpinner.getValue();
            int n3 = 0;
            while (n3 < this.allObjects.length) {
                this.allObjects[n3].setTickSpacing(n);
                ++n3;
            }
            this.invoker.setNeedToSave(true, "Change tick spacing");
        }
        this.repaintObjects();
    }
}

