/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetShape;
import fr.esrf.tangoatk.widget.util.interlock.NetUtils;
import fr.esrf.tangoatk.widget.util.interlock.UndoPattern;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class NetObject {
    public static final int OBJECT_BUBBLE = 1;
    public static final int OBJECT_TEXT = 2;
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    public static final int JUSTIFY_CENTER = 2;
    int type;
    int userType;
    int bSize;
    int maxInput;
    int maxOutput;
    int shape;
    boolean editableShape;
    Point org;
    private String[] labels;
    Point labelOffset;
    int justify;
    String smallCenterLabel;
    String smallBottomLabel;
    Color backColor;
    String[] extParamValue;
    String[] extParamName;
    Point dragStart;
    int selSet;
    int labelAscent;
    static final int SEL_NONE = 0;
    static final int SEL_OBJECT = 1;
    static final int SEL_LABEL = 2;
    static final int SEL_LINK = 10;
    private Vector children;
    private Vector parents;
    private int[] childrenIds;
    private int idx;
    private boolean selected;
    private Rectangle repaintRect;
    private Rectangle boundRect;
    private Rectangle labelRect;
    private int[] labelWidth;
    private int labelHeight;
    private int maxLabelWidth;
    private Font textFont;
    private Object userValue;
    private int[] ashx;
    private int[] ashy;
    private StringBuffer to_write;
    private NetEditor parentEditor;
    private static float[] dashPattern = new float[]{3.0f};
    private static BasicStroke dashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
    private static BufferedImage fntImg = null;
    private static FontRenderContext frc;
    private static Point pt0;

    public NetObject(int n, int n2, int n3, int n4, int n5, int n6) {
        this.type = n;
        this.userType = n2;
        if (n == 1) {
            this.maxInput = n3;
            this.maxOutput = n4;
        } else {
            this.maxInput = 0;
            this.maxOutput = 0;
        }
        this.shape = 0;
        this.org = new Point(n5, n6);
        this.labelOffset = new Point(0, 0);
        this.boundRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.repaintRect = new Rectangle();
        this.children = new Vector();
        this.parents = new Vector();
        this.childrenIds = null;
        this.idx = 0;
        this.selected = false;
        this.ashx = new int[4];
        this.ashy = new int[4];
        this.labels = new String[0];
        this.labelWidth = new int[0];
        this.smallCenterLabel = "";
        this.smallBottomLabel = "";
        this.justify = 2;
        this.dragStart = new Point();
        this.parentEditor = null;
        this.userValue = null;
        this.extParamValue = null;
        this.extParamName = null;
        this.bSize = 10;
        this.backColor = Color.black;
        this.editableShape = true;
        this.textFont = n == 2 ? NetEditor.defaultLabelFont : null;
        if (fntImg == null) {
            fntImg = new BufferedImage(10, 10, 1);
            Graphics2D graphics2D = (Graphics2D)fntImg.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            frc = graphics2D.getFontRenderContext();
        }
    }

    NetObject(UndoPattern undoPattern) {
        this.type = undoPattern.type;
        this.userType = undoPattern.userType;
        this.org = new Point(undoPattern.x, undoPattern.y);
        this.shape = undoPattern.shape;
        this.editableShape = undoPattern.eshape;
        this.labelOffset = new Point(undoPattern.lx, undoPattern.ly);
        this.boundRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.repaintRect = new Rectangle();
        this.children = new Vector();
        this.parents = new Vector();
        this.childrenIds = null;
        this.idx = undoPattern.idx;
        this.selected = false;
        this.ashx = new int[4];
        this.ashy = new int[4];
        this.setLabel(undoPattern.label);
        this.smallCenterLabel = "";
        this.smallBottomLabel = "";
        this.justify = undoPattern.justify;
        this.dragStart = new Point();
        this.parentEditor = null;
        this.userValue = null;
        this.maxInput = undoPattern.maxi;
        this.maxOutput = undoPattern.maxo;
        this.bSize = undoPattern.size;
        this.textFont = undoPattern.textFnt;
        this.extParamName = null;
        this.extParamValue = null;
        if (this.type == 1) {
            this.extParamName = undoPattern.extsN;
            if (undoPattern.extsN != null) {
                this.extParamValue = new String[undoPattern.extsN.length];
                int n = 0;
                while (n < undoPattern.extsN.length) {
                    this.extParamValue[n] = new String(undoPattern.extsV[n]);
                    ++n;
                }
            }
        }
    }

    public void addChild(NetObject netObject) {
        this.children.add(netObject);
        netObject.parents.add(this);
    }

    public void removeChild(NetObject netObject) {
        this.children.remove(netObject);
        netObject.parents.remove(this);
    }

    public void removeChild(int n) {
        this.getChildAt((int)n).parents.remove(this);
        this.children.remove(n);
    }

    public int getChildrenNumber() {
        return this.children.size();
    }

    public NetObject getChildAt(int n) {
        return (NetObject)this.children.get(n);
    }

    public void clearChildren() {
        int n = this.getChildrenNumber();
        int n2 = 0;
        while (n2 < n) {
            this.getChildAt((int)n2).parents.remove(this);
            ++n2;
        }
        this.children.clear();
    }

    public int getParentNumber() {
        return this.parents.size();
    }

    public NetObject getParentAt(int n) {
        return (NetObject)this.parents.get(n);
    }

    public boolean isParentOf(NetObject netObject) {
        return this.children.contains(netObject);
    }

    public boolean isChildOf(NetObject netObject) {
        return this.parents.contains(netObject);
    }

    void setChildrenIdList(int[] nArray) {
        this.childrenIds = nArray;
    }

    int[] getChildrenIdList() {
        return this.childrenIds;
    }

    int getIndex() {
        return this.idx;
    }

    void setIndex(int n) {
        this.idx = n;
    }

    void setParent(NetEditor netEditor) {
        this.parentEditor = netEditor;
    }

    public String getLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.labels.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.labels[n2]);
            if (n2 < n - 1) {
                stringBuffer.append('\n');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void setLabel(String var1_1) {
        if (var1_1 != null) ** GOTO lbl6
        this.labels = new String[0];
        this.labelWidth = new int[this.labels.length];
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.substring(0, var1_1.length() - 1);
lbl6:
            // 2 sources

            ** while (var1_1.endsWith((String)"\n"))
        }
lbl7:
        // 1 sources

        var2_2 = new StringBuffer();
        var4_3 = 0;
        while (var4_3 < var1_1.length()) {
            var3_4 = var1_1.charAt(var4_3);
            if (var3_4 == '\"') {
                var2_2.append('\'');
            } else {
                var2_2.append(var3_4);
            }
            ++var4_3;
        }
        this.labels = var2_2.length() == 0 ? new String[0] : var2_2.toString().split("\n");
        this.labelWidth = new int[this.labels.length];
    }

    public void setLabel(String[] stringArray) {
        this.labels = stringArray;
        this.labelWidth = new int[this.labels.length];
    }

    public String getName() {
        switch (this.type) {
            case 1: {
                return "Bubble";
            }
            case 2: {
                return "Text";
            }
        }
        return "Unknown";
    }

    public int getType() {
        return this.type;
    }

    public int getUserType() {
        return this.userType;
    }

    public void setShape(int n) {
        this.shape = n;
    }

    public int getShape() {
        return this.shape;
    }

    public void setEditableShape(boolean bl) {
        this.editableShape = bl;
    }

    public void setJustify(int n) {
        this.justify = n;
    }

    public int getJustify() {
        return this.justify;
    }

    public int getMaxInput() {
        return this.maxInput;
    }

    public int getMaxOutput() {
        return this.maxOutput;
    }

    public void setCenterLabel(String string) {
        this.smallCenterLabel = string;
    }

    public void setBottomLabel(String string) {
        this.smallBottomLabel = string;
    }

    public void setColor(Color color) {
        this.backColor = color;
    }

    public Color getColor() {
        return this.backColor;
    }

    public void setSize(int n) {
        this.bSize = n;
    }

    public int getSize() {
        return this.bSize;
    }

    public void setUserValue(Object object) {
        this.userValue = object;
    }

    public Object getUserValue() {
        return this.userValue;
    }

    public void setExtensionList(String[] stringArray) {
        if (this.type != 1) {
            System.out.println("NetObject.setExtensionList() : Only bubble object accept extensions.");
            return;
        }
        this.extParamName = stringArray;
        this.extParamValue = new String[stringArray.length];
        int n = 0;
        while (n < this.extParamValue.length) {
            this.extParamValue[n] = "";
            ++n;
        }
    }

    public void setExtendedParam(String string, String string2) {
        int n = this.getExtendedParamIndex(string);
        if (n != -1) {
            this.extParamValue[n] = string;
        } else {
            System.out.println("NetObject.setExtendedParam() : " + string + " does not exist.");
        }
    }

    public void setExtendedParam(int n, String string) {
        int n2 = this.getExtendedParamNumber();
        if (n < 0 || n >= n2) {
            System.out.println("NetObject.setExtendedParam() : index of of bounds.");
            return;
        }
        this.extParamValue[n] = string;
    }

    public String getExtendedParam(String string) {
        int n = this.getExtendedParamIndex(string);
        if (n != -1) {
            return this.extParamValue[n];
        }
        System.out.println("NetObject.getExtendedParam() : " + string + " does not exist.");
        return "";
    }

    public String getExtendedParam(int n) {
        int n2 = this.getExtendedParamNumber();
        if (n < 0 || n >= n2) {
            System.out.println("NetObject.getExtendedParam() : index of of bounds.");
            return "";
        }
        return this.extParamValue[n];
    }

    public int getExtendedParamNumber() {
        if (this.extParamValue == null) {
            return 0;
        }
        return this.extParamValue.length;
    }

    public int getExtendedParamIndex(String string) {
        if (this.extParamName == null) {
            return -1;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.extParamName.length && !bl) {
            bl = string.equalsIgnoreCase(this.extParamName[n]);
            if (bl) continue;
            ++n;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    public void setTextFont(Font font) {
        if (this.type == 2) {
            this.textFont = font;
        }
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public int getXOrigin() {
        if (this.type == 2) {
            return this.org.x;
        }
        return this.org.x * this.parentEditor.XGRID_SIZE;
    }

    public int getYOrigin() {
        if (this.type == 2) {
            return this.org.y;
        }
        return this.org.y * this.parentEditor.YGRID_SIZE;
    }

    boolean acceptInput() {
        switch (this.type) {
            case 1: {
                return this.getParentNumber() < this.maxInput;
            }
        }
        return false;
    }

    boolean acceptOutput() {
        switch (this.type) {
            case 1: {
                return this.getChildrenNumber() < this.maxOutput;
            }
        }
        return false;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean getSelected() {
        return this.selected;
    }

    boolean contains(int n, int n2) {
        return this.boundRect.contains(n, n2);
    }

    boolean labelContains(int n, int n2) {
        return this.labelRect.contains(n, n2);
    }

    private Point getLinkTranslation(int n, int n2, int n3, int n4, NetObject netObject) {
        if (this.isChildOf(netObject)) {
            double d = n4 - n2;
            double d2 = n - n3;
            double d3 = Math.sqrt(d * d + d2 * d2);
            int n5 = (int)(d / d3 * 3.0 + 0.5);
            int n6 = (int)(d2 / d3 * 3.0 + 0.5);
            return new Point(n5, n6);
        }
        return pt0;
    }

    int childContains(int n, int n2) {
        int n3 = this.children.size();
        int n4 = 0;
        boolean bl = false;
        Line2D.Double double_ = new Line2D.Double();
        Rectangle2D.Double double_2 = new Rectangle2D.Double(n - 4, n2 - 4, 8.0, 8.0);
        int n5 = this.org.x * this.parentEditor.XGRID_SIZE;
        int n6 = this.org.y * this.parentEditor.YGRID_SIZE;
        while (n4 < n3 && !bl) {
            NetObject netObject = this.getChildAt(n4);
            int n7 = netObject.org.x * this.parentEditor.XGRID_SIZE;
            int n8 = netObject.org.y * this.parentEditor.YGRID_SIZE;
            Point point = this.getLinkTranslation(n5, n6, n7, n8, netObject);
            ((Line2D)double_).setLine(n5 + point.x, n6 + point.y, n7 + point.x, n8 + point.y);
            bl = double_.intersects(double_2);
            if (bl) continue;
            ++n4;
        }
        if (bl) {
            return n4;
        }
        return -1;
    }

    boolean inside(Rectangle rectangle) {
        return rectangle.contains(this.boundRect);
    }

    boolean hasProperties() {
        switch (this.type) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    void resetDrag() {
        this.dragStart.x = this.org.x;
        this.dragStart.y = this.org.y;
    }

    Rectangle getBoundRect() {
        return this.boundRect;
    }

    Rectangle getRepaintRect() {
        return this.repaintRect;
    }

    NetObject getCopyAt(int n, int n2) {
        NetObject netObject = new NetObject(this.type, this.userType, this.maxInput, this.maxOutput, n, n2);
        netObject.shape = this.shape;
        netObject.editableShape = this.editableShape;
        netObject.bSize = this.bSize;
        netObject.labels = new String[this.labels.length];
        netObject.labelWidth = new int[this.labels.length];
        int n3 = 0;
        while (n3 < this.labels.length) {
            netObject.labels[n3] = new String(this.labels[n3]);
            ++n3;
        }
        netObject.justify = this.justify;
        netObject.textFont = this.textFont;
        netObject.labelOffset.x = this.labelOffset.x;
        netObject.labelOffset.y = this.labelOffset.y;
        netObject.extParamName = this.extParamName;
        if (this.extParamName != null) {
            netObject.extParamValue = new String[this.extParamValue.length];
            n3 = 0;
            while (n3 < this.extParamValue.length) {
                netObject.extParamValue[n3] = new String(this.extParamValue[n3]);
                ++n3;
            }
        } else {
            netObject.extParamValue = null;
        }
        return netObject;
    }

    UndoPattern getUndoPattern() {
        return new UndoPattern(this);
    }

    private void paintArrows(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        double d = -(n4 - n2);
        double d2 = n3 - n;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = 5.0;
        if (d3 >= 1.0) {
            double d5;
            double d6;
            double d7 = (double)(n3 - n) * d4 * 1.3 / d3;
            double d8 = (double)(n4 - n2) * d4 * 1.3 / d3;
            if (bl) {
                d6 = (double)n + (double)(n3 - n) * 0.51;
                d5 = (double)n2 + (double)(n4 - n2) * 0.51;
            } else {
                d6 = (double)n + (double)(n3 - n) * 0.5;
                d5 = (double)n2 + (double)(n4 - n2) * 0.5;
            }
            this.ashx[0] = (int)Math.round(d6 + -d / d3 * d4);
            this.ashy[0] = (int)Math.round(d5 + -d2 / d3 * d4);
            this.ashx[1] = (int)Math.round(d6 + d / d3 * d4);
            this.ashy[1] = (int)Math.round(d5 + d2 / d3 * d4);
            this.ashx[2] = (int)Math.round(d6 + d7);
            this.ashy[2] = (int)Math.round(d5 + d8);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fillPolygon(this.ashx, this.ashy, 3);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    void paintLinks(Graphics2D graphics2D, boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.children.size()) {
            if (bl2 && n == this.selSet - 10) {
                graphics2D.setColor(NetShape.selColor);
            } else {
                graphics2D.setColor(Color.black);
            }
            this.paintLink(graphics2D, this.getChildAt(n), bl);
            ++n;
        }
    }

    private void paintLabels(Graphics2D graphics2D) {
        int n = this.labelRect.y + this.labelAscent;
        switch (this.justify) {
            case 0: {
                int n2 = 0;
                while (n2 < this.labels.length) {
                    graphics2D.drawString(this.labels[n2], this.labelRect.x, n);
                    n += this.labelHeight;
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.labels.length) {
                    graphics2D.drawString(this.labels[n3], this.labelRect.x + (this.maxLabelWidth - this.labelWidth[n3]), n);
                    n += this.labelHeight;
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.labels.length) {
                    graphics2D.drawString(this.labels[n4], this.labelRect.x + (this.maxLabelWidth - this.labelWidth[n4]) / 2, n);
                    n += this.labelHeight;
                    ++n4;
                }
                break;
            }
        }
        if (this.selected && this.parentEditor.isEditable() && this.labelRect.width > 0) {
            graphics2D.setColor(Color.black);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(dashStroke);
            graphics2D.drawRect(this.labelRect.x, this.labelRect.y, this.labelRect.width, this.labelRect.height);
            graphics2D.setStroke(stroke);
        }
    }

    private void paintSmallCenterLabel(Graphics2D graphics2D) {
        if (this.smallCenterLabel.length() > 0) {
            graphics2D.setFont(this.parentEditor.smallFont);
            graphics2D.setColor(Color.black);
            Rectangle2D rectangle2D = this.parentEditor.smallFont.getStringBounds(this.smallCenterLabel, frc);
            graphics2D.drawString(this.smallCenterLabel, this.org.x * this.parentEditor.XGRID_SIZE - (int)(rectangle2D.getWidth() / 2.0), this.org.y * this.parentEditor.YGRID_SIZE + 4);
        }
    }

    private void paintSmallBottomLabel(Graphics2D graphics2D) {
        if (this.smallBottomLabel.length() > 0) {
            graphics2D.setFont(this.parentEditor.smallFont);
            Rectangle2D rectangle2D = this.parentEditor.smallFont.getStringBounds(this.smallBottomLabel, frc);
            graphics2D.drawString(this.smallBottomLabel, this.org.x * this.parentEditor.XGRID_SIZE - (this.bSize + (int)rectangle2D.getWidth() + 2), this.org.y * this.parentEditor.YGRID_SIZE + 15);
        }
    }

    void paintBubble(Graphics2D graphics2D) {
        Color color = this.parentEditor.isEditable() ? Color.yellow : this.backColor;
        boolean bl = this.parentEditor.isEditable() ? this.selected : false;
        NetShape.paintShape(graphics2D, this.shape, bl, color, this.org.x * this.parentEditor.XGRID_SIZE, this.org.y * this.parentEditor.YGRID_SIZE, this.bSize);
        graphics2D.setFont(this.parentEditor.labelFont);
        graphics2D.setColor(Color.black);
        this.paintLabels(graphics2D);
        this.paintSmallBottomLabel(graphics2D);
        this.paintSmallCenterLabel(graphics2D);
    }

    void paintJoin(Graphics2D graphics2D) {
        if (this.parentEditor.isEditable()) {
            if (this.selected) {
                graphics2D.setColor(NetShape.selColor);
            } else {
                graphics2D.setColor(Color.BLACK);
            }
            graphics2D.fillRect(this.org.x * this.parentEditor.XGRID_SIZE - 3, this.org.y * this.parentEditor.YGRID_SIZE - 3, 6, 6);
        } else {
            if (this.bSize == 0) {
                return;
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(this.org.x * this.parentEditor.XGRID_SIZE - 2, this.org.y * this.parentEditor.YGRID_SIZE - 2, 4, 4);
        }
    }

    void paintText(Graphics2D graphics2D) {
        graphics2D.setColor(this.backColor);
        graphics2D.setFont(this.textFont);
        this.paintLabels(graphics2D);
    }

    public void paintLink(Graphics2D graphics2D, NetObject netObject, boolean bl) {
        int n = this.org.x * this.parentEditor.XGRID_SIZE;
        int n2 = this.org.y * this.parentEditor.YGRID_SIZE;
        int n3 = netObject.org.x * this.parentEditor.XGRID_SIZE;
        int n4 = netObject.org.y * this.parentEditor.YGRID_SIZE;
        Point point = this.getLinkTranslation(n, n2, n3, n4, netObject);
        graphics2D.drawLine(n + point.x, n2 + point.y, n3 + point.x, n4 + point.y);
        if (bl) {
            this.paintArrows(graphics2D, n + point.x, n2 + point.y, n3 + point.x, n4 + point.y, point != pt0);
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.parentEditor == null) {
            return;
        }
        this.updateBoundRect();
        switch (this.type) {
            case 1: {
                this.paintBubble(graphics2D);
                break;
            }
            case 2: {
                this.paintText(graphics2D);
            }
        }
    }

    private void updateLabelBoundRect() {
        Font font;
        int n;
        int n2;
        if (this.type == 2) {
            n2 = this.org.x;
            n = this.org.y;
            font = this.textFont;
        } else {
            n2 = this.org.x * this.parentEditor.XGRID_SIZE;
            n = this.org.y * this.parentEditor.YGRID_SIZE - 15;
            font = this.parentEditor.labelFont;
        }
        if (this.labels.length == 0) {
            this.labelRect.setRect(0.0, 0.0, 0.0, 0.0);
            return;
        }
        this.maxLabelWidth = 0;
        int n3 = 0;
        while (n3 < this.labels.length) {
            Rectangle2D rectangle2D = font.getStringBounds(this.labels[n3], frc);
            this.labelHeight = (int)rectangle2D.getHeight();
            this.labelWidth[n3] = (int)rectangle2D.getWidth();
            if (this.labelWidth[n3] > this.maxLabelWidth) {
                this.maxLabelWidth = this.labelWidth[n3];
            }
            ++n3;
        }
        this.labelAscent = (int)((double)this.labelHeight * 0.8);
        switch (this.justify) {
            case 0: {
                this.labelRect.setRect(n2 + this.labelOffset.x, n + this.labelOffset.y - this.labelAscent, this.maxLabelWidth, this.labelHeight * this.labels.length);
                break;
            }
            case 1: {
                this.labelRect.setRect(n2 - this.maxLabelWidth + this.labelOffset.x, n + this.labelOffset.y - this.labelAscent, this.maxLabelWidth, this.labelHeight * this.labels.length);
                break;
            }
            case 2: {
                this.labelRect.setRect(n2 - this.maxLabelWidth / 2 + this.labelOffset.x, n + this.labelOffset.y - this.labelAscent, this.maxLabelWidth, this.labelHeight * this.labels.length);
            }
        }
    }

    private void updateBoundRect() {
        switch (this.type) {
            case 1: {
                this.updateLabelBoundRect();
                NetShape.setBoundRect(this.shape, this.org.x * this.parentEditor.XGRID_SIZE, this.org.y * this.parentEditor.YGRID_SIZE, this.bSize, this.boundRect);
                break;
            }
            case 2: {
                this.updateLabelBoundRect();
                this.boundRect.setRect(this.labelRect.x, this.labelRect.y, this.labelRect.width, this.labelRect.height);
            }
        }
    }

    void updateRepaintRect() {
        if (this.parentEditor != null) {
            this.updateBoundRect();
            this.repaintRect = this.labelRect.width > 0 ? this.boundRect.union(this.labelRect) : new Rectangle(this.boundRect);
        }
    }

    private void saveLabels() {
        if (this.labels.length > 0) {
            this.to_write.append("    label:");
            int n = 0;
            while (n < this.labels.length) {
                this.to_write.append('\"');
                this.to_write.append(this.labels[n]);
                this.to_write.append('\"');
                if (n < this.labels.length - 1) {
                    this.to_write.append(",\n          ");
                }
                ++n;
            }
            this.to_write.append('\n');
        }
        if (this.labelOffset.x != 0 || this.labelOffset.y != 0) {
            this.to_write.append("    label_offset:");
            this.to_write.append(Integer.toString(this.labelOffset.x));
            this.to_write.append(',');
            this.to_write.append(Integer.toString(this.labelOffset.y));
            this.to_write.append('\n');
        }
        if (this.justify != 2) {
            this.to_write.append("    justify:");
            this.to_write.append(Integer.toString(this.justify));
            this.to_write.append('\n');
        }
    }

    private void saveHeader() {
        this.to_write.append("  ");
        this.to_write.append(this.getName());
        this.to_write.append(' ');
        this.to_write.append(Integer.toString(this.userType));
        this.to_write.append(" (");
        this.to_write.append(Integer.toString(this.org.x));
        this.to_write.append(',');
        this.to_write.append(Integer.toString(this.org.y));
        this.to_write.append(") ");
        if (this.type == 1) {
            this.to_write.append(Integer.toString(this.maxInput));
            this.to_write.append(',');
            this.to_write.append(Integer.toString(this.maxOutput));
            this.to_write.append(' ');
        }
        this.to_write.append("{\n");
    }

    private void saveChildrenList() {
        int n = this.children.size();
        if (n > 0) {
            this.to_write.append("    children:");
            int n2 = 0;
            while (n2 < n) {
                NetObject netObject = (NetObject)this.children.get(n2);
                this.to_write.append(Integer.toString(netObject.idx));
                if (n2 < n - 1) {
                    this.to_write.append(',');
                }
                ++n2;
            }
            this.to_write.append('\n');
        }
    }

    private void saveExtensions() {
        int n = this.getExtendedParamNumber();
        if (n > 0) {
            this.to_write.append("    extensions {\n");
            int n2 = 0;
            while (n2 < n) {
                this.to_write.append("      ");
                if (this.extParamName[n2].indexOf(32) > 0) {
                    this.to_write.append('\"');
                    this.to_write.append(this.extParamName[n2]);
                    this.to_write.append('\"');
                } else {
                    this.to_write.append(this.extParamName[n2]);
                }
                this.to_write.append(":\"");
                this.to_write.append(this.extParamValue[n2]);
                this.to_write.append("\"\n");
                ++n2;
            }
            this.to_write.append("    }\n");
        }
    }

    private void saveShape() {
        if (this.shape != 0) {
            this.to_write.append("    shape:");
            this.to_write.append(Integer.toString(this.shape));
            this.to_write.append("\n");
        }
        if (!this.editableShape) {
            this.to_write.append("    editable_shape:0\n");
        }
    }

    private void saveSize() {
        if (this.bSize != 10) {
            this.to_write.append("    size:");
            this.to_write.append(Integer.toString(this.bSize));
            this.to_write.append("\n");
        }
    }

    private void saveFont() {
        if (!NetUtils.fontEquals(this.textFont, NetEditor.defaultLabelFont)) {
            this.to_write.append("    font:\"");
            this.to_write.append(this.textFont.getName());
            this.to_write.append("\",");
            this.to_write.append(Integer.toString(this.textFont.getStyle()));
            this.to_write.append(',');
            this.to_write.append(Integer.toString(this.textFont.getSize()));
            this.to_write.append("\n");
        }
    }

    void saveObject(FileWriter fileWriter) throws IOException {
        this.to_write = new StringBuffer();
        switch (this.type) {
            case 1: {
                this.saveHeader();
                this.saveShape();
                this.saveSize();
                this.saveLabels();
                this.saveChildrenList();
                this.saveExtensions();
                this.to_write.append("  }\n");
                break;
            }
            case 2: {
                this.saveHeader();
                this.saveLabels();
                this.saveFont();
                this.saveChildrenList();
                this.to_write.append("  }\n");
            }
        }
        fileWriter.write(this.to_write.toString());
    }

    static {
        pt0 = new Point(0, 0);
    }
}

