/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;

class TabbedLine {
    JLDataView[] dv;
    DataList[] dl;
    int anno;
    int sIndex;

    TabbedLine(int n) {
        this.dv = new JLDataView[n];
        this.dl = new DataList[n];
    }

    void add(int n, JLDataView jLDataView) {
        this.dv[n] = jLDataView;
        this.dl[n] = jLDataView.getData();
    }

    double getMinTime() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.dl.length) {
            if (this.dl[n] != null && this.dl[n].x < d) {
                d = this.dl[n].x;
            }
            ++n;
        }
        return d;
    }

    String getFirstLine(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.anno = n;
        if (n == 1) {
            stringBuffer.append("Time (s)\t");
        } else {
            stringBuffer.append("Index\t");
        }
        int n2 = 0;
        while (n2 < this.dv.length) {
            stringBuffer.append(this.dv[n2].getName() + "\t");
            ++n2;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    String getNextLine() {
        double d = this.getMinTime();
        if (d == Double.MAX_VALUE) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.anno == 1) {
            long l = (long)d;
            long l2 = l / 1000L;
            long l3 = l % 1000L;
            if (l3 == 0L) {
                stringBuffer.append(l2 + "\t");
            } else if (l3 < 10L) {
                stringBuffer.append(l2 + ".00" + l3 + "\t");
            } else if (l3 < 100L) {
                stringBuffer.append(l2 + ".0" + l3 + "\t");
            } else {
                stringBuffer.append(l2 + "." + l3 + "\t");
            }
        } else {
            stringBuffer.append(Double.toString(d) + "\t");
        }
        int n = 0;
        while (n < this.dl.length) {
            if (this.dl[n] != null) {
                if (this.dl[n].x == d) {
                    stringBuffer.append(Double.toString(this.dl[n].y) + "\t");
                    this.dl[n] = this.dl[n].next;
                } else {
                    stringBuffer.append("*\t");
                }
            } else {
                stringBuffer.append("*\t");
            }
            ++n;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    String[] getFirstFields(int n, boolean bl) {
        this.anno = n;
        this.sIndex = bl ? 1 : 0;
        String[] stringArray = new String[this.dv.length + this.sIndex];
        if (this.sIndex > 0) {
            stringArray[0] = n == 1 ? "Time (s)" : "Index";
        }
        int n2 = 0;
        while (n2 < this.dv.length) {
            stringArray[n2 + this.sIndex] = this.dv[n2].getName();
            ++n2;
        }
        return stringArray;
    }

    String[] getNextFields() {
        double d = this.getMinTime();
        if (d == Double.MAX_VALUE) {
            return null;
        }
        String[] stringArray = new String[this.dv.length + this.sIndex];
        if (this.sIndex > 0) {
            stringArray[0] = this.anno == 1 ? JLAxis.formatTimeValue(d) : Double.toString(d);
        }
        int n = 0;
        while (n < this.dl.length) {
            if (this.dl[n] != null) {
                if (this.dl[n].x == d) {
                    stringArray[n + this.sIndex] = this.dv[n].formatValue(this.dl[n].y);
                    this.dl[n] = this.dl[n].next;
                } else {
                    stringArray[n + this.sIndex] = "";
                }
            } else {
                stringArray[n + this.sIndex] = "";
            }
            ++n;
        }
        return stringArray;
    }
}

