/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class UIManagerHelper {
    public static void setFont(String string, JComponent jComponent) {
        Font font = UIManager.getFont(string + ".Font");
        if (font == null) {
            return;
        }
        jComponent.setFont(font);
    }

    public static void setForeground(String string, JComponent jComponent) {
        Color color = UIManager.getColor(string + ".Foreground");
        if (color == null) {
            return;
        }
        jComponent.setForeground(color);
    }

    public static void setBackground(String string, JComponent jComponent) {
        Color color = UIManager.getColor(string + ".Background");
        if (color == null) {
            return;
        }
        jComponent.setBackground(color);
    }

    public static void setSize(String string, JComponent jComponent) {
        Dimension dimension = UIManager.getDimension(string + ".Size");
        if (dimension == null) {
            return;
        }
        jComponent.setPreferredSize(dimension);
    }

    public static void setAll(String string, JComponent jComponent) {
        UIManagerHelper.setSize(string, jComponent);
        UIManagerHelper.setFont(string, jComponent);
        UIManagerHelper.setForeground(string, jComponent);
        UIManagerHelper.setBackground(string, jComponent);
    }

    public static Dimension getRequiredSize(FontMetrics fontMetrics, int n) {
        int n2 = fontMetrics.getMaxAdvance();
        if (n2 != -1) {
            Dimension dimension = new Dimension(n2 * n, fontMetrics.getHeight());
            return dimension;
        }
        int[] nArray = fontMetrics.getWidths();
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] >= n3) {
                n3 = nArray[n4];
            }
            ++n4;
        }
        Dimension dimension = new Dimension(n3 * n, fontMetrics.getHeight());
        return dimension;
    }
}

