/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class ThreeStateSwitch
extends JComponent
implements MouseListener {
    public static final int UNKNOWN_STATE = 0;
    public static final int ON_STATE = 1;
    public static final int OFF_STATE = 2;
    ImageIcon on_state;
    ImageIcon off_state;
    ImageIcon unknown_state;
    Dimension iconSize;
    Dimension titleSize;
    int currentState;
    String title;
    Font titleFont;
    EventListenerList listenerList;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public ThreeStateSwitch() {
        this.initComponents();
    }

    public ThreeStateSwitch(String string, Font font) {
        this.initComponents();
        if (font != null) {
            this.titleFont = font;
        }
        this.setTitle(string);
    }

    public void setTitle(String string) {
        this.title = string;
        this.computeTitleSize();
    }

    public String getTitle() {
        return this.title;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.titleFont = font;
            this.computeTitleSize();
        }
    }

    public Font getFont() {
        return this.titleFont;
    }

    public void setIcons(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3) {
        this.on_state = imageIcon;
        this.off_state = imageIcon2;
        this.unknown_state = imageIcon3;
        this.iconSize = new Dimension(this.on_state.getIconWidth(), this.on_state.getIconHeight());
        this.computeTitleSize();
    }

    public void setState(int n) {
        this.currentState = n;
        this.repaint();
    }

    public int getState() {
        return this.currentState;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ThreeStateSwitch.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ThreeStateSwitch.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            switch (this.currentState) {
                case 1: {
                    this.currentState = 2;
                    this.fireStateChange("OFF");
                    this.repaint();
                    break;
                }
                case 2: {
                    this.currentState = 1;
                    this.fireStateChange("ON");
                    this.repaint();
                    break;
                }
                default: {
                    this.fireStateChange("UNKNOWN");
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.title != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.setFont(this.titleFont);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            int n = (int)Math.ceil(graphics.getFont().getLineMetrics("ABC", fontRenderContext).getAscent());
            graphics.setColor(this.getForeground());
            graphics.drawString(this.title, (dimension.width - (this.titleSize.width - 6)) / 2, n + 2);
        }
        int n = (dimension.width - this.iconSize.width) / 2;
        int n2 = (dimension.height - (this.iconSize.height - this.titleSize.height)) / 2;
        switch (this.currentState) {
            case 1: {
                graphics.drawImage(this.on_state.getImage(), n, n2, null);
                break;
            }
            case 2: {
                graphics.drawImage(this.off_state.getImage(), n, n2, null);
                break;
            }
            default: {
                graphics.drawImage(this.unknown_state.getImage(), n, n2, null);
            }
        }
        this.paintBorder(graphics);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(Math.max(this.iconSize.width, this.titleSize.width), this.iconSize.height + this.titleSize.height);
    }

    private void computeTitleSize() {
        if (this.title == null) {
            this.titleSize = new Dimension(0, 0);
            return;
        }
        Dimension dimension = ATKGraphicsUtils.measureString(this.title, this.titleFont);
        dimension.width += 6;
        dimension.height += 4;
        this.titleSize = dimension;
    }

    private void initComponents() {
        this.setOpaque(true);
        this.setLayout(null);
        this.setBorder(null);
        this.setBackground(new Color(206, 206, 206));
        this.setForeground(Color.BLACK);
        this.on_state = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/switch_on.gif"));
        this.off_state = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/switch_off.gif"));
        this.unknown_state = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/switch_unknown.gif"));
        this.iconSize = new Dimension(this.on_state.getIconWidth(), this.on_state.getIconHeight());
        this.currentState = 1;
        this.title = null;
        this.titleSize = new Dimension(0, 0);
        this.titleFont = new Font("Dialog", 1, 12);
        this.listenerList = new EventListenerList();
        this.addMouseListener(this);
    }

    private void fireStateChange(String string) {
        ActionListener[] actionListenerArray = (ActionListener[])this.listenerList.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ThreeStateSwitch.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        int n = 0;
        while (n < actionListenerArray.length) {
            actionListenerArray[n].actionPerformed(actionEvent);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

