/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.ScrollRun;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class JAutoScrolledText
extends JComponent {
    public static int CENTER_ALIGNMENT = 1;
    public static int LEFT_ALIGNMENT = 2;
    public static int RIGHT_ALIGNMENT = 3;
    public static int CLASSIC_BEHAVIOR = 2;
    public static int MATRIX_BEHAVIOR = 1;
    private int maxPos = 0;
    private boolean scrollNeeded = false;
    private boolean lastScroll = false;
    private String text;
    private int off_x = 0;
    private int off_y = 0;
    private int align;
    private int sizingBehavior;
    private Insets margin;
    int sleepTime = 0;
    boolean endFlag;
    boolean stopDemand;
    int currentPos = 0;
    int waitTime = 2000;
    EventListenerList listenerList;
    static /* synthetic */ Class class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener;

    public JAutoScrolledText() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.align = CENTER_ALIGNMENT;
        this.stopDemand = false;
        this.endFlag = false;
        this.text = "";
        this.margin = new Insets(2, 3, 2, 3);
        this.sizingBehavior = CLASSIC_BEHAVIOR;
        this.listenerList = new EventListenerList();
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setWaitTime(int n) {
        this.waitTime = n;
    }

    public void setSizingBehavior(int n) {
        this.sizingBehavior = n;
    }

    public int getSizingBehavior() {
        return this.sizingBehavior;
    }

    public Dimension getPreferredSize() {
        if (this.sizingBehavior == MATRIX_BEHAVIOR) {
            return super.getPreferredSize();
        }
        Dimension dimension = ATKGraphicsUtils.measureString(this.text, this.getFont());
        dimension.width += this.margin.right + this.margin.left;
        dimension.height += this.margin.top + this.margin.bottom;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setAutoScroll(int n) {
        this.sleepTime = n;
    }

    public void setText(String string) {
        this.text = string == null ? "" : string;
        this.currentPos = 0;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setVerticalOffset(int n) {
        this.off_y = n;
        this.repaint();
    }

    public int getVerticalOffset() {
        return this.off_y;
    }

    public void setHorizontalOffset(int n) {
        this.off_x = n;
        this.repaint();
    }

    public int getHorizontalOffset() {
        return this.off_x;
    }

    public void setValueOffsets(int n, int n2) {
        System.out.println("JAutoScrolledText.setValueOffsets() is deprecated and has no effects.");
    }

    public void setHorizontalAlignment(int n) {
        this.align = n;
    }

    void scrollText() throws InterruptedException {
        if (this.scrollNeeded) {
            ++this.currentPos;
            if (this.currentPos > this.maxPos) {
                Thread.sleep(this.waitTime);
                this.currentPos = 0;
                this.endFlag = true;
            }
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        Insets insets = this.getInsets();
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = graphics.getFont().getStringBounds(this.text, fontRenderContext);
        this.maxPos = (int)(rectangle2D.getWidth() - (double)(n - (insets.left + insets.right)));
        double d = this.getFont().getLineMetrics(this.text, fontRenderContext).getAscent();
        int n3 = (int)(((double)n2 - rectangle2D.getHeight()) / 2.0 + d);
        boolean bl = this.scrollNeeded = this.maxPos > 0;
        if (this.scrollNeeded) {
            this.fireExceedBounds();
        }
        if (this.lastScroll != this.scrollNeeded && this.sleepTime != 0) {
            if (this.scrollNeeded) {
                this.currentPos = 0;
                this.stopDemand = false;
                this.endFlag = true;
                ScrollRun scrollRun = new ScrollRun(this);
                new Thread(scrollRun).start();
            } else {
                this.stopDemand = true;
            }
        }
        this.lastScroll = this.scrollNeeded;
        if (this.scrollNeeded) {
            graphics.drawString(this.text, this.off_x - this.currentPos, this.off_y + n3);
        } else {
            int n4 = 0;
            switch (this.align) {
                case 1: {
                    n4 = (int)(((double)n - rectangle2D.getWidth()) / 2.0);
                    break;
                }
                case 2: {
                    n4 = this.margin.left;
                    break;
                }
                case 3: {
                    n4 = (int)((double)n - rectangle2D.getWidth() - (double)this.margin.right);
                }
            }
            graphics.drawString(this.text, n4, this.off_y + n3);
        }
        this.paintBorder(graphics);
    }

    public void addTextListener(JAutoScrolledTextListener jAutoScrolledTextListener) {
        this.listenerList.add(class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener == null ? (class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener = JAutoScrolledText.class$("fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener")) : class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener, jAutoScrolledTextListener);
    }

    public void removeTextListener(JAutoScrolledTextListener jAutoScrolledTextListener) {
        this.listenerList.remove(class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener == null ? (class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener = JAutoScrolledText.class$("fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener")) : class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener, jAutoScrolledTextListener);
    }

    private void fireExceedBounds() {
        if (this.listenerList.getListenerCount() > 0) {
            JAutoScrolledTextListener[] jAutoScrolledTextListenerArray = (JAutoScrolledTextListener[])this.listenerList.getListeners(class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener == null ? (class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener = JAutoScrolledText.class$("fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener")) : class$fr$esrf$tangoatk$widget$util$JAutoScrolledTextListener);
            int n = 0;
            while (n < jAutoScrolledTextListenerArray.length) {
                jAutoScrolledTextListenerArray[n].textExceedBounds(this);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

