/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevError;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.widget.util.ErrorList;
import fr.esrf.tangoatk.widget.util.ErrorObject;
import fr.esrf.tangoatk.widget.util.ErrorPanel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class ErrorAdapter
extends AbstractTableModel {
    public static final int TIME = 0;
    public static final int SEVERITY = 1;
    public static final int SOURCE = 2;
    public static final int DESCRIPTION = 3;
    public static final int ORIGIN = 4;
    public static final int REASON = 5;
    private static final int MIN_ERROR_BUFFER_SIZE = 100;
    String[] columnNames = new String[]{"Time", "Severity", "Source", "Description"};
    SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    int errorBufferSize = 100;
    int nbError = 0;
    Vector errors = new Vector();
    Vector filteredErrors = new Vector();
    int sortColumn = -1;
    String visibleSource = null;
    boolean showPanic = true;
    boolean showError = true;
    boolean showWarning = true;
    ErrorPanel peerPanel = null;

    ErrorAdapter() {
    }

    public void setErrorPanel(ErrorPanel errorPanel) {
        this.peerPanel = errorPanel;
    }

    synchronized void clearError() {
        this.errors = new Vector();
        this.filteredErrors = new Vector();
        this.nbError = 0;
        this.fireSourceChange();
        this.updateFilters();
    }

    public synchronized void addError(ErrorEvent errorEvent) {
        boolean bl;
        String string = errorEvent.getSource().toString();
        if (string == null) {
            System.out.println("ErrorAdapter.addError() : Warning cannot handle error with null source !");
            System.out.println("ErrorAdapter.addError() : " + errorEvent.getError());
            return;
        }
        int n = this.getSourceIndex(string);
        if (n >= 0) {
            bl = ((ErrorList)this.errors.get(n)).addError(errorEvent.getError(), errorEvent.getTimeStamp());
        } else {
            ErrorList errorList = new ErrorList(string);
            bl = errorList.addError(errorEvent.getError(), errorEvent.getTimeStamp());
            this.errors.add(errorList);
            this.fireSourceChange();
        }
        if (bl) {
            if (this.nbError >= this.errorBufferSize) {
                ErrorList errorList;
                int n2 = -1;
                long l = Long.MAX_VALUE;
                n = 0;
                n = 0;
                while (n < this.errors.size()) {
                    errorList = (ErrorList)this.errors.get(0);
                    if (errorList.get(0).getTime() < l) {
                        l = errorList.get(0).getTime();
                        n2 = n;
                    }
                    ++n;
                }
                if (n2 >= 0) {
                    errorList = (ErrorList)this.errors.get(n2);
                    errorList.removeFirst();
                    if (errorList.size() == 0) {
                        this.errors.remove(errorList);
                        this.fireSourceChange();
                    }
                }
            } else {
                ++this.nbError;
            }
        }
        this.updateFilters();
    }

    public int getErrorBufferSize() {
        return this.errorBufferSize;
    }

    public void setErrorBufferSize(int n) {
        if (n > 100) {
            this.errorBufferSize = n;
        }
    }

    public void setTimeFormat(SimpleDateFormat simpleDateFormat) {
        this.format = simpleDateFormat;
    }

    public SimpleDateFormat getTimeFormat() {
        return this.format;
    }

    public void setSourceFilter(String string) {
        this.visibleSource = string;
        this.updateFilters();
    }

    public void setSortedColumn(int n) {
        this.sortColumn = n;
        this.updateFilters();
    }

    public void showPanic(boolean bl) {
        this.showPanic = bl;
        this.updateFilters();
    }

    public void showError(boolean bl) {
        this.showError = bl;
        this.updateFilters();
    }

    public void showWarning(boolean bl) {
        this.showWarning = bl;
        this.updateFilters();
    }

    public DevError[] getErrorNumber(int n) {
        Throwable throwable = ((ErrorObject)this.filteredErrors.get(n)).getError();
        if (!(throwable instanceof ATKException)) {
            return null;
        }
        return ((ATKException)throwable).getErrors();
    }

    public Throwable getErrorAt(int n) {
        return ((ErrorObject)this.filteredErrors.get(n)).getError();
    }

    public Vector getAllSource() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.errors.size()) {
            vector.add(((ErrorList)this.errors.get((int)n)).source);
            ++n;
        }
        return vector;
    }

    public Object getValueAt(int n, int n2) {
        ErrorObject errorObject = (ErrorObject)this.filteredErrors.get(n);
        switch (n2) {
            case 0: {
                Date date = new Date(errorObject.getTime());
                return this.format.format(date);
            }
            case 1: {
                return errorObject.getSeverity();
            }
            case 3: {
                return errorObject.getMessage();
            }
            case 2: {
                return errorObject.getSource();
            }
        }
        return "";
    }

    public int getRowCount() {
        return this.filteredErrors.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    /*
     * Unable to fully structure code
     */
    private int getSourceIndex(String var1_1) {
        var2_2 = 0;
        var3_3 = false;
        if (var1_1 != null) ** GOTO lbl8
        return -1;
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1.equalsIgnoreCase(((ErrorList)this.errors.get((int)var2_2)).source);
            if (var3_3) continue;
            ++var2_2;
lbl8:
            // 3 sources

            ** while (!var3_3 && var2_2 < this.errors.size())
        }
lbl9:
        // 1 sources

        if (!var3_3) {
            return -1;
        }
        return var2_2;
    }

    private void updateFilters() {
        Vector vector = new Vector();
        int n = this.getSourceIndex(this.visibleSource);
        if (n >= 0) {
            ErrorList errorList = (ErrorList)this.errors.get(n);
            int n2 = 0;
            while (n2 < errorList.size()) {
                this.insertError(vector, errorList.get(n2));
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.errors.size()) {
                ErrorList errorList = (ErrorList)this.errors.get(n3);
                int n4 = 0;
                while (n4 < errorList.size()) {
                    this.insertError(vector, errorList.get(n4));
                    ++n4;
                }
                ++n3;
            }
        }
        this.filteredErrors = vector;
        this.fireTableDataChanged();
    }

    private void insertError(Vector vector, ErrorObject errorObject) {
        if (!this.wanted(errorObject)) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        boolean bl = false;
        switch (this.sortColumn) {
            case 0: {
                while (!bl && n2 < n) {
                    ErrorObject errorObject2 = (ErrorObject)vector.get(n2);
                    boolean bl2 = bl = errorObject.getTime() <= errorObject2.getTime();
                    if (bl) continue;
                    ++n2;
                }
                break;
            }
            case 1: {
                while (!bl && n2 < n) {
                    ErrorObject errorObject3 = (ErrorObject)vector.get(n2);
                    int n3 = errorObject.getSeverity().compareToIgnoreCase(errorObject3.getSeverity());
                    boolean bl3 = bl = n3 < 0 || n3 == 0 && errorObject.getTime() <= errorObject3.getTime();
                    if (bl) continue;
                    ++n2;
                }
                break;
            }
            case 2: {
                while (!bl && n2 < n) {
                    ErrorObject errorObject4 = (ErrorObject)vector.get(n2);
                    int n4 = errorObject.getSource().compareToIgnoreCase(errorObject4.getSource());
                    boolean bl4 = bl = n4 < 0 || n4 == 0 && errorObject.getTime() <= errorObject4.getTime();
                    if (bl) continue;
                    ++n2;
                }
                break;
            }
            case 3: {
                while (!bl && n2 < n) {
                    ErrorObject errorObject5 = (ErrorObject)vector.get(n2);
                    int n5 = errorObject.getMessage().compareToIgnoreCase(errorObject5.getMessage());
                    boolean bl5 = bl = n5 < 0 || n5 == 0 && errorObject.getTime() <= errorObject5.getTime();
                    if (bl) continue;
                    ++n2;
                }
                break;
            }
            default: {
                vector.add(errorObject);
                return;
            }
        }
        vector.add(n2, errorObject);
    }

    private boolean wanted(ErrorObject errorObject) {
        if (!this.showPanic && errorObject.getSeverity().equals(ATKException.severity[2])) {
            return false;
        }
        if (!this.showError && errorObject.getSeverity().equals(ATKException.severity[1])) {
            return false;
        }
        return this.showWarning || !errorObject.getSeverity().equals(ATKException.severity[0]);
    }

    private void fireSourceChange() {
        if (this.peerPanel != null) {
            this.peerPanel.sourceChange();
        }
    }
}

