/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DeviceFinder
extends JPanel {
    Domain[] domains = new Domain[0];
    String deviceName = null;
    JDialog parent;
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("Devices");
    private JLabel label;
    private JTextField inputField;
    private JScrollPane jScrollPane1;
    private JTree deviceTree;
    private JButton ok;
    private JButton cancel;

    public DeviceFinder(JDialog jDialog) {
        this();
        this.parent = jDialog;
    }

    public DeviceFinder() {
        try {
            Database database = new Database();
            String[] stringArray = database.get_device_domain("*");
            this.addDomains(this.top, database, stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.deviceTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)DeviceFinder.this.deviceTree.getLastSelectedPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (defaultMutableTreeNode == null || !(object instanceof ANode)) {
                    return;
                }
                DeviceFinder.this.inputField.setText(((ANode)object).getName());
            }
        });
    }

    private void addDomains(DefaultMutableTreeNode defaultMutableTreeNode, Database database, String[] stringArray) throws DevFailed {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        this.domains = new Domain[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Domain domain = new Domain(string, database);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(domain);
            String[] stringArray2 = database.get_device_family(string + "/*");
            domain.setNode(defaultMutableTreeNode2);
            this.domains[n] = domain;
            this.initialAddFamilies(defaultMutableTreeNode2, database, domain, stringArray2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
    }

    private void initialAddFamilies(DefaultMutableTreeNode defaultMutableTreeNode, Database database, Domain domain, String[] stringArray) throws DevFailed {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String[] stringArray2 = database.get_device_member(domain.getName() + string + "/*");
            Family family = new Family(domain, string, database);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(family);
            family.setNode(defaultMutableTreeNode2);
            domain.addFamily(family);
            this.initialAddMembers(defaultMutableTreeNode2, database, family, stringArray2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
    }

    private void initialAddMembers(DefaultMutableTreeNode defaultMutableTreeNode, Database database, Family family, String[] stringArray) throws DevFailed {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Member member = new Member(family, string, database);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(member);
            family.addMember(member);
            member.setNode(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
    }

    private void openPath(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.deviceTree.getSelectionModel().setSelectionPath(treePath);
        this.deviceTree.expandPath(treePath);
    }

    private void initComponents() {
        this.label = new JLabel();
        this.inputField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.deviceTree = new JTree(this.top);
        this.ok = new JButton();
        this.cancel = new JButton();
        this.setLayout(new GridBagLayout());
        this.label.setFont(new Font("Dialog", 0, 12));
        this.label.setText("Device");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 9, 5);
        this.add((Component)this.label, gridBagConstraints);
        this.inputField.setColumns(40);
        this.inputField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                DeviceFinder.this.inputFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 10, 10);
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.inputField, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.deviceTree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.ok.setFont(new Font("Dialog", 0, 12));
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeviceFinder.this.okActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 9, 10);
        this.add((Component)this.ok, gridBagConstraints);
        this.cancel.setFont(new Font("Dialog", 0, 12));
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeviceFinder.this.cancelActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 9, 0);
        this.add((Component)this.cancel, gridBagConstraints);
    }

    private void okActionPerformed(ActionEvent actionEvent) {
        if (this.parent != null) {
            this.parent.dispose();
        }
        this.deviceName = this.inputField.getText();
    }

    private void cancelActionPerformed(ActionEvent actionEvent) {
        if (this.parent != null) {
            this.parent.dispose();
        }
        this.deviceName = null;
    }

    private synchronized void inputFieldKeyTyped(KeyEvent keyEvent) {
        if (Character.isISOControl(keyEvent.getKeyChar())) {
            return;
        }
        this.inputField.setEditable(false);
        String string = this.inputField.getText() + keyEvent.getKeyChar();
        Domain domain = null;
        Family family = null;
        Member member = null;
        String string2 = string;
        String string3 = null;
        String string4 = null;
        if (string.indexOf(47) != -1) {
            try {
                string2 = string.substring(0, string.indexOf(47));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String string5;
                string3 = string5 = string.substring(string.indexOf(47) + 1, string.length());
                string3 = string5.substring(0, string5.indexOf(47));
                string4 = string5.substring(string5.indexOf(47) + 1, string5.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((domain = this.findDomain(string2)) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            keyEvent.consume();
            family = domain.findFamily(string3);
            if (family != null) {
                member = family.findMember(string4);
                if (member != null) {
                    defaultMutableTreeNode = member.getNode();
                    string = member.getName();
                } else {
                    defaultMutableTreeNode = family.getNode();
                    string = family.getName() + (string4 == null ? "" : string4);
                }
            } else {
                defaultMutableTreeNode = domain.getNode();
                string = domain.getName() + (string3 == null ? "" : string3);
            }
            this.openPath(defaultMutableTreeNode);
            this.inputField.setText(string);
        }
        this.inputField.setEditable(true);
    }

    Domain findDomain(String string) {
        if (this.domains.length == 1) {
            return this.domains[0];
        }
        int n = 0;
        Domain domain = null;
        int n2 = 0;
        while (n2 < this.domains.length) {
            if (this.domains[n2].toString().startsWith(string)) {
                domain = this.domains[n2];
                ++n;
            }
            ++n2;
        }
        if (n == 1) {
            return domain;
        }
        return null;
    }

    public String getDevice() {
        return this.deviceName;
    }

    public static String getDeviceName() {
        JDialog jDialog = new JDialog();
        DeviceFinder deviceFinder = new DeviceFinder(jDialog);
        jDialog.setContentPane(deviceFinder);
        jDialog.pack();
        jDialog.setModal(true);
        jDialog.show();
        System.out.println("> " + deviceFinder.getDevice());
        return deviceFinder.getDevice();
    }

    public static void main(String[] stringArray) {
        DeviceFinder.getDeviceName();
    }

    class Member
    extends ANode {
        Family family;

        Member(Family family, String string, Database database) {
            this.name = string;
            this.database = database;
            this.family = family;
        }

        public String getName() {
            return this.family.getName() + this.name;
        }
    }

    class Family
    extends ANode {
        Domain domain;
        Database database;
        List members = new Vector();
        DefaultMutableTreeNode node;

        Family(Domain domain, String string, Database database) {
            this.name = string;
            this.domain = domain;
            this.database = database;
        }

        public String getName() {
            return this.domain + "/" + this.name + "/";
        }

        public List getMembers() {
            return this.members;
        }

        public void addMember(Member member) {
            this.members.add(member);
        }

        Member findMember(String string) {
            if (this.members.size() == 1) {
                return (Member)this.members.get(0);
            }
            if (string == null) {
                return null;
            }
            int n = 0;
            Member member = null;
            int n2 = 0;
            while (n2 < this.members.size()) {
                Member member2 = (Member)this.members.get(n2);
                if (member2.toString().startsWith(string)) {
                    member = member2;
                    ++n;
                }
                ++n2;
            }
            if (n == 1) {
                return member;
            }
            return null;
        }
    }

    class Domain
    extends ANode {
        List families = new Vector();

        Domain(String string, Database database) {
            this.name = string;
            this.database = database;
        }

        Family findFamily(String string) {
            if (this.families.size() == 1) {
                return (Family)this.families.get(0);
            }
            if (string == null) {
                return null;
            }
            int n = 0;
            Family family = null;
            int n2 = 0;
            while (n2 < this.families.size()) {
                Family family2 = (Family)this.families.get(n2);
                System.out.println(family2 + " = " + string);
                if (family2.toString().startsWith(string)) {
                    family = family2;
                    ++n;
                }
                ++n2;
            }
            if (n == 1) {
                return family;
            }
            return null;
        }

        public String getName() {
            return this.name + "/";
        }

        public void addFamily(Family family) {
            this.families.add(family);
        }

        public List getFamilies() {
            return this.families;
        }
    }

    abstract class ANode {
        String name;
        DefaultMutableTreeNode node;
        Database database;

        ANode() {
        }

        public abstract String getName();

        public void setNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.node = defaultMutableTreeNode;
        }

        public DefaultMutableTreeNode getNode() {
            return this.node;
        }

        public String toString() {
            return this.name;
        }
    }
}

