/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.jloox;

import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxDigit;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxEnterLeaveAdapter;
import com.loox.jloox.LxEnterLeaveListener;
import com.loox.jloox.LxGroup;
import com.loox.jloox.LxMouseAdapter;
import com.loox.jloox.LxMouseEvent;
import com.loox.jloox.LxMouseListener;
import com.loox.jloox.LxMultiState;
import com.loox.jloox.LxPushButton;
import com.loox.jloox.LxSlider;
import com.loox.jloox.LxVariable;
import com.loox.jloox.LxVariableEvent;
import com.loox.jloox.LxVariableListener;
import com.loox.jloox.LxView;
import esrfSynopticJLM.ExtendedData;
import esrfSynopticJLM.ExtendedGraph;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.core.attribute.AttributeFactory;
import fr.esrf.tangoatk.core.command.CommandFactory;
import fr.esrf.tangoatk.core.command.InvalidCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.command.AnyCommandViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Paint;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TangoSynopticHandler
implements IStateListener,
IStatusListener,
INumberScalarListener {
    public static final int TOOL_TIP_NONE = 0;
    public static final int TOOL_TIP_STATE = 1;
    public static final int TOOL_TIP_STATUS = 2;
    public static final int TOOL_TIP_NAME = 3;
    private static final String TACO_HEADER = "taco:";
    private static final int STATE_INDEX = 0;
    private static final int STATUS_INDEX = 1;
    private static Map dynoState = new HashMap();
    private int toolTipMode;
    private LxAbstractGraph graph = null;
    private LxView view = null;
    private String jlooxFileName = null;
    private AttributeFactory aFac = null;
    private CommandFactory cFac = null;
    private DeviceFactory dFac = null;
    private AttributeList lxAtl = null;
    private List lxDevl = null;
    private LxComponent[] lxComps = null;
    private Map lxHash;
    private Map stateCashHash;
    private Map panelHash;
    private AnyCommandViewer acv = null;
    private JFrame argFrame = null;
    private ErrorHistory errorHistWind = null;

    public TangoSynopticHandler() {
        ExtendedGraph extendedGraph = new ExtendedGraph();
        LxView lxView = new LxView();
        this.toolTipMode = 0;
        this.jlooxFileName = null;
        lxView.setGraph((LxAbstractGraph)extendedGraph);
        this.graph = extendedGraph;
        this.view = lxView;
        this.aFac = AttributeFactory.getInstance();
        this.cFac = CommandFactory.getInstance();
        this.dFac = DeviceFactory.getInstance();
    }

    public TangoSynopticHandler(String string) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        this.setJlooxFileName(string);
    }

    public TangoSynopticHandler(String string, ErrorHistory errorHistory) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        if (errorHistory != null) {
            this.errorHistWind = errorHistory;
        }
        this.setJlooxFileName(string);
    }

    public TangoSynopticHandler(String string, int n) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            this.toolTipMode = n;
        }
        this.setJlooxFileName(string);
    }

    public int getToolTipMode() {
        return this.toolTipMode;
    }

    public void setToolTipMode(int n) {
        if ((n == 0 || n == 1 || n == 2 || n == 3) && this.toolTipMode != n) {
            if (n == 0) {
                this.view.activateEnterLeaveNotification(false);
            } else {
                this.view.activateEnterLeaveNotification(true);
            }
            this.toolTipMode = n;
        }
    }

    public LxView getJlooxView() {
        return this.view;
    }

    public String getJlooxFileName() {
        return this.jlooxFileName;
    }

    public void setJlooxFileName(String string) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this.lxHash = new HashMap();
        this.stateCashHash = new HashMap();
        FileReader fileReader = new FileReader(string);
        String string2 = this.graph.read(string);
        if (string2 != null) {
            throw new IllegalArgumentException(string2);
        }
        this.lxComps = null;
        this.lxComps = this.graph.getComponents();
        if (this.graph.getComponentCount() == 0 || this.lxComps == null) {
            throw new MissingResourceException("The JLoox file has no component inside. First draw a JLoox File.", "LxGraph", null);
        }
        this.jlooxFileName = string;
        this.parseJlooxComponents(this.lxComps);
    }

    protected void parseJlooxComponents(LxComponent[] lxComponentArray) {
        int n = 0;
        while (n < lxComponentArray.length) {
            LxComponent lxComponent = lxComponentArray[n];
            String string = lxComponent.getName();
            if (this.isDevice(string)) {
                this.addDevice(lxComponent, string);
            } else if (this.isCommand(string)) {
                this.addCommand(lxComponent, string);
            } else if (this.isAttribute(string)) {
                this.addAttribute(lxComponent, string);
            }
            ++n;
        }
    }

    protected boolean isAttribute(String string) {
        int n = string.lastIndexOf("/");
        if (n <= 0 || n >= string.length()) {
            return false;
        }
        try {
            String string2 = string.substring(0, n);
            boolean bl = this.isDevice(string2);
            if (!bl) {
                return false;
            }
            String string3 = string.substring(n, string.length());
            boolean bl2 = Pattern.matches("/[a-zA-Z_0-9[-]]+", string3);
            if (!bl2) {
                return false;
            }
            return this.aFac.isAttribute(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    protected boolean isCommand(String string) {
        int n = string.lastIndexOf("/");
        if (n <= 0 || n >= string.length()) {
            return false;
        }
        try {
            String string2 = string.substring(0, n);
            boolean bl = this.isDevice(string2);
            if (!bl) {
                return false;
            }
            String string3 = string.substring(n, string.length());
            boolean bl2 = Pattern.matches("/[a-zA-Z_0-9[-]]+", string3);
            if (!bl2) {
                return false;
            }
            return this.cFac.isCommand(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    protected boolean isDevice(String string) {
        boolean bl = Pattern.matches("//[a-zA-Z_0-9]+:[0-9]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", string);
        if (!bl) {
            bl = Pattern.matches("[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[[a-zA-Z_0-9][-]]+", string);
        }
        if (!bl) {
            bl = Pattern.matches("taco:[a-zA-Z_0-9]+/[a-zA-Z_0-9]+/[a-zA-Z_0-9]+", string);
        }
        if (bl) {
            return this.dFac.isDevice(string);
        }
        return false;
    }

    private void addDevice(LxComponent lxComponent, String string) {
        try {
            this.addDeviceListener(this.dFac.getDevice(string));
            this.mouseify(lxComponent, string);
            this.stashComponent(string, lxComponent);
            this.addDevToStateCashHashMap(string);
        }
        catch (ConnectionException connectionException) {
            System.out.println("Couldn't load device " + string + " " + (Object)((Object)connectionException));
        }
    }

    private void addDeviceListener(Device device) {
        System.out.println("connecting to " + device);
        device.addStateListener((IStateListener)this);
        device.addStatusListener((IStatusListener)this);
        if (this.errorHistWind != null) {
            device.addErrorListener((IErrorListener)this.errorHistWind);
        }
    }

    private void mouseify(LxComponent lxComponent, String string) {
        lxComponent.addMouseListener((LxMouseListener)new LxMouseAdapter(){

            public void mousePressed(LxMouseEvent lxMouseEvent) {
                TangoSynopticHandler.this.deviceClicked(lxMouseEvent);
            }
        });
        lxComponent.addEnterLeaveListener((LxEnterLeaveListener)new LxEnterLeaveAdapter(){

            public void mouseEntered(LxMouseEvent lxMouseEvent) {
                TangoSynopticHandler.this.devDisplayToolTip(lxMouseEvent);
            }

            public void mouseExited(LxMouseEvent lxMouseEvent) {
                TangoSynopticHandler.this.devRemoveToolTip(lxMouseEvent);
            }
        });
    }

    private void deviceClicked(LxMouseEvent lxMouseEvent) {
        Constructor<?> constructor;
        LxComponent lxComponent = lxMouseEvent.getLxComponent();
        String string = lxComponent.getName();
        Object object = lxComponent.getUserData();
        String string2 = null;
        String string3 = null;
        if (object != null) {
            if (object instanceof ExtendedData) {
                ExtendedData extendedData = (ExtendedData)object;
                string2 = extendedData.getClassName();
                if (string2 != null) {
                    string3 = extendedData.getConstParameter();
                } else {
                    string2 = "atkpanel.MainPanel";
                    string3 = null;
                }
            } else {
                string2 = "atkpanel.MainPanel";
                string3 = null;
            }
        } else {
            string2 = "atkpanel.MainPanel";
            string3 = null;
        }
        System.out.println("clName = " + string2 + "  constParam = " + string3 + " devName = " + string);
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        try {
            Class<?> clazz = Class.forName(string2);
            classArray[0] = string2.getClass();
            constructor = clazz.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "The panel class : " + string2 + " not found; ignored.\n");
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Failed to load the constructor " + string2 + "( String ) for the panel class.\n");
            return;
        }
        objectArray[0] = string3 == null ? string : (string3.length() > 0 ? string3 : string);
        System.out.println("params[0]= " + objectArray[0]);
        try {
            constructor.newInstance(objectArray);
            Thread.sleep(500L);
        }
        catch (InstantiationException instantiationException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 1 the panel class : " + string2 + ".\n");
        }
        catch (IllegalAccessException illegalAccessException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 2 the panel class : " + string2 + ".\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 3 the panel class : " + string2 + ".\n");
        }
        catch (InvocationTargetException invocationTargetException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 4 the panel class : " + string2 + ".\n");
            System.out.println(invocationTargetException);
            System.out.println(invocationTargetException.getMessage());
            invocationTargetException.printStackTrace();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Got an exception when instantiate the panel class : " + string2 + ".\n");
        }
    }

    private void stashComponent(String string, LxComponent lxComponent) {
        Vector<LxComponent> vector = (Vector<LxComponent>)this.lxHash.get(string);
        if (vector == null) {
            vector = new Vector<LxComponent>();
        }
        vector.add(lxComponent);
        this.lxHash.put(string, vector);
    }

    private void addDevToStateCashHashMap(String string) {
        Vector<String> vector = (Vector<String>)this.stateCashHash.get(string);
        if (vector != null) {
            return;
        }
        vector = new Vector<String>();
        String string2 = new String("no status");
        vector.add(0, string2);
        vector.add(1, string2);
        this.stateCashHash.put(string, vector);
    }

    private void addCommand(LxComponent lxComponent, String string) {
        if (lxComponent instanceof LxPushButton) {
            this.addCommmand((LxPushButton)lxComponent, string);
        }
    }

    private void addCommmand(LxPushButton lxPushButton, String string) {
        ICommand iCommand = null;
        try {
            iCommand = this.cFac.getCommand(string);
            if (iCommand != null) {
                this.mouseify(lxPushButton, iCommand);
            }
        }
        catch (ConnectionException connectionException) {
            System.out.println("Couldn't load device for command" + string + " " + (Object)((Object)connectionException));
        }
        catch (DevFailed devFailed) {
            System.out.println("Couldn't find the command" + string + " " + (Object)((Object)devFailed));
        }
    }

    private void mouseify(LxPushButton lxPushButton, ICommand iCommand) {
        final ICommand iCommand2 = iCommand;
        lxPushButton.addVariableListener(new LxVariableListener(){

            public void valueChanged(LxVariableEvent lxVariableEvent) {
                LxVariable lxVariable = null;
                lxVariable = lxVariableEvent.getVariable();
                if (lxVariable instanceof LxPushButton) {
                    LxPushButton lxPushButton = null;
                    lxPushButton = (LxPushButton)lxVariable;
                    if (lxPushButton.getState()) {
                        System.out.println("Acommand is " + iCommand2);
                        TangoSynopticHandler.this.commandClicked(iCommand2);
                    }
                }
            }
        });
    }

    private void commandClicked(ICommand iCommand) {
        if (iCommand instanceof InvalidCommand) {
            JOptionPane.showMessageDialog((Component)this.view, iCommand.getName() + " is not supported. ", "Error", 1);
            return;
        }
        if (iCommand instanceof VoidVoidCommand) {
            iCommand.execute();
            return;
        }
        if (this.acv == null) {
            this.argFrame = new JFrame();
            this.acv = new AnyCommandViewer();
            this.argFrame.getContentPane().add(this.acv);
        }
        this.acv.initialize(iCommand);
        this.acv.setBorder(null);
        this.acv.setInputVisible(true);
        this.acv.setDeviceButtonVisible(true);
        this.acv.setDescriptionVisible(true);
        this.acv.setInfoButtonVisible(true);
        if (!iCommand.takesInput()) {
            iCommand.execute();
        }
        this.argFrame.setTitle(iCommand.getName());
        this.argFrame.pack();
        this.argFrame.show();
    }

    private void addAttribute(LxComponent lxComponent, String string) {
        if (lxComponent instanceof LxDigit) {
            this.addAttribute((LxDigit)lxComponent, string);
        }
        if (lxComponent instanceof LxSlider) {
            this.addAttribute((LxSlider)lxComponent, string);
        }
    }

    private void addAttribute(LxDigit lxDigit, String string) {
        IAttribute iAttribute = null;
        try {
            iAttribute = this.aFac.getAttribute(string);
            if (iAttribute != null && iAttribute instanceof INumberScalar) {
                this.addAttributeListener((INumberScalar)iAttribute);
                this.stashComponent(string, (LxComponent)lxDigit);
            }
        }
        catch (ConnectionException connectionException) {
            System.out.println("Couldn't load device for attribute" + string + " " + (Object)((Object)connectionException));
        }
        catch (DevFailed devFailed) {
            System.out.println("Couldn't find the attribute" + string + " " + (Object)((Object)devFailed));
        }
    }

    private void addAttribute(LxSlider lxSlider, String string) {
        IAttribute iAttribute = null;
        try {
            iAttribute = this.aFac.getAttribute(string);
            if (iAttribute != null && iAttribute instanceof INumberScalar) {
                this.addAttributeListener((INumberScalar)iAttribute);
                this.stashComponent(string, (LxComponent)lxSlider);
            }
        }
        catch (ConnectionException connectionException) {
            System.out.println("Couldn't load device for attribute" + string + " " + (Object)((Object)connectionException));
        }
        catch (DevFailed devFailed) {
            System.out.println("Couldn't find the attribute" + string + " " + (Object)((Object)devFailed));
        }
    }

    private void addAttributeListener(INumberScalar iNumberScalar) {
        System.out.println("connecting to a number scalar attribute : " + iNumberScalar);
        iNumberScalar.addNumberScalarListener((INumberScalarListener)this);
        if (this.errorHistWind != null) {
            iNumberScalar.addErrorListener((IErrorListener)this.errorHistWind);
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        INumberScalar iNumberScalar = null;
        iNumberScalar = numberScalarEvent.getNumberSource();
        String string = iNumberScalar.getName();
        if (iNumberScalar != null) {
            List list = (List)this.lxHash.get(string);
            if (list == null) {
                return;
            }
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                LxComponent lxComponent = null;
                lxComponent = (LxComponent)list.get(n2);
                if (lxComponent != null) {
                    double d;
                    if (lxComponent instanceof LxDigit) {
                        LxDigit lxDigit = (LxDigit)lxComponent;
                        d = numberScalarEvent.getValue();
                        lxDigit.setValue(d);
                    }
                    if (lxComponent instanceof LxSlider) {
                        LxSlider lxSlider = (LxSlider)lxComponent;
                        d = numberScalarEvent.getValue();
                        lxSlider.setValue(d);
                    }
                }
                ++n2;
            }
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public void stateChange(StateEvent stateEvent) {
        Object object;
        Device device = (Device)stateEvent.getSource();
        String string = device.getName();
        List list = null;
        list = (List)this.stateCashHash.get(string);
        if (list != null) {
            object = null;
            try {
                object = (String)list.get(0);
                if (object != null && ((String)object).equals(stateEvent.getState())) {
                    return;
                }
                object = new String(stateEvent.getState());
                list.set(0, object);
                this.stateCashHash.put(string, list);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if ((object = (List)this.lxHash.get(string)) == null) {
            return;
        }
        int n = object.size();
        int n2 = 0;
        while (n2 < n) {
            LxComponent lxComponent = (LxComponent)object.get(n2);
            if (lxComponent instanceof LxElement) {
                if (((LxElement)lxComponent).getPaint().getTransparency() == 1) {
                    ((LxElement)lxComponent).setPaint((Paint)ATKConstant.getColor4State(stateEvent.getState()));
                } else {
                    ((LxElement)lxComponent).setLineColor(ATKConstant.getColor4State(stateEvent.getState()));
                }
            } else if (lxComponent instanceof LxGroup) {
                this.groupChangeColor((LxGroup)lxComponent, stateEvent.getState());
            } else if (lxComponent instanceof LxMultiState) {
                this.multiStateDynoChange((LxMultiState)lxComponent, stateEvent.getState());
            }
            ++n2;
        }
    }

    public void statusChange(StatusEvent statusEvent) {
        Device device = (Device)statusEvent.getSource();
        String string = device.getName();
        List list = null;
        list = (List)this.stateCashHash.get(string);
        if (list != null) {
            String string2 = null;
            try {
                string2 = (String)list.get(1);
                if (string2 != null && string2.equals(statusEvent.getStatus())) {
                    return;
                }
                string2 = new String(statusEvent.getStatus());
                list.set(1, string2);
                this.stateCashHash.put(string, list);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return;
            }
        }
    }

    private void groupChangeColor(LxGroup lxGroup, String string) {
        if (lxGroup == null) {
            return;
        }
        LxComponent[] lxComponentArray = lxGroup.getComponents();
        int n = lxGroup.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            LxComponent lxComponent = lxComponentArray[n2];
            if (lxComponent instanceof LxElement) {
                if (((LxElement)lxComponent).getPaint() == null) {
                    ((LxElement)lxComponent).setLineColor(ATKConstant.getColor4State(string));
                } else if (((LxElement)lxComponent).getPaint().getTransparency() == 1) {
                    ((LxElement)lxComponent).setPaint((Paint)ATKConstant.getColor4State(string));
                } else {
                    ((LxElement)lxComponent).setLineColor(ATKConstant.getColor4State(string));
                }
            } else if (lxComponent instanceof LxGroup) {
                this.groupChangeColor((LxGroup)lxComponent, string);
            } else if (lxComponent instanceof LxMultiState) {
                this.multiStateDynoChange((LxMultiState)lxComponent, string);
            }
            ++n2;
        }
    }

    private int getDynoState(String string) {
        Integer n = (Integer)dynoState.get(string);
        return n;
    }

    private void multiStateDynoChange(LxMultiState lxMultiState, String string) {
        int n = this.getDynoState(string);
        try {
            lxMultiState.setValue(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = this.getDynoState("UNKNOWN");
            lxMultiState.setValue(n);
        }
    }

    public void devDisplayToolTip(LxMouseEvent lxMouseEvent) {
        List list = null;
        String string = null;
        if (this.toolTipMode == 0) {
            this.view.setToolTipText(null);
            return;
        }
        if (this.toolTipMode == 3) {
            LxComponent lxComponent = lxMouseEvent.getLxComponent();
            String string2 = lxComponent.getName();
            this.view.setToolTipText(string2);
            return;
        }
        if (this.toolTipMode == 1) {
            LxComponent lxComponent = lxMouseEvent.getLxComponent();
            String string3 = lxComponent.getName();
            list = (List)this.stateCashHash.get(string3);
            if (list == null) {
                this.view.setToolTipText(null);
                return;
            }
            try {
                string = (String)list.get(0);
                if (string == null) {
                    this.view.setToolTipText(null);
                    return;
                }
                this.view.setToolTipText(string);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.view.setToolTipText(null);
                return;
            }
        }
        this.view.setToolTipText(null);
    }

    public void devRemoveToolTip(LxMouseEvent lxMouseEvent) {
        this.view.setToolTipText(null);
    }

    public static void main(String[] stringArray) {
        TangoSynopticHandler tangoSynopticHandler = new TangoSynopticHandler();
        try {
            tangoSynopticHandler.setJlooxFileName("/users/poncet/ATK_OLD/jloox_files/id14_4.jlx");
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("Prog Aborted.");
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        LxView lxView = tangoSynopticHandler.getJlooxView();
        lxView.fitToGraph(20, 20);
        jFrame.setContentPane((Container)lxView);
        jFrame.pack();
        jFrame.show();
    }

    static {
        dynoState.put("UNKNOWN", new Integer(0));
        dynoState.put("OFF", new Integer(1));
        dynoState.put("CLOSE", new Integer(1));
        dynoState.put("EXTRACT", new Integer(1));
        dynoState.put("INIT", new Integer(1));
        dynoState.put("DISABLE", new Integer(1));
        dynoState.put("ON", new Integer(2));
        dynoState.put("OPEN", new Integer(2));
        dynoState.put("INSERT", new Integer(2));
        dynoState.put("ALARM", new Integer(3));
        dynoState.put("FAULT", new Integer(4));
        dynoState.put("MOVING", new Integer(5));
        dynoState.put("RUNNING", new Integer(5));
        dynoState.put("STANDBY", new Integer(6));
    }
}

