/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.jdraw;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.AttributeFactory;
import fr.esrf.tangoatk.core.command.CommandFactory;
import fr.esrf.tangoatk.core.command.InvalidCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.command.AnyCommandViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDMouseAdapter;
import fr.esrf.tangoatk.widget.util.jdraw.JDMouseEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TangoSynopticHandler
extends JDrawEditor
implements IStateListener,
IStatusListener,
INumberScalarListener,
IDevStateScalarListener {
    public static final int TOOL_TIP_NONE = 0;
    public static final int TOOL_TIP_STATE = 1;
    public static final int TOOL_TIP_STATUS = 2;
    public static final int TOOL_TIP_NAME = 3;
    private static final int STATE_INDEX = 0;
    private static final int STATUS_INDEX = 1;
    private static Map dynoState = new HashMap();
    private int toolTipMode = 0;
    private String jdrawFileFullName = null;
    private AttributeFactory aFac = AttributeFactory.getInstance();
    private CommandFactory cFac = CommandFactory.getInstance();
    private DeviceFactory dFac = DeviceFactory.getInstance();
    private AttributeList allAttributes = new AttributeList();
    private Map jdHash;
    private Map stateCashHash;
    private AnyCommandViewer acv = null;
    private JFrame argFrame = null;
    private ErrorHistory errorHistWind = null;

    public TangoSynopticHandler() {
        super(3);
    }

    public TangoSynopticHandler(String string) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        this.setSynopticFileName(string);
    }

    public TangoSynopticHandler(String string, ErrorHistory errorHistory) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        if (errorHistory != null) {
            this.errorHistWind = errorHistory;
        }
        this.setSynopticFileName(string);
    }

    public TangoSynopticHandler(String string, int n) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            this.toolTipMode = n;
        }
        this.setSynopticFileName(string);
    }

    public int getToolTipMode() {
        return this.toolTipMode;
    }

    public void setToolTipMode(int n) {
        if ((n == 0 || n == 1 || n == 2 || n == 3) && this.toolTipMode != n) {
            this.toolTipMode = n;
        }
    }

    public ErrorHistory getErrorHistoryWindow() {
        return this.errorHistWind;
    }

    public void setErrorHistoryWindow(ErrorHistory errorHistory) {
        if (errorHistory == null) {
            return;
        }
        if (this.jdrawFileFullName != null) {
            return;
        }
        this.errorHistWind = errorHistory;
    }

    public String getSynopticFileName() {
        return this.jdrawFileFullName;
    }

    public AttributeList getAttributeList() {
        return this.allAttributes;
    }

    public void setSynopticFileName(String string) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this.jdHash = new HashMap();
        this.stateCashHash = new HashMap();
        try {
            this.loadFile(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        if (this.getObjectNumber() == 0) {
            throw new MissingResourceException("The Jdraw file has no component inside. First draw a Jdraw File.", "JDrawEditor", null);
        }
        this.jdrawFileFullName = string;
        this.parseJdrawComponents();
        this.computePreferredSize();
        if (this.allAttributes.size() > 0) {
            int n = 0;
            while (n < this.allAttributes.size()) {
                ((AAttribute)this.allAttributes.elementAt(n)).refresh();
                ++n;
            }
            this.allAttributes.startRefresher();
        }
    }

    protected void parseJdrawComponents() {
        int n = 0;
        while (n < this.getObjectNumber()) {
            JDObject jDObject = this.getObjectAt(n);
            String string = jDObject.getName();
            if (this.isDevice(string)) {
                this.addDevice(jDObject, string);
            } else if (this.isAttribute(string)) {
                this.addAttribute(jDObject, string);
            } else if (this.isCommand(string)) {
                this.addCommand(jDObject, string);
            }
            ++n;
        }
    }

    protected boolean isAttribute(String string) {
        int n = string.lastIndexOf("/");
        if (n <= 0 || n >= string.length()) {
            return false;
        }
        try {
            String string2 = string.substring(0, n);
            boolean bl = this.isDevice(string2);
            if (!bl) {
                return false;
            }
            String string3 = string.substring(n, string.length());
            boolean bl2 = Pattern.matches("/[a-zA-Z_0-9[-]]+", string3);
            if (!bl2) {
                return false;
            }
            return this.aFac.isAttribute(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    protected boolean isCommand(String string) {
        int n = string.lastIndexOf("/");
        if (n <= 0 || n >= string.length()) {
            return false;
        }
        try {
            String string2 = string.substring(0, n);
            boolean bl = this.isDevice(string2);
            if (!bl) {
                return false;
            }
            String string3 = string.substring(n, string.length());
            boolean bl2 = Pattern.matches("/[a-zA-Z_0-9[-]]+", string3);
            if (!bl2) {
                return false;
            }
            return this.cFac.isCommand(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    protected boolean isDevice(String string) {
        if (!this.isDeviceName(string)) {
            return false;
        }
        return this.dFac.isDevice(string);
    }

    private boolean isDeviceName(String string) {
        boolean bl;
        String string2 = new String(string);
        if (string2.startsWith("tango:")) {
            string2 = string2.substring(6);
        }
        if (!(bl = Pattern.matches("//[a-zA-Z_0-9]+:[0-9]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", string2))) {
            bl = Pattern.matches("[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[[a-zA-Z_0-9][-]]+", string2);
        }
        if (!bl) {
            bl = Pattern.matches("taco:[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", string2);
        }
        if (!bl) {
            bl = Pattern.matches("//[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+:[0-9]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", string2);
        }
        return bl;
    }

    private void addDevice(JDObject jDObject, String string) {
        try {
            this.addDeviceListener(this.dFac.getDevice(string));
            this.mouseifyDevice(jDObject);
            this.stashComponent(string, jDObject);
            this.addDevToStateCashHashMap(string);
        }
        catch (ConnectionException connectionException) {
            System.out.println("Couldn't load device " + string + " " + (Object)((Object)connectionException));
        }
    }

    private void addDeviceListener(Device device) {
        System.out.println("connecting to a device : " + device);
        device.addStateListener((IStateListener)this);
        device.addStatusListener((IStatusListener)this);
        if (this.errorHistWind != null) {
            device.addErrorListener((IErrorListener)this.errorHistWind);
        }
    }

    private void mouseifyDevice(JDObject jDObject) {
        jDObject.addMouseListener(new JDMouseAdapter(){

            public void mousePressed(JDMouseEvent jDMouseEvent) {
                TangoSynopticHandler.this.deviceClicked(jDMouseEvent);
            }

            public void mouseEntered(JDMouseEvent jDMouseEvent) {
                TangoSynopticHandler.this.devDisplayToolTip(jDMouseEvent);
            }

            public void mouseExited(JDMouseEvent jDMouseEvent) {
                TangoSynopticHandler.this.devRemoveToolTip();
            }
        });
    }

    private void mouseifyAttribute(JDObject jDObject) {
        jDObject.addMouseListener(new JDMouseAdapter(){

            public void mousePressed(JDMouseEvent jDMouseEvent) {
                TangoSynopticHandler.this.attributeClicked(jDMouseEvent);
            }

            public void mouseEntered(JDMouseEvent jDMouseEvent) {
                TangoSynopticHandler.this.attDisplayToolTip(jDMouseEvent);
            }

            public void mouseExited(JDMouseEvent jDMouseEvent) {
                TangoSynopticHandler.this.attRemoveToolTip();
            }
        });
    }

    private void mouseifyStateAttribute(JDObject jDObject) {
        jDObject.addMouseListener(new JDMouseAdapter(){

            public void mousePressed(JDMouseEvent jDMouseEvent) {
                TangoSynopticHandler.this.stateAttributeClicked(jDMouseEvent);
            }

            public void mouseEntered(JDMouseEvent jDMouseEvent) {
                TangoSynopticHandler.this.devDisplayToolTip(jDMouseEvent);
            }

            public void mouseExited(JDMouseEvent jDMouseEvent) {
                TangoSynopticHandler.this.devRemoveToolTip();
            }
        });
    }

    private void deviceClicked(JDMouseEvent jDMouseEvent) {
        JDObject jDObject = (JDObject)jDMouseEvent.getSource();
        String string = jDObject.getName();
        this.launchPanel(jDObject, string, true);
    }

    private void attributeClicked(JDMouseEvent jDMouseEvent) {
        JDObject jDObject = (JDObject)jDMouseEvent.getSource();
        String string = jDObject.getName();
        this.launchPanel(jDObject, string, false);
    }

    private void stateAttributeClicked(JDMouseEvent jDMouseEvent) {
        JDObject jDObject = (JDObject)jDMouseEvent.getSource();
        String string = jDObject.getName();
        int n = string.lastIndexOf(47);
        if (n > 0) {
            String string2 = string.substring(0, n);
            this.launchPanel(jDObject, string2, true);
        }
    }

    private void launchPanel(JDObject jDObject, String string, boolean bl) {
        Constructor<?> constructor;
        if (!jDObject.hasExtendedParam("className")) {
            if (bl) {
                this.showDefaultPanel(string);
            }
            return;
        }
        String string2 = jDObject.getExtendedParam("className");
        String string3 = jDObject.getExtendedParam("classParam");
        if (string3.length() == 0) {
            string3 = null;
        }
        System.out.println("clName = " + string2 + "  constParam = " + string3 + " compName = " + string);
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        try {
            Class<?> clazz = Class.forName(string2);
            classArray[0] = string.getClass();
            constructor = clazz.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "The panel class : " + string2 + " not found; ignored.\n");
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Failed to load the constructor " + string2 + "( String ) for the panel class.\n");
            return;
        }
        objectArray[0] = string3 == null ? string : (string3.length() > 0 ? string3 : string);
        System.out.println("params[0]= " + objectArray[0]);
        try {
            constructor.newInstance(objectArray);
            Thread.sleep(500L);
        }
        catch (InstantiationException instantiationException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 1 the panel class : " + string2 + ".\n");
        }
        catch (IllegalAccessException illegalAccessException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 2 the panel class : " + string2 + ".\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 3 the panel class : " + string2 + ".\n");
        }
        catch (InvocationTargetException invocationTargetException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 4 the panel class : " + string2 + ".\n");
            System.out.println(invocationTargetException);
            System.out.println(invocationTargetException.getMessage());
            invocationTargetException.printStackTrace();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Got an exception when instantiate the panel class : " + string2 + ".\n");
        }
    }

    private void showDefaultPanel(String string) {
        Constructor<?> constructor;
        Class<?> clazz;
        Class[] classArray = new Class[5];
        Object[] objectArray = new Object[5];
        System.out.println("showDefaultPanel called");
        try {
            clazz = Class.forName("atkpanel.MainPanel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "showDefaultPanel : atkpanel.MainPanel not found; ignored.\n");
            return;
        }
        try {
            classArray[0] = string.getClass();
            classArray[1] = Class.forName("java.lang.Boolean");
            classArray[2] = classArray[1];
            classArray[3] = classArray[1];
            classArray[4] = classArray[1];
            constructor = clazz.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "showDefaultPanel :java.lang.Boolean not found; ignored.\n");
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "showDefaultPanel : Failed to load the constructor (five arguments) for atkpanel read-only.\n");
            return;
        }
        objectArray[0] = string;
        objectArray[1] = Boolean.FALSE;
        objectArray[2] = Boolean.TRUE;
        objectArray[3] = Boolean.FALSE;
        objectArray[4] = Boolean.TRUE;
        try {
            constructor.newInstance(objectArray);
            Thread.sleep(500L);
        }
        catch (InstantiationException instantiationException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 1 the atkpanel read-only.\n");
        }
        catch (IllegalAccessException illegalAccessException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 2 the atkpanel read-only.\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 3 the atkpanel read-only.\n");
        }
        catch (InvocationTargetException invocationTargetException) {
            JOptionPane.showMessageDialog(null, "Failed to instantiate 4 the atkpanel read-only.\n");
            System.out.println(invocationTargetException);
            System.out.println(invocationTargetException.getMessage());
            invocationTargetException.printStackTrace();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Got an exception when instantiate the default panel : atkpanel readonly.\n");
        }
    }

    private void stashComponent(String string, JDObject jDObject) {
        Vector<JDObject> vector = (Vector<JDObject>)this.jdHash.get(string);
        if (vector == null) {
            vector = new Vector<JDObject>();
        }
        vector.add(jDObject);
        this.jdHash.put(string, vector);
    }

    private void addDevToStateCashHashMap(String string) {
        Vector<String> vector = (Vector<String>)this.stateCashHash.get(string);
        if (vector != null) {
            return;
        }
        vector = new Vector<String>();
        String string2 = new String("no status");
        vector.add(0, string2);
        vector.add(1, string2);
        this.stateCashHash.put(string, vector);
    }

    private void addCommand(JDObject jDObject, String string) {
        if (jDObject.isInteractive()) {
            this.addCommmand(jDObject, string);
        }
    }

    private void addCommmand(JDObject jDObject, String string) {
        ICommand iCommand = null;
        try {
            iCommand = this.cFac.getCommand(string);
            if (iCommand != null) {
                this.mouseifyCommand(jDObject, iCommand);
            }
        }
        catch (ConnectionException connectionException) {
            System.out.println("Couldn't load device for command" + string + " " + (Object)((Object)connectionException));
        }
        catch (DevFailed devFailed) {
            System.out.println("Couldn't find the command" + string + " " + (Object)((Object)devFailed));
        }
    }

    private void mouseifyCommand(JDObject jDObject, ICommand iCommand) {
        final ICommand iCommand2 = iCommand;
        jDObject.addValueListener(new JDValueListener(){

            public void valueChanged(JDObject jDObject) {
            }

            public void valueExceedBounds(JDObject jDObject) {
                System.out.println("Acommand is " + iCommand2);
                TangoSynopticHandler.this.commandClicked(iCommand2);
            }
        });
    }

    private void commandClicked(ICommand iCommand) {
        if (iCommand instanceof InvalidCommand) {
            JOptionPane.showMessageDialog(this, iCommand.getName() + " is not supported. ", "Error", 1);
            return;
        }
        if (iCommand instanceof VoidVoidCommand) {
            iCommand.execute();
            return;
        }
        if (this.acv == null) {
            this.argFrame = new JFrame();
            this.acv = new AnyCommandViewer();
            this.argFrame.getContentPane().add(this.acv);
        }
        this.acv.initialize(iCommand);
        this.acv.setBorder(null);
        this.acv.setInputVisible(true);
        this.acv.setDeviceButtonVisible(true);
        this.acv.setDescriptionVisible(true);
        this.acv.setInfoButtonVisible(true);
        if (!iCommand.takesInput()) {
            iCommand.execute();
        }
        this.argFrame.setTitle(iCommand.getName());
        this.argFrame.pack();
        this.argFrame.show();
    }

    private void addStateScalarAttribute(JDObject jDObject, IDevStateScalar iDevStateScalar) {
        String string = iDevStateScalar.getName();
        System.out.println("Connecting to a StateScalar attribute : " + string);
        this.mouseifyStateAttribute(jDObject);
        this.stashComponent(string, jDObject);
        this.addDevToStateCashHashMap(string);
        iDevStateScalar.addDevStateScalarListener((IDevStateScalarListener)this);
        this.allAttributes.add((IEntity)iDevStateScalar);
        if (this.errorHistWind != null) {
            iDevStateScalar.addErrorListener((IErrorListener)this.errorHistWind);
        }
    }

    private void addNumberScalarAttribute(JDObject jDObject, INumberScalar iNumberScalar) {
        if (jDObject instanceof JDSwingObject) {
            JComponent jComponent = ((JDSwingObject)jDObject).getComponent();
            if (jComponent instanceof SimpleScalarViewer) {
                ((SimpleScalarViewer)jComponent).setModel(iNumberScalar);
                this.allAttributes.add((IEntity)iNumberScalar);
            } else if (jComponent instanceof NumberScalarWheelEditor) {
                ((NumberScalarWheelEditor)jComponent).setModel(iNumberScalar);
                this.allAttributes.add((IEntity)iNumberScalar);
            }
        } else {
            this.mouseifyAttribute(jDObject);
            String string = iNumberScalar.getName();
            System.out.println("connecting to a NumberScalar attribute : " + string);
            this.allAttributes.add((IEntity)iNumberScalar);
            iNumberScalar.addNumberScalarListener((INumberScalarListener)this);
            if (this.errorHistWind != null) {
                iNumberScalar.addErrorListener((IErrorListener)this.errorHistWind);
            }
            this.stashComponent(iNumberScalar.getName(), jDObject);
        }
    }

    private void addSpectrumScalarAttribute(JDObject jDObject, INumberSpectrum iNumberSpectrum) {
        JComponent jComponent;
        if (jDObject instanceof JDSwingObject && (jComponent = ((JDSwingObject)jDObject).getComponent()) instanceof NumberSpectrumViewer) {
            ((NumberSpectrumViewer)jComponent).setModel(iNumberSpectrum);
            this.allAttributes.add((IEntity)iNumberSpectrum);
        }
    }

    private void addStringScalarAttribute(JDObject jDObject, IStringScalar iStringScalar) {
        JComponent jComponent;
        if (jDObject instanceof JDSwingObject && (jComponent = ((JDSwingObject)jDObject).getComponent()) instanceof SimpleScalarViewer) {
            ((SimpleScalarViewer)jComponent).setModel(iStringScalar);
            this.allAttributes.add((IEntity)iStringScalar);
        }
    }

    private void addAttribute(JDObject jDObject, String string) {
        block7: {
            IAttribute iAttribute = null;
            try {
                iAttribute = this.aFac.getAttribute(string);
                if (iAttribute == null) break block7;
                if (iAttribute instanceof IDevStateScalar) {
                    this.addStateScalarAttribute(jDObject, (IDevStateScalar)iAttribute);
                    return;
                }
                if (iAttribute instanceof INumberScalar) {
                    this.addNumberScalarAttribute(jDObject, (INumberScalar)iAttribute);
                    return;
                }
                if (iAttribute instanceof IStringScalar) {
                    this.addStringScalarAttribute(jDObject, (IStringScalar)iAttribute);
                    return;
                }
                if (iAttribute instanceof INumberSpectrum) {
                    this.addSpectrumScalarAttribute(jDObject, (INumberSpectrum)iAttribute);
                    return;
                }
            }
            catch (ConnectionException connectionException) {
                System.out.println("Couldn't load device for attribute" + string + " " + (Object)((Object)connectionException));
            }
            catch (DevFailed devFailed) {
                System.out.println("Couldn't find the attribute" + string + " " + (Object)((Object)devFailed));
            }
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double d = numberScalarEvent.getValue();
        INumberScalar iNumberScalar = null;
        iNumberScalar = numberScalarEvent.getNumberSource();
        String string = iNumberScalar.getName();
        if (iNumberScalar != null) {
            List list = (List)this.jdHash.get(string);
            if (list == null) {
                return;
            }
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                JDObject jDObject = null;
                jDObject = (JDObject)list.get(n2);
                if (jDObject != null) {
                    if (jDObject.isProgrammed()) {
                        int n3 = 0;
                        if (!Double.isNaN(d)) {
                            n3 = (int)Math.rint(d);
                        }
                        jDObject.preRefresh();
                        jDObject.setValue(n3);
                        jDObject.refresh();
                    }
                    if (jDObject instanceof JDBar) {
                        ((JDBar)jDObject).setBarValue(d);
                        jDObject.refresh();
                    } else if (jDObject instanceof JDSlider) {
                        jDObject.preRefresh();
                        ((JDSlider)jDObject).setSliderValue(d);
                        jDObject.refresh();
                    }
                }
                ++n2;
            }
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        Object object = errorEvent.getSource();
        if (object instanceof IDevStateScalar) {
            IDevStateScalar iDevStateScalar = (IDevStateScalar)errorEvent.getSource();
            String string = "UNKNOWN";
            this.manageStateChange(iDevStateScalar.getName(), string);
            return;
        }
        if (object instanceof INumberScalar) {
            NumberScalarEvent numberScalarEvent = new NumberScalarEvent((INumberScalar)object, Double.NaN, errorEvent.getTimeStamp());
            this.numberScalarChange(numberScalarEvent);
            return;
        }
    }

    private void manageStateChange(String string, String string2) {
        List list;
        Object object;
        List list2 = null;
        list2 = (List)this.stateCashHash.get(string);
        if (list2 != null) {
            object = null;
            try {
                object = (String)list2.get(0);
                if (object != null && ((String)object).equals(string2)) {
                    return;
                }
                object = new String(string2);
                list2.set(0, object);
                this.stateCashHash.put(string, list2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if ((list = (List)this.jdHash.get(string)) == null) {
            return;
        }
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            object = (JDObject)list.get(n2);
            if (((JDObject)object).isProgrammed()) {
                ((JDObject)object).setValue(this.getDynoState(string2));
                ((JDObject)object).refresh();
            } else {
                this.changeJDobjColour((JDObject)object, string2);
            }
            ++n2;
        }
    }

    public void devStateScalarChange(DevStateScalarEvent devStateScalarEvent) {
        IDevStateScalar iDevStateScalar = (IDevStateScalar)devStateScalarEvent.getSource();
        String string = devStateScalarEvent.getValue();
        this.manageStateChange(iDevStateScalar.getName(), string);
    }

    public void stateChange(StateEvent stateEvent) {
        Device device = (Device)stateEvent.getSource();
        String string = stateEvent.getState();
        this.manageStateChange(device.getName(), string);
    }

    private void changeJDobjColour(JDObject jDObject, String string) {
        if (jDObject instanceof JDGroup) {
            this.changeJDgroupCoulor(jDObject, string);
            return;
        }
        if (jDObject.getFillStyle() == 0) {
            jDObject.setForeground(ATKConstant.getColor4State(string));
        } else {
            jDObject.setBackground(ATKConstant.getColor4State(string));
        }
        jDObject.refresh();
    }

    private void changeJDgroupCoulor(JDObject jDObject, String string) {
        JDGroup jDGroup = null;
        int n = 0;
        JDObject jDObject2 = null;
        if (!(jDObject instanceof JDGroup)) {
            return;
        }
        if (jDObject.getName().equalsIgnoreCase("IgnoreRepaint")) {
            return;
        }
        jDGroup = (JDGroup)jDObject;
        n = jDGroup.getChildrenNumber();
        int n2 = 0;
        while (n2 < n) {
            jDObject2 = jDGroup.getChildAt(n2);
            if (jDObject2 != null && !jDObject2.getName().equalsIgnoreCase("IgnoreRepaint")) {
                if (jDObject2 instanceof JDGroup) {
                    this.changeJDgroupCoulor(jDObject2, string);
                } else {
                    if (jDObject2.getFillStyle() == 0) {
                        jDObject2.setForeground(ATKConstant.getColor4State(string));
                    } else {
                        jDObject2.setBackground(ATKConstant.getColor4State(string));
                    }
                    jDObject2.refresh();
                }
            }
            ++n2;
        }
    }

    public void statusChange(StatusEvent statusEvent) {
        Device device = (Device)statusEvent.getSource();
        String string = device.getName();
        List list = null;
        list = (List)this.stateCashHash.get(string);
        if (list != null) {
            String string2 = null;
            try {
                string2 = (String)list.get(1);
                if (string2 != null && string2.equals(statusEvent.getStatus())) {
                    return;
                }
                string2 = new String(statusEvent.getStatus());
                list.set(1, string2);
                this.stateCashHash.put(string, list);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return;
            }
        }
    }

    private int getDynoState(String string) {
        Integer n = (Integer)dynoState.get(string);
        return n;
    }

    private void devDisplayToolTip(JDMouseEvent jDMouseEvent) {
        List list = null;
        String string = null;
        if (this.toolTipMode == 0) {
            this.setToolTipText(null);
            return;
        }
        if (this.toolTipMode == 3) {
            JDObject jDObject = (JDObject)jDMouseEvent.getSource();
            String string2 = jDObject.getName();
            this.setToolTipText(string2);
            return;
        }
        if (this.toolTipMode == 1) {
            JDObject jDObject = (JDObject)jDMouseEvent.getSource();
            String string3 = jDObject.getName();
            list = (List)this.stateCashHash.get(string3);
            if (list == null) {
                this.setToolTipText(null);
                return;
            }
            try {
                string = (String)list.get(0);
                if (string == null) {
                    this.setToolTipText(null);
                    return;
                }
                this.setToolTipText(string);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.setToolTipText(null);
                return;
            }
        }
        this.setToolTipText(null);
    }

    private void devRemoveToolTip() {
        this.setToolTipText(null);
    }

    private void attDisplayToolTip(JDMouseEvent jDMouseEvent) {
        if (this.toolTipMode != 3) {
            this.setToolTipText(null);
            return;
        }
        JDObject jDObject = (JDObject)jDMouseEvent.getSource();
        String string = jDObject.getName();
        this.setToolTipText(string);
    }

    private void attRemoveToolTip() {
        this.setToolTipText(null);
    }

    public static void main(String[] stringArray) {
        TangoSynopticHandler tangoSynopticHandler = null;
        try {
            tangoSynopticHandler = new TangoSynopticHandler("/segfs/tango/jclient/JLinac/jdraw_file/test_taco.jdw");
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("Prog Aborted.");
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setContentPane(tangoSynopticHandler);
        jFrame.pack();
        jFrame.show();
    }

    static {
        dynoState.put("UNKNOWN", new Integer(0));
        dynoState.put("OFF", new Integer(1));
        dynoState.put("CLOSE", new Integer(1));
        dynoState.put("EXTRACT", new Integer(1));
        dynoState.put("INIT", new Integer(1));
        dynoState.put("DISABLE", new Integer(1));
        dynoState.put("ON", new Integer(2));
        dynoState.put("OPEN", new Integer(2));
        dynoState.put("INSERT", new Integer(2));
        dynoState.put("ALARM", new Integer(3));
        dynoState.put("FAULT", new Integer(4));
        dynoState.put("MOVING", new Integer(5));
        dynoState.put("RUNNING", new Integer(5));
        dynoState.put("STANDBY", new Integer(6));
    }
}

